/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.search;

import com.kingdee.eas.cp.eps.scene.SceneParameters;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SearchParameters {
    private String key;
    private String timeRange;
    private String module;
    private String category;
    private String attachType;
    private String state;
    private String org;
    private String sortType;
    private SceneParameters sceneParameters;
    private Date startTime;
    private Date endTime;
    private int pageSize;
    private int startNum;
    public static int PAGE_SIZE = 20;
    private String fakeKey;

    public SearchParameters() {
    }

    public SearchParameters(String key) {
        this.key = key;
        this.pageSize = PAGE_SIZE;
        this.startNum = 0;
    }

    public SearchParameters(String attachType, String category, String key, String module, String timeRange) {
        this.attachType = attachType;
        this.category = category;
        this.key = key;
        this.module = module;
        this.timeRange = timeRange;
    }

    public SceneParameters getSceneParameters() {
        return this.sceneParameters;
    }

    public void setSceneParameters(SceneParameters sceneParameters) {
        this.sceneParameters = sceneParameters;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public int getPageSize() {
        return this.pageSize > 0 ? this.pageSize : PAGE_SIZE;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getStartNum() {
        return this.startNum;
    }

    public void setStartNum(int startNum) {
        this.startNum = startNum;
    }

    public String getFakeKey() {
        this.fakeKey = this.key.length() > 2 ? this.getCJKKey(this.key) : this.key;
        return this.fakeKey;
    }

    private boolean isChinese(String name) {
        boolean flag = true;
        char[] cs = name.toCharArray();
        for (int n = 0; n < cs.length; ++n) {
            char c = cs[n];
            if (c >= '\u0000' && c <= '~') {
                flag = false;
                return flag;
            }
            if ((c < ' ' || c > '@') && (c < '[' || c > '`')) continue;
            flag = false;
            return flag;
        }
        return flag;
    }

    private String getCJKKey(String key) {
        StringBuffer result = new StringBuffer();
        String temp = "";
        boolean lastIsChinese = false;
        int size = key.length();
        for (int n = 0; n < size - 1; ++n) {
            lastIsChinese = this.isChinese(key.substring(n, n + 1));
            if (lastIsChinese) {
                if (this.isChinese(key.substring(n + 1, n + 2))) {
                    result.append(" " + key.substring(n, n + 2));
                    continue;
                }
                result.append(" " + key.substring(n, n + 1));
                continue;
            }
            temp = temp + key.substring(n, n + 1);
            if (this.isChinese(key.substring(n + 1, n + 2))) {
                result.append(" " + temp);
                temp = "";
            }
            if (n != size - 2) continue;
            temp = temp + key.substring(n + 1, n + 2);
            result.append(" " + temp);
        }
        return result.toString();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(String timeRange) {
        this.timeRange = timeRange;
        int days = Integer.parseInt(timeRange);
        if ("181".equals(timeRange)) {
            this.endTime = SearchParameters.getDateBefore(days);
        } else if ("91".equals(timeRange)) {
            this.endTime = SearchParameters.getDateBefore(days);
        } else {
            this.startTime = SearchParameters.getDateBefore(days);
        }
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public static Date getDateBefore(int day) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(5, c.get(5) - day);
        return c.getTime();
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getAttachType() {
        return this.attachType;
    }

    public void setAttachType(String attachType) {
        this.attachType = attachType;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }
}

