/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.mc.DatePlanException;
import com.kingdee.eas.cp.mc.app.AbstractDatePlanControllerBean;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DatePlanControllerBean
extends AbstractDatePlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.mc.app.DatePlanControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.cp.mc.ManageCommunicateResource";

    protected ArrayList _getTodayPlanOrderByTime(Context ctx, Timestamp beginTime, Timestamp endTime) throws BOSException, EASBizException {
        ArrayList<String[]> returnList = new ArrayList<String[]>();
        int start = 0;
        int end = 22;
        IObjectPK userID = ctx.getCaller();
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selectItemCol = new SelectorItemCollection();
        SelectorItemInfo selItemInfo = new SelectorItemInfo("person");
        selectItemCol.add(selItemInfo);
        UserInfo user = iUser.getUserInfo(userID, selectItemCol);
        String personID = user.getPerson().getId().toString();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (String)"com.kingdee.eas.cp.mc.app.DatePlanQuery");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fic = filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("person.id", (Object)personID));
        fic.add(new FilterItemInfo("endTime", (Object)beginTime, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("endTime", (Object)endTime, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("beginTime", (Object)beginTime, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("beginTime", (Object)endTime, CompareType.LESS_EQUALS));
        filterInfo.setMaskString("#1 and ( (#2 and #3) or (#4 and #5) )");
        exec.setObjectView(view);
        IRowSet row = exec.executeQuery(start, end);
        Timestamp today = new Timestamp(System.currentTimeMillis());
        int spaceIndex = today.toString().indexOf(" ");
        String todayStr = today.toString();
        String[] str = null;
        try {
            while (row.next()) {
                str = new String[7];
                Timestamp startTimeDate = row.getTimestamp("FBeginTime");
                str[0] = startTimeDate.toString();
                str[1] = row.getTimestamp("FEndTime").toString();
                str[2] = row.getString("FID").toString();
                str[3] = row.getString("FEvent" + ctx.getLocale()).toString();
                str[4] = String.valueOf(row.getBoolean("FIsToTimeAvoke"));
                if (str[0].startsWith(todayStr.substring(0, spaceIndex))) {
                    str[5] = "1";
                }
                str[6] = startTimeDate.before(today) ? "1" : "0";
                returnList.add(str);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return returnList;
    }

    private GregorianCalendar getDatefromLong(long datelong) {
        int year = (int)datelong / 1000000 / 100;
        int month = (int)(datelong -= 10000000000L * (long)year) / 100000000;
        int date = (int)(datelong -= (long)month * 100000000L) / 1000000;
        int hour = (int)(datelong -= (long)date * 100000L) / 10000;
        int minu = (int)(datelong -= (long)hour * 1000L) / 100;
        int second = (int)(datelong -= (long)minu * 100L);
        GregorianCalendar calendar = new GregorianCalendar(year, month, date, hour, minu, second);
        return calendar;
    }

    private long getLongfromDate(GregorianCalendar calendar) {
        long longdate = 10000000000L * (long)calendar.get(1);
        longdate += 100000000L * (long)calendar.get(2);
        longdate += 1000000L * (long)calendar.get(5);
        longdate += 10000L * (long)calendar.get(10);
        longdate += 100L * (long)calendar.get(12);
        return longdate += 1L * (long)calendar.get(13);
    }

    @Override
    protected ArrayList _getMyDatePlanOrderByTime(Context ctx, Timestamp beginTime, Timestamp endTime, int pageCount, int currentPage) throws BOSException, EASBizException {
        ArrayList<Object> returnList = new ArrayList<Object>();
        int start = pageCount * (currentPage - 1);
        int end = pageCount * currentPage;
        if (start < 0) {
            end = (start += pageCount) + pageCount;
        }
        IObjectPK userID = ctx.getCaller();
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selectItemCol = new SelectorItemCollection();
        SelectorItemInfo selItemInfo = new SelectorItemInfo("person");
        selectItemCol.add(selItemInfo);
        UserInfo user = iUser.getUserInfo(userID, selectItemCol);
        String personID = user.getPerson().getId().toString();
        StringBuffer sql = new StringBuffer("select count(fid) from t_cp_dateplan where ");
        sql.append(" ( ( datediff(day,FBeginTime,TO_DATE('" + beginTime + "') )<=0 and datediff(day,FBeginTime,TO_DATE('" + endTime + "') )>=0 ) ");
        sql.append(" or ( datediff(day,FEndTime,TO_DATE('" + beginTime + "') )<=0 and datediff(day,FEndTime,TO_DATE('" + endTime + "') )>=0 )");
        sql.append(") and FPersonID=?");
        Object[] param = new Object[]{personID};
        IRowSet rowcount = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        try {
            int sumcount;
            if (rowcount.next()) {
                sumcount = rowcount.getInt(1);
                if (sumcount <= 0) {
                    returnList.add(new Integer(0));
                    return returnList;
                }
            } else {
                returnList.add(new Integer(0));
                return returnList;
            }
            returnList.add(new Integer(sumcount));
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new DatePlanException(DatePlanException.GETDATEPLANEXCEPTION);
        }
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mc.app", "DatePlanQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fic = filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("person.id", (Object)personID));
        fic.add(new FilterItemInfo("endTime", (Object)beginTime, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("endTime", (Object)endTime, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("beginTime", (Object)beginTime, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("beginTime", (Object)endTime, CompareType.LESS_EQUALS));
        filterInfo.setMaskString("#0 and ( (#1 and #2) or (#3 and #4) )");
        view.setFilter(filterInfo);
        exec.setObjectView(view);
        IRowSet row = exec.executeQuery(start, end);
        String[] str = null;
        ArrayList<String[]> list = null;
        String temp = null;
        try {
            while (row.next()) {
                Object[] obj;
                int endIndex;
                String tempStr;
                Timestamp beginT = row.getTimestamp("beginTime");
                Timestamp endT = row.getTimestamp("endTime");
                String id = row.getString("id");
                String event = row.getString("topic");
                String tStr = beginT.toString();
                int spaceIndex = tStr.indexOf(" ");
                tStr = tStr.substring(0, spaceIndex);
                String beginStr = tStr + " 00:00:00.1";
                String endStr = tStr + " 23:59:59.9";
                Timestamp firstDay = Timestamp.valueOf(beginStr);
                Timestamp endDay = Timestamp.valueOf(endStr);
                Timestamp today = new Timestamp(System.currentTimeMillis());
                int spaceTodayIndex = today.toString().indexOf(" ");
                String todayStr = today.toString();
                if (endT != null) {
                    if ((!beginT.after(firstDay) || !beginT.before(endDay)) && (!endT.after(firstDay) || !endT.before(endDay))) continue;
                    str = new String[5];
                    tStr = beginT.toString();
                    spaceIndex = tStr.indexOf(" ") > 0 ? tStr.indexOf(" ") : tStr.length();
                    tempStr = null;
                    tempStr = tStr.substring(0, spaceIndex);
                    endIndex = tStr.indexOf(".") > 0 ? tStr.indexOf(".") : tStr.length();
                    str[0] = tStr.substring(spaceIndex, endIndex) + "~~";
                    tStr = endT.toString();
                    spaceIndex = tStr.indexOf(" ") > 0 ? tStr.indexOf(" ") : tStr.length();
                    int n = endIndex = tStr.indexOf(".") > 0 ? tStr.indexOf(".") : tStr.length();
                    if (DateTimeUtils.dateDiff((Date)beginT, (Date)endT) != 0L) {
                        str[0] = str[0] + DateTimeUtils.format((Date)endT, (String)"yyyy-MM-dd");
                    }
                    str[0] = str[0] + tStr.substring(spaceIndex, endIndex);
                    str[1] = event;
                    str[2] = id;
                    str[3] = beginT.toString().startsWith(todayStr.substring(0, spaceTodayIndex)) ? "1" : "0";
                    str[4] = beginT.before(today) ? "1" : "0";
                    if (temp == null || !temp.trim().equalsIgnoreCase(tempStr)) {
                        if (temp != null) {
                            obj = new Object[]{temp, list};
                            returnList.add(obj);
                            list = null;
                        }
                        list = new ArrayList();
                        temp = tempStr;
                    }
                    list.add(str);
                    continue;
                }
                if (!beginT.after(firstDay) || !beginT.before(endDay)) continue;
                str = new String[5];
                tStr = beginT.toString();
                spaceIndex = tStr.indexOf(" ") > 0 ? tStr.indexOf(" ") : tStr.length();
                tempStr = null;
                tempStr = tStr.substring(0, spaceIndex);
                endIndex = tStr.indexOf(".") > 0 ? tStr.indexOf(".") : tStr.length();
                str[0] = tStr.substring(spaceIndex, endIndex);
                str[1] = event;
                str[2] = id;
                str[3] = str[0].startsWith(todayStr.substring(0, spaceTodayIndex)) ? "1" : "0";
                str[4] = beginT.before(today) ? "1" : "0";
                if (temp == null || !temp.trim().equalsIgnoreCase(tempStr)) {
                    if (temp != null) {
                        obj = new Object[]{temp, list};
                        returnList.add(obj);
                        list = null;
                    }
                    list = new ArrayList<String[]>();
                    temp = tempStr;
                }
                list.add(str);
            }
            if (list != null) {
                Object[] obj = new Object[]{temp, list};
                returnList.add(obj);
                list = null;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new DatePlanException(DatePlanException.GETDATEPLANEXCEPTION);
        }
        return returnList;
    }

    @Override
    protected boolean _isHasDatePlanInStartTimeEndTime(Context ctx, Timestamp startTime, Timestamp endtime, int oprtState) throws BOSException, EASBizException {
        IObjectPK userID = ctx.getCaller();
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selectItemCol = new SelectorItemCollection();
        SelectorItemInfo selItemInfo = new SelectorItemInfo("person");
        selectItemCol.add(selItemInfo);
        UserInfo user = iUser.getUserInfo(userID, selectItemCol);
        String personID = user.getPerson().getId().toString();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mc.app", "DatePlanQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fic = filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("person.id", (Object)personID));
        fic.add(new FilterItemInfo("endTime", (Object)startTime, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("endTime", (Object)endtime, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("beginTime", (Object)startTime, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("beginTime", (Object)endtime, CompareType.LESS_EQUALS));
        filterInfo.setMaskString("#0 and ( (#1 and #2) or (#3 and #4) )");
        view.setFilter(filterInfo);
        exec.setObjectView(view);
        IRowSet row = exec.executeQuery();
        boolean success = false;
        try {
            success = row.next() ? (oprtState == 0 ? true : (oprtState == 2 ? row.next() : true)) : false;
        }
        catch (SQLException sqle) {
            logger.error((Object)"\u5224\u65ad\u662f\u5426\u5b58\u5728\u65e5\u7a0b\u51b2\u7a81\u6570\u636e\u67e5\u8be2\u5931\u8d25", (Throwable)sqle);
            throw new DatePlanException(DatePlanException.JUDGEDATEPLANEXCEPTION);
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _sendAvokeMobie(Context ctx) throws BOSException, EASBizException {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer("select FID,FTimeAvoke,FTopic,FBeginTime,FPersonID from T_CP_DatePlan");
        sql.append(" where FIsMobileAvoke=1 and FIsHaveSendMobile=0");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Timestamp beginTime = null;
        int timeAvoke = 0;
        String topic = "";
        String personid = null;
        Locale locale = null;
        String mobile = null;
        String id = null;
        String idSuccessLsit = null;
        String idFailLsit = null;
        PersonInfo person = null;
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        try {
            while (row.next()) {
                beginTime = row.getTimestamp("FBeginTime");
                timeAvoke = row.getInt("FTimeAvoke");
                Timestamp tempTime = new Timestamp(beginTime.getTime());
                tempTime.setMinutes(beginTime.getMinutes() - timeAvoke);
                if (!tempTime.before(now)) continue;
                topic = row.getString("FTopic");
                personid = row.getString("FPersonID");
                id = row.getString("FID");
                if (personid == null) {
                    if (idFailLsit == null) {
                        idFailLsit = id;
                        continue;
                    }
                    idFailLsit = idFailLsit + "," + id;
                    continue;
                }
                person = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personid));
                if (person == null) {
                    if (idFailLsit == null) {
                        idFailLsit = id;
                        continue;
                    }
                    idFailLsit = idFailLsit + "," + id;
                    continue;
                }
                mobile = person.getCell();
                if (mobile == null || mobile == "") {
                    if (idFailLsit == null) {
                        idFailLsit = id;
                        continue;
                    }
                    idFailLsit = idFailLsit + "," + id;
                    continue;
                }
                locale = MsgUtil.getLocalByPersonID((String)personid, (Context)ctx);
                StringBuffer title = new StringBuffer(ResourceBase.getString((String)RESOURCE, (String)"mobile.avoke", (Locale)locale)).append(" " + topic);
                title.append(";").append(ResourceBase.getString((String)RESOURCE, (String)"starttime", (Locale)locale));
                title.append(":").append(beginTime);
                try {
                    MsgUtil.msgMobileDerect((Context)ctx, (String)title.toString(), (String)mobile);
                    if (idSuccessLsit == null) {
                        idSuccessLsit = id;
                        continue;
                    }
                    idSuccessLsit = idSuccessLsit + "','" + id;
                }
                catch (Exception e) {
                    logger.info((Object)("\u53d1\u9001\u77ed\u4fe1\u51fa\u9519\uff1a" + e.getMessage()));
                    if (idFailLsit == null) {
                        idFailLsit = id;
                        continue;
                    }
                    idFailLsit = idFailLsit + "','" + id;
                }
            }
            StringBuffer sqlUpdate = null;
            if (idSuccessLsit != null) {
                sqlUpdate = new StringBuffer("update T_CP_DatePlan set FIsHaveSendMobile = 1 where FID in ('").append(idSuccessLsit).append("')");
                DbUtil.execute((Context)ctx, (String)sqlUpdate.toString());
            }
            if (idFailLsit != null) {
                sqlUpdate = new StringBuffer("update T_CP_DatePlan set FIsHaveSendMobile = 2 where FID in ('").append(idFailLsit).append("')");
                DbUtil.execute((Context)ctx, (String)sqlUpdate.toString());
            }
            logger.info((Object)("\u53d1\u9001\u6210\u529f\u7684ID\u5217\u8868:" + idSuccessLsit));
            logger.info((Object)("\u53d1\u9001\u5931\u8d25\u7684ID\u5217\u8868:" + idFailLsit));
            return true;
        }
        catch (SQLException sqle) {
            logger.error((Object)"\u53d1\u9001\u65e5\u7a0b\u63d0\u793a\u5931\u8d25", (Throwable)sqle);
        }
        return true;
    }

    @Override
    protected ArrayList _geDatePlan(Context ctx, String personIds, Timestamp beginTime, Timestamp endTime, int pageCount, int currentPage) throws BOSException, EASBizException {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        int start = pageCount * (currentPage - 1);
        int end = pageCount * currentPage;
        if (start < 0) {
            end = (start += pageCount) + pageCount;
        }
        SelectorItemCollection selectItemCol = new SelectorItemCollection();
        SelectorItemInfo selItemInfo = new SelectorItemInfo("person");
        selectItemCol.add(selItemInfo);
        StringBuffer sql = new StringBuffer("select count(fid) from t_cp_dateplan where ");
        sql.append(" ( ( datediff(day,FBeginTime,TO_DATE('" + beginTime + "') )<=0 and datediff(day,FBeginTime,TO_DATE('" + endTime + "') )>=0 ) ");
        sql.append(" or ( datediff(day,FEndTime,TO_DATE('" + beginTime + "') )<=0 and datediff(day,FEndTime,TO_DATE('" + endTime + "') )>=0 )");
        sql.append(") and FPersonID in( ");
        sql.append(this.makeInludeIdStr(personIds));
        sql.append(")");
        IRowSet rowcount = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            int sumcount;
            if (rowcount.next()) {
                sumcount = rowcount.getInt(1);
                if (sumcount <= 0) {
                    returnList.add(new Integer(0));
                    return returnList;
                }
            } else {
                returnList.add(new Integer(0));
                return returnList;
            }
            returnList.add(new Integer(sumcount));
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new DatePlanException(DatePlanException.GETDATEPLANEXCEPTION);
        }
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mc.app", "DatePlanQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fic = filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("person.id", (Object)personIds, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("endTime", (Object)beginTime, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("endTime", (Object)endTime, CompareType.LESS_EQUALS));
        fic.add(new FilterItemInfo("beginTime", (Object)beginTime, CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("beginTime", (Object)endTime, CompareType.LESS_EQUALS));
        filterInfo.setMaskString("#0 and ( (#1 and #2) or (#3 and #4) )");
        view.setFilter(filterInfo);
        exec.setObjectView(view);
        IRowSet row = exec.executeQuery(start, end);
        returnList.add((Integer)row);
        return returnList;
    }

    private String makeInludeIdStr(String ids) {
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        StringBuffer personIdBf = new StringBuffer();
        String[] idArray = ids.split(",");
        for (int i = 0; i < idArray.length; ++i) {
            if (i == 0) {
                personIdBf.append("'");
                personIdBf.append(idArray[i]);
                personIdBf.append("'");
                continue;
            }
            personIdBf.append(",");
            personIdBf.append("'");
            personIdBf.append(idArray[i]);
            personIdBf.append("'");
        }
        return personIdBf.toString();
    }
}

