/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.mc.DatePlanEntryException;
import com.kingdee.eas.cp.mc.DatePlanEventBillFactory;
import com.kingdee.eas.cp.mc.DatePlanEventBillInfo;
import com.kingdee.eas.cp.mc.DatePlanEventEntryFactory;
import com.kingdee.eas.cp.mc.DatePlanEventEntryInfo;
import com.kingdee.eas.cp.mc.IDatePlanEventBill;
import com.kingdee.eas.cp.mc.IDatePlanEventEntry;
import com.kingdee.eas.cp.mc.app.AbstractDatePlanEventEntryControllerBean;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class DatePlanEventEntryControllerBean
extends AbstractDatePlanEventEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.mc.app.DatePlanEventEntryControllerBean");

    @Override
    protected boolean _isHasDatePlanInStartTimeEndTime(Context ctx, Timestamp startTime, Timestamp endtime, int oprtState) throws BOSException, EASBizException {
        return false;
    }

    private boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkError(pk, model);
        super._save(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkError(model);
        return super._save(ctx, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkError(pk, model);
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkError(null, model);
        return super._submit(ctx, model);
    }

    private void checkError(IObjectValue model) throws BOSException, EASBizException {
        DatePlanEventEntryInfo info = (DatePlanEventEntryInfo)model;
        if (info.getId() == null) {
            throw new DatePlanEntryException(DatePlanEntryException.IDNOTNULL);
        }
    }

    protected void checkError(IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        Timestamp end;
        DatePlanEventEntryInfo info = (DatePlanEventEntryInfo)model;
        if (pk == null && info.getId() == null) {
            throw new DatePlanEntryException(DatePlanEntryException.IDNOTNULL);
        }
        if (this.objectIsNull(info.getTopic())) {
            throw new DatePlanEntryException(DatePlanEntryException.TOPIC_NOT_NULL);
        }
        if (this.objectIsNull(info.getEvent())) {
            throw new DatePlanEntryException(DatePlanEntryException.REASON_NOT_NULL);
        }
        if (this.objectIsNull(info.getPerson())) {
            throw new DatePlanEntryException(DatePlanEntryException.TOPIC_NOT_NULL);
        }
        Timestamp start = info.getBeginTime();
        if (start.before(end = info.getEndTime())) {
            throw new DatePlanEntryException(DatePlanEntryException.STARTTIME_BEGIN_THEN_ENDTIME);
        }
        if (info.getTimeAvoke() < 5 && (info.isIsToTimeAvoke() || info.isIsMobileAvoke())) {
            throw new DatePlanEntryException(DatePlanEntryException.TIME_AVOKE_TIME_MUST_BIGGER_5);
        }
    }

    @Override
    protected String _saveBatch(Context ctx, String personIdList, String uuid, String starttime, String endtime, int timeAvoke, boolean isToTimeAvokeMobile, boolean isToTimeAvoke, String reason, String parent, String topic) throws BOSException, EASBizException {
        if (parent == null || parent.trim().length() < 1) {
            throw new DatePlanEntryException(DatePlanEntryException.DATE_BILL_NOT_NULL);
        }
        IDatePlanEventEntry iEntry = DatePlanEventEntryFactory.getLocalInstance(ctx);
        IDatePlanEventBill iDateBill = DatePlanEventBillFactory.getLocalInstance(ctx);
        DatePlanEventBillInfo dateBill = iDateBill.getDatePlanEventBillInfo((IObjectPK)new ObjectUuidPK(parent));
        Timestamp st = Timestamp.valueOf(starttime);
        Timestamp nt = Timestamp.valueOf(endtime);
        if (uuid == null || uuid.equals("null") || uuid.length() < 1) {
            uuid = Uuid.create().toString();
        }
        iEntry.delete("where uuid='" + uuid + "'");
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        String[] person = null;
        if (personIdList == null || personIdList.trim().length() <= 1) {
            throw new DatePlanEntryException(DatePlanEntryException.PERSON_NOT_NULL);
        }
        person = personIdList.split(",");
        PersonInfo personInfo = null;
        DatePlanEventEntryInfo entryInfo = null;
        int size = person.length;
        for (int i = 0; i < size; ++i) {
            entryInfo = new DatePlanEventEntryInfo();
            entryInfo.setBeginTime(st);
            entryInfo.setEndTime(nt);
            entryInfo.setTimeAvoke(timeAvoke);
            entryInfo.setIsToTimeAvoke(isToTimeAvoke);
            entryInfo.setIsMobileAvoke(isToTimeAvokeMobile);
            entryInfo.setEvent(reason);
            entryInfo.setUuid(uuid);
            entryInfo.setTopic(topic);
            entryInfo.setParent(dateBill);
            personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(person[i].split("#")[0]));
            entryInfo.setPerson(personInfo);
            iEntry.addnew(entryInfo);
        }
        return uuid;
    }
}

