/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.StringUtil;
import com.kingdee.eas.cp.mc.app.AbstractDatePlanFacadeControllerBean;
import com.kingdee.eas.cp.mc.web.MCUtils;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DatePlanFacadeControllerBean
extends AbstractDatePlanFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.mc.app.DatePlanFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.cp.mc.ManageCommunicateResource";

    @Override
    protected boolean _isHasDatePlanTo(Context ctx) throws BOSException, EASBizException {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        PersonInfo personid = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()).getPerson();
        String person = "";
        if (personid != null) {
            person = personid.getId().toString();
        }
        StringBuffer sql = new StringBuffer("select FID,FTimeAvoke,FEvent,FBeginTime from T_DatePlan");
        sql.append(" where FPersonID=? and FIsToTimeAvoke=?");
        Object[] param = new Object[]{person, Integer.valueOf("1")};
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        ArrayList<Object[]> msgList = new ArrayList<Object[]>();
        Timestamp beginTime = null;
        int timeAvoke = 0;
        Object id = null;
        Object event = null;
        Object[] message = null;
        int msgCount = 0;
        try {
            while (row.next()) {
                beginTime = row.getTimestamp("FBeginTime");
                Timestamp tempTime = MCUtils.addTime(beginTime, "minute", timeAvoke = row.getInt("FTimeAvoke"));
                if (tempTime.before(now)) continue;
                message = new Object[4];
                message[0] = row.getString("FEvent");
                if (message[0] != null) {
                    message[0] = message[0].toString().replaceAll("\n", "");
                    message[0] = message[0].toString().replaceAll("\r", "");
                } else {
                    message[0] = "";
                }
                message[1] = beginTime;
                message[2] = row.getString("FID");
                message[2] = StringUtil.encoder((String)message[2].toString());
                message[3] = new Integer(timeAvoke);
                int betweenYear = beginTime.getYear() - now.getYear();
                if (Math.abs(betweenYear) > 1) {
                    message[4] = betweenYear > 0 ? betweenYear + "\u5e74" : "\u8fc7\u671f" + betweenYear + "\u5e74";
                } else {
                    int betweenMonth = beginTime.getMonth() - now.getMonth();
                    if (Math.abs(betweenMonth) > 1) {
                        message[4] = betweenMonth > 0 ? betweenMonth + "\u6708" : "\u8fc7\u671f" + betweenMonth + "\u6708";
                    } else {
                        int betweenDate = beginTime.getDate() - now.getDate();
                        if (Math.abs(betweenDate) > 1) {
                            message[4] = betweenDate > 0 ? betweenYear + "\u5929" : "\u8fc7\u671f" + betweenDate + "\u5929";
                        } else {
                            int betweenHour = beginTime.getHours() - now.getHours();
                            if (Math.abs(betweenHour) > 1) {
                                message[4] = betweenHour > 0 ? betweenHour + "\u5c0f\u65f6" : "\u8fc7\u671f" + betweenHour + "\u5c0f\u65f6";
                            } else {
                                int betweenMinute = beginTime.getMinutes() - now.getMinutes();
                                if (Math.abs(betweenMinute) > 1) {
                                    message[4] = betweenMinute > 0 ? betweenMinute + "\u5206\u949f" : "\u8fc7\u671f" + betweenMinute + "\u5206\u949f";
                                }
                            }
                        }
                    }
                }
                ++msgCount;
                msgList.add(message);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    protected void _datePlanAvoke(Context ctx) throws BOSException, EASBizException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getDatePlanAvoke(Context ctx) throws BOSException, EASBizException {
        Locale locale;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        PersonInfo personid = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()).getPerson();
        String person = "";
        Locale locale2 = locale = ctx != null ? ctx.getLocale() : null;
        if (personid == null) {
            return null;
        }
        person = personid.getId().toString();
        StringBuffer sql = new StringBuffer("select FID,FTimeAvoke,FEvent,FBeginTime,FIsAvoke,FLastAvokeTime from T_CP_DatePlan");
        sql.append(" where FPersonID=? and FIsToTimeAvoke=? and FBeginTime>=?");
        Timestamp outTime = new Timestamp(DateTimeUtils.addDay((Date)new Date(), (long)-1L).getTime());
        Object[] param = new Object[]{person, true, outTime};
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        ArrayList<Object> msgList = new ArrayList<Object>();
        Timestamp beginTime = null;
        int timeAvoke = 0;
        Object[] message = null;
        int msgCount = 0;
        boolean isAvoke = false;
        Object lastTime = null;
        String idList = "";
        try {
            while (row.next()) {
                beginTime = row.getTimestamp("FBeginTime");
                timeAvoke = row.getInt("FTimeAvoke");
                isAvoke = row.getBoolean("FIsAvoke");
                Timestamp tempTime = new Timestamp(beginTime.getTime());
                tempTime.setMinutes(beginTime.getMinutes() - timeAvoke);
                if (!tempTime.before(now)) continue;
                message = new Object[4];
                message[1] = row.getString("FEvent");
                if (message[1] != null) {
                    message[1] = message[1].toString().replaceAll("\r", "");
                    message[1] = message[1].toString().replaceAll("\n", "");
                } else {
                    message[1] = "";
                }
                message[3] = beginTime;
                message[0] = row.getString("FID");
                message[2] = 0 + EASCommonResource.getString((String)RESOURCE, (String)"minute", (Locale)locale);
                idList = idList == "" ? (String)message[0] : idList + "','" + (String)message[0];
                long passMinute = (now.getTime() - beginTime.getTime()) / 60000L;
                message[2] = passMinute > 0L ? EASCommonResource.getString((String)RESOURCE, (String)"passed", (Locale)locale) + passMinute + EASCommonResource.getString((String)RESOURCE, (String)"minute", (Locale)locale) : EASCommonResource.getString((String)RESOURCE, (String)"before.passed", (Locale)locale) + Math.abs(passMinute) + EASCommonResource.getString((String)RESOURCE, (String)"minute", (Locale)locale);
                ++msgCount;
                msgList.add(message);
            }
            msgList.add(0, new Integer(msgCount));
        }
        catch (SQLException sqle) {
            logger.error((Object)"\u53d1\u9001\u65e5\u7a0b\u63d0\u793a\u5931\u8d25", (Throwable)sqle);
        }
        if (idList == null || idList == "") {
            return msgList;
        }
        StringBuffer updateSQL = new StringBuffer("update t_cp_dateplan set FIsAvoke =?,FLastAvokeTime=?");
        updateSQL.append("where FID in('" + idList + "')");
        Connection conn = null;
        PreparedStatement pstmt = null;
        Timestamp date = new Timestamp(System.currentTimeMillis());
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(updateSQL.toString());
            pstmt.setInt(1, 1);
            pstmt.setTimestamp(2, date);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"\u66f4\u65b0\u65e5\u7a0b\u4fe1\u606f\u5931\u8d25", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return msgList;
    }
}

