/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.shape;

import com.kingdee.eas.cp.mc.shape.AdapterShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public class Circle
extends AdapterShape {
    private static final long serialVersionUID = -8513210907659204549L;
    private int x;
    private int y;
    private int diameter;

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getDiameter() {
        return this.diameter;
    }

    public void setDiameter(int diameter) {
        this.diameter = diameter;
    }

    public Point getCenter() {
        int radius = this.diameter / 2;
        int _x = this.x + radius;
        int _y = this.y + radius;
        return new Point(_x, _y);
    }

    public int getRadius() {
        return this.diameter / 2;
    }

    @Override
    public boolean contains(Point p) {
        return this.getCenter().distance(p) - (double)this.getRadius() <= 2.0;
    }

    @Override
    public void draw(Graphics2D g2d) {
        g2d.setColor(Color.BLACK);
        g2d.drawOval(this.x, this.y, this.diameter, this.diameter);
        if (this.active) {
            this.drawHighlighted(g2d);
        }
    }

    @Override
    public void drawHighlighted(Graphics2D g2d) {
        g2d.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
        g2d.fillOval(this.x, this.y, this.diameter, this.diameter);
    }

    public String toString() {
        if (this.getAttribute().getTitle() != null && !"".equals(this.getAttribute().getTitle().trim())) {
            return this.getAttribute().getTitle();
        }
        return "Circle(" + this.getCenter().x + "," + this.getCenter().y + "," + this.getRadius() + ")";
    }

    public String toParamString() {
        return String.valueOf(this.getX()) + "," + String.valueOf(this.getY()) + "," + String.valueOf(this.getRadius() * 2);
    }

    @Override
    public String toXml() {
        StringBuffer buf = new StringBuffer();
        buf.append("  <hot");
        buf.append(" type=\"Circle\"  param=\"");
        buf.append(this.toParamString());
        buf.append("\"");
        buf.append(" info=\"");
        buf.append(this.toString());
        buf.append("\">\n");
        buf.append("    <attribute ");
        buf.append(this.attribute.toString());
        buf.append("/>\n");
        buf.append("");
        buf.append("  </hot>");
        return buf.toString();
    }
}

