/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.mc.DatePlanFactory;
import com.kingdee.eas.cp.mc.IDatePlan;
import com.kingdee.eas.portal.web.action.PortletDispatchAction;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class DateWorkShareAction
extends PortletDispatchAction {
    private static final String RESOURCE = "com.kingdee.eas.cp.mc.ManageCommunicateResource";
    private static final Logger logger = Logger.getLogger((String)DateWorkShareAction.class.getName());

    public ActionForward queryAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String userId = ctx.getCaller().toString();
        String sql = "select FSharePersonID from T_CP_DateWorkShare where FCreatorID = ?";
        IRowSet rows = null;
        Object[] params = new Object[]{userId};
        String[][] shareArray = null;
        try {
            rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rows != null && rows.size() > 0) {
                StringBuffer personIdBf = new StringBuffer();
                int i = 0;
                String personId = null;
                while (rows.next()) {
                    personId = rows.getString("FSharePersonID");
                    if (i == 0) {
                        personIdBf.append(personId);
                    } else {
                        personIdBf.append(",");
                        personIdBf.append(personId);
                    }
                    ++i;
                }
                shareArray = this.queryByIds(ctx, personIdBf.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u53d6\u5f97\u65e5\u7a0b\u5171\u4eab\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        request.setAttribute("shareArray", (Object)shareArray);
        return mapping.findForward("success");
    }

    public ActionForward queryShareAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String[][] dateShareData = null;
        String sharePersonIds = this.getSharePersonIds(ctx);
        if (!StringUtils.isEmpty((String)sharePersonIds)) {
            IDatePlan iDatePlan;
            ArrayList datePlanData;
            Timestamp startTime = new Timestamp(System.currentTimeMillis());
            Timestamp endTime = new Timestamp(System.currentTimeMillis());
            if (request.getParameter("startTime") != null) {
                startTime = Timestamp.valueOf(request.getParameter("startTime"));
            }
            if (request.getParameter("endTime") != null) {
                endTime = Timestamp.valueOf(request.getParameter("endTime"));
            }
            int pageCurrent = 0;
            int pageCount = 22;
            if (request.getParameter("pageCount") != null) {
                pageCount = Integer.valueOf(request.getParameter("pageCount"));
            }
            if (request.getParameter("pageCurrent") != null) {
                pageCurrent = Integer.valueOf(request.getParameter("pageCurrent"));
            }
            if ((datePlanData = (iDatePlan = DatePlanFactory.getLocalInstance(ctx)).geDatePlan(sharePersonIds, startTime, endTime, pageCount, pageCurrent)) != null) {
                Integer count = (Integer)datePlanData.get(0);
                request.setAttribute("dataCount", (Object)count);
                if (count > 0) {
                    String[][] shareArray = null;
                    try {
                        shareArray = this.queryByIds(ctx, sharePersonIds);
                        HashMap<String, String[]> personIdMap = new HashMap<String, String[]>();
                        for (int j = 0; j < shareArray.length; ++j) {
                            personIdMap.put(shareArray[j][0], shareArray[j]);
                        }
                        IRowSet row = (IRowSet)datePlanData.get(1);
                        dateShareData = new String[row.size()][7];
                        String[] temp = null;
                        int k = 0;
                        while (row.next()) {
                            temp = (String[])personIdMap.get(row.getString("person.id"));
                            dateShareData[k][0] = row.getString("id");
                            if (temp != null) {
                                dateShareData[k][1] = temp[1];
                                dateShareData[k][2] = temp[2];
                                dateShareData[k][3] = temp[3];
                            }
                            dateShareData[k][4] = row.getString("topic");
                            dateShareData[k][5] = row.getString("beginTime");
                            dateShareData[k][6] = row.getString("endTime");
                            ++k;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u53d6\u5f97\u5176\u4ed6\u4eba\u5458\u65e5\u7a0b\u5171\u4eab\u6570\u636e\u51fa\u9519", (Throwable)e);
                    }
                }
            }
        }
        request.setAttribute("dateShareData", (Object)dateShareData);
        return mapping.findForward("shareSuccess");
    }

    public ActionForward queryLowerAdminOrgAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String sharePersonIds;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String[][] dateShareData = null;
        String orgid = request.getParameter("adminOrgid");
        if (!StringUtils.isEmpty((String)orgid) && !StringUtils.isEmpty((String)(sharePersonIds = this.getPersonIdsByOrgid(ctx, orgid)))) {
            IDatePlan iDatePlan;
            ArrayList datePlanData;
            Timestamp startTime = new Timestamp(System.currentTimeMillis());
            Timestamp endTime = new Timestamp(System.currentTimeMillis());
            if (request.getParameter("startTime") != null) {
                startTime = Timestamp.valueOf(request.getParameter("startTime"));
            }
            if (request.getParameter("endTime") != null) {
                endTime = Timestamp.valueOf(request.getParameter("endTime"));
            }
            int pageCurrent = 0;
            int pageCount = 22;
            if (request.getParameter("pageCount") != null) {
                pageCount = Integer.valueOf(request.getParameter("pageCount"));
            }
            if (request.getParameter("pageCurrent") != null) {
                pageCurrent = Integer.valueOf(request.getParameter("pageCurrent"));
            }
            if ((datePlanData = (iDatePlan = DatePlanFactory.getLocalInstance(ctx)).geDatePlan(sharePersonIds, startTime, endTime, pageCount, pageCurrent)) != null) {
                Integer count = (Integer)datePlanData.get(0);
                request.setAttribute("dataCount", (Object)count);
                if (count > 0) {
                    String[][] shareArray = null;
                    try {
                        shareArray = this.queryByIds(ctx, sharePersonIds);
                        HashMap<String, String[]> personIdMap = new HashMap<String, String[]>();
                        for (int j = 0; j < shareArray.length; ++j) {
                            personIdMap.put(shareArray[j][0], shareArray[j]);
                        }
                        IRowSet row = (IRowSet)datePlanData.get(1);
                        dateShareData = new String[row.size()][7];
                        String[] temp = null;
                        int k = 0;
                        while (row.next()) {
                            temp = (String[])personIdMap.get(row.getString("person.id"));
                            dateShareData[k][0] = row.getString("id");
                            if (temp != null) {
                                dateShareData[k][1] = temp[1];
                                dateShareData[k][2] = temp[2];
                                dateShareData[k][3] = temp[3];
                            }
                            dateShareData[k][4] = row.getString("topic");
                            dateShareData[k][5] = row.getString("beginTime");
                            dateShareData[k][6] = row.getString("endTime");
                            ++k;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u53d6\u5f97\u5176\u4ed6\u4eba\u5458\u65e5\u7a0b\u5171\u4eab\u6570\u636e\u51fa\u9519", (Throwable)e);
                    }
                }
            }
        }
        request.setAttribute("dateShareData", (Object)dateShareData);
        return mapping.findForward("shareSuccess");
    }

    public ActionForward queryLowerPersonAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String[][] dateShareData = null;
        String sharePersonIds = this.geLowerPersonIds(ctx);
        if (!StringUtils.isEmpty((String)sharePersonIds)) {
            IDatePlan iDatePlan;
            ArrayList datePlanData;
            Timestamp startTime = new Timestamp(System.currentTimeMillis());
            Timestamp endTime = new Timestamp(System.currentTimeMillis());
            if (request.getParameter("startTime") != null) {
                startTime = Timestamp.valueOf(request.getParameter("startTime"));
            }
            if (request.getParameter("endTime") != null) {
                endTime = Timestamp.valueOf(request.getParameter("endTime"));
            }
            int pageCurrent = 0;
            int pageCount = 22;
            if (request.getParameter("pageCount") != null) {
                pageCount = Integer.valueOf(request.getParameter("pageCount"));
            }
            if (request.getParameter("pageCurrent") != null) {
                pageCurrent = Integer.valueOf(request.getParameter("pageCurrent"));
            }
            if ((datePlanData = (iDatePlan = DatePlanFactory.getLocalInstance(ctx)).geDatePlan(sharePersonIds, startTime, endTime, pageCount, pageCurrent)) != null) {
                Integer count = (Integer)datePlanData.get(0);
                request.setAttribute("dataCount", (Object)count);
                if (count > 0) {
                    String[][] shareArray = null;
                    try {
                        shareArray = this.queryByIds(ctx, sharePersonIds);
                        HashMap<String, String[]> personIdMap = new HashMap<String, String[]>();
                        for (int j = 0; j < shareArray.length; ++j) {
                            personIdMap.put(shareArray[j][0], shareArray[j]);
                        }
                        IRowSet row = (IRowSet)datePlanData.get(1);
                        dateShareData = new String[row.size()][7];
                        String[] temp = null;
                        int k = 0;
                        while (row.next()) {
                            temp = (String[])personIdMap.get(row.getString("person.id"));
                            dateShareData[k][0] = row.getString("id");
                            if (temp != null) {
                                dateShareData[k][1] = temp[1];
                                dateShareData[k][2] = temp[2];
                                dateShareData[k][3] = temp[3];
                            }
                            dateShareData[k][4] = row.getString("topic");
                            dateShareData[k][5] = row.getString("beginTime");
                            dateShareData[k][6] = row.getString("endTime");
                            ++k;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u53d6\u5f97\u5176\u4ed6\u4eba\u5458\u65e5\u7a0b\u5171\u4eab\u6570\u636e\u51fa\u9519", (Throwable)e);
                    }
                }
            }
        }
        request.setAttribute("dateShareData", (Object)dateShareData);
        return mapping.findForward("shareSuccess");
    }

    public String[][] queryByIds(Context ctx, String ids) {
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        IQueryExecutor exec = null;
        MetaDataPK mainQueryPK = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonQuery");
        filterInfo.setMaskString("#0");
        try {
            entityViewInfo.setFilter(filterInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            String[][] rowDataArray = new String[rowSet.size()][4];
            int i = 0;
            while (rowSet.next()) {
                rowDataArray[i][0] = rowSet.getString("ID");
                rowDataArray[i][1] = rowSet.getString("NUMBER");
                rowDataArray[i][2] = rowSet.getString("NAME");
                rowDataArray[i][3] = rowSet.getString("AdminOrgUnit.name");
                ++i;
            }
            return rowDataArray;
        }
        catch (Exception e) {
            logger.error((Object)"\u901a\u8fc7ID\u67e5\u4eba\u5458\u6570\u636e\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private String getSharePersonIds(Context ctx) {
        StringBuffer personIdBf = new StringBuffer();
        try {
            IObjectPK userPk = ctx.getCaller();
            PersonInfo person = UserFactory.getLocalInstance((Context)ctx).getUserInfo(userPk).getPerson();
            if (person != null) {
                String sql = "select FPersonID from T_CP_DateWorkShare where FSharePersonID = ?";
                IRowSet rows = null;
                Object[] params = new Object[]{person.getId().toString()};
                rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                if (rows != null && rows.size() > 0) {
                    int i = 0;
                    String personId = null;
                    while (rows.next()) {
                        personId = rows.getString("FPersonID");
                        if (i == 0) {
                            personIdBf.append(personId);
                        } else {
                            personIdBf.append(",");
                            personIdBf.append(personId);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u53d6\u5f97\u65e5\u7a0b\u5171\u4eab\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
        return personIdBf.toString();
    }

    public String getPersonIdsByOrgid(Context ctx, String orgid) {
        StringBuffer personIdBf = new StringBuffer();
        try {
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonQuery");
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)orgid));
            entityViewInfo.setFilter(filterInfo);
            IQueryExecutor exec = null;
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            int i = 0;
            String personId = null;
            while (rowSet.next()) {
                personId = rowSet.getString("ID");
                if (i == 0) {
                    personIdBf.append(personId);
                } else {
                    personIdBf.append(",");
                    personIdBf.append(personId);
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u901a\u8fc7\u7ec4\u7ec7ID\u53d6\u4eba\u5458\u6570\u636e\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return personIdBf.toString();
    }

    public String geLowerPersonIds(Context ctx) {
        StringBuffer personIdBf = new StringBuffer();
        try {
            IObjectPK userPk = ctx.getCaller();
            PersonInfo person = UserFactory.getLocalInstance((Context)ctx).getUserInfo(userPk).getPerson();
            if (person != null) {
                String personidStr = person.getId().toString();
                IPersonFacade iPerson = PersonFacadeFactory.getLocalInstance((Context)ctx);
                IRowSet rows = iPerson.getAllUnderlingPersonByPerson(personidStr);
                if (rows != null && rows.size() > 0) {
                    String personId = null;
                    int i = 0;
                    while (rows.next()) {
                        personId = rows.getString("ID");
                        if (personId.equals(personidStr)) continue;
                        if (i == 0) {
                            personIdBf.append(personId);
                        } else {
                            personIdBf.append(",");
                            personIdBf.append(personId);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u901a\u8fc7\u7ec4\u7ec7ID\u53d6\u4eba\u5458\u6570\u636e\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return personIdBf.toString();
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

