/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.cp.cpmm.BillTypeEnum;
import com.kingdee.eas.cp.cpmm.CPMMBizException;
import com.kingdee.eas.cp.cpmm.IProcessSetting;
import com.kingdee.eas.cp.cpmm.ProcessSettingCollection;
import com.kingdee.eas.cp.cpmm.ProcessSettingFactory;
import com.kingdee.eas.cp.cpmm.ProcessSettingInfo;
import com.kingdee.eas.cp.cpmm.app.SqlUtilControlBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class CPMMWorkFlowControlBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cpmm.app.CPMMWorkFlowControlBean");

    public static Boolean canAccess(Context ctx, String procID, String billID) throws CPMMBizException {
        return CPMMWorkFlowControlBean.canPassed(ctx, "procID", procID, billID);
    }

    public static Boolean canAccess(Context ctx, String procID, String billID, String cuID) throws CPMMBizException {
        return CPMMWorkFlowControlBean.canPassed(ctx, "procID", procID, billID, cuID);
    }

    public static Boolean hasConditions(Context ctx, BillTypeEnum billType, String billID) throws CPMMBizException {
        Boolean flag = CPMMWorkFlowControlBean.canPassed(ctx, "bizBillType", billType.getValue(), billID);
        if (flag.booleanValue()) {
            return flag;
        }
        throw new CPMMBizException(CPMMBizException.START_WF_ERROR);
    }

    public static Boolean canPassed(Context ctx, String compareKey, String compareValue, String billID) throws CPMMBizException {
        if (billID == null) {
            return new Boolean(false);
        }
        Boolean flag = new Boolean(true);
        try {
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String CUId = cu.getId().toString();
            IProcessSetting service = ProcessSettingFactory.getLocalInstance(ctx);
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo(compareKey, (Object)compareValue, CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("CU.id", (Object)CUId, CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("canShare", (Object)new Boolean(true), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1 and ( #2 or #3 )");
            entityView.setFilter(filter1);
            logger.info((Object)("CPMMWorkFlowControlBean before checkProcEnable,view:" + entityView));
            ProcessSettingCollection temp = CPMMWorkFlowControlBean.checkProcEnabled(ctx, service.getProcessSettingCollection(entityView));
            if (temp == null || temp.size() < 1) {
                logger.info((Object)("CPMMWorkFlowControlBean availble procss count is 0!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!billID:" + billID));
                flag = new Boolean(false);
            } else {
                logger.info((Object)("CPMMWorkFlowControlBean availble procss count > 0,procss count:" + temp.size() + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!billID:" + billID));
                String metaQueryPath = CPMMWorkFlowControlBean.getMetaQueryPathByProc(ctx, temp.get(0));
                logger.info((Object)("CPMMWorkFlowControlBean process check metaQueryPath:" + metaQueryPath));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billID, CompareType.EQUALS));
                FilterInfo tempFilter = new FilterInfo();
                for (int i = 0; i < temp.size(); ++i) {
                    FilterInfo filter = new FilterInfo();
                    ProcessSettingInfo info = temp.get(i);
                    String sql = info.getFilterInfo();
                    if (sql != null && !sql.equals("")) {
                        filter = new FilterInfo(sql);
                    }
                    filter.mergeFilter(filterInfo, "and");
                    tempFilter.mergeFilter(filter, "or");
                }
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(tempFilter);
                logger.info((Object)("CPMMWorkFlowControlBean process check view:" + view));
                IRowSet row = CPMMWorkFlowControlBean.query(ctx, metaQueryPath, view);
                if (row == null || row.size() < 1) {
                    logger.info((Object)("CPMMWorkFlowControlBean no procss ok!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!billID:" + billID));
                    flag = new Boolean(false);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)("error occur in the function \"canPassed\" Of the class \"CPMMWorkFlowControlBean\" : \n " + e.getCause()));
        }
        catch (ParserException e) {
            logger.error((Object)("error occur in the function \"canPassed\" Of the class \"CPMMWorkFlowControlBean\" : \n " + e.getCause()));
        }
        logger.info((Object)("CPMMWorkFlowControlBean procss check:" + flag + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!billID:" + billID));
        return flag;
    }

    public static Boolean canPassed(Context ctx, String compareKey, String compareValue, String billID, String cuID) throws CPMMBizException {
        if (billID == null) {
            return new Boolean(false);
        }
        Boolean flag = new Boolean(true);
        try {
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            IProcessSetting service = ProcessSettingFactory.getLocalInstance(ctx);
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo(compareKey, (Object)compareValue, CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(0), CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuID, CompareType.EQUALS));
            filter1.getFilterItems().add(new FilterItemInfo("canShare", (Object)new Boolean(true), CompareType.EQUALS));
            filter1.setMaskString("#0 and #1 and ( #2 or #3 )");
            entityView.setFilter(filter1);
            logger.info((Object)("CPMMWorkFlowControlBean before checkProcEnable,view:" + entityView + ",cuID " + cuID));
            ProcessSettingCollection temp = CPMMWorkFlowControlBean.checkProcEnabled(ctx, service.getProcessSettingCollection(entityView));
            if (temp == null || temp.size() < 1) {
                logger.info((Object)("CPMMWorkFlowControlBean availble procss count is 0!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!billID:" + billID));
                flag = new Boolean(false);
            } else {
                logger.info((Object)("CPMMWorkFlowControlBean availble procss count > 0,procss count:" + temp.size() + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!billID:" + billID));
                String metaQueryPath = CPMMWorkFlowControlBean.getMetaQueryPathByProc(ctx, temp.get(0));
                logger.info((Object)("CPMMWorkFlowControlBean process check metaQueryPath:" + metaQueryPath));
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billID, CompareType.EQUALS));
                FilterInfo tempFilter = new FilterInfo();
                for (int i = 0; i < temp.size(); ++i) {
                    FilterInfo filter = new FilterInfo();
                    ProcessSettingInfo info = temp.get(i);
                    String sql = info.getFilterInfo();
                    if (sql != null && !sql.equals("")) {
                        filter = new FilterInfo(sql);
                    }
                    filter.mergeFilter(filterInfo, "and");
                    tempFilter.mergeFilter(filter, "or");
                }
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(tempFilter);
                logger.info((Object)("CPMMWorkFlowControlBean process check view:" + view));
                IRowSet row = CPMMWorkFlowControlBean.query(ctx, metaQueryPath, view);
                if (row == null || row.size() < 1) {
                    logger.info((Object)("CPMMWorkFlowControlBean no procss ok!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!billID:" + billID));
                    flag = new Boolean(false);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)("error occur in the function \"canPassed\" Of the class \"CPMMWorkFlowControlBean\" : \n " + e.getCause()));
        }
        catch (ParserException e) {
            logger.error((Object)("error occur in the function \"canPassed\" Of the class \"CPMMWorkFlowControlBean\" : \n " + e.getCause()));
        }
        logger.info((Object)("CPMMWorkFlowControlBean procss check:" + flag + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!billID:" + billID));
        return flag;
    }

    public static ProcessSettingCollection checkProcEnabled(Context ctx, ProcessSettingCollection rawData) {
        ProcessSettingCollection coll = new ProcessSettingCollection();
        if (rawData != null && rawData.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("enable", (Object)new Integer(1), CompareType.EQUALS));
            ProcessSettingInfo info = null;
            StringBuffer maskStr = new StringBuffer();
            maskStr.append("#0");
            int size = rawData.size();
            for (int i = 0; i < size; ++i) {
                info = rawData.get(i);
                filter.getFilterItems().add(new FilterItemInfo("procdefID", (Object)info.getProcID(), CompareType.EQUALS));
                maskStr.append(" " + (i == 0 ? "and" : "or") + " #" + (i + 1));
            }
            filter.setMaskString(maskStr.toString());
            view.setFilter(filter);
            try {
                IRowSet dataRows = SqlUtilControlBean.query(ctx, "com.kingdee.eas.cp.cpmm.app.CPMMProcDefQuery", view);
                if (dataRows != null) {
                    HashMap<String, Integer> checkMap = new HashMap<String, Integer>();
                    String pID = null;
                    while (dataRows.next()) {
                        pID = dataRows.getString("procdefID");
                        if (checkMap.containsKey(pID)) {
                            if ((Integer)checkMap.get(pID) > dataRows.getInt("innerVersion")) continue;
                            checkMap.put(pID, new Integer(dataRows.getInt("innerVersion")));
                            continue;
                        }
                        checkMap.put(pID, new Integer(dataRows.getInt("innerVersion")));
                    }
                    Set procIdSet = checkMap.keySet();
                    Iterator ite = procIdSet.iterator();
                    ProcessSettingCollection tempData = (ProcessSettingCollection)((Object)rawData.clone());
                    String procId = null;
                    block5: while (ite.hasNext()) {
                        procId = (String)ite.next();
                        int size2 = tempData.size();
                        for (int i = 0; i < size2; ++i) {
                            if (!tempData.get(i).getProcID().equals(procId)) continue;
                            coll.add(tempData.get(i));
                            continue block5;
                        }
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return coll;
    }

    private static String getMetaQueryPathByProc(Context ctx, ProcessSettingInfo info) {
        String flowType = info.getBizBillType().getValue();
        if (flowType == null || flowType.equals("")) {
            return null;
        }
        if (flowType.equals("PURCHASINGBILL")) {
            return "com.kingdee.eas.cp.cpmm.app.MPurchasingBillF7Query";
        }
        if (flowType.equals("OUTBOUND")) {
            return "com.kingdee.eas.cp.cpmm.app.MOutboundBillF7Query";
        }
        if (flowType.equals("WAREHOUSINGBILL")) {
            return "com.kingdee.eas.cp.cpmm.app.MWarehousingBillF7Query";
        }
        return "com.kingdee.eas.cp.cpmm.app.MChangeBillF7Query";
    }

    public static IRowSet query(Context ctx, String metaQueryPath, EntityViewInfo view) throws BOSException {
        IRowSet dataRows = null;
        if (ctx != null && metaQueryPath != null && !metaQueryPath.trim().equals("")) {
            String post = metaQueryPath.substring(metaQueryPath.lastIndexOf(46) + 1);
            String pre = metaQueryPath = metaQueryPath.substring(0, metaQueryPath.lastIndexOf(46));
            IQueryExecutor iqe = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(pre, post));
            if (iqe != null) {
                if (view != null) {
                    iqe.setObjectView(view);
                    logger.info((Object)("\n========================process check sql============================\n" + iqe.getSQL() + "\n\n========================end============================\n"));
                }
                dataRows = iqe.executeQuery(0, 1);
            }
        }
        return dataRows;
    }
}

