/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.cpmm.CPMMBizException;
import com.kingdee.eas.cp.cpmm.IMaterialsRecord;
import com.kingdee.eas.cp.cpmm.IWarehousePosition;
import com.kingdee.eas.cp.cpmm.MaterialsRecordFactory;
import com.kingdee.eas.cp.cpmm.WarehouseFactory;
import com.kingdee.eas.cp.cpmm.WarehouseInfo;
import com.kingdee.eas.cp.cpmm.WarehousePositionFactory;
import com.kingdee.eas.cp.cpmm.WarehouseStateEnum;
import com.kingdee.eas.cp.cpmm.app.AbstractWarehouseControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class WarehouseControllerBean
extends AbstractWarehouseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cpmm.app.WarehouseControllerBean");
    IMaterialsRecord mService = null;
    IWarehousePosition pService = null;

    protected void _setDisabled(Context ctx, BOSUuid pk) throws BOSException {
        ObjectUuidPK mpk = new ObjectUuidPK(pk);
        try {
            WarehouseInfo info = WarehouseFactory.getLocalInstance(ctx).getWarehouseInfo((IObjectPK)mpk);
            info.setState(WarehouseStateEnum.jinyong);
            WarehouseFactory.getLocalInstance(ctx).update((IObjectPK)mpk, info);
        }
        catch (EASBizException e) {
            logger.error((Object)("error occur in the function \"_setDisabled\" Of the class \"WarehouseControllerBean\" : \n " + e.getCause()));
        }
    }

    protected void _setEnable(Context ctx, BOSUuid pk) throws BOSException {
        ObjectUuidPK mpk = new ObjectUuidPK(pk);
        try {
            WarehouseInfo info = WarehouseFactory.getLocalInstance(ctx).getWarehouseInfo((IObjectPK)mpk);
            info.setState(WarehouseStateEnum.qiyong);
            WarehouseFactory.getLocalInstance(ctx).update((IObjectPK)mpk, info);
        }
        catch (EASBizException e) {
            logger.error((Object)("error occur in the function \"_setEnable\" Of the class \"WarehouseControllerBean\" : \n " + e.getCause()));
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WarehouseInfo info = (WarehouseInfo)model;
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (cu != null) {
            filterItem = new FilterItemInfo("CU.id", (Object)cu.getId(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, info, "number") + info.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    private void checkDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.mService = MaterialsRecordFactory.getLocalInstance(ctx);
        this.pService = WarehousePositionFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)pk.toString(), CompareType.EQUALS));
        if (this.mService.exists(filter)) {
            throw new CPMMBizException(CPMMBizException.WAREHOUSE_DEL_ERROR);
        }
        if (this.pService.exists(filter)) {
            throw new CPMMBizException(CPMMBizException.WAREHOUSE_DEL_ERROR2);
        }
    }
}

