/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mrm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.message.common.KDMemAttachment;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.mrm.IMRApply;
import com.kingdee.eas.cp.mrm.IMeetingRoom;
import com.kingdee.eas.cp.mrm.IMeetingSetting;
import com.kingdee.eas.cp.mrm.MRApplyCollection;
import com.kingdee.eas.cp.mrm.MRApplyFactory;
import com.kingdee.eas.cp.mrm.MRApplyInfo;
import com.kingdee.eas.cp.mrm.MRApplyMRApplyCCCollection;
import com.kingdee.eas.cp.mrm.MRApplyMRAttendantCollection;
import com.kingdee.eas.cp.mrm.MRApplyMRAttendantInfo;
import com.kingdee.eas.cp.mrm.MRMBaseException;
import com.kingdee.eas.cp.mrm.MRRegularInfo;
import com.kingdee.eas.cp.mrm.MeetingRoomFactory;
import com.kingdee.eas.cp.mrm.MeetingRoomInfo;
import com.kingdee.eas.cp.mrm.MeetingSettingCollection;
import com.kingdee.eas.cp.mrm.MeetingSettingFactory;
import com.kingdee.eas.cp.mrm.MeetingSettingInfo;
import com.kingdee.eas.hr.perf.app.PfServerUtils;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MRMRegularInteval {
    private MRRegularInfo regular;
    private Date intevalBeginDate;
    private Date intevalEndDate;
    private Date genBeginDate;
    private Date genEndDate;
    private Date meetBeginDate;
    private Date meetEndDate;
    private Date curDate;
    public static String EAS = "com.kingdee.eas.cp.mrm.MailResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.mrm.MRMRegularInteval");
    public static final String CURDATE_NOT_IN_REGULAR_TIMERANGE = "CURDATE_NOT_IN_REGULAR_TIMERANGE";
    public static final String CURDATE_NOT_IN_REGULAR_GENTIME = "CURDATE_NOT_IN_REGULAR_GENTIME";
    public static final String CURDATE_IN_MEETINGTIME = "CURDATE_IN_MEETINGTIME";
    static Locale local;
    static String applyer;
    static String time;
    static String address;
    static String nameBefor;
    static String nameAfter;
    static String mRAttendant;
    static String meetContent;
    static String comperer;
    static String recorder;
    static String startTime;
    static String startSet;
    static String remark;

    public MRMRegularInteval(MRRegularInfo regular, Date curDate) {
        this.regular = regular;
        this.curDate = curDate;
    }

    public static String getCellNumberStr(Context ctx, ArrayList personList) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        PersonInfo person = null;
        int size = personList.size();
        for (int i = 0; i < size; ++i) {
            person = (PersonInfo)personList.get(i);
            set.add(person.getId().toString());
        }
        if (set.size() == 0) {
            return "";
        }
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        evi.getSelector().add(new SelectorItemInfo("cell"));
        PersonCollection pc = ip.getPersonCollection(evi);
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        int size2 = pc.size();
        for (int i = 0; i < size2; ++i) {
            person = pc.get(i);
            if (person.getCell() == null || person.getCell().trim().length() == 0) continue;
            map.put(person.getCell(), person.getCell());
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    public static String getMailPersonStr(Context ctx, ArrayList personList) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        PersonInfo person = null;
        int size = personList.size();
        for (int i = 0; i < size; ++i) {
            person = (PersonInfo)personList.get(i);
            set.add(person.getId().toString());
        }
        if (set.size() == 0) {
            return "";
        }
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        PersonCollection pc = ip.getPersonCollection(evi);
        StringBuffer sb = new StringBuffer();
        int size2 = pc.size();
        for (int i = 0; i < size2; ++i) {
            person = pc.get(i);
            if (person.getEmail() == null || person.getEmail().trim().length() == 0) continue;
            if (sb.toString().length() > 0) {
                sb.append(";");
            }
            sb.append(pc.get(i).getEmail());
        }
        return sb.toString();
    }

    public static String getMailPersonStr(Context ctx, PersonInfo person) throws BOSException {
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection pc = ip.getPersonCollection("select email,cell where id = '" + person.getId().toString() + "'");
        if (pc.size() > 0) {
            person = pc.get(0);
            if (person.getEmail() == null || person.getEmail().trim().length() == 0) {
                return "";
            }
            return person.getEmail();
        }
        return "";
    }

    public static String getMailPersonStr(Context ctx, String personId) throws BOSException {
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection pc = ip.getPersonCollection("select email,cell where id = '" + personId + "'");
        if (pc.size() > 0) {
            PersonInfo person = pc.get(0);
            if (person.getEmail() == null || person.getEmail().trim().length() == 0) {
                return "";
            }
            return person.getEmail();
        }
        return "";
    }

    public static String getTimeStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd HH:mm");
        return format.format(date);
    }

    public static String getTimeStr(Time time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd HH:mm");
        return format.format(new Time(time.getTime()));
    }

    public static boolean getBooleanByStr(String str) {
        if (str == null) {
            return false;
        }
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        return false;
    }

    public static HashMap getInformType(Context ctx, String cuIdStr) throws BOSException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        String cuId = null;
        cuId = null != cuIdStr && !cuIdStr.equals("") ? cuIdStr : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        IMeetingSetting im = MeetingSettingFactory.getLocalInstance(ctx);
        MeetingSettingCollection c = im.getMeetingSettingCollection("select key, value where CU.id = '" + cuId + "'");
        boolean isSMS = false;
        boolean isMessage = false;
        boolean isEmail = false;
        MeetingSettingInfo ms = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            ms = c.get(i);
            if (ms.getKey().equalsIgnoreCase("isSMS")) {
                isSMS = MRMRegularInteval.getBooleanByStr(ms.getValue());
                continue;
            }
            if (ms.getKey().equalsIgnoreCase("isMessage")) {
                isMessage = MRMRegularInteval.getBooleanByStr(ms.getValue());
                continue;
            }
            if (!ms.getKey().equalsIgnoreCase("isEmail")) continue;
            isEmail = MRMRegularInteval.getBooleanByStr(ms.getValue());
        }
        map.put("isSMS", isSMS);
        map.put("isMessage", isMessage);
        map.put("isEmail", isEmail);
        return map;
    }

    public static void sendInform(Context ctx, MRApplyInfo apply) throws Exception {
        local = ctx.getLocale();
        MRMRegularInteval.setMailHead();
        boolean isSubmitEmail = apply.isSubmitEmail();
        boolean isSubmitSMS = apply.isSubmitSMS();
        boolean isSubmitMessage = apply.isSubmitMessage();
        if (isSubmitMessage) {
            try {
                MRMRegularInteval.sendMessage(ctx, apply);
                MRMRegularInteval.sendMessageToRoomAdmin(ctx, apply);
            }
            catch (Exception e) {
                logger.error((Object)("send message error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
        if (isSubmitEmail) {
            try {
                MRMRegularInteval.sendMail(ctx, apply);
                MRMRegularInteval.sendMailToRoomAdmin(ctx, apply);
            }
            catch (Exception e) {
                logger.error((Object)("send mail error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
        if (isSubmitSMS) {
            try {
                MRMRegularInteval.sendSMS(ctx, apply);
            }
            catch (Exception e) {
                logger.error((Object)("send sms error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
    }

    public static void sendInfoLater(Context ctx, MRApplyInfo apply) throws Exception {
        local = ctx.getLocale();
        MRMRegularInteval.setMailHead();
        boolean isLaterEmail = apply.isLaterEmail();
        boolean isLaterSMS = apply.isLaterSMS();
        boolean isLaterMessage = apply.isLaterMessage();
        if (isLaterMessage) {
            try {
                MRMRegularInteval.sendMessage(ctx, apply);
                MRMRegularInteval.sendMessageToRoomAdmin(ctx, apply);
            }
            catch (Exception e) {
                logger.error((Object)("send message error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
        if (isLaterEmail) {
            try {
                MRMRegularInteval.sendMail(ctx, apply);
                MRMRegularInteval.sendMailToRoomAdmin(ctx, apply);
            }
            catch (Exception e) {
                logger.error((Object)("send mail error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
        if (isLaterSMS) {
            try {
                MRMRegularInteval.sendSMS(ctx, apply);
            }
            catch (Exception e) {
                logger.error((Object)("send sms error:" + e.getMessage() + e.getStackTrace().toString()));
            }
        }
    }

    public static void setMailHead() {
        startTime = ResourceBase.getString((String)EAS, (String)"startTime", (Locale)local);
        startSet = ResourceBase.getString((String)EAS, (String)"startSet", (Locale)local);
        remark = ResourceBase.getString((String)EAS, (String)"remark", (Locale)local);
        applyer = ResourceBase.getString((String)EAS, (String)"applyer", (Locale)local);
        time = ResourceBase.getString((String)EAS, (String)"time", (Locale)local);
        address = ResourceBase.getString((String)EAS, (String)"address", (Locale)local);
        nameBefor = ResourceBase.getString((String)EAS, (String)"nameBefor", (Locale)local);
        nameAfter = ResourceBase.getString((String)EAS, (String)"nameAfter", (Locale)local);
        mRAttendant = ResourceBase.getString((String)EAS, (String)"mRAttendant", (Locale)local);
        meetContent = ResourceBase.getString((String)EAS, (String)"meetContent", (Locale)local);
        comperer = ResourceBase.getString((String)EAS, (String)"comperer", (Locale)local);
        recorder = ResourceBase.getString((String)EAS, (String)"recorder", (Locale)local);
    }

    public static String getMsgBodyByMRApplyInfo(MRApplyInfo apply) {
        StringBuffer sb = new StringBuffer();
        sb.append(ResourceBase.getString((String)EAS, (String)"theme", (Locale)local));
        sb.append(apply.getName());
        sb.append("\n");
        sb.append(applyer);
        sb.append(apply.getApplier().getName());
        sb.append("\n");
        sb.append(time);
        sb.append(MRMRegularInteval.getTimeStr(apply.getStartTime()));
        sb.append("-");
        sb.append(MRMRegularInteval.getTimeStr(apply.getEndTime()));
        sb.append("\n");
        sb.append(address);
        sb.append(apply.getAddress().getName());
        return sb.toString();
    }

    public static String getMsgBodyByMRApplyInfo(MRApplyInfo apply, boolean isEmail) {
        StringBuffer sb = new StringBuffer();
        sb.append(ResourceBase.getString((String)EAS, (String)"theme", (Locale)local));
        sb.append(apply.getName());
        sb.append("\n");
        sb.append(applyer);
        sb.append(apply.getApplier().getName());
        sb.append("\n");
        sb.append(time);
        sb.append(MRMRegularInteval.getTimeStr(apply.getStartTime()));
        sb.append("-");
        sb.append(MRMRegularInteval.getTimeStr(apply.getEndTime()));
        sb.append("\n");
        sb.append(address);
        sb.append(apply.getAddress().getName());
        return sb.toString();
    }

    public static String getMsgTitleByMRApplyInfo(MRApplyInfo apply) {
        StringBuffer sb = new StringBuffer();
        sb.append(nameBefor);
        sb.append(apply.getName());
        sb.append(nameAfter);
        return sb.toString();
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public static void sendMessage(Context ctx, String[] ids, String messageStr, String senderStr, String bodyStr, String billID, int billType) throws BOSException, EASBizException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = MRMRegularInteval.getContextLocales(ctx);
        Locale locale2 = null;
        if (ids == null || ids.length == 0 || null == billID || "".equals(billID)) {
            return;
        }
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            if (PfServerUtils.objectIsNull((Object)ids[i])) continue;
            Message message = MessageFactory.newMessage((String)"kingdee.workflow");
            for (Locale locale2 : lcla) {
                message.setLocaleStringHeader("title", messageStr, locale2);
                message.setLocaleStringHeader("sender", senderStr, locale2);
                if (bodyStr == null) {
                    message.setLocaleStringHeader("body", messageStr, locale2);
                    continue;
                }
                message.setLocaleStringHeader("body", bodyStr, locale2);
            }
            message.setIntHeader("type", 0);
            message.setIntHeader("bizType", 20);
            message.setIntHeader("sourceStatus", 0);
            message.setIntHeader("priority", 10);
            message.setStringHeader("bizPackage", "com.kingdee.eas.cp.mrm.app");
            message.setStringHeader("realBizPackage", "com.kingdee.eas.cp.mrm.app");
            message.setStringHeader("sourceID", "");
            String billURL = "";
            switch (billType) {
                case 0: {
                    billURL = "/easweb/cp/mrm/mRApplyEdit.jsf?operateState=VIEW&billId=" + billID;
                    break;
                }
                case 1: {
                    billURL = "/easweb/cp/mrm/mRSummaryEdit.jsf?operateState=VIEW&billId=" + billID;
                    break;
                }
                case 2: {
                    billURL = "/easweb/cp/mrm/mRRegularEdit.jsf?operateState=VIEW&billId=" + billID;
                    break;
                }
                default: {
                    billURL = "/easweb/cp/mrm/mRApplyEdit.jsf?operateState=VIEW&billId=" + billID;
                }
            }
            StringBuffer sourceIdsSB = new StringBuffer("CPOVMSG::billPassURL:null;billURL:");
            sourceIdsSB.append(billURL);
            sourceIdsSB.append(";billID:");
            sourceIdsSB.append(billID);
            message.setStringHeader("sourceIDs", sourceIdsSB.toString());
            logger.info((Object)("MRMRegularInteval::sendMessage()--bizPackage = com.kingdee.eas.cp.mrm.app,sourceIDs = " + sourceIdsSB.toString()));
            message.setStringHeader("databaseCenter", ctx.getAIS());
            message.setStringHeader("solution", ctx.getSolution());
            message.setStringHeader("receiver", ids[i]);
            senderAgent.sendMessage(message);
        }
    }

    public static String[] getUserIdByApply(Context ctx, MRApplyInfo apply) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        MRApplyMRAttendantCollection attC = apply.getMRAttendant();
        if (attC != null) {
            int size = attC.size();
            for (int i = 0; i < size; ++i) {
                set.add(attC.get(i).getAttendant().getId().toString());
            }
        }
        if (apply.getCompere() != null) {
            set.add(apply.getCompere().getId().toString());
        }
        if (set.size() == 0) {
            return new String[0];
        }
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() == 0) {
            return new String[0];
        }
        String[] userIds = new String[uc.size()];
        int size = userIds.length;
        for (int i = 0; i < size; ++i) {
            userIds[i] = uc.get(i).getId().toString();
        }
        return userIds;
    }

    public static void sendMessage(Context ctx, MRApplyInfo apply) throws EASBizException, BOSException {
        String[] ids = MRMRegularInteval.getUserIdByApply(ctx, apply);
        String messageStr = MRMRegularInteval.getMsgTitleByMRApplyInfo(apply);
        String senderStr = apply.getApplier().getName();
        String bodyStr = MRMRegularInteval.getMsgBodyByMRApplyInfo(apply);
        MRMRegularInteval.sendMessage(ctx, ids, messageStr, senderStr, bodyStr, apply.getId().toString(), 0);
    }

    public static void sendMessageToRoomAdmin(Context ctx, MRApplyInfo apply) throws EASBizException, BOSException {
        String senderStr;
        StringBuffer bodyStr;
        StringBuffer messageStr;
        IMeetingRoom iMeetingRoom;
        String[] ids;
        MeetingRoomInfo room = apply.getAddress();
        if (room.getContact() != null) {
            ids = new String[1];
            iMeetingRoom = MeetingRoomFactory.getLocalInstance(ctx);
            room = iMeetingRoom.getMeetingRoomInfo("select * , contact.* where id='" + room.getId().toString() + "'");
            ids[0] = room.getContact().getId().toString();
            messageStr = new StringBuffer();
            messageStr.append(startTime + MRMRegularInteval.getTimeStr(apply.getStartTime()) + startSet + room.getName());
            bodyStr = new StringBuffer();
            bodyStr.append(startTime + MRMRegularInteval.getTimeStr(apply.getStartTime()) + startSet + room.getName() + "\n");
            bodyStr.append(time + MRMRegularInteval.getTimeStr(apply.getStartTime()) + "-" + MRMRegularInteval.getTimeStr(apply.getEndTime()) + "\n");
            bodyStr.append(address + room.getName() + "\n");
            if (apply.getRemark() == null) {
                bodyStr.append(remark + "");
            } else {
                bodyStr.append(remark + apply.getRemark());
            }
            senderStr = apply.getApplier().getName();
            MRMRegularInteval.sendMessage(ctx, MRMRegularInteval.getUserIDsByPersonIDs(ctx, ids), messageStr.toString(), senderStr, bodyStr.toString(), apply.getId().toString(), 0);
        }
        if (room.getContactTwo() != null) {
            ids = new String[1];
            iMeetingRoom = MeetingRoomFactory.getLocalInstance(ctx);
            room = iMeetingRoom.getMeetingRoomInfo("select * , contactTwo.* where id='" + room.getId().toString() + "'");
            ids[0] = room.getContactTwo().getId().toString();
            messageStr = new StringBuffer();
            messageStr.append(startTime + MRMRegularInteval.getTimeStr(apply.getStartTime()) + startSet + room.getName());
            bodyStr = new StringBuffer();
            bodyStr.append(startTime + MRMRegularInteval.getTimeStr(apply.getStartTime()) + startSet + room.getName() + "\n");
            bodyStr.append(time + MRMRegularInteval.getTimeStr(apply.getStartTime()) + "-" + MRMRegularInteval.getTimeStr(apply.getEndTime()) + "\n");
            bodyStr.append(address + room.getName() + "\n");
            if (apply.getRemark() == null) {
                bodyStr.append(remark + "");
            } else {
                bodyStr.append(remark + apply.getRemark());
            }
            senderStr = apply.getApplier().getName();
            MRMRegularInteval.sendMessage(ctx, MRMRegularInteval.getUserIDsByPersonIDs(ctx, ids), messageStr.toString(), senderStr, bodyStr.toString(), apply.getId().toString(), 0);
        }
    }

    public static String[] getUserIDsByPersonIDs(Context ctx, String[] personIDs) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        if (personIDs != null) {
            int size = personIDs.length;
            for (int i = 0; i < size; ++i) {
                set.add(personIDs[i]);
            }
        }
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() == 0) {
            return new String[0];
        }
        String[] userIds = new String[uc.size()];
        int size = userIds.length;
        for (int i = 0; i < size; ++i) {
            userIds[i] = uc.get(i).getId().toString();
        }
        return userIds;
    }

    public static boolean isConnect(Context ctx) {
        ServerCenter serverCenter = ServerCenter.getInstance((Context)ctx);
        boolean isConnect = serverCenter.isConnect();
        return isConnect;
    }

    public static void sendSMS(Context ctx, MRApplyInfo apply) throws EASBizException, BOSException {
        String receiver;
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        MRApplyMRAttendantCollection attC = apply.getMRAttendant();
        int size = attC.size();
        for (int i = 0; i < size; ++i) {
            list.add(attC.get(i).getAttendant());
        }
        MRApplyMRApplyCCCollection ccC = apply.getMRApplyCC();
        int size2 = ccC.size();
        for (int i = 0; i < size2; ++i) {
            list.add(ccC.get(i).getCc());
        }
        if (apply.getCompere() != null) {
            list.add(apply.getCompere());
        }
        if (apply.getCaller() != null) {
            list.add(apply.getCaller());
        }
        if (apply.getRecorder() != null) {
            list.add(apply.getRecorder());
        }
        if (apply.getAddress().getContact() != null) {
            list.add(apply.getAddress().getContact());
        }
        if (apply.getAddress().getContactTwo() != null) {
            list.add(apply.getAddress().getContactTwo());
        }
        if ((receiver = MRMRegularInteval.getCellNumberStr(ctx, list)) == null || "".equals(receiver)) {
            return;
        }
        String content = MRMRegularInteval.getMsgBodyByMRApplyInfo(apply);
        SendMessageParamInfo paramInfo = new SendMessageParamInfo();
        paramInfo.setAppendCompanyName(false);
        paramInfo.setAppendNumber(false);
        paramInfo.setAppendPersonName(false);
        paramInfo.setAppendRevert(false);
        paramInfo.setAppendUserName(false);
        paramInfo.setContent(content);
        paramInfo.setReceiver(receiver);
        paramInfo.setCanback(false);
        logger.error((Object)"MsgFacadeFactory.getLocalInstance(ctx)>>iMsgFacade.sendMsg(paramInfo)");
        IMsgFacade iMsgFacade = MsgFacadeFactory.getLocalInstance((Context)ctx);
        iMsgFacade.sendMsg(paramInfo);
    }

    public static void sendMail(Context ctx, MRApplyInfo apply) throws Exception {
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        MRApplyMRAttendantCollection attC = apply.getMRAttendant();
        if (attC != null) {
            int size = attC.size();
            for (int i = 0; i < size; ++i) {
                list.add(attC.get(i).getAttendant());
            }
        }
        if (apply.getCompere() != null) {
            list.add(apply.getCompere());
        }
        if (apply.getCaller() != null) {
            list.add(apply.getCaller());
        }
        if (apply.getRecorder() != null) {
            list.add(apply.getRecorder());
        }
        String to = MRMRegularInteval.getMailPersonStr(ctx, list);
        list = new ArrayList();
        MRApplyMRApplyCCCollection ccC = apply.getMRApplyCC();
        if (ccC != null) {
            int size = ccC.size();
            for (int i = 0; i < size; ++i) {
                list.add(ccC.get(i).getCc());
            }
        }
        String cc = MRMRegularInteval.getMailPersonStr(ctx, list);
        String subject = MRMRegularInteval.getMsgTitleByMRApplyInfo(apply);
        String body = MRMRegularInteval.getMsgBodyByMRApplyInfo(apply, true);
        String attendant = MRMRegularInteval.getAttendant(ctx, apply);
        String com_Rec = MRMRegularInteval.getCom_Rec(apply);
        if (!(to != null && to.length() != 0 || cc != null && cc.length() != 0)) {
            return;
        }
        KDMemAttachment kDMessageAttachment = new KDMemAttachment();
        byte[] blob = MRMRegularInteval.getBlob(ctx, apply);
        if (blob != null) {
            kDMessageAttachment.setData(blob);
            kDMessageAttachment.setName(meetContent + ".doc");
            kDMessageAttachment.setSize(blob.length);
            KDMessageAttachment[] kdMA = new KDMessageAttachment[]{kDMessageAttachment};
            MsgUtil.msgMailDerect((Context)ctx, (String)subject, (String)(body + com_Rec + attendant), (String)to, null, (String)cc, (KDMessageAttachment[])kdMA);
        } else {
            MsgUtil.msgMailDerect((Context)ctx, (String)subject, (String)(body + com_Rec + attendant), (String)to, null, (String)cc, null);
        }
    }

    public static void sendMailToRoomAdmin(Context ctx, MRApplyInfo apply) throws Exception {
        String to = "";
        String cc = "";
        if (null == apply.getAddress().getContact().getId().toString()) {
            return;
        }
        to = MRMRegularInteval.getMailPersonStr(ctx, apply.getAddress().getContact().getId().toString());
        StringBuffer title = new StringBuffer();
        title.append(startTime + MRMRegularInteval.getTimeStr(apply.getStartTime()) + startSet + apply.getAddress().getName());
        StringBuffer bodyStr = new StringBuffer();
        bodyStr.append(startTime + MRMRegularInteval.getTimeStr(apply.getStartTime()) + startSet + apply.getAddress().getName() + "\n");
        bodyStr.append(time + MRMRegularInteval.getTimeStr(apply.getStartTime()) + "-" + MRMRegularInteval.getTimeStr(apply.getEndTime()) + "\n");
        bodyStr.append(address + apply.getAddress().getName() + "\n");
        if (apply.getRemark() == null) {
            bodyStr.append(remark + "");
        } else {
            bodyStr.append(remark + apply.getRemark());
        }
        if (!(to != null && to.length() != 0 || cc != null && cc.length() != 0)) {
            return;
        }
        MsgUtil.msgMailDerect((Context)ctx, (String)title.toString(), (String)bodyStr.toString(), (String)to, null, (String)cc, null);
    }

    public static void sendMailToRoomAdmin2(Context ctx, MRApplyInfo apply) throws Exception {
        String to = "";
        String cc = "";
        if (null == apply.getAddress().getContactTwo().getId().toString()) {
            return;
        }
        to = MRMRegularInteval.getMailPersonStr(ctx, apply.getAddress().getContactTwo().getId().toString());
        StringBuffer title = new StringBuffer();
        title.append(startTime + MRMRegularInteval.getTimeStr(apply.getStartTime()) + startSet + apply.getAddress().getName());
        StringBuffer bodyStr = new StringBuffer();
        bodyStr.append(startTime + MRMRegularInteval.getTimeStr(apply.getStartTime()) + startSet + apply.getAddress().getName() + "\n");
        bodyStr.append(time + MRMRegularInteval.getTimeStr(apply.getStartTime()) + "-" + MRMRegularInteval.getTimeStr(apply.getEndTime()) + "\n");
        bodyStr.append(address + apply.getAddress().getName() + "\n");
        if (apply.getRemark() == null) {
            bodyStr.append(remark + "");
        } else {
            bodyStr.append(remark + apply.getRemark());
        }
        if (!(to != null && to.length() != 0 || cc != null && cc.length() != 0)) {
            return;
        }
        MsgUtil.msgMailDerect((Context)ctx, (String)title.toString(), (String)bodyStr.toString(), (String)to, null, (String)cc, null);
    }

    public static void checkTime(Context ctx, Time startTime, Time endTime, String id, String roomId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(4)));
        filter.getFilterItems().add(new FilterItemInfo("address", (Object)roomId));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)startTime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)startTime, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)startTime, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)endTime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)endTime, CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)endTime, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startTime", (Object)startTime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)endTime, CompareType.GREATER_EQUALS));
        filter.setMaskString("#0 and (#1 or #2) and #3 and ((#4 and #5) or (#6 and #7) or (#8 and #9) or (#10 and #11))");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("address.id"));
        evi.getSelector().add(new SelectorItemInfo("id"));
        IMRApply imr = MRApplyFactory.getLocalInstance(ctx);
        MRApplyCollection c = imr.getMRApplyCollection(evi);
        int size = c.size();
        if (size > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    sb.append(c.get(i).getNumber());
                    continue;
                }
                sb.append(";");
                sb.append(c.get(i).getNumber());
            }
            throw new MRMBaseException(MRMBaseException.APPLYTIME_CONFLICT, new Object[]{sb.toString()});
        }
    }

    public static boolean isInDate(Date curDate, Date beginDate, Date endDate) {
        return curDate.compareTo(beginDate) >= 0 && curDate.compareTo(endDate) < 0;
    }

    public Date getCurDate() {
        return this.curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getGenBeginDate() {
        return this.genBeginDate;
    }

    public void setGenBeginDate(Date genBeginDate) {
        this.genBeginDate = genBeginDate;
    }

    public Date getGenEndDate() {
        return this.genEndDate;
    }

    public void setGenEndDate(Date genEndDate) {
        this.genEndDate = genEndDate;
    }

    public Date getIntevalBeginDate() {
        return this.intevalBeginDate;
    }

    public void setIntevalBeginDate(Date intevalBeginDate) {
        this.intevalBeginDate = intevalBeginDate;
    }

    public Date getIntevalEndDate() {
        return this.intevalEndDate;
    }

    public void setIntevalEndDate(Date intevalEndDate) {
        this.intevalEndDate = intevalEndDate;
    }

    public Date getMeetBeginDate() {
        return this.meetBeginDate;
    }

    public void setMeetBeginDate(Date meetBeginDate) {
        this.meetBeginDate = meetBeginDate;
    }

    public MRRegularInfo getRegular() {
        return this.regular;
    }

    public void setRegular(MRRegularInfo regular) {
        this.regular = regular;
    }

    public static Date getDateByDateAndTime(Date date, Time time) {
        Calendar cDate = Calendar.getInstance();
        cDate.setTime(date);
        Calendar cTime = Calendar.getInstance();
        cTime.setTime(new Date(time.getTime()));
        Calendar c = Calendar.getInstance();
        c.set(1, cDate.get(1));
        c.set(2, cDate.get(2));
        c.set(5, cDate.get(5));
        c.set(11, cTime.get(11));
        c.set(12, cTime.get(12));
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public Date getMeetEndDate() {
        return this.meetEndDate;
    }

    public void setMeetEndDate(Date meetEndDate) {
        this.meetEndDate = meetEndDate;
    }

    public static String getAttendant(Context ctx, MRApplyInfo apply) {
        StringBuffer retStr = new StringBuffer();
        try {
            IMRApply mRApply = MRApplyFactory.getLocalInstance(ctx);
            try {
                MRApplyInfo mRApplyInfo = mRApply.getMRApplyInfo("select MRAttendant.attendant.name where id='" + apply.getId().toString() + "'");
                MRApplyMRAttendantCollection mRApplyMRAttendantCollection = mRApplyInfo.getMRAttendant();
                for (int i = 0; i < mRApplyMRAttendantCollection.size(); ++i) {
                    MRApplyMRAttendantInfo mRApplyMRAttendantInfo = mRApplyMRAttendantCollection.get(i);
                    if (mRApplyMRAttendantInfo.getAttendant() == null) continue;
                    retStr.append(mRApplyMRAttendantInfo.getAttendant().getName()).append(";");
                }
                if (retStr.length() > 0) {
                    return "\n" + mRAttendant + retStr.substring(0, retStr.length() - 1) + "\n";
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return "\n" + mRAttendant + retStr + "\n";
    }

    public static byte[] getBlob(Context ctx, MRApplyInfo apply) {
        String sql = "select FDocEntity from T_MRM_MRAPPLY WHERE FID='" + apply.getId() + "'";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
            Blob blob = null;
            if (rows.next()) {
                blob = rows.getBlob(1);
                if (blob != null) {
                    return blob.getBytes(1L, Integer.valueOf(String.valueOf(blob.length())));
                }
                return null;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCom_Rec(MRApplyInfo apply) {
        StringBuffer retStr = new StringBuffer();
        if (apply.getCompere() != null) {
            retStr.append("\n" + comperer + apply.getCompere().getName());
        } else {
            retStr.append("\n" + comperer);
        }
        return retStr.toString();
    }

    static {
        applyer = "";
        time = "";
        address = "";
        nameBefor = "";
        nameAfter = "";
        mRAttendant = "";
        meetContent = "";
        comperer = "";
        recorder = "";
        startTime = "";
        startSet = "";
        remark = "";
    }
}

