/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mrm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.PigeStatusEnum;
import com.kingdee.eas.cp.dm.ContentTypeEnum;
import com.kingdee.eas.cp.dm.archive.ArchiveDocumentImpl;
import com.kingdee.eas.cp.dm.archive.ArchiveDocumentParamsInfo;
import com.kingdee.eas.cp.dm.archive.file.ExportFile;
import com.kingdee.eas.cp.dm.archive.util.ArchiveUtils;
import com.kingdee.eas.cp.mrm.IMRAdmin;
import com.kingdee.eas.cp.mrm.IMRApply;
import com.kingdee.eas.cp.mrm.IMRSummary;
import com.kingdee.eas.cp.mrm.MRAdminCollection;
import com.kingdee.eas.cp.mrm.MRAdminFactory;
import com.kingdee.eas.cp.mrm.MRApplyFactory;
import com.kingdee.eas.cp.mrm.MRApplyInfo;
import com.kingdee.eas.cp.mrm.MRApplyMRApplyCCCollection;
import com.kingdee.eas.cp.mrm.MRApplyMRAttendantCollection;
import com.kingdee.eas.cp.mrm.MRMBaseException;
import com.kingdee.eas.cp.mrm.MRSummaryFactory;
import com.kingdee.eas.cp.mrm.MRSummaryInfo;
import com.kingdee.eas.cp.mrm.MRSummaryMRApplyCCInfo;
import com.kingdee.eas.cp.mrm.MRSummaryMRAttendantInfo;
import com.kingdee.eas.cp.mrm.MeetingTypeFactory;
import com.kingdee.eas.cp.mrm.MeetingTypeInfo;
import com.kingdee.eas.cp.mrm.MrmArchiveCollection;
import com.kingdee.eas.cp.mrm.MrmArchiveFactory;
import com.kingdee.eas.cp.mrm.SummaryStateEnum;
import com.kingdee.eas.cp.mrm.app.AbstractMRSummaryControllerBean;
import com.kingdee.eas.cp.mrm.utils.OACommonDataProvider;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.print.MultiDataSourceProviderProxy;
import com.kingdee.eas.framework.print.MultiapprovePrintUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MRSummaryControllerBean
extends AbstractMRSummaryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.mrm.app.MRSummaryControllerBean");
    private String mrmResource = "com.kingdee.eas.cp.mrm.MailResource";

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkForDelete(ctx, (IObjectValue)this.getMRSummaryInfo(ctx, pk));
        super._delete(ctx, pk);
    }

    private void checkForDelete(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MRSummaryInfo info = (MRSummaryInfo)model;
        if (1 == info.getState().getValue() && !this.isMRAdmin(ctx)) {
            throw new MRMBaseException(MRMBaseException.MRSUMMARY_NOT_ALLOW_DELETE);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        this.saveFile(ctx, model, pk);
        return pk;
    }

    @Override
    protected void _addNewForDoc(Context ctx, IObjectValue model) throws BOSException {
        try {
            IObjectPK pk = super._addnew(ctx, model);
            this.saveFile(ctx, model, pk);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MRSummaryInfo info = (MRSummaryInfo)model;
        if (1 == info.getState().getValue()) {
            IObjectPK pk = null;
            pk = super._save(ctx, model);
            this.saveFile(ctx, model, pk);
            super._save(ctx, (IObjectValue)info);
            model.setExtendedProperty("ignoreWorkflow", "true");
            try {
                logger.info((Object)"_submit MRMRSummary.sendInform(...)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return pk;
        }
        IObjectPK pk = null;
        String pubProcess = null;
        if (info.getMrType() != null) {
            pubProcess = info.getMrType().getSummaryProcess();
            ((MRSummaryInfo)model).setSummaryProcess(info.getMrType().getSummaryProcess());
        }
        if (pubProcess != null && !"".equals(pubProcess)) {
            ((MRSummaryInfo)model).setState(SummaryStateEnum.AUD);
            pk = super._submit(ctx, model);
            this.saveFile(ctx, model, pk);
        } else {
            ((MRSummaryInfo)model).setState(SummaryStateEnum.END);
            pk = super._save(ctx, model);
            this.saveFile(ctx, model, pk);
            model.setExtendedProperty("ignoreWorkflow", "true");
            try {
                logger.info((Object)"_submit MRMRSummary.sendInform(...)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(Context ctx, IObjectValue model, IObjectPK pk) {
        String sql = "select FEntity from T_CP_DocExchange where fid = ? ";
        Object[] obj = new Object[1];
        Blob blob = null;
        InputStream in = null;
        Statement ps = null;
        Connection conn = null;
        try {
            obj[0] = model.getString("fileName");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])obj);
            if (rows.next() && null != (blob = rows.getBlob(1))) {
                in = blob.getBinaryStream();
            }
            sql = "update T_MRM_MRSUMMARY SET FDocEntity = ? WHERE FID = ?";
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            if (in != null && ps != null) {
                logger.info((Object)("Remove DocEntity Size is:" + in.available()));
                ps.setBinaryStream(1, in, in.available());
                ps.setString(2, pk.toString());
                ps.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        sql = "delete T_CP_DocExchange where fid = ? ";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])obj);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private boolean isMRAdmin(Context ctx) throws BOSException {
        boolean flag = false;
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String personID = user.getPerson().getId().toString();
        IMRAdmin mrAdmin = MRAdminFactory.getLocalInstance(ctx);
        MRAdminCollection collection = mrAdmin.getMRAdminCollection("select * where mrApplyAdmin.id ='" + personID + "'");
        if (0 != collection.size()) {
            flag = true;
        }
        return flag;
    }

    @Override
    protected IObjectValue _convert(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        try {
            MRSummaryInfo summaryInfo = (MRSummaryInfo)model;
            MRApplyInfo applyInfo = this.getApplyInfoByPK(ctx, pk);
            if (applyInfo == null) {
                throw new MRMBaseException(MRMBaseException.APPLY_CONVERNT_TO_SUMMARY_FAILED);
            }
            if (model == null) {
                model = new MRSummaryInfo();
                summaryInfo.setId(BOSUuid.create((BOSObjectType)model.getBOSType()));
            }
            summaryInfo.setMrApply(applyInfo);
            summaryInfo.setAddress(applyInfo.getAddress());
            summaryInfo.setStartTime(applyInfo.getStartTime());
            summaryInfo.setEndTime(applyInfo.getEndTime());
            summaryInfo.setCaller(applyInfo.getCaller());
            summaryInfo.setCompere(applyInfo.getCompere());
            if (summaryInfo.getMRAttendant() != null) {
                summaryInfo.getMRAttendant().clear();
            }
            MRSummaryMRAttendantInfo attendant = null;
            MRApplyMRAttendantCollection _attC = applyInfo.getMRAttendant();
            if (_attC != null && _attC.size() > 0) {
                int size = _attC.size();
                for (int i = 0; i < size; ++i) {
                    attendant = new MRSummaryMRAttendantInfo();
                    attendant.setSeq(_attC.get(i).getSeq());
                    attendant.setAttendant(_attC.get(i).getAttendant());
                    summaryInfo.getMRAttendant().add(attendant);
                }
            }
            if (summaryInfo.getMRApplyCC() != null) {
                summaryInfo.getMRApplyCC().clear();
            }
            MRSummaryMRApplyCCInfo cc = null;
            MRApplyMRApplyCCCollection _ccC = applyInfo.getMRApplyCC();
            if (_ccC != null && _ccC.size() > 0) {
                int size = _ccC.size();
                for (int i = 0; i < size; ++i) {
                    cc = new MRSummaryMRApplyCCInfo();
                    cc.setSeq(_ccC.get(i).getSeq());
                    cc.setCc(_ccC.get(i).getCc());
                    summaryInfo.getMRApplyCC().add(cc);
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getStackTrace().toString());
            throw new MRMBaseException(MRMBaseException.APPLY_CONVERNT_TO_SUMMARY_FAILED);
        }
        catch (BOSException e) {
            logger.error((Object)e.getStackTrace().toString());
            throw e;
        }
        return model;
    }

    private MRApplyInfo getApplyInfoByPK(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMRApply imr = MRApplyFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("mrType.id"));
        sic.add(new SelectorItemInfo("mrType.number"));
        sic.add(new SelectorItemInfo("mrType.name"));
        sic.add(new SelectorItemInfo("impDegree"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("applier.number"));
        sic.add(new SelectorItemInfo("applyUnit.id"));
        sic.add(new SelectorItemInfo("applyUnit.name"));
        sic.add(new SelectorItemInfo("applyUnit.number"));
        sic.add(new SelectorItemInfo("address.id"));
        sic.add(new SelectorItemInfo("address.number"));
        sic.add(new SelectorItemInfo("address.name"));
        sic.add(new SelectorItemInfo("startTime"));
        sic.add(new SelectorItemInfo("endTime"));
        sic.add(new SelectorItemInfo("caller.id"));
        sic.add(new SelectorItemInfo("caller.number"));
        sic.add(new SelectorItemInfo("caller.name"));
        sic.add(new SelectorItemInfo("compere.id"));
        sic.add(new SelectorItemInfo("compere.number"));
        sic.add(new SelectorItemInfo("compere.name"));
        sic.add(new SelectorItemInfo("MRApplyCC.id"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.id"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.name"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.number"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.seq"));
        sic.add(new SelectorItemInfo("MRAttendant.id"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.id"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.name"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.number"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.seq"));
        sic.add(new SelectorItemInfo("recorder.id"));
        sic.add(new SelectorItemInfo("recorder.number"));
        sic.add(new SelectorItemInfo("recorder.name"));
        return imr.getMRApplyInfo(pk, sic);
    }

    @Override
    protected void _shenpi(Context ctx, IObjectValue model) throws BOSException {
        IMRSummary MRSummary2 = MRSummaryFactory.getLocalInstance(ctx);
        try {
            MRSummaryInfo MRSummaryModel = MRSummary2.getMRSummaryInfo((IObjectPK)new ObjectUuidPK(((MRSummaryInfo)model).getId()), this.getSelectors());
            MRSummaryModel.setState(SummaryStateEnum.END);
            MRSummaryModel.remove("docEntity");
            super._save(ctx, (IObjectValue)MRSummaryModel);
            try {
                logger.info((Object)"_shenpi MRMRSummary.sendInform(...)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("fileName"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("mrType.id"));
        sic.add(new SelectorItemInfo("mrType.number"));
        sic.add(new SelectorItemInfo("mrType.name"));
        sic.add(new SelectorItemInfo("impDegree"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("applier.number"));
        sic.add(new SelectorItemInfo("applyUnit.id"));
        sic.add(new SelectorItemInfo("applyUnit.name"));
        sic.add(new SelectorItemInfo("applyUnit.number"));
        sic.add(new SelectorItemInfo("address.id"));
        sic.add(new SelectorItemInfo("address.number"));
        sic.add(new SelectorItemInfo("address.name"));
        sic.add(new SelectorItemInfo("startTime"));
        sic.add(new SelectorItemInfo("endTime"));
        sic.add(new SelectorItemInfo("caller.id"));
        sic.add(new SelectorItemInfo("caller.number"));
        sic.add(new SelectorItemInfo("caller.name"));
        sic.add(new SelectorItemInfo("compere.id"));
        sic.add(new SelectorItemInfo("compere.number"));
        sic.add(new SelectorItemInfo("compere.name"));
        sic.add(new SelectorItemInfo("MRApplyCC.id"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.id"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.name"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.number"));
        sic.add(new SelectorItemInfo("MRApplyCC.cc.seq"));
        sic.add(new SelectorItemInfo("MRAttendant.id"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.id"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.name"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.number"));
        sic.add(new SelectorItemInfo("MRAttendant.attendant.seq"));
        sic.add(new SelectorItemInfo("recorder.id"));
        sic.add(new SelectorItemInfo("recorder.number"));
        sic.add(new SelectorItemInfo("recorder.name"));
        sic.add(new SelectorItemInfo("mrApply.id"));
        sic.add(new SelectorItemInfo("mrApply.number"));
        sic.add(new SelectorItemInfo("mrApply.name"));
        return sic;
    }

    @Override
    protected void _shenpiFailed(Context ctx, IObjectValue model) throws BOSException {
        IMRSummary MRSummary2 = MRSummaryFactory.getLocalInstance(ctx);
        try {
            MRSummaryInfo MRSummaryModel = MRSummary2.getMRSummaryInfo((IObjectPK)new ObjectUuidPK(((MRSummaryInfo)model).getId()));
            MRSummaryModel.setState(SummaryStateEnum.SAVE);
            MRSummaryModel.remove("docEntity");
            super._save(ctx, (IObjectValue)MRSummaryModel);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    protected void _summaryWorkFlow(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _quxiao(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected boolean _pigeonholeToDM(Context ctx, IObjectValue model) throws BOSException {
        MRSummaryInfo mrSummaryInfo = (MRSummaryInfo)model;
        ArrayList<String> ids = new ArrayList<String>();
        String billId = model.get("id").toString();
        ids.add(billId);
        MultiDataSourceProviderProxy multiDataSourceProviderProxy = MultiapprovePrintUtility.getMultiQueryDelegate(ids, (Context)ctx);
        OACommonDataProvider data = new OACommonDataProvider(ctx, ids, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRSummaryQuery"));
        String summaryTypeId = mrSummaryInfo.getMrType().getId().toString();
        String cuId = null;
        try {
            MeetingTypeInfo meetingTypeInfo = MeetingTypeFactory.getLocalInstance(ctx).getMeetingTypeInfo((IObjectPK)new ObjectUuidPK(summaryTypeId));
            cuId = meetingTypeInfo.getCU().getId().toString();
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        MrmArchiveCollection pigeCol = MrmArchiveFactory.getLocalInstance(ctx).getMrmArchiveCollection("select isAllowRePige,printTemplate,pigePath,categoryPath.id,categoryPath.isArchive where (mrmTyepName.id='" + summaryTypeId + "' or isOverallSeting=1) and cu.id='" + cuId + "' order by isOverallSeting asc");
        if (pigeCol == null || pigeCol.size() < 1) {
            logger.warn((Object)"***********\u6ca1\u6709\u5f52\u6863\u8bbe\u7f6e**********");
            return false;
        }
        if (mrSummaryInfo.getPigState().getValue() == 1 && !pigeCol.get(0).isIsAllowRePige()) {
            logger.warn((Object)"******************\u8be5\u516c\u6587\u5df2\u5f52\u6863\uff0c\u4e14\u4e0d\u5141\u8bb8\u91cd\u590d\u5f52\u6863*************");
            return false;
        }
        String templatePath = pigeCol.get(0).getPrintTemplate().split(",")[0];
        String categoryId = pigeCol.get(0).getCategoryPath().getId().toString();
        multiDataSourceProviderProxy.put("MainQuery", (BOSQueryDelegate)data);
        if (mrSummaryInfo.getPigState().getValue() != 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String dateStr = "(" + sdf.format(new Date()) + ")";
            mrSummaryInfo.setName(mrSummaryInfo.getName() + dateStr);
        }
        ArchiveDocumentParamsInfo paramsInfo = this.contructParams(mrSummaryInfo, categoryId);
        try {
            ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
            ExportFile.exportPDF((Context)ctx, (String)templatePath, (MultiDataSourceProviderProxy)multiDataSourceProviderProxy, (OutputStream)bodyStream);
            ByteArrayInputStream bodyInputStream = new ByteArrayInputStream(bodyStream.toByteArray());
            List tempList = ArchiveUtils.getAttach((Context)ctx, (String)paramsInfo.getBizID());
            InputStream[] newFileStreams = new ByteArrayInputStream[((InputStream[])tempList.get(0)).length + 1];
            String[] newFileNames = new String[((String[])tempList.get(1)).length + 1];
            if (tempList != null && tempList.size() >= 2) {
                String mrSummaryId = ((MRSummaryInfo)model).getId().toString();
                String docName = "";
                String sql = "select FName,FDocEntity from T_MRM_MrSummary WHERE FID='" + mrSummaryId + "'";
                Blob blob = null;
                InputStream docAsAttatch = null;
                IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rows.next()) {
                    docName = rows.getString(1);
                    blob = rows.getBlob(2);
                    if (null != blob) {
                        docAsAttatch = blob.getBinaryStream();
                    }
                }
                for (int i = 0; i < newFileStreams.length - 1; ++i) {
                    newFileStreams[i] = ((ByteArrayInputStream[])tempList.get(0))[i];
                    newFileNames[i] = ((String[])tempList.get(1))[i];
                }
                newFileStreams[i] = docAsAttatch;
                newFileNames[i] = ResourceBase.getString((String)this.mrmResource, (String)"bodyContent", (Locale)new Locale("L2")) + "(" + docName + ").doc";
            }
            ArchiveDocumentImpl arch = new ArchiveDocumentImpl();
            arch.archiveDocument(ctx, paramsInfo, (InputStream)bodyInputStream, newFileStreams, newFileNames);
            if (1 != mrSummaryInfo.getPigState().getValue()) {
                IMRSummary mrSummaryService = MRSummaryFactory.getLocalInstance(ctx);
                mrSummaryInfo.setPigState(PigeStatusEnum.PIGEONHOLED);
                mrSummaryService.save((CoreBaseInfo)mrSummaryInfo);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getStackTrace());
            return false;
        }
        return true;
    }

    private ArchiveDocumentParamsInfo contructParams(MRSummaryInfo model, String categoryId) {
        if (model == null) {
            return null;
        }
        ArchiveDocumentParamsInfo params = new ArchiveDocumentParamsInfo();
        params.setBizID(model.getId().toString());
        params.setNumber(model.getNumber());
        params.setTitle(model.getName());
        params.setDescription(model.getDescription());
        params.setCreateTime(model.getCreateTime());
        params.setDocNumber(model.getNumber());
        params.setMark("guidang");
        params.setModuleName("mrm");
        params.setVersion("test001");
        params.setArchive(true);
        params.setCategoryId(categoryId);
        params.setContentType(ContentTypeEnum.PDF);
        return params;
    }
}

