/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.sm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.sm.IInvitedPerson2Person;
import com.kingdee.eas.cp.sm.IScheduleEditConfig;
import com.kingdee.eas.cp.sm.ISchedulePlan;
import com.kingdee.eas.cp.sm.InvitedPerson2PersonCollection;
import com.kingdee.eas.cp.sm.InvitedPerson2PersonFactory;
import com.kingdee.eas.cp.sm.InvitedPerson2PersonInfo;
import com.kingdee.eas.cp.sm.MessageCenterUtil;
import com.kingdee.eas.cp.sm.ScheduleEditConfigCollection;
import com.kingdee.eas.cp.sm.ScheduleEditConfigFactory;
import com.kingdee.eas.cp.sm.ScheduleEditConfigInfo;
import com.kingdee.eas.cp.sm.SchedulePlanFactory;
import com.kingdee.eas.cp.sm.SchedulePlanInfo;
import com.kingdee.eas.cp.sm.app.AbstractMessageCenterFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MessageCenterFacadeControllerBean
extends AbstractMessageCenterFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.sm.app.MessageCenterFacadeControllerBean");
    private static final String RES = "com.kingdee.eas.cp.sm.BizCollResource";

    protected void _createMessageBackGroundJob(Context ctx, String scheduleID, Date notifyStartDate, Date notifyFinishDate) throws BOSException, EASBizException {
        EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.cp.sm.app.MessageCenterFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)functionPK);
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("scheduleId", scheduleID);
        if (notifyStartDate != null) {
            try {
                OperationInfo notifyStartDateOperation = function.getOperation().get(0);
                service.createJobProcessDef(MessageCenterFacadeControllerBean.getProcessName(ctx, scheduleID, notifyStartDate), function, notifyStartDateOperation, jobContext, MessageCenterFacadeControllerBean.getScheduleXML(notifyStartDate), ctx.getLocale());
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getStackTrace());
            }
        }
        if (notifyFinishDate != null) {
            try {
                OperationInfo notifyFinishDateOperation = function.getOperation().get(1);
                service.createJobProcessDef(MessageCenterFacadeControllerBean.getProcessName(ctx, scheduleID, notifyFinishDate), function, notifyFinishDateOperation, jobContext, MessageCenterFacadeControllerBean.getScheduleXML(notifyFinishDate), ctx.getLocale());
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getStackTrace());
            }
        }
    }

    protected void _sendMessageForFinish(Context ctx, String scheduleId) throws BOSException {
        SchedulePlanInfo schedulePlanInfo = this.getPlanInfo(ctx, scheduleId);
        if (schedulePlanInfo == null) {
            return;
        }
        if (schedulePlanInfo.getState() == null || "UNDO".equals(schedulePlanInfo.getState().getValue())) {
            Collection personColl = this.getPersonColl(schedulePlanInfo, ctx);
            ScheduleEditConfigInfo editConfigInfo = this.getEditConfig(ctx);
            String title = ResourceBase.getString((String)RES, (String)"schedule_message_for_finish", (Locale)ctx.getLocale());
            title = title.replaceFirst("1AA", schedulePlanInfo.getTitle());
            title = title.replaceFirst("2BB", editConfigInfo.getUndoNotifyConfig() + "");
            logger.info((Object)("MessageCenterFacadeControllerBean::_sendMessageForFinish()---isIsMessage = " + schedulePlanInfo.isIsMessage() + ", isIsMail = " + schedulePlanInfo.isIsMail() + ",isIsMobile = " + schedulePlanInfo.isIsMobile()));
            if (editConfigInfo.isIsMessage()) {
                try {
                    MessageCenterUtil.sendMessage(ctx, personColl, title, schedulePlanInfo.getPersonCreator().getName(), this.getMessageBody(schedulePlanInfo, ctx), scheduleId);
                    logger.info((Object)"MessageCenterFacadeControllerBean::_sendMessageForFinish()--MessageCenterUtil.sendMessage is ok!");
                }
                catch (Exception ex) {
                    logger.error((Object)("MessageCenterFacadeControllerBean::_sendMessageForFinish()--MessageCenterUtil.sendMessage is faild! Exception = " + ex.getMessage()));
                    ex.printStackTrace();
                    logger.error((Object)ex.getStackTrace());
                }
            }
            if (editConfigInfo.isIsMail()) {
                try {
                    MessageCenterUtil.sendMail(ctx, personColl, title, MessageCenterFacadeControllerBean.getCommonMailBody(schedulePlanInfo, ctx), null, null, null);
                    logger.info((Object)"MessageCenterFacadeControllerBean::_sendMessageForFinish()--MessageCenterUtil.sendMail is ok!");
                }
                catch (Exception ex) {
                    logger.error((Object)("MessageCenterFacadeControllerBean::_sendMessageForFinish()--MessageCenterUtil.sendMail is faild! Exception = " + ex.getMessage()));
                    ex.printStackTrace();
                    logger.error((Object)ex.getStackTrace());
                }
            }
            if (editConfigInfo.isIsSms()) {
                try {
                    MessageCenterUtil.sendSMS(ctx, personColl, title);
                    logger.info((Object)"MessageCenterFacadeControllerBean::_sendMessageForFinish()--MessageCenterUtil.sendSMS is ok!");
                }
                catch (Exception ex) {
                    logger.error((Object)("MessageCenterFacadeControllerBean::_sendMessageForFinish()--MessageCenterUtil.sendSMS is faild! Exception = " + ex.getMessage()));
                    ex.printStackTrace();
                    logger.error((Object)ex.getStackTrace());
                }
            }
        }
    }

    protected void _sendMessageForRemind(Context ctx, String scheduleId) throws BOSException, EASBizException {
        SchedulePlanInfo schedulePlanInfo = this.getPlanInfo(ctx, scheduleId);
        if (schedulePlanInfo.getState() == null || "UNDO".equals(schedulePlanInfo.getState().getValue())) {
            Collection personColl = this.getPersonColl(schedulePlanInfo, ctx);
            String title = ResourceBase.getString((String)RES, (String)"schedule_message_for_remind", (Locale)ctx.getLocale());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            title = title.replaceFirst("1AA", "1AA" + ResourceBase.getString((String)RES, (String)"eventDate", (Locale)ctx.getLocale()) + ":" + dateFormat.format(schedulePlanInfo.getEventDate()) + "," + ResourceBase.getString((String)RES, (String)"eventEndDate", (Locale)ctx.getLocale()) + ":" + dateFormat.format(schedulePlanInfo.getEventEndDate()));
            title = title.replaceFirst("1AA", schedulePlanInfo.getTitle());
            title = title.replaceFirst("2BB", schedulePlanInfo.getNotifyTime() + "");
            logger.info((Object)("MessageCenterFacadeControllerBean::_sendMessageForRemind()---isIsMessage = " + schedulePlanInfo.isIsMessage() + ", isIsMail = " + schedulePlanInfo.isIsMail() + ",isIsMobile = " + schedulePlanInfo.isIsMobile()));
            if (schedulePlanInfo.isIsMessage()) {
                try {
                    MessageCenterUtil.sendMessage(ctx, personColl, title, schedulePlanInfo.getPersonCreator().getName(), this.getMessageBody(schedulePlanInfo, ctx), scheduleId);
                    logger.info((Object)"MessageCenterFacadeControllerBean::_sendMessageForRemind()--MessageCenterUtil.sendMessage is ok!");
                }
                catch (Exception ex) {
                    logger.error((Object)("MessageCenterFacadeControllerBean::_sendMessageForRemind()--MessageCenterUtil.sendMessage is faild! Exception = " + ex.getMessage()));
                    ex.printStackTrace();
                    logger.error((Object)ex.getStackTrace());
                }
            }
            if (schedulePlanInfo.isIsMail()) {
                try {
                    MessageCenterUtil.sendMail(ctx, personColl, title, MessageCenterFacadeControllerBean.getCommonMailBody(schedulePlanInfo, ctx), null, null, null);
                    logger.info((Object)"MessageCenterFacadeControllerBean::_sendMessageForRemind()--MessageCenterUtil.sendMail is ok!");
                }
                catch (Exception ex) {
                    logger.error((Object)("MessageCenterFacadeControllerBean::_sendMessageForRemind()--MessageCenterUtil.sendMail is faild! Exception = " + ex.getMessage()));
                    ex.printStackTrace();
                    logger.error((Object)ex.getStackTrace());
                }
            }
            if (schedulePlanInfo.isIsMobile()) {
                try {
                    MessageCenterUtil.sendSMS(ctx, personColl, title);
                    logger.info((Object)"MessageCenterFacadeControllerBean::_sendMessageForRemind()--MessageCenterUtil.sendSMS is ok!");
                }
                catch (Exception ex) {
                    logger.error((Object)("MessageCenterFacadeControllerBean::_sendMessageForRemind()--MessageCenterUtil.sendSMS is faild! Exception = " + ex.getMessage()));
                    ex.printStackTrace();
                    logger.error((Object)ex.getStackTrace());
                }
            }
        }
    }

    public void _deleteMessageRetireJob(Context ctx, String scheduleID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        String local = "_" + ctx.getLocale().toString();
        String procName = MessageCenterFacadeControllerBean.getProcessNamePrefix(scheduleID) + "%";
        sb.append("delete from t_wfr_procdef  \n");
        sb.append("\twhere fprocdeftype = 'BACKGROUNDJOB'  \n");
        sb.append("\tand fname");
        sb.append(local);
        sb.append(" like '");
        sb.append(procName);
        sb.append("'  \n");
        sb.append("\tand fprocdefid not in (  \n");
        sb.append("\tselect fprocdefid from t_wfr_procinst where fprocdefid in (  \n");
        sb.append("\tselect fprocdefid from t_wfr_procdef   \n");
        sb.append("\twhere fprocdeftype='BACKGROUNDJOB'   \n");
        sb.append("\tand fname");
        sb.append(local);
        sb.append(" like '");
        sb.append(procName);
        sb.append("')  \n");
        sb.append("\t\t)  \n");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private String getMessageBody(SchedulePlanInfo planInfo, Context ctx) {
        StringBuffer sb = new StringBuffer();
        sb.append(ResourceBase.getString((String)RES, (String)"schedule_message_body_title", (Locale)ctx.getLocale()));
        sb.append(planInfo.getTitle());
        sb.append("\n");
        sb.append(ResourceBase.getString((String)RES, (String)"schedule_message_body_content", (Locale)ctx.getLocale()));
        String content = null != planInfo.getContent() && !"".equals(planInfo.getContent()) ? planInfo.getContent() : planInfo.getTitle();
        sb.append(content);
        return sb.toString();
    }

    private Collection getPersonColl(SchedulePlanInfo schedulePlanInfo, Context ctx) {
        ArrayList<PersonInfo> personColl = new ArrayList<PersonInfo>();
        personColl.add(schedulePlanInfo.getPersonCreator());
        InvitedPerson2PersonCollection invitedPersonColl = new InvitedPerson2PersonCollection();
        EntityViewInfo invitedPersonView = new EntityViewInfo();
        invitedPersonView.getSelector().add(new SelectorItemInfo("person.id"));
        invitedPersonView.getSelector().add(new SelectorItemInfo("person.name"));
        FilterInfo invitedPersonFilter = new FilterInfo();
        invitedPersonFilter.getFilterItems().add(new FilterItemInfo("schedule", (Object)schedulePlanInfo.getId().toString()));
        invitedPersonFilter.getFilterItems().add(new FilterItemInfo("inviteBillState", (Object)new Integer(2), CompareType.NOTEQUALS));
        invitedPersonView.setFilter(invitedPersonFilter);
        IInvitedPerson2Person iinvitedPerson = null;
        try {
            iinvitedPerson = InvitedPerson2PersonFactory.getLocalInstance(ctx);
            invitedPersonColl = iinvitedPerson.getInvitedPerson2PersonCollection(invitedPersonView);
            Iterator ite = invitedPersonColl.iterator();
            InvitedPerson2PersonInfo person2personInfo = null;
            while (ite.hasNext()) {
                person2personInfo = (InvitedPerson2PersonInfo)ite.next();
                personColl.add(person2personInfo.getPerson());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return personColl;
    }

    private SchedulePlanInfo getPlanInfo(Context ctx, String scheduleId) {
        SchedulePlanInfo schedulePlanInfo = null;
        try {
            ISchedulePlan schedulePlan = SchedulePlanFactory.getLocalInstance(ctx);
            String ksql = " select id,title, isMail, isMobile, isMessage, notifyTime, state, personCreator.id, personCreator.name, eventDate, eventEndDate  where id ='" + scheduleId + "'";
            schedulePlanInfo = schedulePlan.getSchedulePlanInfo(ksql);
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getStackTrace());
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getStackTrace());
        }
        return schedulePlanInfo;
    }

    private static String getDateStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd HH:mm");
        return format.format(date);
    }

    private static String getScheduleDateDesc(Date date) {
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        int day = DateTimeUtils.getDay((Date)date);
        int hour = date.getHours();
        int minute = date.getMinutes();
        int second = date.getSeconds();
        String value = second + " " + minute + " " + hour + " " + day + " " + month + " ? " + year;
        return value;
    }

    private static String getScheduleXML(Date date) {
        Date dt = DateTimeUtils.addMinute((Date)date, (long)1L);
        ScheduleDef define = new ScheduleDef(null);
        define.setType(ScheduleType.ONETIME);
        define.setBeginTime(dt);
        define.setEndTime(dt);
        define.setUseCalendar(false);
        define.setDefine(MessageCenterFacadeControllerBean.getScheduleDateDesc(dt));
        define.setRetryTime(0);
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        return scheduleXML;
    }

    private static String getProcessName(Context ctx, String scheduleID, Date jobDate) {
        return MessageCenterFacadeControllerBean.getProcessNamePrefix(scheduleID) + "_" + MessageCenterFacadeControllerBean.getDateStr(jobDate);
    }

    private static String getProcessNamePrefix(String regularID) {
        return "CP_SM_" + regularID;
    }

    private static String getCommonMailBody(SchedulePlanInfo schedulePlanInfo, Context ctx) {
        String body = ResourceBase.getString((String)RES, (String)"schedule_mail_common_body", (Locale)ctx.getLocale());
        body = body.replaceFirst("0A", schedulePlanInfo.getTitle());
        body = body.replaceFirst("1B", MessageCenterFacadeControllerBean.dateToString(schedulePlanInfo.getEventDate(), "yyyy-MM-dd HH:mm"));
        body = body.replaceFirst("2C", MessageCenterFacadeControllerBean.dateToString(schedulePlanInfo.getEventEndDate(), "yyyy-MM-dd HH:mm"));
        body = body.replaceFirst("3D", schedulePlanInfo.getPersonCreator().getName());
        return body;
    }

    private static String dateToString(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat fo = new SimpleDateFormat(pattern);
        return fo.format(date);
    }

    private ScheduleEditConfigInfo getEditConfig(Context ctx) {
        ScheduleEditConfigInfo retInfo = null;
        try {
            IScheduleEditConfig editConfigService = ScheduleEditConfigFactory.getLocalInstance(ctx);
            ScheduleEditConfigCollection coll = editConfigService.getScheduleEditConfigCollection();
            if (coll != null && coll.size() == 1) {
                retInfo = coll.get(0);
            } else {
                retInfo = new ScheduleEditConfigInfo();
                retInfo.setMaxFinishEditConfig(3);
                retInfo.setMaxUndoEditConfig(3);
                retInfo.setUndoNotifyConfig(12);
                retInfo.setIsMail(true);
                retInfo.setIsMessage(true);
                retInfo.setIsSms(false);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return retInfo;
    }
}

