/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.sm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.sm.ISchedule4PersonVisableConfig;
import com.kingdee.eas.cp.sm.Schedule4PersonVisableConfigFactory;
import com.kingdee.eas.cp.sm.Schedule4PersonVisableConfigInfo;
import com.kingdee.eas.cp.sm.ScheduleShareConfigCollection;
import com.kingdee.eas.cp.sm.ScheduleShareConfigInfo;
import com.kingdee.eas.cp.sm.util.CommonDataUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ScheduleDataDao {
    public List getMyCreateScheduleData(Context ctx, Calendar cal) throws BOSException, SQLException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userId", userInfo.getPerson().getId().toString());
        return this.getUserCreateScheduleData(ctx, paramMap);
    }

    public List getUserCreateScheduleData(Context ctx, Map paramMap) throws BOSException, SQLException {
        Calendar cal = (Calendar)paramMap.get("userCal");
        List retList = new ArrayList();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(this.getSelectorOfMySchedule());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo = this.getFilterInfoOfUserSchedule(ctx, paramMap);
        if (cal != null) {
            filterInfo.mergeFilter(this.getQueryTimeZone(cal), "and");
        }
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.sm.app.SchedulePlanQuery");
        retList = CommonDataUtil.query((IMetaDataPK)queryPK, entityViewInfo, ctx);
        return retList;
    }

    public List getInvitedMyScheduleData(Context ctx) throws BOSException, SQLException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userId", userInfo.getPerson().getId().toString());
        return this.getInvitedUserScheduleData(ctx, paramMap);
    }

    public List getInvitedUserScheduleData(Context ctx, Map paramMap) throws BOSException, SQLException {
        Calendar cal = (Calendar)paramMap.get("userCal");
        List retList = new ArrayList();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(this.getSelectorOfInvitedMy());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo = this.getFilterInfoOfInvitedUser(ctx, paramMap);
        if (cal != null) {
            filterInfo.mergeFilter(this.getQueryTimeZone(cal), "and");
        }
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.sm.app.SchedulePlanQuery");
        retList = CommonDataUtil.query((IMetaDataPK)queryPK, entityViewInfo, ctx);
        return retList;
    }

    protected IMetaDataPK getQueryPK(Context ctx, Map paramMap) {
        return new MetaDataPK("com.kingdee.eas.cp.sm.app.SchedulePlanQuery");
    }

    public Set getPersonIdSet(Context ctx, HttpServletRequest request) {
        HashSet<String> resultSet = new HashSet<String>();
        try {
            ISchedule4PersonVisableConfig iconfig = Schedule4PersonVisableConfigFactory.getLocalInstance(ctx);
            PersonInfo curPersonInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            String sql = "select *,config.person.id,config.person.name,config.isView where person.id='" + curPersonInfo.getId().toString() + "' ";
            Schedule4PersonVisableConfigInfo configInfo = null;
            configInfo = !iconfig.exists(sql) ? new Schedule4PersonVisableConfigInfo() : iconfig.getSchedule4PersonVisableConfigInfo(sql);
            ScheduleShareConfigCollection sscc = configInfo.getConfig();
            ScheduleShareConfigInfo ssc = null;
            int size = sscc.size();
            for (int i = 0; i < size; ++i) {
                ssc = sscc.get(i);
                PersonInfo person = ssc.getPerson();
                if (!ssc.isIsView()) continue;
                resultSet.add(person.getId().toString());
            }
            HttpSession session = request.getSession();
            if ("yes".equals(session.getAttribute("showSelf"))) {
                resultSet.add(curPersonInfo.getId().toString());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    private FilterInfo getFilterInfoOfMySchedule(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("personCreator.id", (Object)userInfo.getPerson().getId().toString()));
        return filterInfo;
    }

    private FilterInfo getFilterInfoOfUserSchedule(Context ctx, Map paramMap) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        String userId = "";
        userId = paramMap.get("userId") != null ? paramMap.get("userId").toString() : userInfo.getPerson().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("personCreator.id", (Object)userId));
        return filterInfo;
    }

    private FilterInfo getFilterInfoOfInvitedMy(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("invitedPerson.person.id", (Object)userInfo.getPerson().getId().toString()));
        return filterInfo;
    }

    private FilterInfo getFilterInfoOfInvitedUser(Context ctx, Map paramMap) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        String userId = "";
        userId = paramMap.get("userId") != null ? paramMap.get("userId").toString() : userInfo.getPerson().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("invitedPerson.person.id", (Object)userId));
        return filterInfo;
    }

    private SelectorItemCollection getSelectorOfMySchedule() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("eventDate"));
        sic.add(new SelectorItemInfo("eventEndDate"));
        sic.add(new SelectorItemInfo("title"));
        sic.add(new SelectorItemInfo("content"));
        sic.add(new SelectorItemInfo("personCreator.name"));
        sic.add(new SelectorItemInfo("personCreator.id"));
        sic.add(new SelectorItemInfo("sstate"));
        sic.add(new SelectorItemInfo("scheduleStatus"));
        sic.add(new SelectorItemInfo("scheduleType.name"));
        return sic;
    }

    private SelectorItemCollection getSelectorOfMineList() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("eventDate"));
        sic.add(new SelectorItemInfo("eventEndDate"));
        sic.add(new SelectorItemInfo("title"));
        sic.add(new SelectorItemInfo("content"));
        sic.add(new SelectorItemInfo("personCreator.name"));
        sic.add(new SelectorItemInfo("personCreator.id"));
        sic.add(new SelectorItemInfo("sstate"));
        sic.add(new SelectorItemInfo("scheduleStatus"));
        sic.add(new SelectorItemInfo("scheduleType.name"));
        sic.add(new SelectorItemInfo("invitedPerson.inviter.name"));
        sic.add(new SelectorItemInfo("invitedPerson.inviter.id"));
        sic.add(new SelectorItemInfo("invitedPerson.person.name"));
        sic.add(new SelectorItemInfo("invitedPerson.person.id"));
        sic.add(new SelectorItemInfo("invitedPerson.inviteBillState"));
        sic.add(new SelectorItemInfo("invitedPerson.isdeleted"));
        return sic;
    }

    private SelectorItemCollection getSelectorOfInvitedMy() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("eventDate"));
        sic.add(new SelectorItemInfo("eventEndDate"));
        sic.add(new SelectorItemInfo("title"));
        sic.add(new SelectorItemInfo("content"));
        sic.add(new SelectorItemInfo("personCreator.name"));
        sic.add(new SelectorItemInfo("personCreator.id"));
        sic.add(new SelectorItemInfo("sstate"));
        sic.add(new SelectorItemInfo("invitedPerson.inviter.name"));
        sic.add(new SelectorItemInfo("invitedPerson.inviter.id"));
        sic.add(new SelectorItemInfo("invitedPerson.person.name"));
        sic.add(new SelectorItemInfo("invitedPerson.person.id"));
        sic.add(new SelectorItemInfo("invitedPerson.inviteBillState"));
        sic.add(new SelectorItemInfo("invitedPerson.isdeleted"));
        return sic;
    }

    public boolean isShowCancelSchedule(Context ctx, UserInfo userInfo) {
        boolean result = true;
        String sql = "select isCancelVisable,isDeletedVisable where person.id ='" + userInfo.getPerson().getId().toString() + "'";
        Schedule4PersonVisableConfigInfo configModel = new Schedule4PersonVisableConfigInfo();
        try {
            ISchedule4PersonVisableConfig ischeduleConfig = Schedule4PersonVisableConfigFactory.getLocalInstance(ctx);
            if (ischeduleConfig.exists(sql)) {
                configModel = ischeduleConfig.getSchedule4PersonVisableConfigInfo(sql);
                result = configModel.isIsCancelVisable();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isShowDeletedSchedule(Context ctx, UserInfo userInfo) {
        boolean result = true;
        String sql = "select isCancelVisable,isDeletedVisable where person.id ='" + userInfo.getPerson().getId().toString() + "'";
        Schedule4PersonVisableConfigInfo configModel = new Schedule4PersonVisableConfigInfo();
        try {
            ISchedule4PersonVisableConfig ischeduleConfig = Schedule4PersonVisableConfigFactory.getLocalInstance(ctx);
            if (ischeduleConfig.exists(sql)) {
                configModel = ischeduleConfig.getSchedule4PersonVisableConfigInfo(sql);
                result = configModel.isIsDeletedVisable();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map transDate3Months(Calendar cal) {
        HashMap<String, Calendar> paramMap = new HashMap<String, Calendar>();
        if (cal == null) {
            return null;
        }
        paramMap.put("curCalRange", cal);
        int[][] months = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
        int month = cal.get(2);
        int year = cal.get(1);
        Calendar minCalRange = Calendar.getInstance();
        int mYear = year;
        int mMonth = month - 1;
        if (month == 0) {
            --mYear;
            mMonth = 11;
        }
        minCalRange.set(1, mYear);
        minCalRange.set(2, mMonth);
        minCalRange.set(5, 1);
        minCalRange.set(11, 0);
        minCalRange.set(12, 0);
        minCalRange.set(13, 0);
        paramMap.put("minCalRange", minCalRange);
        int xYear = year;
        int xMonth = month + 1;
        if (month == 11) {
            ++xYear;
            xMonth = 0;
        }
        int nextMonthDay = months[this.isLeapYear(year)][xMonth];
        Calendar maxCalRange = Calendar.getInstance();
        maxCalRange.set(1, xYear);
        maxCalRange.set(2, xMonth);
        maxCalRange.set(5, nextMonthDay);
        maxCalRange.set(11, 23);
        maxCalRange.set(12, 59);
        maxCalRange.set(13, 59);
        paramMap.put("maxCalRange", maxCalRange);
        return paramMap;
    }

    public FilterInfo getQueryTimeZone(Calendar cal) {
        FilterInfo filter = new FilterInfo();
        Map monthMap = this.transDate3Months(cal);
        Calendar minCalRange = (Calendar)monthMap.get("minCalRange");
        filter.getFilterItems().add(new FilterItemInfo("eventDate", (Object)minCalRange.getTime(), CompareType.GREATER_EQUALS));
        Calendar maxCalRange = (Calendar)monthMap.get("maxCalRange");
        filter.getFilterItems().add(new FilterItemInfo("eventDate", (Object)maxCalRange.getTime(), CompareType.LESS_EQUALS));
        return filter;
    }

    public int isLeapYear(int year) {
        if (year % 4 == 0 || year % 4 == 0 && year % 100 != 0) {
            return 1;
        }
        return 0;
    }
}

