/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.stamp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.stamp.CommonSealFactory;
import com.kingdee.eas.cp.stamp.CommonSealInfo;
import com.kingdee.eas.cp.stamp.ICommonSeal;
import com.kingdee.eas.cp.stamp.IPersonalSeal;
import com.kingdee.eas.cp.stamp.IStampLog;
import com.kingdee.eas.cp.stamp.LogResultEnum;
import com.kingdee.eas.cp.stamp.OperationTypeEnum;
import com.kingdee.eas.cp.stamp.PersonalSealFactory;
import com.kingdee.eas.cp.stamp.PersonalSealInfo;
import com.kingdee.eas.cp.stamp.SealTypeEnum;
import com.kingdee.eas.cp.stamp.StampLogFactory;
import com.kingdee.eas.cp.stamp.StampLogInfo;
import com.kingdee.eas.cp.stamp.SubmodelEnum;
import com.kingdee.eas.cp.stamp.SubsystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class StampLogUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.stamp.StampLogUtil");

    public static IObjectPK beginLog(Context ctx, String sealID, String bizObjType, int subsystem, int submodel, String billTitle, int operationType) {
        IObjectPK logPK = null;
        int sealType = StampLogUtil.getSealType(ctx, sealID);
        logPK = StampLogUtil.beginLog(ctx, sealID, BOSObjectType.create((String)bizObjType), subsystem, submodel, billTitle, sealType, operationType);
        return logPK;
    }

    public static IObjectPK beginLog(Context ctx, String sealID, BOSObjectType bizObjType, int subsystem, int submodel, String billTitle, int sealType, int operationType) {
        IObjectPK logPK = null;
        StampLogInfo stampLogInfo = new StampLogInfo();
        stampLogInfo.setSealID(sealID);
        stampLogInfo.setEntityBosTypeId(bizObjType.toString());
        stampLogInfo.setSubsystem(SubsystemEnum.getEnum(subsystem));
        stampLogInfo.setSubmodel(SubmodelEnum.getEnum(submodel));
        stampLogInfo.setBillTitle(billTitle);
        stampLogInfo.setSealType(SealTypeEnum.getEnum(sealType));
        stampLogInfo.setIsSuccessed(LogResultEnum.FAILED);
        stampLogInfo.setOccurTime(new Timestamp(System.currentTimeMillis()));
        stampLogInfo.setOperationType(OperationTypeEnum.getEnum(operationType));
        StampLogUtil.fillPersonAndCUInfo(ctx, stampLogInfo);
        StampLogUtil.fillSealName(ctx, sealID, sealType, stampLogInfo);
        StampLogUtil.fillEntityName(ctx, bizObjType, stampLogInfo, subsystem, submodel);
        try {
            logPK = StampLogUtil.getStampLogBizInterface(ctx).save(stampLogInfo);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        return logPK;
    }

    public static int getSealType(Context ctx, String sealID) {
        int sealtype = 1;
        try {
            ICommonSeal commonSeal = StampLogUtil.getCommonSealBizInterface(ctx);
            if (!commonSeal.exists((IObjectPK)new ObjectUuidPK(sealID))) {
                sealtype = 2;
            }
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        return sealtype;
    }

    public static void afterLog(Context ctx, IObjectPK logPK) {
        if (logPK == null) {
            return;
        }
        try {
            StampLogUtil.getStampLogBizInterface(ctx).upateLogStatus(logPK);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
    }

    private static void fillPersonAndCUInfo(Context ctx, StampLogInfo stampLogInfo) {
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        stampLogInfo.setOperationPersonID(person.getId().toString());
        stampLogInfo.setOperationPersonName(person.getName());
        stampLogInfo.setPermissionPersonID(person.getId().toString());
        stampLogInfo.setPermissionPersonName(person.getName());
        CtrlUnitInfo ctrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        stampLogInfo.setCuID(ctrlUnit.getId().toString());
    }

    private static void fillSealName(Context ctx, String sealID, int sealType, StampLogInfo stampLogInfo) {
        try {
            String sealName = null;
            if (sealType == 1) {
                ICommonSeal commonSeal = StampLogUtil.getCommonSealBizInterface(ctx);
                CommonSealInfo commonSealInfo = commonSeal.getCommonSealInfo((IObjectPK)new ObjectUuidPK(sealID));
                sealName = commonSealInfo.getName();
            } else {
                IPersonalSeal personSeal = StampLogUtil.getPersonalSealBizInterface(ctx);
                PersonalSealInfo personSealInfo = personSeal.getPersonalSealInfo((IObjectPK)new ObjectUuidPK(sealID));
                sealName = personSealInfo.getName();
            }
            stampLogInfo.setSealName(sealName);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
    }

    private static void fillEntityName(Context ctx, BOSObjectType bizObjType, StampLogInfo stampLogInfo, int subsystem, int submodel) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BusinessObjectInfo boInfo = null;
        try {
            boInfo = loader.getBusinessObject(bizObjType);
        }
        catch (MetaDataNotFoundException e) {
            return;
        }
        if (boInfo == null) {
            return;
        }
        stampLogInfo.setEntityName(boInfo.getAlias());
    }

    private static ICommonSeal getCommonSealBizInterface(Context ctx) throws BOSException {
        ICommonSeal commonSeal = null;
        try {
            commonSeal = ctx == null ? CommonSealFactory.getRemoteInstance() : CommonSealFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        return commonSeal;
    }

    private static IPersonalSeal getPersonalSealBizInterface(Context ctx) throws BOSException {
        IPersonalSeal personalSeal = null;
        try {
            personalSeal = ctx == null ? PersonalSealFactory.getRemoteInstance() : PersonalSealFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        return personalSeal;
    }

    private static IStampLog getStampLogBizInterface(Context ctx) throws BOSException {
        IStampLog stampLog = null;
        try {
            stampLog = ctx != null ? StampLogFactory.getLocalInstance(ctx) : StampLogFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        return stampLog;
    }
}

