/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.stamp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentHandleFacade;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.util.WebAttachmentItem;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.service.WebFMEServiceImpl;
import com.kingdee.eas.base.fme.uimodel.FMEParameter;
import com.kingdee.eas.base.form.extend.flow.ITemplate;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.extend.flow.TemplateUsedStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.stamp.AbstractExchangeLogEntryInfo;
import com.kingdee.eas.cp.stamp.AttachStatusEnum;
import com.kingdee.eas.cp.stamp.ExchangeFailedTypeEnum;
import com.kingdee.eas.cp.stamp.ExchangeLogCollection;
import com.kingdee.eas.cp.stamp.ExchangeLogEntryCollection;
import com.kingdee.eas.cp.stamp.ExchangeLogEntryFactory;
import com.kingdee.eas.cp.stamp.ExchangeLogEntryInfo;
import com.kingdee.eas.cp.stamp.ExchangeLogFactory;
import com.kingdee.eas.cp.stamp.ExchangeLogInfo;
import com.kingdee.eas.cp.stamp.ExchangeStateEnum;
import com.kingdee.eas.cp.stamp.IExchangeLog;
import com.kingdee.eas.cp.stamp.app.AbstractExchangeFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ExchangeFacadeControllerBean
extends AbstractExchangeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.stamp.app.ExchangeFacadeControllerBean");
    private static String queryBoAttSql = "SELECT FAttachmentID FROM T_BAS_BoAttchAsso WHERE FBoID = ''{0}'' ";
    private static String deleteBoAttSql = "DELETE FROM T_BAS_BoAttchAsso WHERE FBoID = ''{0}''";
    private static String deleteAttSql = "DELETE FROM t_bas_attachment WHERE FID = ''{0}''";
    private static String querySql = "select \"ATTACHMENT\".fid,\"ATTACHMENT\".fsimplename, \"ATTACHMENT\".fname_l2,\"ATTACHMENT\".fname_l3  FROM T_BAS_Attachment AS \"ATTACHMENT\"  RIGHT OUTER JOIN T_BAS_BoAttchAsso AS \"BOATTCHASSO\"  ON \"ATTACHMENT\".FID = \"BOATTCHASSO\".FAttachmentID  where \"BOATTCHASSO\".FBoID = ? ";

    @Override
    protected boolean _ftpExchange(Context ctx, String formIds) throws BOSException {
        IExchangeLog iExchange = ExchangeLogFactory.getLocalInstance(ctx);
        ExchangeLogCollection coll = iExchange.getExchangeLogCollection(this.getExchangeEntityView());
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            ExchangeLogInfo info = coll.get(i);
            if (!this.checkBeforeExchange(info.getFormId(), ctx)) continue;
            logger.info((Object)("FTPexchange" + info.getFormId().toString()));
            this.changeTemplateState(info.getFormId(), ctx, 0);
            this.changeExchangeLogState(info.getFormId(), "1", ctx);
            boolean flag = this.doUnhandStateExchange(info, ctx);
            logger.info((Object)"FTPexchange do unhand exchange ok");
            if (flag) {
                this.updateFormCtrlAndPropertyTable(ctx, info);
                this.changeExchangeLogState(info.getFormId(), "2", ctx);
                this.changeTemplateState(info.getFormId(), ctx, info.getTemplateUsedState().getValue());
                continue;
            }
            this.changeExchangeLogState(info.getFormId(), "3", ctx);
        }
        return true;
    }

    @Override
    protected boolean _deleteAttachment(Context ctx, String formIds) throws BOSException {
        if (null != formIds) {
            IExchangeLog iExchange = ExchangeLogFactory.getLocalInstance(ctx);
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("attachState", (Object)"1", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("attachState", (Object)"3", CompareType.EQUALS));
            filter.setMaskString("#0 or #1)");
            entityView.setFilter(filter);
            ExchangeLogCollection coll = iExchange.getExchangeLogCollection(entityView);
            IBoAttchAsso iBoAtt = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            Iterator ite = coll.iterator();
            while (ite.hasNext()) {
                ExchangeLogInfo logInfo = (ExchangeLogInfo)ite.next();
                logger.info((Object)("FTPdelete" + logInfo.getFormId().toString()));
                IObjectCollection dataColl = this.getExchangeBillColl(logInfo.getFormMainEntity(), ctx, null);
                if (dataColl != null) {
                    ArrayList<String> aList = new ArrayList<String>();
                    int j = dataColl.size();
                    for (int i = 0; i < j; ++i) {
                        String queryBoAtt = MessageFormat.format(queryBoAttSql, dataColl.getObject(i).get("id").toString());
                        String deleteBoAtt = MessageFormat.format(deleteBoAttSql, dataColl.getObject(i).get("id").toString());
                        try {
                            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryBoAtt);
                            while (rs.next()) {
                                aList.add(rs.getString("FAttachmentID"));
                            }
                            DbUtil.execute((Context)ctx, (String)deleteBoAtt);
                            Iterator iteEx = aList.iterator();
                            while (iteEx.hasNext()) {
                                String deleteAtt = MessageFormat.format(deleteAttSql, (String)iteEx.next());
                                DbUtil.execute((Context)ctx, (String)deleteAtt);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.changeExchangeAttaState(iExchange, logInfo, "3", ctx);
                            return false;
                        }
                    }
                }
                this.changeExchangeAttaState(iExchange, logInfo, "2", ctx);
            }
            return true;
        }
        return false;
    }

    private void changeExchangeAttaState(IExchangeLog iExchange, ExchangeLogInfo info, String attaState, Context ctx) {
        info.setAttachState(AttachStatusEnum.getEnum(attaState));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("attachState"));
        try {
            iExchange.updatePartial(info, sic);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void updateFormCtrlAndPropertyTable(Context ctx, ExchangeLogInfo info) {
        String formId = info.getFormId();
        String newCtrlId = "";
        String newKey = "";
        String layoutId = "";
        String layoutCtrlSql = "SELECT * FROM T_BAS_FormLayoutCtrl WHERE FLayoutID IN ( SELECT FID FROM T_BAS_FormLayout WHERE FFormID=?) AND FElementTypeID = ?";
        String delLayoutCtrlSql = "DELETE FROM T_BAS_FormLayoutCtrl WHERE FLayoutID = ? AND FElementTypeID= ?";
        String delLayoutCtrlBtn = "DELETE FROM T_BAS_FormLayoutCtrl WHERE FLayoutID = ? AND FKey in ( SELECT FObjectKey FROM T_BAS_FormActionList WHERE FFormID = ? and FParaments like '%Upload%')";
        String delExtPropertySql = "DELETE FROM t_bas_formextproperty WHERE fformid = ?  AND fobjectkey IN (SELECT Fkey FROM T_BAS_FormLayoutCtrl WHERE flayoutid = ? and felementtypeid = ?)";
        String updateVersionSql = "UPDATE T_BAS_Form SET FVersion = ? WHERE FID = ? ";
        String queryVersionSql = "SELECT FVersion FROM T_BAS_Form WHERE FID = '" + formId + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryVersionSql);
            if (rs.next()) {
                DbUtil.execute((Context)ctx, (String)updateVersionSql, (Object[])new String[]{"" + new Date().getTime(), formId});
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)layoutCtrlSql, (Object[])new Object[]{formId, new Integer(1013)})).next()) {
                newCtrlId = this.createNewID();
                newKey = "F" + new Date().getTime();
                layoutId = rs.getString("FLayoutID");
                StringBuffer insertCtrlSql = new StringBuffer(200);
                insertCtrlSql.append("INSERT INTO T_BAS_FormLayoutCtrl (FID,FLayoutID,FKey,FentityKey,").append("FElementTypeID,FCaption_L1,FCaption_L2,FCaption_L3,FLeft, FTop,FWidth,FHeight,").append(" FStyle,FContainer,FTabIndex,FLocked,FVisible ) VALUES (").append(" '" + newCtrlId + "','").append(rs.getString("FLayoutID") + "', '").append(newKey + "', '").append(rs.getString("FentityKey") + "',").append("1024, '").append(rs.getString("FCaption_L1") + "', '").append(rs.getString("FCaption_L2") + "', '").append(rs.getString("FCaption_L3") + "', ").append(rs.getInt("FLeft") + ", ").append(rs.getInt("FTop") + ", ").append(rs.getInt("FWidth") + ", ").append(rs.getInt("FHeight") + ", ").append(rs.getInt("FStyle") + ", '").append(rs.getString("FContainer") + "', ").append(rs.getInt("FTabIndex") + ", ").append(rs.getInt("FLocked") + ", ").append(rs.getInt("FVisible") + ") ");
                DbUtil.execute((Context)ctx, (String)insertCtrlSql.toString());
                String propertySql = " insert into T_BAS_FormExtProperty(FID, FFormID, FLayoutID, FObjectKey,  FObjectType, FPropertyName, FValue, FValueType) VALUES(?,?,?,?,?,?,?,?)";
                DbUtil.execute((Context)ctx, (String)propertySql, (Object[])new Object[]{this.createNewID(), formId, layoutId, newKey, new Integer(3), "FtpServer", info.getFtpPathId(), new Integer(0)});
                DbUtil.execute((Context)ctx, (String)propertySql, (Object[])new Object[]{this.createNewID(), formId, layoutId, newKey, new Integer(3), "FtpFileSize", "100", new Integer(1)});
                DbUtil.execute((Context)ctx, (String)propertySql, (Object[])new Object[]{this.createNewID(), formId, layoutId, newKey, new Integer(3), "FtpFileCount", "10", new Integer(1)});
                DbUtil.execute((Context)ctx, (String)propertySql, (Object[])new Object[]{this.createNewID(), formId, layoutId, newKey, new Integer(3), "FtpFileExt", "doc,docx,xls,xlsx,pdf,ppt,pptx,txt,zip,rar,bmp,jpg,gif,png", new Integer(0)});
                DbUtil.execute((Context)ctx, (String)delExtPropertySql, (Object[])new Object[]{formId, layoutId, new Integer(1013)});
                DbUtil.execute((Context)ctx, (String)delLayoutCtrlSql, (Object[])new Object[]{layoutId, new Integer(1013)});
                DbUtil.execute((Context)ctx, (String)delLayoutCtrlBtn, (Object[])new String[]{layoutId, formId});
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private boolean doUnhandStateExchange(ExchangeLogInfo info, Context ctx) {
        boolean flag = true;
        IObjectCollection dataColl = this.getExchangeBillColl(info.getFormMainEntity(), ctx, this.getBillFilterInfo(info));
        if (dataColl != null && dataColl != null && dataColl.size() > 0) {
            for (IObjectValue value : dataColl) {
                try {
                    this.doExchangeByBillId(value.get("id").toString(), info.getFormId(), info.getFtpPathId(), ctx);
                }
                catch (BOSException e) {
                    flag = false;
                    this.handlerFailedExchange(info, value, (Exception)((Object)e), ctx);
                    logger.error((Object)e.getStackTrace());
                    break;
                }
                catch (Exception e) {
                    flag = false;
                    this.handlerFailedExchange(info, value, e, ctx);
                    logger.error((Object)e.getStackTrace());
                    break;
                }
            }
        }
        return flag;
    }

    private FilterInfo getBillFilterInfo(ExchangeLogInfo info) {
        FilterInfo filter = null;
        if (info.getEntries() != null && info.getEntries().size() > 0) {
            filter = new FilterInfo();
            ExchangeLogEntryCollection coll = info.getEntries();
            Iterator ite = coll.iterator();
            AbstractExchangeLogEntryInfo aEntry = null;
            while (ite.hasNext()) {
                ExchangeLogEntryInfo iteTmp = (ExchangeLogEntryInfo)ite.next();
                if (aEntry != null && !aEntry.getBoCreateTime().before(iteTmp.getBoCreateTime())) continue;
                aEntry = iteTmp;
            }
            if (filter.getFilterItems() != null && aEntry != null) {
                filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)aEntry.getBoCreateTime(), CompareType.GREATER_EQUALS));
            }
        }
        return filter;
    }

    private void handlerFailedExchange(ExchangeLogInfo info, IObjectValue value, Exception e, Context ctx) {
        String billId = value.get("id").toString();
        Timestamp createTime = (Timestamp)value.get("createTime");
        String errMsg = e.getMessage();
        String errMsgDetail = "";
        StackTraceElement[] es = e.getStackTrace();
        if (es != null) {
            int j = es.length;
            for (int i = 0; i < j; ++i) {
                errMsgDetail = errMsgDetail + es[i].toString();
            }
            if (errMsgDetail.length() > 200) {
                errMsgDetail = errMsgDetail.substring(0, 2000);
            }
        }
        ExchangeLogEntryInfo entryInfo = new ExchangeLogEntryInfo();
        entryInfo.setBoId(billId);
        entryInfo.setBoCreateTime(createTime);
        entryInfo.setDetail(errMsg);
        entryInfo.setDetailEx(errMsgDetail);
        entryInfo.setParent(info);
        entryInfo.setFailedType(ExchangeFailedTypeEnum.BILLFAILED);
        try {
            ExchangeLogEntryFactory.getLocalInstance(ctx).addnew(entryInfo);
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getStackTrace());
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getStackTrace());
        }
    }

    private boolean checkBeforeExchange(String formId, Context ctx) {
        boolean flag = true;
        return flag;
    }

    private void changeTemplateState(String formId, Context ctx, int templateState) {
        try {
            ITemplate iTemplate = TemplateFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("formID", (Object)formId));
            entityView.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("usedState"));
            CoreBaseCollection coll = iTemplate.getCollection(entityView);
            if (coll.size() > 0) {
                Iterator ite = coll.iterator();
                TemplateInfo aInfo = null;
                while (ite.hasNext()) {
                    aInfo = (TemplateInfo)ite.next();
                    aInfo.setUsedState(TemplateUsedStateEnum.getEnum((int)templateState));
                    iTemplate.updatePartial((CoreBaseInfo)aInfo, sic);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getStackTrace());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getStackTrace());
        }
    }

    private void changeExchangeLogState(String formId, String state, Context ctx) {
        try {
            IExchangeLog iExchangeLog = ExchangeLogFactory.getLocalInstance(ctx);
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("formID", (Object)formId));
            entityView.setFilter(filterInfo);
            ExchangeLogCollection coll = iExchangeLog.getExchangeLogCollection(entityView);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("exchangeState"));
            sic.add(new SelectorItemInfo("startTime"));
            sic.add(new SelectorItemInfo("endTime"));
            if (coll.size() > 0) {
                Iterator ite = coll.iterator();
                ExchangeLogInfo aLog = null;
                while (ite.hasNext()) {
                    aLog = (ExchangeLogInfo)ite.next();
                    aLog.setExchangeState(ExchangeStateEnum.getEnum(state));
                    if ("1".equals(state)) {
                        aLog.setStartTime(new Timestamp(new Date().getTime()));
                    } else if ("2".equals(state)) {
                        aLog.setEndTime(new Timestamp(new Date().getTime()));
                    }
                    iExchangeLog.updatePartial(aLog, sic);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private EntityViewInfo getExchangeEntityView() {
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeState", (Object)"0", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("exchangeState", (Object)"3", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        info.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        info.setSelector(sic);
        return info;
    }

    private IObjectCollection getExchangeBillColl(String bosType, Context ctx, FilterInfo filterInfo) {
        IObjectCollection coll = null;
        try {
            Connection cn = EJBFactory.getConnection((Context)ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)bosType), (Context)ctx, (Connection)cn);
            if (filterInfo != null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo sorterItemInfonew = new SorterItemInfo("createTime");
                sorterItemInfonew.setSortType(SortType.ASCEND);
                sorter.add(sorterItemInfonew);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                viewInfo.setFilter(filterInfo);
                viewInfo.setSorter(sorter);
                viewInfo.setSelector(sic);
                coll = dao.getCollection(viewInfo);
            } else {
                coll = dao.getCollection("SELECT ID ORDER BY createTime ASC");
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return coll;
    }

    private boolean doExchangeByBillId(String billId, String formId, String ftpPathId, Context ctx) throws BOSException, Exception {
        logger.info((Object)("FTPexchange doExchangeByBillId" + billId + "," + formId));
        boolean flag = true;
        try {
            AttachmentCollection attachmentList = ExchangeFacadeControllerBean.getAttachmentCollectionBy(billId, ctx);
            int length = 0;
            if (attachmentList != null) {
                Iterator ite = attachmentList.iterator();
                while (ite.hasNext()) {
                    AttachmentInfo info = (AttachmentInfo)ite.next();
                    if (null == info.getFile()) {
                        ite.remove();
                        continue;
                    }
                    ++length;
                }
            }
            logger.info((Object)("FTPexchange doExchangeByBillId attach size" + billId + "," + length));
            if (length > 0) {
                InputStream[] fileStreams = new InputStream[length];
                String[] fileNames = new String[length];
                String[] userIds = new String[length];
                for (int i = 0; i < length; ++i) {
                    fileStreams[i] = new ByteArrayInputStream(attachmentList.get(i).getFile());
                    fileNames[i] = attachmentList.get(i).getName() + "." + attachmentList.get(i).getSimpleName();
                    userIds[i] = attachmentList.get(i).getCreator() == null ? "" : attachmentList.get(i).getCreator().getId().toString();
                }
                FMEParameter param = new FMEParameter();
                param.setClientType(1);
                param.setNewBusinessID(billId);
                param.setNewPathID(ftpPathId);
                param.setNewCategoryInfo(formId);
                param.setQueryCategoryInfo(formId);
                WebFMEServiceImpl fmeService = new WebFMEServiceImpl(ctx);
                logger.info((Object)("FTPexchange doExchangeByBillId attach ftp start " + billId));
                ServiceResult result = fmeService.uploadFile(fileStreams, fileNames, billId, param, userIds);
                logger.info((Object)("FTPexchange doExchangeByBillId attach ftp ok " + billId));
                if (!result.isResult()) {
                    flag = false;
                    throw new Exception(result.toString());
                }
            }
        }
        catch (BOSException e) {
            flag = false;
            throw e;
        }
        catch (Exception e) {
            flag = false;
            throw e;
        }
        return flag;
    }

    private static AttachmentCollection getAttachmentCollectionBy(String billId, Context context) throws BOSException {
        IAttachment attachment = AttachmentFactory.getLocalInstance((Context)context);
        AttachmentCollection attachmentCollection = null;
        HashSet<String> ids = new HashSet<String>();
        IRowSet rowset = DbUtil.executeQuery((Context)context, (String)querySql, (Object[])new String[]{billId});
        try {
            while (rowset.next()) {
                ids.add(rowset.getString("fid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (ids.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            evi.setSelector(ExchangeFacadeControllerBean.getAttachmentInfoSelector());
            attachmentCollection = attachment.getAttachmentCollection(evi);
        }
        return attachmentCollection;
    }

    private static List getAttachmentListBy(String billId, Context context) throws BOSException {
        IAttachmentHandleFacade attachHandler = AttachmentHandleFacadeFactory.getLocalInstance((Context)context);
        return attachHandler.getWebAttachment(billId);
    }

    private static EntityViewInfo getEntityViewInfo4AttachmentInfo(List attachments) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(ExchangeFacadeControllerBean.getAttachmentInfoFilter(attachments));
        evi.setSelector(ExchangeFacadeControllerBean.getAttachmentInfoSelector());
        return evi;
    }

    private static FilterInfo getAttachmentInfoFilter(List attachments) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ExchangeFacadeControllerBean.getAttachmentIds(attachments), CompareType.INCLUDE));
        return filter;
    }

    private static String getAttachmentIds(List attachments) {
        StringBuffer ids = new StringBuffer("");
        Iterator it = attachments.iterator();
        while (it.hasNext()) {
            ids.append(((WebAttachmentItem)it.next()).getId().toString());
            ids.append(",");
        }
        return ids.toString();
    }

    private static SelectorItemCollection getAttachmentInfoSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("creator.id"));
        selector.add(new SelectorItemInfo("creator.name"));
        selector.add(new SelectorItemInfo("lastUpdateUser.id"));
        selector.add(new SelectorItemInfo("lastUpdateUser.name"));
        return selector;
    }

    private String createNewID() {
        return BOSUuid.create((String)"9A7EAE92").toString();
    }
}

