/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.stamp.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class CheckPermissionService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.stamp.service.CheckPermissionService");
    private static CheckPermissionService checkPermissionService;
    private static final String CP_STAMP_AMODULE_SET = "cp_stamp_amodule_set";
    private static final String CP_STAMP_SEAL_ADMIN = "cp_stamp_Seal_Admin";

    public boolean getAllSetPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK) throws BOSException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        boolean hasFunctionPermission = false;
        try {
            hasFunctionPermission = iPermission.hasFunctionPermission(userPK, orgPK, CP_STAMP_AMODULE_SET);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        return hasFunctionPermission;
    }

    public boolean getSealManagementPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK) throws BOSException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        boolean hasFunctionPermission = false;
        try {
            hasFunctionPermission = iPermission.hasFunctionPermission(userPK, orgPK, CP_STAMP_SEAL_ADMIN);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        return hasFunctionPermission;
    }

    public static CheckPermissionService getInstance() {
        return null == checkPermissionService ? new CheckPermissionService() : checkPermissionService;
    }
}

