/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IWorkCalendar;
import com.kingdee.eas.basedata.assistant.WorkCalendarFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfs.ActInstFactory;
import com.kingdee.eas.cp.wfs.ActInstInfo;
import com.kingdee.eas.cp.wfs.AssignFactory;
import com.kingdee.eas.cp.wfs.AssignInfo;
import com.kingdee.eas.cp.wfs.IActInst;
import com.kingdee.eas.cp.wfs.IAssign;
import com.kingdee.eas.cp.wfs.IProcDef;
import com.kingdee.eas.cp.wfs.IProcInst;
import com.kingdee.eas.cp.wfs.IStepDef;
import com.kingdee.eas.cp.wfs.ProcDefFactory;
import com.kingdee.eas.cp.wfs.ProcDefInfo;
import com.kingdee.eas.cp.wfs.ProcInstFactory;
import com.kingdee.eas.cp.wfs.ProcInstInfo;
import com.kingdee.eas.cp.wfs.StepDefFactory;
import com.kingdee.eas.cp.wfs.StepDefInfo;
import com.kingdee.eas.cp.wfs.SyncTypeEnum;
import com.kingdee.eas.cp.wfs.app.AbstractSyncWorkflowFacadeControllerBean;
import com.kingdee.eas.cp.wfs.utils.DataUtil;
import com.kingdee.eas.cp.wfs.utils.SyncLogUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncWorkflowFacadeControllerBean
extends AbstractSyncWorkflowFacadeControllerBean {
    private static final long serialVersionUID = 1228372244191432096L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.wfs.app.SyncWorkflowFacadeControllerBean");
    private static Timestamp curTime;
    private static final String TABLE_ASSIGN = "T_WFR_Assign";
    private static final String TABLE_ASSIGNHST = "T_WFR_AssignHst";
    private static final String TABLE_ASSIGNDETAIL = "T_WFR_AssignDetail";
    private Map flowTypeMap;
    private Map flowTemplateMap;
    private Map cuMap;
    private static final String SQL_UPDATE_ISDELAY1 = "update t_wfs_assign set FIsDelay = 1 where exists (   select factdefid from t_wfs_stepdef   where t_wfs_stepdef.factdefid = t_wfs_assign.factdefid   and t_wfs_stepdef.fversion = t_wfs_assign.fversion  and  t_wfs_stepdef.fprocdefid  = t_wfs_assign.fprocdefid   and t_wfs_stepdef.FtimeLimit > 0   and t_wfs_stepdef.FtimeLimit * 60 < t_wfs_assign.FCostWorkTime)";
    private static final String SQL_UPDATE_ISDELAY2 = "update T_WFS_ActInst  set FIsDelay = 1 where exists (   select assign.factinstid from t_wfs_assign assign   where assign.factinstid = T_WFS_ActInst.factinstid  and assign.FIsDelay = 1)";
    private static final String SQL_UPDATE_ISDELAY3 = "update T_WFS_ProcInst  set FIsDelay = 1 where exists (   select assign.factinstid from t_wfs_assign assign   where assign.fprocinstid = T_WFS_ProcInst.fprocinstid  and assign.FIsDelay = 1)";
    private static final String SQL_UPDATE_ACTINST = "UPDATE T_WFS_ACTINST SET FCOSTWORKTIME = (select sum(FCOSTWORKTIME) from T_WFS_ASSIGN   WHERE T_WFS_ASSIGN.FACTINSTID = T_WFS_ACTINST.FACTINSTID) WHERE EXISTS (   SELECT FID FROM T_WFS_PROCINST   WHERE T_WFS_PROCINST.FPROCINSTID = T_WFS_ACTINST.FPROCINSTID   AND T_WFS_PROCINST.FState = 'finished' ) AND EXISTS (   SELECT FID FROM T_WFS_ASSIGN   WHERE T_WFS_ASSIGN.FACTINSTID = T_WFS_ACTINST.FACTINSTID ) ";
    private static final String SQL_UPDATE_WFM1 = "INSERT INTO T_WFS_FlowType(FID,FNumber,fsimplename,FName_l1,FName_l2,FDescription_l1,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime) select dbo.newbosid('21B298FB'),fid,FSimpleName,FName_l1,FName_l2,fid,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime from t_bas_templatetype WHERE  NOT EXISTS ( SELECT ft.FID FROM T_WFS_FlowType AS ft where ft.FNumber = t_bas_templatetype.fid  )";
    private static final String SQL_UPDATE_WFM2 = "INSERT INTO T_WFS_FlowTemplate(FID,FName_l1,FName_l2,FNumber,FFlowTypeID,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime) SELECT dbo.newbosid('3E2A0DBB'),FName_l1,FName_l2,fid, (select T_WFS_FlowType.fid from T_WFS_FlowType  where T_WFS_FlowType.fNumber = t_bas_template.FTemplateTypeID),fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime FROM t_bas_template WHERE  NOT EXISTS (  SELECT ft.FID FROM T_WFS_FlowTemplate AS ft  where ft.FNumber = t_bas_template.FID ) and exists (  select T_WFS_FlowType.fid from T_WFS_FlowType  where T_WFS_FlowType.fNumber = t_bas_template.FTemplateTypeID )";
    private static final String SQL_UPDATE_WFM3 = "update T_WFS_FlowType set fname_l2 = (select fname_l2 from t_bas_templatetype where t_bas_templatetype.fid = T_WFS_FlowType.fnumber) , flastupdateuserid = (select flastupdateuserid from t_bas_templatetype where t_bas_templatetype.fid = t_wfs_flowtype.fnumber), flastupdatetime = (select flastupdatetime from t_bas_templatetype where t_bas_templatetype.fid = t_wfs_flowtype.fnumber) where exists (  select fid from t_bas_templatetype where t_bas_templatetype.fid = T_WFS_FlowType.fnumber )";
    private static final String SQL_UPDATE_WFM4 = "update T_WFS_FlowTemplate set fname_l2 = (select fname_l2 from t_bas_template where t_bas_template.fid = T_WFS_FlowTemplate.fnumber), flastupdateuserid = (select flastupdateuserid from t_bas_template where t_bas_template.fid = T_WFS_FlowTemplate.fnumber), flastupdatetime = (select flastupdatetime from t_bas_template where t_bas_template.fid = T_WFS_FlowTemplate.fnumber) where exists ( select fid from t_bas_template where t_bas_template.fid = T_WFS_FlowTemplate.fnumber )";
    private static final String SQL_DELETE_START = "delete from t_wfs_actinst where fstate = 'finished' and exists ( select fid from t_wfs_stepdef stepdef where stepdef.fprocdefid = t_wfs_actinst.fprocdefid  and factdefid =t_wfs_actinst.factdefid  and fismanpower = 1 and fversion = t_wfs_actinst.fversion ) and not exists ( select fassignid from t_wfs_assign assign where assign.factinstid = t_wfs_actinst.factinstid ) ";

    protected synchronized boolean _sync(Context ctx) throws BOSException {
        curTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        this.init(ctx);
        DataUtil.dropIdx(ctx);
        SyncLogUtil.addLog(ctx, curTime, false, SyncTypeEnum.PROCDEF, "\u5f00\u59cb\u540c\u6b65\u6d41\u7a0b\u5b9a\u4e49\u6570\u636e");
        this.syncProcDef(ctx);
        SyncLogUtil.addLog(ctx, curTime, true, SyncTypeEnum.PROCDEF, "\u5b8c\u6210\u5de5\u4f5c\u6d41\u5b9a\u4e49\u540c\u6b65");
        this._beforeSyncInst(ctx);
        this.syncProcInst(ctx);
        this.syncInstDetail(ctx);
        SyncLogUtil.addLog(ctx, curTime, true, SyncTypeEnum.PROCINST, "\u5b8c\u6210\u5de5\u4f5c\u6d41\u6d41\u7a0b\u5b9e\u4f8b\u540c\u6b65");
        this._updateIsDelay(ctx);
        DataUtil.createIdx(ctx);
        DataUtil.resetQueryContext(ctx);
        return true;
    }

    private void init(Context ctx) {
        this._updateWFM(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,fnumber,'type' as ftype from t_wfs_flowtype");
        sql.append(" where fnumber like 'com.%' ");
        sql.append("union all ");
        sql.append("select fid,fnumber,'template' as ftype from t_wfs_flowtemplate");
        sql.append(" where fnumber like 'com.%'");
        sql.append("union all ");
        sql.append("select fid,flongnumber as fnumber,'cu' as ftype from t_org_ctrlunit");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            this.flowTypeMap = new HashMap();
            this.flowTemplateMap = new HashMap();
            this.cuMap = new HashMap();
            while (rowSet.next()) {
                if ("type".equals(rowSet.getString("ftype"))) {
                    this.flowTypeMap.put(rowSet.getString("fnumber"), rowSet.getString("fid"));
                    continue;
                }
                if ("template".equals(rowSet.getString("ftype"))) {
                    this.flowTemplateMap.put(rowSet.getString("fnumber"), rowSet.getString("fid"));
                    continue;
                }
                if (!"cu".equals(rowSet.getString("ftype"))) continue;
                this.cuMap.put(rowSet.getString("fid"), rowSet.getString("fnumber"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void syncProcInst(Context ctx) {
        this._syncProcInst(ctx, true);
        this._syncProcInst(ctx, false);
    }

    private void syncProcDef(Context ctx) {
        Timestamp lastSuccessTime = SyncLogUtil.getLastSuccessTime(ctx, SyncTypeEnum.PROCDEF);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append("PROCDEF.FPROCDEFID AS FPROCDEFID, ");
        sql.append("PROCDEF.FNAME_l2 AS FNAME, ");
        sql.append("PROCDEF.FProcCode AS FPROCCODE, ");
        sql.append("PROCDEF.FDESC_l2 AS FDESC, ");
        sql.append("PROCDEF.FCREATEDTIME AS FCREATEDTIME, ");
        sql.append("PROCDEF.FAUTHOR AS FAUTHOR, ");
        sql.append("PROCDEF.FVALIDFROM AS FVALIDFROM, ");
        sql.append("PROCDEF.FVALIDTO AS FVALIDTO, ");
        sql.append("PROCDEF.FPACKAGENAME AS FPACKAGENAME, ");
        sql.append("PROCDEF.FENABLE AS FENABLE, ");
        sql.append("PROCDEF.FBIZPACKAGE_l2 AS FBIZPACKAGE, ");
        sql.append("PROCDEF.FMd5hash AS FMd5hash, ");
        sql.append("PROCDEF.FINNERVERSION AS INNERVERSION ");
        sql.append("FROM T_WFR_ProcDef AS PROCDEF ");
        sql.append("WHERE  PROCDEF.FPROCDEFTYPE = 'NORMAL' ");
        sql.append("AND PROCDEF.FCREATEDTIME <= {" + curTime + "} ");
        if (lastSuccessTime != null) {
            sql.append("AND PROCDEF.FCREATEDTIME > {" + lastSuccessTime + "} ");
        }
        sql.append("ORDER BY FCREATEDTIME ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            IProcDef iProcDef = ProcDefFactory.getLocalInstance(ctx);
            ProcDefInfo pdi = null;
            while (rowSet.next()) {
                pdi = new ProcDefInfo();
                pdi.setProcDefID(rowSet.getString("FPROCDEFID"));
                pdi.setName(rowSet.getString("FNAME"));
                pdi.setDescription(rowSet.getString("FDESC"));
                pdi.setCreateTime(rowSet.getTimestamp("FCREATEDTIME"));
                pdi.setPackageName(rowSet.getString("FPACKAGENAME"));
                pdi.setVersion(rowSet.getInt("INNERVERSION"));
                String[] ids = this.getFlowType(ctx, rowSet.getString("FPACKAGENAME"), rowSet.getString("FPROCDEFID"), rowSet.getInt("INNERVERSION"));
                pdi.setFlowType(ids[0]);
                pdi.setFlowTemplate(ids[1]);
                try {
                    iProcDef.addnew((CoreBaseInfo)pdi);
                    this.addActDef(ctx, rowSet.getString("FPROCDEFID"), rowSet.getString("FMd5hash"), rowSet.getInt("INNERVERSION"));
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
            this._updateFlowType(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void _updateFlowType(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_wfs_procdef ");
        sql.append("set fflowtype = (select top 1 ft.fflowtypeid from t_bas_documentinfo docinfo,t_wfs_flowtemplate ft ");
        sql.append("where docinfo.fflowid =t_wfs_procdef.FProcDefID and ft.fnumber = docinfo.ftemplateid ) ");
        sql.append("where fflowtype is null ");
        StringBuffer sql2 = new StringBuffer();
        sql2.append("update t_wfs_procdef ");
        sql2.append("set FFlowTemplate = (select top 1 ft.fid from t_bas_documentinfo docinfo,t_wfs_flowtemplate ft  ");
        sql2.append("where docinfo.fflowid =t_wfs_procdef.FProcDefID and ft.fnumber = docinfo.ftemplateid ) ");
        sql2.append("where FFlowTemplate is null ");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString());
            DbUtil.execute((Context)ctx, (String)sql2.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void addActDef(Context ctx, String procDefID, String hashCode, int version) {
        try {
            IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)ctx);
            ProcessDef pd = wfService.getProcessDefByDefineHashValue(hashCode);
            ActivityCollection acts = pd.getActivitys();
            ActivityDef act = null;
            BigDecimal dec = null;
            IStepDef iStepDef = StepDefFactory.getLocalInstance(ctx);
            int size = acts.size();
            for (int i = 0; i < size; ++i) {
                act = acts.get(i);
                StepDefInfo stepDef = new StepDefInfo();
                stepDef.setProcDefID(procDefID);
                stepDef.setActDefID(act.getID());
                stepDef.setName(act.getName(ctx.getLocale()));
                logger.info((Object)(act.getName() + ":::::::::" + act.getName(ctx.getLocale())));
                stepDef.setVersion(version);
                dec = act.getActivityHeader().getLimit().getDeadlineTime();
                if (dec != null) {
                    stepDef.setTimeLimit(dec.floatValue());
                }
                if (act instanceof ManpowerActivityDef) {
                    stepDef.setIsManpower(true);
                } else {
                    stepDef.setIsManpower(false);
                }
                try {
                    iStepDef.addnew((CoreBaseInfo)stepDef);
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void _syncProcInst(Context ctx, boolean isHistory) {
        Timestamp lastSuccessTime;
        Timestamp startTime = lastSuccessTime = SyncLogUtil.getLastSuccessTime(ctx, SyncTypeEnum.PROCINST);
        Timestamp endTime = curTime;
        if (lastSuccessTime == null) {
            StringBuffer tSql = new StringBuffer();
            tSql.append("select max(flaststatetime) as maxTime, min(flaststatetime) as minTime from ");
            if (isHistory) {
                tSql.append("t_wfr_procinsthst");
            } else {
                tSql.append("t_wfr_procinst");
            }
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)tSql.toString());
                if (rowSet.next()) {
                    startTime = rowSet.getTimestamp("minTime");
                    endTime = rowSet.getTimestamp("maxTime");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (startTime != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(startTime);
            while (startTime.before(curTime)) {
                c.add(2, 2);
                endTime = new Timestamp(c.getTimeInMillis());
                if (endTime.after(curTime)) {
                    endTime = curTime;
                }
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT ");
                sql.append("PROCINST.FPROCINSTID AS FPROCINSTID, ");
                sql.append("PROCINST.FSTATE AS FSTATE, ");
                sql.append("PROCINST.FPROCDEFID AS FPROCDEFID, ");
                sql.append("PROCINST.FPROCDEFVER AS FPROCDEFVER, ");
                sql.append("PROCINST.FPROCDEFNAME_l2 AS FPROCDEFNAME, ");
                sql.append("PROCINST.FPROCINSTTOPIC_l2 AS FPROCINSTTOPIC, ");
                sql.append("PROCINST.FCREATEDTIME AS FCREATEDTIME,  ");
                sql.append("PROCINST.FCOMLETETIME AS FCOMLETETIME, ");
                sql.append("PROCINST.FINITIATORID AS FINITIATORID, ");
                sql.append("PROCINST.FINITIATORNAME_l2 AS FINITIATORNAME, ");
                sql.append("usr.fpersonid AS fpersonid, ");
                sql.append("PROCINST.FCODE AS FCODE ");
                if (isHistory) {
                    sql.append("FROM T_WFR_ProcInstHST AS PROCINST ,t_pm_user as usr ");
                } else {
                    sql.append("FROM T_WFR_ProcInst AS PROCINST ,t_pm_user as usr ");
                }
                sql.append("WHERE PROCINST.FINITIATORID = usr.fid and PROCINST.FPROCDEFTYPE = 'NORMAL' ");
                sql.append("AND PROCINST.flaststatetime < {" + endTime + "} ");
                if (startTime != null) {
                    sql.append("AND PROCINST.flaststatetime >= {" + startTime + "} ");
                }
                sql.append("ORDER BY FCREATEDTIME  ");
                logger.info((Object)("synclog:::" + sql.toString()));
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    IProcInst iProcInst = ProcInstFactory.getLocalInstance(ctx);
                    ProcInstInfo pii = null;
                    IWorkCalendar wc = WorkCalendarFactory.getLocalInstance((Context)ctx);
                    BigDecimal amount = null;
                    BigDecimal arg60 = new BigDecimal(60);
                    AdminOrgUnitInfo adminOrgUnitInfo = null;
                    String wcOrgID = null;
                    while (rowSet.next()) {
                        pii = new ProcInstInfo();
                        try {
                            adminOrgUnitInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)rowSet.getString("fpersonid")));
                        }
                        catch (EASBizException e1) {
                            e1.printStackTrace();
                        }
                        catch (UuidException e1) {
                            e1.printStackTrace();
                        }
                        pii.setProcDefID(rowSet.getString("FPROCDEFID"));
                        pii.setState(this.convertState(rowSet.getString("FSTATE")));
                        pii.setVersion(rowSet.getInt("FPROCDEFVER"));
                        pii.setCompleteTime(rowSet.getDate("FCOMLETETIME"));
                        pii.setCreateTime(rowSet.getTimestamp("FCREATEDTIME"));
                        UserInfo user = new UserInfo();
                        user.setId(BOSUuid.read((String)rowSet.getString("FINITIATORID")));
                        pii.setCreator(user);
                        pii.setProcInstID(rowSet.getString("FPROCINSTID"));
                        pii.setName(rowSet.getString("FPROCDEFNAME"));
                        pii.setIsDelay(false);
                        if (adminOrgUnitInfo != null) {
                            pii.setOrgID(adminOrgUnitInfo.getId().toString());
                            pii.setOrgName(adminOrgUnitInfo.getName());
                            pii.setOrgLongNumber(adminOrgUnitInfo.getLongNumber());
                            pii.setOrgLevel(adminOrgUnitInfo.getLevel());
                            pii.setCU(adminOrgUnitInfo.getCU());
                            if (this.cuMap.containsKey(adminOrgUnitInfo.getCU().getId().toString())) {
                                pii.setCuLongNumber((String)this.cuMap.get(adminOrgUnitInfo.getCU().getId().toString()));
                            }
                            wcOrgID = this.getWorkCalendarOrg(ctx, adminOrgUnitInfo.getLongNumber());
                        }
                        if (rowSet.getDate("FCOMLETETIME") != null && wcOrgID != null) {
                            try {
                                amount = wc.getWorkTime(wcOrgID, (Date)rowSet.getTimestamp("FCREATEDTIME"), (Date)rowSet.getDate("FCOMLETETIME"), true, 0);
                                pii.setCostTime(amount.multiply(arg60).intValue());
                                amount = wc.getWorkTime(wcOrgID, (Date)rowSet.getTimestamp("FCREATEDTIME"), (Date)rowSet.getDate("FCOMLETETIME"), false, 0);
                                pii.setCostWorkTime(amount.multiply(arg60).intValue());
                            }
                            catch (EASBizException e) {
                                e.printStackTrace();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            iProcInst.addnew((CoreBaseInfo)pii);
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                startTime = new Timestamp(c.getTimeInMillis());
            }
        }
    }

    private void syncInstDetail(Context ctx) {
        this._syncActInst(ctx, true);
        this._syncActInst(ctx, false);
        this._syncAssign(ctx);
    }

    private void _syncActInst(Context ctx, boolean isHistory) {
        Timestamp lastSuccessTime;
        Timestamp startTime = lastSuccessTime = SyncLogUtil.getLastSuccessTime(ctx, SyncTypeEnum.PROCINST);
        Timestamp endTime = curTime;
        if (lastSuccessTime == null) {
            StringBuffer tSql = new StringBuffer();
            tSql.append("select max(flaststatetime) as maxTime, min(flaststatetime) as minTime from ");
            if (isHistory) {
                tSql.append("T_WFR_ActInstHST");
            } else {
                tSql.append("T_WFR_ActInst");
            }
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)tSql.toString());
                if (rowSet.next()) {
                    startTime = rowSet.getTimestamp("minTime");
                    endTime = rowSet.getTimestamp("maxTime");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (startTime != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(startTime);
            while (startTime.before(curTime)) {
                c.add(5, 3);
                endTime = new Timestamp(c.getTimeInMillis());
                if (endTime.after(curTime)) {
                    endTime = curTime;
                }
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT ");
                sql.append("ACTINST.FACTINSTID AS FACTINSTID, ");
                sql.append("ACTINST.FSTATE AS FSTATE, ");
                sql.append("ACTINST.FACTDEFNAME_l2 AS FACTDEFNAME, ");
                sql.append("ACTINST.FPROCDEFID AS FPROCDEFID, ");
                sql.append("ACTINST.FACTDEFID AS FACTDEFID, ");
                sql.append("ACTINST.FCREATEDTIME AS FCREATEDTIME, ");
                sql.append("ACTINST.FCOMLETETIME AS FCOMLETETIME, ");
                sql.append("procinst.fversion as fversion, ");
                sql.append("procinst.FControlUnitID as FControlUnitID, ");
                sql.append("procinst.FCuLongNumber as FCuLongNumber, ");
                sql.append("procinst.FOrgID as FOrgID, ");
                sql.append("procinst.FOrgLongNumber as FOrgLongNumber, ");
                sql.append("procinst.FOrgName as FOrgName, ");
                sql.append("procinst.FOrgLevel as FOrgLevel, ");
                sql.append("ACTINST.FPROCINSTID AS  FPROCINSTID ");
                if (isHistory) {
                    sql.append("FROM T_WFR_ActInstHST AS ACTINST ");
                } else {
                    sql.append("FROM T_WFR_ActInst AS ACTINST ");
                }
                sql.append("inner join T_WFS_procinst as procinst on procinst.fprocinstid = ACTINST.fprocinstid ");
                sql.append("WHERE ACTINST.FPROCDEFTYPE = 'NORMAL' ");
                sql.append("AND exists (select stepdef.factdefid from t_wfs_stepdef stepdef ");
                sql.append("where stepdef.factdefid = actinst.factdefid ");
                sql.append(" and stepdef.fismanpower = 1) ");
                sql.append("AND ACTINST.flaststatetime < {" + endTime + "} ");
                if (startTime != null) {
                    sql.append("AND ACTINST.flaststatetime >= {" + startTime + "} ");
                }
                sql.append("ORDER BY FCREATEDTIME ");
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    IActInst iActInst = ActInstFactory.getLocalInstance(ctx);
                    ActInstInfo aii = null;
                    while (rowSet.next()) {
                        aii = new ActInstInfo();
                        aii.setProcDefID(rowSet.getString("FPROCDEFID"));
                        aii.setActDefID(rowSet.getString("FACTDEFID"));
                        aii.setProcInstID(rowSet.getString("FPROCINSTID"));
                        aii.setActInstID(rowSet.getString("FACTINSTID"));
                        aii.setState(this.convertState(rowSet.getString("FSTATE")));
                        aii.setCompleteTime(rowSet.getDate("FCOMLETETIME"));
                        aii.setCreateTime(rowSet.getTimestamp("FCREATEDTIME"));
                        aii.setName(rowSet.getString("FACTDEFNAME"));
                        aii.setIsDelay(false);
                        aii.setVersion(rowSet.getInt("fversion"));
                        CtrlUnitInfo cu = new CtrlUnitInfo();
                        cu.setId(BOSUuid.read((String)rowSet.getString("FControlUnitID")));
                        aii.setCU(cu);
                        aii.setCuLongNumber(rowSet.getString("FCuLongNumber"));
                        aii.setOrgID(rowSet.getString("FOrgID"));
                        aii.setOrgLevel(rowSet.getInt("FOrgLevel"));
                        aii.setOrgLongNumber(rowSet.getString("FOrgLongNumber"));
                        aii.setOrgName(rowSet.getString("FOrgName"));
                        try {
                            iActInst.addnew((CoreBaseInfo)aii);
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                startTime = new Timestamp(c.getTimeInMillis());
            }
        }
    }

    private void _syncAssign(Context ctx) {
        this._addAssign(ctx, TABLE_ASSIGN);
        this._addAssign(ctx, TABLE_ASSIGNDETAIL);
        this._addAssign(ctx, TABLE_ASSIGNHST);
    }

    private String getAssignSql(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append("ASSIGN.FASSIGNID AS ASSIGNID, ");
        sql.append("ASSIGN.FSUBJECT_l2 AS SUBJECT, ");
        sql.append("ASSIGN.FBODY_l2 AS BODY, ");
        sql.append("ASSIGN.FSTATE AS STATE, ");
        sql.append("ASSIGN.FPERSONUSERID AS PERSONUSERID, ");
        sql.append("ASSIGN.FPERSONUSERNAME_l2 AS PERSONUSERNAME, ");
        sql.append("ASSIGN.FPERSONEMPID AS PERSONEMPID, ");
        sql.append("ASSIGN.FPERSONEMPNAME_l2 AS PERSONEMPNAME, ");
        sql.append("ASSIGN.FPERFORMERUID AS PERFORMERUID, ");
        sql.append("ASSIGN.FPERFORMERUNAME_l2 AS PERFORMERUNAME, ");
        sql.append("ASSIGN.FPERFORMEREID AS PERFORMEREID, ");
        sql.append("ASSIGN.FPERFORMERENAME_l2 AS PERFORMERENAME, ");
        sql.append("ASSIGN.FACTINSTID AS ACTINSTID, ");
        sql.append("ASSIGN.FACTDEFID AS ACTDEFID, ");
        sql.append("ASSIGN.FACTDEFNAME_l2 AS ACTDEFNAME, ");
        sql.append("ASSIGN.FPROCDEFHASH AS PROCDEFHASH, ");
        sql.append("ASSIGN.FPROCDEFID AS PROCDEFID, ");
        sql.append("ASSIGN.FPROCDEFNAME_l2 AS PROCDEFNAME, ");
        sql.append("ASSIGN.FPROCINSTID AS PROCINSTID, ");
        sql.append("ASSIGN.FENDTIME AS ENDTIME, ");
        sql.append("ASSIGN.FLASTSTATETIME AS LASTSTATETIME, ");
        sql.append("ASSIGN.FCREATEDTIME AS CREATEDTIME, ");
        sql.append("ASSIGN.FACCEPTTIME AS ACCEPTTIME, ");
        sql.append("ASSIGN.FBIZPACKAGE AS BIZPACKAGE, ");
        sql.append("ASSIGN.FBIZFUNCTION AS BIZFUNCTION, ");
        sql.append("ASSIGN.FBIZOPERATION AS BIZOPERATION, ");
        sql.append("ASSIGN.FBIZOBJID AS BIZOBJID, ");
        sql.append("ASSIGN.FAPPDEFID AS APPDEFID, ");
        sql.append("ASSIGN.FPRIORITY AS PRIORITY, ");
        sql.append("ASSIGN.FWAITINGTIME AS WAITINGTIME, ");
        sql.append("ASSIGN.FDURATION AS DURATION, ");
        sql.append("ASSIGN.FWORKINGTIME AS WORKINGTIME, ");
        sql.append("procinst.fversion as fversion, ");
        sql.append("ASSIGN.FIsSendMsg AS ISSENDMSG ");
        sql.append("FROM " + tableName + " AS ASSIGN ");
        sql.append("inner join T_WFS_procinst as procinst on procinst.fprocinstid = ASSIGN.fprocinstid ");
        return sql.toString();
    }

    private void _addAssign(Context ctx, String tableName) {
        Timestamp lastSuccessTime;
        if (StringUtils.isEmpty((String)tableName)) {
            return;
        }
        Timestamp startTime = lastSuccessTime = SyncLogUtil.getLastSuccessTime(ctx, SyncTypeEnum.PROCINST);
        Timestamp endTime = curTime;
        if (lastSuccessTime == null) {
            StringBuffer tSql = new StringBuffer();
            tSql.append("select max(flaststatetime) as maxTime, min(flaststatetime) as minTime from ");
            tSql.append(tableName);
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)tSql.toString());
                if (rowSet.next()) {
                    startTime = rowSet.getTimestamp("minTime");
                    endTime = rowSet.getTimestamp("maxTime");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (startTime != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(startTime);
            while (startTime.before(curTime)) {
                c.add(5, 3);
                endTime = new Timestamp(c.getTimeInMillis());
                if (endTime.after(curTime)) {
                    endTime = curTime;
                }
                StringBuffer sql = new StringBuffer();
                sql.append(this.getAssignSql(tableName));
                sql.append("WHERE ASSIGN.flaststatetime < {" + endTime + "} ");
                if (startTime != null) {
                    sql.append("AND ASSIGN.flaststatetime >= {" + startTime + "} ");
                }
                sql.append("ORDER BY FCREATEDTIME ");
                logger.info((Object)("synclog:::" + sql.toString()));
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    IAssign iAssign = AssignFactory.getLocalInstance(ctx);
                    AssignInfo aii = null;
                    IWorkCalendar wc = WorkCalendarFactory.getLocalInstance((Context)ctx);
                    BigDecimal amount = null;
                    BigDecimal arg60 = new BigDecimal(60);
                    AdminOrgUnitInfo adminOrgUnitInfo = null;
                    String wcOrgID = null;
                    while (rowSet.next()) {
                        aii = new AssignInfo();
                        try {
                            adminOrgUnitInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)rowSet.getString("PERSONEMPID")));
                        }
                        catch (EASBizException e1) {
                            e1.printStackTrace();
                        }
                        catch (UuidException e1) {
                            e1.printStackTrace();
                        }
                        aii.setProcDefID(rowSet.getString("PROCDEFID"));
                        aii.setActDefID(rowSet.getString("ACTDEFID"));
                        aii.setProcInstID(rowSet.getString("PROCINSTID"));
                        aii.setActInstID(rowSet.getString("ACTINSTID"));
                        aii.setState(this.convertAssignState(rowSet.getString("STATE")));
                        aii.setCompleteTime(rowSet.getDate("ENDTIME"));
                        aii.setCreateTime(rowSet.getTimestamp("CREATEDTIME"));
                        aii.setName(rowSet.getString("ACTDEFNAME"));
                        aii.setBizObjID(rowSet.getString("BIZOBJID"));
                        aii.setBizPackage(rowSet.getString("BIZPACKAGE"));
                        aii.setBizOperation(rowSet.getString("BIZOPERATION"));
                        aii.setAssignID(rowSet.getString("ASSIGNID"));
                        aii.setUserID(rowSet.getString("PERSONUSERID"));
                        aii.setPersonID(rowSet.getString("PERSONEMPID"));
                        aii.setIsDelay(false);
                        aii.setVersion(rowSet.getInt("fversion"));
                        if (adminOrgUnitInfo != null) {
                            aii.setOrgID(adminOrgUnitInfo.getId().toString());
                            aii.setOrgName(adminOrgUnitInfo.getName());
                            aii.setOrgLongNumber(adminOrgUnitInfo.getLongNumber());
                            aii.setOrgLevel(adminOrgUnitInfo.getLevel());
                            aii.setCU(adminOrgUnitInfo.getCU());
                            if (this.cuMap.containsKey(adminOrgUnitInfo.getCU().getId().toString())) {
                                aii.setCuLongNumber((String)this.cuMap.get(adminOrgUnitInfo.getCU().getId().toString()));
                            }
                            wcOrgID = this.getWorkCalendarOrg(ctx, adminOrgUnitInfo.getLongNumber());
                        }
                        if (rowSet.getDate("ENDTIME") != null && adminOrgUnitInfo != null && wcOrgID != null) {
                            try {
                                amount = wc.getWorkTime(wcOrgID, (Date)rowSet.getTimestamp("CREATEDTIME"), (Date)rowSet.getDate("ENDTIME"), true, 0);
                                aii.setCostTime(amount.multiply(arg60).intValue());
                                amount = wc.getWorkTime(wcOrgID, (Date)rowSet.getTimestamp("CREATEDTIME"), (Date)rowSet.getDate("ENDTIME"), false, 0);
                                aii.setCostWorkTime(amount.multiply(arg60).intValue());
                            }
                            catch (EASBizException e) {
                                e.printStackTrace();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            iAssign.addnew((CoreBaseInfo)aii);
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                startTime = new Timestamp(c.getTimeInMillis());
            }
        }
    }

    private void _beforeSyncInst(Context ctx) throws BOSException {
        Timestamp lastSuccessTime = SyncLogUtil.getLastSuccessTime(ctx, SyncTypeEnum.PROCINST);
        if (lastSuccessTime == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("delete from t_wfs_procinst ");
        sql.append("where exists ( ");
        sql.append("  select procinst.fprocinstid from t_wfr_procinst procinst ");
        sql.append("  where procinst.fprocinstid = t_wfs_procinst.fprocinstid  ");
        sql.append("  and procinst.flaststatetime >{" + lastSuccessTime + "}) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from t_wfs_procinst ");
        sql.append("where exists ( ");
        sql.append("  select procinst.fprocinstid from t_wfr_procinsthst procinst ");
        sql.append("  where procinst.fprocinstid = t_wfs_procinst.fprocinstid ");
        sql.append("  and procinst.flaststatetime > {" + lastSuccessTime + "}) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from t_wfs_actinst ");
        sql.append("where exists ( ");
        sql.append("  select actinst.factinstid from t_wfr_actinst actinst ");
        sql.append("  where actinst.factinstid = t_wfs_actinst.factinstid  ");
        sql.append("  and actinst.flaststatetime >{" + lastSuccessTime + "}) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from t_wfs_actinst ");
        sql.append("where exists ( ");
        sql.append("  select actinst.factinstid from t_wfr_actinsthst actinst ");
        sql.append("  where actinst.factinstid = t_wfs_actinst.factinstid  ");
        sql.append("  and actinst.flaststatetime > {" + lastSuccessTime + "}) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from t_wfs_assign ");
        sql.append("where exists ( ");
        sql.append("  select ass.fassignid from t_wfr_assigndetail ass ");
        sql.append("  where ass.fassignid = t_wfs_assign.fassignid  ");
        sql.append("  and ass.flaststatetime > {" + lastSuccessTime + "}) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("delete from t_wfs_assign ");
        sql.append("where exists ( ");
        sql.append("  select ass.fassignid from t_wfr_assignhst ass ");
        sql.append("  where ass.fassignid = t_wfs_assign.fassignid ");
        sql.append("  and ass.flaststatetime > {" + lastSuccessTime + "}) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void _updateIsDelay(Context ctx) {
        try {
            DbUtil.execute((Context)ctx, (String)SQL_UPDATE_ISDELAY1);
            DbUtil.execute((Context)ctx, (String)SQL_UPDATE_ISDELAY2);
            DbUtil.execute((Context)ctx, (String)SQL_UPDATE_ISDELAY3);
            DbUtil.execute((Context)ctx, (String)SQL_DELETE_START);
            DbUtil.execute((Context)ctx, (String)SQL_UPDATE_ACTINST);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void _updateWFM(Context ctx) {
        try {
            DbUtil.execute((Context)ctx, (String)SQL_UPDATE_WFM1);
            DbUtil.execute((Context)ctx, (String)SQL_UPDATE_WFM2);
            DbUtil.execute((Context)ctx, (String)SQL_UPDATE_WFM3);
            DbUtil.execute((Context)ctx, (String)SQL_UPDATE_WFM4);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private String convertState(String workFlowState) {
        String result = "";
        result = workFlowState != null ? (workFlowState.equals("closed.completed") ? "finished" : (workFlowState.startsWith("closed") ? "canceled" : "running")) : "canceled";
        return result;
    }

    private String convertAssignState(String assignState) {
        String result = "";
        result = assignState != null ? (assignState.equals(String.valueOf(16)) || assignState.equals(String.valueOf(8)) ? "finished" : (assignState.equals(String.valueOf(4)) ? "canceled" : "running")) : "canceled";
        return result;
    }

    private String[] getFlowType(Context ctx, String packageName, String procdefid, int version) {
        String[] flowtypeID = new String[2];
        if (!StringUtils.isEmpty((String)packageName)) {
            if (packageName.startsWith("com.kingdee.eas.cp.wfm") || packageName.startsWith("com.kingdee.eas.cp.odm")) {
                String sql = "select top 1 ft.fflowtypeid,ft.fid from t_bas_documentinfo docinfo,t_wfs_flowtemplate ft where docinfo.fflowid = '" + procdefid + "' and ft.fnumber = docinfo.ftemplateid ";
                String verSql = "and exists (select a.FBIZOBJID from T_WFr_Assigndetail a , t_wfr_procinst p where a.FBIZOBJID = docinfo.FSOURCEPK and a.fprocinstid = p.fprocinstid and fprocdefver = " + version + ")";
                try {
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql + verSql));
                    if (rowSet.next()) {
                        flowtypeID[0] = rowSet.getString("fflowtypeid");
                        flowtypeID[1] = rowSet.getString("fid");
                    } else {
                        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                        if (rowSet.next()) {
                            flowtypeID[0] = rowSet.getString("fflowtypeid");
                            flowtypeID[1] = rowSet.getString("fid");
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else if (packageName.startsWith("com.kingdee.eas.cp.")) {
                String number = "";
                number = packageName.indexOf(46, 19) > 0 ? packageName.substring(0, packageName.indexOf(46, 19)) : packageName;
                flowtypeID[0] = this.getIDFromMap(number, this.flowTypeMap);
                flowtypeID[1] = this.getIDFromMap(number, this.flowTemplateMap);
            } else if (packageName.startsWith("com.kingdee.eas.")) {
                String number = "";
                number = packageName.indexOf(46, 17) > 0 ? packageName.substring(0, packageName.indexOf(46, 17)) : packageName;
                flowtypeID[0] = this.getIDFromMap(number, this.flowTypeMap);
                flowtypeID[1] = this.getIDFromMap(number, this.flowTemplateMap);
            } else {
                flowtypeID[0] = this.getIDFromMap(packageName, this.flowTypeMap);
                flowtypeID[1] = this.getIDFromMap(packageName, this.flowTemplateMap);
            }
        }
        return flowtypeID;
    }

    private String getIDFromMap(String number, Map map) {
        if (map.containsKey(number)) {
            return map.get(number).toString();
        }
        return null;
    }

    private String getWorkCalendarOrg(Context ctx, String longNumber) {
        String orgID = null;
        if (!StringUtils.isEmpty((String)longNumber)) {
            String sql = "select fid,fname_l2,flongnumber from t_org_admin where fnumber in ('" + longNumber.replaceAll("!", "','") + "') " + "and exists (select fid from t_WorkCalendar where t_WorkCalendar.FOrgunitID = t_org_admin.fid) " + "order by flongnumber desc";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rowSet.next()) {
                    orgID = rowSet.getString("fid");
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return orgID;
    }

    private void getCUMap(Context ctx) {
    }
}

