/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfs.CollectTypeEnum;
import com.kingdee.eas.cp.wfs.FormConfigEntryCollection;
import com.kingdee.eas.cp.wfs.FormConfigInfo;
import com.kingdee.eas.cp.wfs.FormTypeEnum;
import com.kingdee.eas.cp.wfs.ResourceUtils;
import com.kingdee.eas.cp.wfs.utils.Clock;
import com.kingdee.eas.cp.wfs.utils.DataUtil;
import com.kingdee.eas.cp.wfs.utils.DateUtils;
import com.kingdee.eas.cp.wfs.utils.ExcelExportUtils;
import com.kingdee.eas.cp.wfs.utils.ExcelStyleToolKit;
import com.kingdee.eas.cp.wfs.utils.NumericUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.json.JSONException;
import org.json.JSONObject;

public class AbstractExcelReportBiz {
    public static final String LABEL_HEAD = "head";
    public static final String LABEL_BODY = "body";
    public static final String LABEL_COLSPAN = "colspan";
    public static final String LABEL_ROWSPAN = "rowspan";
    public static final String LABEL_ROWID = "rowid";
    public static final String LABEL_COLID = "colid";
    public static final String LABEL_VALUE = "value";
    public static final String LABEL_ROWIDS = "rowids";
    public static final String LABEL_COLIDS = "colids";
    public static final String LABEL_FORMAT_ROW_ID = "formatRowId";
    public static final String LABEL_FORMAT_COL_ID = "formatColId";
    public static final String LABEL_SUB_POST_ID = "_sub";
    public static final String LABEL_TOTAL_POST_ID = "total";
    public static final String QUERY_GET_CHILD_ADMIN = "com.kingdee.eas.cp.wfs.app.GetChildAdminDataQuery";
    public static final String QUERY_GET_ADMIN_AND_PROCDEF = "com.kingdee.eas.cp.wfs.app.GetAminOrgAndProcDefQuery";
    public static final String QUERY_GET_ADMIN_PROCDEF_STEPDEF = "com.kingdee.eas.cp.wfs.app.GetAdminProcStepDataQuery";
    public static final String QUERY_GET_FLOWTYPE_PROCDEF = "com.kingdee.eas.cp.wfs.app.GetProcTypeProcDefQuery";
    public static final String QUERY_GET_FLOWTEMPLATE_PROCDEF = "com.kingdee.eas.cp.wfs.app.GetProcTemplateProcDefQuery";
    public static final String QUERY_GET_FLOWTYPE_PROCDEF_STEPDEF = "com.kingdee.eas.cp.wfs.app.GetProcTypeProcDefStepDefQuery";
    public static final String QUERY_GET_FLOWTEMPLATE_PROCDEF_STEPDEF = "com.kingdee.eas.cp.wfs.app.GetProcTemplateProcDefStepDefQuery";
    public static final String QUERY_GET_PROCDEF = "com.kingdee.eas.cp.wfs.app.GetProcDefQuery";
    public static final String QUERY_GET_PROCDEF_STEPDEF = "com.kingdee.eas.cp.wfs.app.GetProcDefStepDefQuery";
    public static final String TEXT_SUB_COUNT = ResourceUtils.getString("SUB_COUNT");
    public static final String TEXT_TOTAL_COUNT = ResourceUtils.getString("TOTAL_COUNT");
    public static final String TEXT_AVERAGE = ResourceUtils.getString("AVERAGE");
    public static final String TEXT_TOTAL_AVERAGE = ResourceUtils.getString("TOTAL_AVERAGE");
    private static final int LATITUDE_COL_WIDTH = 300;
    private Map procdefNameMap = null;
    private Map collectItemNameMap = null;
    private HashMap colMap = null;
    private HashMap rowMap = null;
    private HashSet calculRowIdxSet = null;
    private HSSFWorkbook workbook = null;
    private HSSFSheet sheet = null;
    private HSSFCellStyle commonStyle = null;
    private List collectItems;
    private boolean isNeedConfigEntryJoinQuery;
    private int dataRowCount = 0;
    private int dataColCount = 0;
    private int dataRowStartIdx = 0;
    private int dataColStartIdx = 0;
    protected Logger logger = Logger.getLogger(this.getClass());
    protected Clock clock;
    protected ExcelStyleToolKit styleKit;
    private String reportName;
    private String className;
    private boolean isDebug = true;
    private String userId = null;
    private UserInfo user = null;
    private String configInfo;
    private String configName;

    public int getDataRowCount() {
        return this.dataRowCount;
    }

    public void setDataRowCount(int dataRowCount) {
        this.dataRowCount = dataRowCount;
        this.logInfo("DataRowCount:" + this.dataRowCount);
    }

    public int getDataColCount() {
        return this.dataColCount;
    }

    public void setDataColCount(int dataColCount) {
        this.dataColCount = dataColCount;
        this.logInfo("DataColCount:" + this.dataColCount);
    }

    public boolean isNeedConfigEntryJoinQuery() {
        return this.isNeedConfigEntryJoinQuery;
    }

    public void setIsNeedConfigEntryJoinQuery(boolean isNeedConfigEntryJoinQuery) {
        this.isNeedConfigEntryJoinQuery = isNeedConfigEntryJoinQuery;
    }

    public AbstractExcelReportBiz() {
        this.reset();
        this.className = this.getClass().getName();
        if (this.className.indexOf("ExcelExportGeneralViewReportBiz") != -1) {
            this.reportName = FormTypeEnum.TOTAL.getAlias();
        } else if (this.className.indexOf("ExcelExportProcInstReportBiz") != -1) {
            this.reportName = FormTypeEnum.INSTANCE.getAlias();
        } else if (this.className.indexOf("ExcelExportProcInstCostTimeReportBiz") != -1) {
            this.reportName = FormTypeEnum.INSTANCE_SPARETIME.getAlias();
        } else if (this.className.indexOf("ExcelExportStepInstReportBiz") != -1) {
            this.reportName = FormTypeEnum.NODE.getAlias();
        } else if (this.className.indexOf("ExcelExportStepInstCostTimeReportBiz") != -1) {
            this.reportName = FormTypeEnum.NODE_SPARETIME.getAlias();
        } else if (this.className.indexOf("ExcelExportPostponeReportBiz") != -1) {
            this.reportName = FormTypeEnum.DEFER.getAlias();
        }
        this.clock = new Clock();
    }

    private void initLoggerHeadInfo(FormConfigInfo config) {
        try {
            StringBuffer sb = new StringBuffer();
            this.configName = config.getName();
            sb.append("\n*-----------------------------------------------------------------------*\n");
            sb.append("*\t********************\u62a5\u8868\u5bfc\u51faExcel\u914d\u7f6e\u4fe1\u606f*******************\n");
            sb.append("*\t\u62a5\u8868\u540d\u79f0\uff1a" + this.configName + "\n");
            sb.append("*\t\u62a5\u8868\u7c7b\u578b\uff1a" + (config.getFormType() == null ? "" : config.getFormType().getAlias()) + "\n");
            sb.append("*\t\u7ec4\u7ec7\u8303\u56f4\uff1a" + (config.getAdmin() == null ? "" : config.getAdmin().getId().toString()) + "\n");
            sb.append("*\t\u7edf\u8ba1\u5468\u671f\uff1a" + (config.getStatPeriod() == null ? "" : config.getStatPeriod().getAlias()) + "\n");
            sb.append("*\t\u5f00\u59cb\u65e5\u671f\uff1a" + (config.getStartDate() == null ? "" : DateUtils.formatDate(config.getStartDate(), "yyyy-MM-dd")) + "\n");
            sb.append("*\t\u7ed3\u675f\u65e5\u671f\uff1a" + (config.getEndDate() == null ? "" : DateUtils.formatDate(config.getEndDate(), "yyyy-MM-dd")) + "\n");
            sb.append("*\t\u6c47\u603b\u65b9\u5f0f\uff1a" + (config.getCollectType() == null ? "" : config.getCollectType().getAlias()) + "\n");
            sb.append("*-----------------------------------------------------------------------*\n");
            this.configInfo = sb.toString();
            this.logger.info((Object)this.configInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EntityViewInfo createEmptyView() {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        return view;
    }

    protected void reset() {
        this.colMap = new HashMap();
        this.rowMap = new HashMap();
        this.calculRowIdxSet = new HashSet();
        this.isNeedConfigEntryJoinQuery = false;
        this.workbook = null;
        if (this.styleKit != null) {
            this.styleKit.reset();
        }
        this.sheet = null;
        this.commonStyle = null;
        this.dataRowCount = 0;
        this.dataColCount = 0;
        this.dataRowStartIdx = 0;
        this.dataColStartIdx = 0;
        this.userId = null;
        this.user = null;
    }

    protected FilterItemInfo getAdminOrgAndUserRangeFilterItem(Context ctx, String compareField) {
        return new FilterItemInfo(compareField, (Object)this.getUserId(), CompareType.EQUALS);
    }

    protected void logInfo(String text) {
        if (this.isDebug) {
            this.logger.info((Object)("\n===================\u90ae\u4ef6\u9644\u4ef6\u5bfc\u51fa\u62a5\u8868\u65e5\u5fd7===============================\n\nUser Name:" + (this.user == null ? "" : this.user.getName()) + "\nUser Id:" + this.userId + "\n\u5bfc\u51fa\u6d41\u7a0b\u7edf\u8ba1\u62a5\u8868 - " + this.reportName + "\n\u62a5\u8868\u540d\u79f0\uff1a" + this.configName + "\nclasspath : " + this.className + "\n" + text + "\n"));
        }
    }

    protected void logError(String text) {
        if (this.isDebug) {
            this.logger.error((Object)("\n===================\u90ae\u4ef6\u9644\u4ef6\u5bfc\u51fa\u62a5\u8868\u65e5\u5fd7===============================\n\nUser Name:" + (this.user == null ? "" : this.user.getName()) + "\nUser Id:" + this.userId + "\n\u5bfc\u51fa\u6d41\u7a0b\u7edf\u8ba1\u62a5\u8868 - " + this.reportName + "\n\u62a5\u8868\u540d\u79f0\uff1a" + this.configName + "\nclasspath : " + this.className + "\n" + text + "\n"));
        }
    }

    protected String insertProcInstSubQueryFilter(String sql, String filterText) {
        String markStr = "WHERE \"ORGRANGE\".FType = 20) AS \"PROCINST\"";
        if (sql != null && sql.trim().length() > 0 && filterText != null && filterText.trim().length() > 0 && sql.toLowerCase().indexOf(markStr.toLowerCase()) > 0) {
            int markIdx = sql.toLowerCase().indexOf(markStr.toLowerCase());
            return sql.substring(0, markIdx) + "WHERE \"ORGRANGE\".FType = 20 AND (" + filterText + ")) AS \"PROCINST\"" + sql.substring(markIdx + markStr.length());
        }
        return sql;
    }

    public int getDataRowStartIdx() {
        return this.dataRowStartIdx;
    }

    public void setDataRowStartIdx(int dataRowStartIdx) {
        this.dataRowStartIdx = dataRowStartIdx;
        this.logInfo("DataRowStartIdx:" + this.dataRowStartIdx);
    }

    public int getDataColStartIdx() {
        return this.dataColStartIdx;
    }

    public void setDataColStartIdx(int dataColStartIdx) {
        this.dataColStartIdx = dataColStartIdx;
        this.logInfo("DataColStartIdx:" + this.dataColStartIdx);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void buildHeadData(Context ctx, FormConfigInfo config) throws Exception {
    }

    public void setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    protected IRowSet query(Context ctx, String metaQueryPath, EntityViewInfo view) throws BOSException {
        return DataUtil.query(ctx, metaQueryPath, view, this.isDebug() ? this.logger : null, this.isDebug() ? this.clock : null);
    }

    protected IRowSet query(Context ctx, String sql) throws BOSException {
        return DataUtil.query(ctx, sql, this.isDebug() ? this.logger : null, this.isDebug() ? this.clock : null);
    }

    protected String insertStr(String source, String insertPlace, String insertText, boolean isBefore) {
        String _tempInsertPlace;
        if (insertText == null) {
            return source;
        }
        String _tempSource = source.toLowerCase();
        int idx = _tempSource.indexOf(_tempInsertPlace = insertPlace.toLowerCase());
        if (idx > -1) {
            String newText = isBefore ? insertText + insertPlace : insertPlace + insertText;
            return source.substring(0, idx) + newText + source.substring(idx + insertPlace.length(), source.length());
        }
        return source;
    }

    protected String insertGroupByItem(String sql, String fieldName) {
        if (sql != null) {
            if (sql.toUpperCase().indexOf("GROUP BY") != -1) {
                return sql.replaceAll("(?u)GROUP BY", "GROUP BY " + fieldName + ",");
            }
            return sql;
        }
        return null;
    }

    protected String insertCUAndOrgRangeFilterSQL(Context ctx, FormConfigInfo config, String sql, String cuField, String userField) {
        return this.insertFilter(sql, (userField != null ? userField + "='" + this.getUserId() + "'" : "") + (userField != null && cuField != null ? " AND " : "") + (cuField != null ? cuField + "='" + config.getAdmin().getCU().getId().toString() + "'" : ""));
    }

    protected String insertFilter(String sql, String insertFilter) {
        if (sql == null || sql.trim().equals("") || insertFilter == null || insertFilter.trim().equals("")) {
            return sql;
        }
        String _temp = sql;
        if (_temp.toLowerCase().lastIndexOf("where ") != -1) {
            int splitIdx = _temp.toLowerCase().lastIndexOf("where ") + "where ".length();
            return sql.substring(0, splitIdx) + insertFilter + " AND " + sql.substring(splitIdx);
        }
        if (_temp.toLowerCase().lastIndexOf("group by") != -1) {
            int splitIdx = _temp.toLowerCase().lastIndexOf("group by ");
            return sql.substring(0, splitIdx) + " WHERE " + insertFilter + " " + sql.substring(splitIdx);
        }
        if (_temp.toLowerCase().lastIndexOf("order by") != -1) {
            int splitIdx = _temp.toLowerCase().lastIndexOf("order by ");
            return sql.substring(0, splitIdx) + " WHERE " + insertFilter + " " + sql.substring(splitIdx);
        }
        return sql + " WHERE " + insertFilter;
    }

    protected String createDateCASESQL(List periodDatas, String dateField) {
        StringBuffer sql = new StringBuffer();
        sql.append("\n (CASE \n");
        Map itemData = null;
        int size = periodDatas.size();
        for (int i = 0; i < size; ++i) {
            itemData = (Map)periodDatas.get(i);
            sql.append("WHEN " + dateField + " BETWEEN {TS'" + DateUtils.formatDate((Date)itemData.get("startDate"), null) + "'} AND {TS'" + DateUtils.formatDate(DateUtils.addOneDay((Date)itemData.get("endDate")), null) + "'} THEN '" + "dateGroup" + i + "' \n");
        }
        sql.append("END)\n");
        return sql.toString();
    }

    protected void createSUMRowCellData(int rowIdx) {
    }

    protected String removeCollectItemSQL(String sql, CollectTypeEnum type) {
        if (sql != null && type != null && (type.equals((Object)CollectTypeEnum.PROCESSTYPE) || type.equals((Object)CollectTypeEnum.PROCESSTEMPLATE) || type.equals((Object)CollectTypeEnum.PROCESS))) {
            String idField = null;
            switch (type.getValue()) {
                case 1: {
                    idField = "\"TYPE\".FID";
                    break;
                }
                case 2: {
                    idField = "\"TEMPLATE\".FID";
                    break;
                }
                case 3: {
                    idField = "\"PROCDEF\".FProcDefID";
                }
            }
            String[] collectItemSQL = new String[]{"INNER JOIN T_WFS_FormConfigEntry AS \"ENTRY\"", "ON " + idField + " = \"ENTRY\".FCollectItemId", "INNER JOIN T_WFS_FormConfig AS \"CONFIG\"", "ON \"ENTRY\".FBillID = \"CONFIG\".FID"};
            String _temp = sql.toLowerCase();
            if (_temp.indexOf(collectItemSQL[0].toLowerCase()) != -1 && _temp.indexOf(collectItemSQL[1].toLowerCase()) != -1 && _temp.indexOf(collectItemSQL[2].toLowerCase()) != -1 && _temp.indexOf(collectItemSQL[3].toLowerCase()) != -1) {
                return sql.replaceAll(collectItemSQL[0], "").replaceAll(collectItemSQL[1], "").replaceAll(collectItemSQL[2], "").replaceAll(collectItemSQL[3], "");
            }
        }
        return sql;
    }

    protected String getLastPeriodId(String periodId) {
        String idxStr;
        String lastPeriodId = null;
        if (!(periodId == null || "".equals(periodId) || (idxStr = periodId.substring("dateGroup".length())) == null || "".equals(idxStr) || idxStr.equals("0"))) {
            lastPeriodId = "dateGroup" + (Integer.valueOf(idxStr) - 1);
        }
        return lastPeriodId;
    }

    protected void fillUpEmptyGridCell() throws JSONException {
        if (this.sheet != null) {
            Iterator it = this.rowMap.keySet().iterator();
            HashSet<String> calculRowIdxSet = new HashSet<String>();
            String rowId = null;
            while (it.hasNext()) {
                rowId = (String)it.next();
                if (rowId.lastIndexOf(LABEL_SUB_POST_ID) == -1 && !rowId.equals(LABEL_TOTAL_POST_ID)) continue;
                calculRowIdxSet.add(this.rowMap.get(rowId).toString());
            }
            Object cell = null;
            int maxRowIdx = this.dataRowStartIdx + this.dataRowCount - 1;
            for (int rowStep = this.dataRowStartIdx; rowStep <= maxRowIdx; ++rowStep) {
                int maxColIdx = this.dataColStartIdx + this.dataColCount - 1;
                for (int colStep = this.dataColStartIdx; colStep <= maxColIdx; ++colStep) {
                    if (this.sheet.getRow(rowStep) == null || this.sheet.getRow(rowStep).getCell(colStep) != null) continue;
                    this.appendCellData(rowStep, colStep, this.createCellData(""), calculRowIdxSet.contains(rowStep + "") ? this.styleKit.getCommonCalculateStyle() : this.getDiffLineCellStyle(rowStep));
                }
            }
        }
    }

    protected String insertStepDefSubQueryFilter(String sql, String filterText) {
        String _temp = sql;
        if (_temp.toLowerCase().indexOf("where \"stepdef\".fismanpower = 1) as \"stepdef\"") != -1) {
            return sql.replaceAll("(?u)where \"stepdef\".fismanpower = 1\\) as \"stepdef\"", "WHERE \"STEPDEF\".FIsManpower = 1 AND " + filterText + " ) AS \"STEPDEF\" ");
        }
        if (_temp.toLowerCase().indexOf("where \"stepdef\".fismanpower = 1 and \"orgrange\".ftype = 20) as \"stepdef\"") != -1) {
            return sql.replaceAll("(?u)where \"stepdef\".fismanpower = 1 and \"orgrange\".ftype = 20\\) as \"stepdef\"", "WHERE \"STEPDEF\".FIsManpower = 1 AND \"ORGRANGE\".FType = 20 AND " + filterText + " ) AS \"STEPDEF\" ");
        }
        if (_temp.toLowerCase().indexOf("where \"orgrange\".ftype = 20) as \"stepdef\"") != -1) {
            return sql.replaceAll("(?u)where \"orgrange\".ftype = 20\\) as \"stepdef\"", "WHERE \"ORGRANGE\".FType = 20 AND " + filterText + " ) AS \"STEPDEF\" ");
        }
        return sql;
    }

    protected String insertProcDefSubQueryFilter(String sql, String filterText) {
        String _temp = sql;
        if (_temp.toLowerCase().indexOf("where \"orgrange\".ftype = 20) as \"procdef\"") != -1) {
            return sql.replaceAll("(?u)where \"orgrange\".ftype = 20\\) as \"procdef\"", "WHERE \"ORGRANGE\".FType = 20 AND " + filterText + (this.getProcDefSubFilterForLatitude() == null ? "" : " AND " + this.getProcDefSubFilterForLatitude()) + " ) AS \"PROCDEF\" ");
        }
        return sql;
    }

    protected String getProcDefSubFilterForLatitude() {
        return null;
    }

    protected StringBuffer removeNewestVersionProcJoinQuery(StringBuffer sourceSql) {
        String sql = sourceSql.toString();
        int mark = sql.indexOf("AS \"NEWESTPROC\"");
        if (mark != -1) {
            int _idx2;
            int startIdx = sql.substring(0, mark).lastIndexOf("INNER JOIN (SELECT");
            int _idx1 = sql.substring(mark).indexOf("\"NEWESTPROC\".\"PROCDEFID\"") + mark;
            int endIdx = _idx1 > (_idx2 = sql.substring(mark).indexOf("\"NEWESTPROC\".\"NEWVERSION\"") + mark) ? _idx1 + "\"NEWESTPROC\".\"PROCDEFID\"".length() : _idx2 + "\"NEWESTPROC\".\"NEWVERSION\"".length();
            return new StringBuffer(sql.substring(0, startIdx) + sql.substring(endIdx, sql.length()));
        }
        return sourceSql;
    }

    protected EntityViewInfo createCollectIdView(String idField, FormConfigInfo config) {
        EntityViewInfo view = null;
        FormConfigEntryCollection entry = config.getEntry();
        if (entry != null) {
            FormConfigEntryCollection coll = config.getEntry();
            view = this.createEmptyView();
            StringBuffer maskStr = new StringBuffer();
            int idx = 0;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (coll.get(i).getCollectItemId() == null) continue;
                view.getFilter().getFilterItems().add(new FilterItemInfo(idField, (Object)coll.get(i).getCollectItemId()));
                maskStr.append((idx == 0 ? "" : " or ") + "#" + i);
                ++idx;
            }
            view.getFilter().setMaskString(maskStr.toString());
        }
        return view;
    }

    public List getChildAdmin(Context ctx, String parentId, String longNumber, int level) throws EASBizException, BOSException, UuidException, SQLException {
        LinkedList<AdminOrgUnitInfo> listData = new LinkedList<AdminOrgUnitInfo>();
        AdminOrgUnitInfo info = null;
        EntityViewInfo view = this.createEmptyView();
        if (longNumber == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("level"));
            info = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentId), sic);
            longNumber = info.getLongNumber();
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level + 1), CompareType.EQUALS));
        IRowSet dataRows = this.query(ctx, QUERY_GET_CHILD_ADMIN, view);
        if (dataRows != null) {
            while (dataRows.next()) {
                info = new AdminOrgUnitInfo();
                info.setId(BOSUuid.read((String)dataRows.getString("id")));
                info.setLongNumber(dataRows.getString("longNumber"));
                info.setName(dataRows.getString("name"));
                listData.add(info);
            }
        }
        return listData;
    }

    public List getChildAdmin(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, UuidException, SQLException {
        LinkedList<AdminOrgUnitInfo> listData = new LinkedList<AdminOrgUnitInfo>();
        AdminOrgUnitInfo info = null;
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(config.getAdmin().getLongNumber() + "!%"), CompareType.LIKE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(config.getAdmin().getLevel() + 1), CompareType.EQUALS));
        IRowSet dataRows = this.query(ctx, QUERY_GET_CHILD_ADMIN, view);
        if (dataRows != null) {
            while (dataRows.next()) {
                info = new AdminOrgUnitInfo();
                info.setId(BOSUuid.read((String)dataRows.getString("id")));
                info.setLongNumber(dataRows.getString("longNumber"));
                info.setName(dataRows.getString("name"));
                if (dataRows.getString("CU.id") != null) {
                    CtrlUnitInfo cu = new CtrlUnitInfo();
                    cu.setId(BOSUuid.read((String)dataRows.getString("cu.id")));
                    info.setCU(cu);
                }
                listData.add(info);
            }
        }
        return listData;
    }

    private Map createLatitudeItemMap(List listData, String mappingFieldName) {
        HashMap<String, CoreBaseInfo> collectItemMapping = null;
        if (listData != null) {
            collectItemMapping = new HashMap<String, CoreBaseInfo>();
            int size = listData.size();
            for (int i = 0; i < size; ++i) {
                if (((CoreBaseInfo)listData.get(i)).get(mappingFieldName) == null) continue;
                collectItemMapping.put(((CoreBaseInfo)listData.get(i)).get(mappingFieldName).toString(), (CoreBaseInfo)listData.get(i));
            }
            if (collectItemMapping.keySet().size() == 0) {
                collectItemMapping = null;
            }
        }
        return collectItemMapping;
    }

    private void initProcdefNameMap(Context ctx) throws BOSException, SQLException {
        this.procdefNameMap = new HashMap();
        IRowSet dataRows = this.query(ctx, "com.kingdee.eas.cp.wfs.app.GetProcDefWithNewestVersionQuery", null);
        if (dataRows != null && dataRows.size() > 0) {
            while (dataRows.next()) {
                this.procdefNameMap.put(dataRows.getString("PROCDEFID"), dataRows.getString("NAME"));
            }
        }
    }

    public String createChildAdminDataSQL(Context ctx, FormConfigInfo config, String queryName, Map adminFieldNames, String timeFieldName) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(config.getAdmin().getLongNumber() + "!%"), CompareType.LIKE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("cu.longNumber", (Object)(config.getAdmin().getCU().getLongNumber() + "%"), CompareType.LIKE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("user.id", (Object)this.getUserId(), CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo(timeFieldName, (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo(timeFieldName, (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS_EQUALS));
        StringBuffer sql = new StringBuffer(DataUtil.getSQL(ctx, queryName, view));
        StringBuffer idSQL = new StringBuffer();
        LinkedList<AdminOrgUnitInfo> adminList = this.getChildAdmin(ctx, config);
        if (adminList == null || adminList.size() == 0) {
            adminList = new LinkedList<AdminOrgUnitInfo>();
            adminList.add(new AdminOrgUnitInfo());
            ((AdminOrgUnitInfo)adminList.get(0)).setId(config.getAdmin().getId());
            ((AdminOrgUnitInfo)adminList.get(0)).setName("");
        }
        AdminOrgUnitInfo admin = null;
        String idReplace = "(?u)NULLVALUE1 AS \"REPLACESTATEMENT1\"";
        idSQL.append(" \n(CASE \n");
        this.collectItemNameMap = new HashMap();
        int size = adminList.size();
        for (int i = 0; i < size; ++i) {
            admin = (AdminOrgUnitInfo)adminList.get(i);
            idSQL.append("WHEN " + (String)adminFieldNames.get("longNumber") + " LIKE '" + admin.getLongNumber() + "%' THEN '" + admin.getId().toString() + "' \n");
            this.collectItemNameMap.put(admin.getId().toString(), admin.getName());
        }
        idSQL.append(" END )");
        String _sql = sql.toString().replaceAll(idReplace, idSQL.toString() + " as \"ID\" \n");
        if (queryName.equals(QUERY_GET_ADMIN_AND_PROCDEF)) {
            _sql = _sql + "\nORDER BY \"ID\" ASC";
        } else if (queryName.equals(QUERY_GET_ADMIN_PROCDEF_STEPDEF)) {
            _sql = _sql + "\nORDER BY \"ID\" ASC,\"PROCDEF.PROCDEFID\" ASC";
        }
        return _sql;
    }

    public void buildBiLatitudeBizData(Context ctx, FormConfigInfo config, int rowIdx, IRowSet dataRows, Map fstFieldNames, Map secFieldNames) throws SQLException, JSONException {
        this.dataRowStartIdx = rowIdx;
        this.dataColStartIdx = 2;
        boolean hasSubCalculRow = false;
        ArrayList<Integer> rowIdxs = new ArrayList<Integer>();
        if (dataRows != null) {
            String fstId = null;
            String lastFstId = null;
            String secId = null;
            JSONObject fstItem = null;
            JSONObject secItem = null;
            boolean fstColIdx = false;
            boolean secColIdx = true;
            int secItemCount = 0;
            int fstRowIdx = rowIdx;
            Map collectItemMapping = this.createLatitudeItemMap(this.collectItems, (String)fstFieldNames.get("id"));
            HashSet<String> addedCollectItem = new HashSet<String>();
            while (dataRows.next()) {
                fstId = dataRows.getString((String)fstFieldNames.get("id"));
                if (collectItemMapping != null && fstId != null) {
                    if (collectItemMapping.keySet().contains(fstId)) {
                        addedCollectItem.add(fstId);
                        collectItemMapping.remove(fstId);
                    } else if (!addedCollectItem.contains(fstId)) {
                        fstId = null;
                    }
                }
                secItem = (secId = dataRows.getString((String)secFieldNames.get("id"))) != null ? (this.procdefNameMap != null ? this.createCellData((String)this.procdefNameMap.get(secId)) : this.createCellData(dataRows.getString((String)secFieldNames.get("name")))) : null;
                if (fstId != null) {
                    if (fstId.equals(lastFstId)) {
                        if (secItem != null) {
                            this.appendCellData(rowIdx, 1, secItem, this.getDiffLineCellStyle(rowIdx));
                            this.registRowIdx(fstId + "_" + secId, rowIdx);
                            ++rowIdx;
                            ++secItemCount;
                        }
                    } else {
                        if (dataRows.isFirst() || lastFstId == null) {
                            fstItem = this.collectItemNameMap != null ? this.createCellData((String)this.collectItemNameMap.get(dataRows.getString((String)fstFieldNames.get("id")))) : this.createCellData(dataRows.getString((String)fstFieldNames.get("name")));
                            fstRowIdx = rowIdx;
                        } else {
                            if (secItemCount == 0) {
                                this.appendCellData(rowIdx, 1, this.createCellData(""), this.getDiffLineCellStyle(rowIdx));
                                ++rowIdx;
                                ++secItemCount;
                            } else {
                                if (config.getFormType().equals((Object)FormTypeEnum.INSTANCE_SPARETIME) || config.getFormType().equals((Object)FormTypeEnum.NODE_SPARETIME)) {
                                    this.appendCellData(rowIdx, 1, this.createCellData(TEXT_AVERAGE), this.styleKit.get("8"));
                                    ExcelExportUtils.appendBlockData(this.sheet, this.styleKit.get("11"), 0, this.createCellData(new Integer(0)), this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1, rowIdx, rowIdx);
                                } else {
                                    this.appendCellData(rowIdx, 1, this.createCellData(TEXT_SUB_COUNT), this.styleKit.get("8"));
                                    this.appendSumFormulaRowData(rowIdx, fstRowIdx, rowIdx - 1, this.styleKit.getCommonCalculateStyle());
                                    rowIdxs.add(new Integer(rowIdx));
                                }
                                ++secItemCount;
                                hasSubCalculRow = true;
                                this.registRowIdx(lastFstId + LABEL_SUB_POST_ID, rowIdx);
                                ++rowIdx;
                            }
                            fstItem.put(LABEL_ROWSPAN, (Object)new Integer(secItemCount));
                            this.appendCellData(fstRowIdx, 0, fstItem);
                            fstItem = this.collectItemNameMap != null ? this.createCellData((String)this.collectItemNameMap.get(dataRows.getString((String)fstFieldNames.get("id")))) : this.createCellData(dataRows.getString((String)fstFieldNames.get("name")));
                            fstRowIdx = rowIdx;
                            secItemCount = 0;
                        }
                        if (secItem != null) {
                            this.appendCellData(rowIdx, 1, secItem, this.getDiffLineCellStyle(rowIdx));
                            this.registRowIdx(fstId + "_" + secId, rowIdx);
                            ++rowIdx;
                            ++secItemCount;
                        }
                        lastFstId = fstId;
                    }
                    if (!dataRows.isLast()) continue;
                    if (secItemCount == 0) {
                        this.appendCellData(rowIdx, 1, this.createCellData(""), this.getDiffLineCellStyle(rowIdx));
                        ++secItemCount;
                    } else {
                        if (config.getFormType().equals((Object)FormTypeEnum.INSTANCE_SPARETIME) || config.getFormType().equals((Object)FormTypeEnum.NODE_SPARETIME)) {
                            this.appendCellData(rowIdx, 1, this.createCellData(TEXT_AVERAGE), this.styleKit.get("8"));
                            ExcelExportUtils.appendBlockData(this.sheet, this.styleKit.get("11"), 0, this.createCellData(new Integer(0)), this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1, rowIdx, rowIdx);
                        } else {
                            this.appendCellData(rowIdx, 1, this.createCellData(TEXT_SUB_COUNT), this.styleKit.get("8"));
                            this.appendSumFormulaRowData(rowIdx, fstRowIdx, rowIdx - 1, this.styleKit.getCommonCalculateStyle());
                            rowIdxs.add(new Integer(rowIdx));
                        }
                        hasSubCalculRow = true;
                        this.registRowIdx(fstId + LABEL_SUB_POST_ID, rowIdx);
                        ++rowIdx;
                        ++secItemCount;
                    }
                    fstItem.put(LABEL_ROWSPAN, (Object)new Integer(secItemCount));
                    this.appendCellData(fstRowIdx, 0, fstItem);
                    continue;
                }
                if (fstItem == null) continue;
                if (secItemCount == 0) {
                    this.appendCellData(rowIdx, 1, this.createCellData(""), this.getDiffLineCellStyle(rowIdx));
                    ++secItemCount;
                } else {
                    if (config.getFormType().equals((Object)FormTypeEnum.INSTANCE_SPARETIME) || config.getFormType().equals((Object)FormTypeEnum.NODE_SPARETIME)) {
                        this.appendCellData(rowIdx, 1, this.createCellData(TEXT_AVERAGE), this.styleKit.get("8"));
                        ExcelExportUtils.appendBlockData(this.sheet, this.styleKit.get("11"), 0, this.createCellData(new Integer(0)), this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1, rowIdx, rowIdx);
                    } else {
                        this.appendCellData(rowIdx, 1, this.createCellData(TEXT_SUB_COUNT), this.styleKit.get("8"));
                        this.appendSumFormulaRowData(rowIdx, fstRowIdx, rowIdx - 1, this.styleKit.getCommonCalculateStyle());
                        rowIdxs.add(new Integer(rowIdx));
                    }
                    hasSubCalculRow = true;
                    this.registRowIdx(lastFstId + LABEL_SUB_POST_ID, rowIdx);
                    ++rowIdx;
                    ++secItemCount;
                }
                fstItem.put(LABEL_ROWSPAN, (Object)new Integer(secItemCount));
                this.appendCellData(fstRowIdx, 0, fstItem);
                lastFstId = null;
                fstId = null;
                secId = null;
                secItem = null;
                fstItem = null;
            }
            if (collectItemMapping != null && collectItemMapping.keySet().size() > 0) {
                Iterator it = collectItemMapping.keySet().iterator();
                String cId = null;
                JSONObject emptyFstItem = null;
                while (it.hasNext()) {
                    cId = (String)it.next();
                    emptyFstItem = this.createCellData(((CoreBaseInfo)collectItemMapping.get(cId)).get((String)fstFieldNames.get("name")));
                    this.appendCellData(rowIdx, 0, emptyFstItem);
                    this.appendCellData(rowIdx, 1, this.createCellData(""), this.getDiffLineCellStyle(rowIdx));
                    ++rowIdx;
                }
            }
            HSSFCell lastCell = null;
            if (config.getFormType().equals((Object)FormTypeEnum.INSTANCE_SPARETIME) || config.getFormType().equals((Object)FormTypeEnum.NODE_SPARETIME)) {
                lastCell = this.appendCellData(rowIdx, 0, this.createCellData(1, 2, TEXT_TOTAL_AVERAGE), this.styleKit.get("8"));
                ExcelExportUtils.appendBlockData(this.sheet, this.styleKit.get("11"), 0, this.createCellData(new Integer(0)), this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1, rowIdx, rowIdx);
            } else {
                lastCell = this.appendCellData(rowIdx, 0, this.createCellData(1, 2, TEXT_TOTAL_COUNT), this.styleKit.get("8"));
                if (lastCell != null) {
                    this.appendSumFormulaRowData(rowIdx, rowIdxs, this.styleKit.getCommonCalculateStyle());
                }
            }
            if (lastCell != null) {
                this.registRowIdx(LABEL_TOTAL_POST_ID, rowIdx);
            }
            this.setDataRowCount(rowIdx - this.dataRowStartIdx + 1);
        }
    }

    public void buildTriLatitudeBizData(Context ctx, FormConfigInfo config, IRowSet dataRows, int rowIdx, Map fstFieldNames, Map secFieldNames, Map thrFieldNames) throws EASBizException, BOSException, SQLException, JSONException {
        this.dataRowStartIdx = rowIdx;
        this.dataColStartIdx = 3;
        boolean hasSubCalculRow = false;
        ArrayList<Integer> rowIdxList = new ArrayList<Integer>();
        if (dataRows != null) {
            int fstRowIdx;
            String fstId = null;
            String lastFstId = null;
            String secId = null;
            String lastSecId = null;
            String thrId = null;
            JSONObject fstItem = null;
            JSONObject secItem = null;
            JSONObject thrItem = null;
            JSONObject calculItem = null;
            boolean fstColIdx = false;
            boolean secColIdx = true;
            int thrColIdx = 2;
            int secRowIdx = fstRowIdx = rowIdx;
            int secItemCount = 0;
            int thrItemCount = 0;
            int fstItemSpan = 0;
            HashSet<String> fstHasThrItem = new HashSet<String>();
            HSSFCell cell = null;
            Map collectItemMapping = this.createLatitudeItemMap(this.collectItems, (String)fstFieldNames.get("id"));
            HashSet<String> addedCollectItem = new HashSet<String>();
            while (dataRows.next()) {
                fstId = dataRows.getString((String)fstFieldNames.get("id"));
                if (collectItemMapping != null && fstId != null) {
                    if (collectItemMapping.keySet().contains(fstId)) {
                        addedCollectItem.add(fstId);
                        collectItemMapping.remove(fstId);
                    } else if (!addedCollectItem.contains(fstId)) {
                        fstId = null;
                    }
                }
                secId = dataRows.getString((String)secFieldNames.get("id"));
                thrId = dataRows.getString((String)thrFieldNames.get("id"));
                thrItem = thrId != null ? this.createCellData(dataRows.getString((String)thrFieldNames.get("name"))) : null;
                if (fstId != null) {
                    if (fstId.equals(lastFstId)) {
                        if (secId != null) {
                            if (secId.equals(lastSecId)) {
                                if (thrItem != null) {
                                    cell = this.appendCellData(secRowIdx + thrItemCount, 2, thrItem, this.getDiffLineCellStyle(secRowIdx + thrItemCount));
                                    this.registRowIdx(fstId + "_" + secId + "_" + thrId, cell.getRowIndex());
                                    fstHasThrItem.add(fstId);
                                    rowIdx += cell == null || cell.getRowIndex() < rowIdx ? 0 : 1;
                                    ++thrItemCount;
                                    cell = null;
                                }
                            } else {
                                if (secItem != null) {
                                    if (thrItemCount == 0) {
                                        this.appendCellData(secRowIdx, 2, this.createCellData(""), this.getDiffLineCellStyle(secRowIdx));
                                        ++thrItemCount;
                                    }
                                    fstItemSpan += thrItemCount;
                                    secItem.put(LABEL_ROWSPAN, thrItemCount);
                                    this.appendCellData(secRowIdx, 1, secItem);
                                }
                                secItem = this.procdefNameMap != null ? this.createCellData((String)this.procdefNameMap.get(dataRows.getString((String)secFieldNames.get("id")))) : this.createCellData(dataRows.getString((String)secFieldNames.get("name")));
                                secRowIdx = fstRowIdx + fstItemSpan < rowIdx ? fstRowIdx + fstItemSpan : rowIdx;
                                lastSecId = secId;
                                thrItemCount = 0;
                                if (thrItem != null) {
                                    cell = this.appendCellData(secRowIdx + thrItemCount, 2, thrItem, this.getDiffLineCellStyle(secRowIdx + thrItemCount));
                                    this.registRowIdx(fstId + "_" + secId + "_" + thrId, cell.getRowIndex());
                                    fstHasThrItem.add(fstId);
                                    thrItemCount = 1;
                                    cell = null;
                                }
                                ++secItemCount;
                                rowIdx += fstRowIdx + fstItemSpan < rowIdx ? 0 : 1;
                            }
                        } else if (secItem != null) {
                            if (thrItemCount == 0) {
                                this.appendCellData(secRowIdx, 2, this.createCellData(""), this.getDiffLineCellStyle(secRowIdx));
                                ++thrItemCount;
                            }
                            fstItemSpan += thrItemCount;
                            secItem.put(LABEL_ROWSPAN, thrItemCount);
                            this.appendCellData(secRowIdx, 1, secItem);
                            secItem = null;
                            secRowIdx = rowIdx;
                            secId = null;
                            lastSecId = null;
                            thrItemCount = 0;
                        }
                    } else {
                        if (fstItem != null) {
                            if (secItemCount == 0) {
                                this.appendCellData(fstRowIdx, 2, this.createCellData(""), this.getDiffLineCellStyle(fstRowIdx));
                                this.appendCellData(fstRowIdx, 1, this.createCellData(""));
                                ++fstItemSpan;
                            } else {
                                if (secItem != null) {
                                    if (thrItemCount == 0) {
                                        this.appendCellData(secRowIdx, 2, this.createCellData(""), this.getDiffLineCellStyle(secRowIdx));
                                        ++thrItemCount;
                                    }
                                    fstItemSpan += thrItemCount;
                                    secItem.put(LABEL_ROWSPAN, thrItemCount);
                                    this.appendCellData(secRowIdx, 1, secItem);
                                }
                                if (fstHasThrItem.contains(lastFstId)) {
                                    if (config.getFormType().equals((Object)FormTypeEnum.INSTANCE_SPARETIME) || config.getFormType().equals((Object)FormTypeEnum.NODE_SPARETIME)) {
                                        calculItem = this.createCellData(TEXT_AVERAGE);
                                        calculItem.put(LABEL_COLSPAN, 2);
                                        this.appendCellData(rowIdx, 1, calculItem, this.styleKit.get("8"));
                                        ExcelExportUtils.appendBlockData(this.sheet, this.styleKit.get("11"), 0, this.createCellData(new Integer(0)), this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1, rowIdx, rowIdx);
                                    } else {
                                        calculItem = this.createCellData(TEXT_SUB_COUNT);
                                        calculItem.put(LABEL_COLSPAN, 2);
                                        this.appendCellData(rowIdx, 1, calculItem, this.styleKit.get("8"));
                                        this.appendSumFormulaRowData(rowIdx, fstRowIdx, rowIdx - 1, this.styleKit.getCommonCalculateStyle());
                                        rowIdxList.add(new Integer(rowIdx));
                                    }
                                    ++fstItemSpan;
                                    hasSubCalculRow = true;
                                    this.registRowIdx(lastFstId + LABEL_SUB_POST_ID, rowIdx);
                                    ++rowIdx;
                                }
                            }
                            ++secItemCount;
                            fstItem.put(LABEL_ROWSPAN, fstItemSpan);
                            this.appendCellData(fstRowIdx, 0, fstItem);
                        }
                        fstItem = this.collectItemNameMap != null ? this.createCellData((String)this.collectItemNameMap.get(dataRows.getString((String)fstFieldNames.get("id")))) : this.createCellData(dataRows.getString((String)fstFieldNames.get("name")));
                        fstRowIdx = rowIdx;
                        lastFstId = fstId;
                        secItemCount = 0;
                        fstItemSpan = 0;
                        if (secId != null) {
                            secItem = this.procdefNameMap != null ? this.createCellData((String)this.procdefNameMap.get(dataRows.getString((String)secFieldNames.get("id")))) : this.createCellData(dataRows.getString((String)secFieldNames.get("name")));
                            secRowIdx = fstRowIdx + fstItemSpan < rowIdx ? fstRowIdx + fstItemSpan : rowIdx;
                            lastSecId = secId;
                            thrItemCount = 0;
                            if (thrItem != null) {
                                cell = this.appendCellData(secRowIdx + thrItemCount, 2, thrItem, this.getDiffLineCellStyle(secRowIdx + thrItemCount));
                                this.registRowIdx(fstId + "_" + secId + "_" + thrId, rowIdx);
                                fstHasThrItem.add(fstId);
                                thrItemCount = 1;
                            }
                            ++secItemCount;
                        }
                        rowIdx += fstRowIdx + fstItemSpan < rowIdx ? 0 : 1;
                    }
                    if (!dataRows.isLast()) continue;
                    if (secItemCount == 0) {
                        this.appendCellData(fstRowIdx, 2, this.createCellData(""), this.getDiffLineCellStyle(fstRowIdx));
                        this.appendCellData(fstRowIdx, 1, this.createCellData(""));
                        ++fstItemSpan;
                    } else {
                        if (secItem != null) {
                            if (thrItemCount == 0) {
                                this.appendCellData(secRowIdx, 2, this.createCellData(""), this.getDiffLineCellStyle(secRowIdx));
                                ++thrItemCount;
                            }
                            fstItemSpan += thrItemCount;
                            secItem.put(LABEL_ROWSPAN, thrItemCount);
                            this.appendCellData(secRowIdx, 1, secItem);
                        }
                        if (fstHasThrItem.contains(lastFstId)) {
                            if (config.getFormType().equals((Object)FormTypeEnum.INSTANCE_SPARETIME) || config.getFormType().equals((Object)FormTypeEnum.NODE_SPARETIME)) {
                                calculItem = this.createCellData(TEXT_AVERAGE);
                                calculItem.put(LABEL_COLSPAN, 2);
                                this.appendCellData(rowIdx, 1, calculItem, this.styleKit.get("8"));
                                ExcelExportUtils.appendBlockData(this.sheet, this.styleKit.get("11"), 0, this.createCellData(new Integer(0)), this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1, rowIdx, rowIdx);
                            } else {
                                calculItem = this.createCellData(TEXT_SUB_COUNT);
                                calculItem.put(LABEL_COLSPAN, 2);
                                this.appendCellData(rowIdx, 1, calculItem, this.styleKit.get("8"));
                                this.appendSumFormulaRowData(rowIdx, fstRowIdx, rowIdx - 1, this.styleKit.getCommonCalculateStyle());
                                rowIdxList.add(new Integer(rowIdx));
                            }
                            ++fstItemSpan;
                            hasSubCalculRow = true;
                            this.registRowIdx(fstId + LABEL_SUB_POST_ID, rowIdx);
                            ++rowIdx;
                        }
                    }
                    ++secItemCount;
                    fstItem.put(LABEL_ROWSPAN, fstItemSpan);
                    this.appendCellData(fstRowIdx, 0, fstItem);
                    continue;
                }
                if (fstItem == null) continue;
                if (secItemCount == 0) {
                    this.appendCellData(fstRowIdx, 2, this.createCellData(""), this.getDiffLineCellStyle(fstRowIdx));
                    this.appendCellData(fstRowIdx, 1, this.createCellData(""));
                    ++fstItemSpan;
                } else {
                    if (secItem != null) {
                        if (thrItemCount == 0) {
                            this.appendCellData(secRowIdx, 2, this.createCellData(""), this.getDiffLineCellStyle(secRowIdx));
                            ++thrItemCount;
                        }
                        fstItemSpan += thrItemCount;
                        secItem.put(LABEL_ROWSPAN, thrItemCount);
                        this.appendCellData(secRowIdx, 1, secItem);
                    }
                    if (fstHasThrItem.contains(lastFstId)) {
                        if (config.getFormType().equals((Object)FormTypeEnum.INSTANCE_SPARETIME) || config.getFormType().equals((Object)FormTypeEnum.NODE_SPARETIME)) {
                            calculItem = this.createCellData(TEXT_AVERAGE);
                            calculItem.put(LABEL_COLSPAN, 2);
                            this.appendCellData(rowIdx, 1, calculItem, this.styleKit.get("8"));
                            ExcelExportUtils.appendBlockData(this.sheet, this.styleKit.get("11"), 0, this.createCellData(new Integer(0)), this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1, rowIdx, rowIdx);
                        } else {
                            calculItem = this.createCellData(TEXT_SUB_COUNT);
                            calculItem.put(LABEL_COLSPAN, 2);
                            this.appendCellData(rowIdx, 1, calculItem, this.styleKit.get("8"));
                            this.appendSumFormulaRowData(rowIdx, fstRowIdx, rowIdx - 1, this.styleKit.getCommonCalculateStyle());
                            rowIdxList.add(new Integer(rowIdx));
                        }
                        ++fstItemSpan;
                        hasSubCalculRow = true;
                        this.registRowIdx(lastFstId + LABEL_SUB_POST_ID, rowIdx);
                    }
                }
                ++secItemCount;
                fstItem.put(LABEL_ROWSPAN, fstItemSpan);
                this.appendCellData(fstRowIdx, 0, fstItem);
                fstItem = null;
                fstRowIdx = ++rowIdx;
                fstId = null;
                lastFstId = null;
                secItemCount = 0;
                secItem = null;
                secRowIdx = rowIdx;
                secId = null;
                lastSecId = null;
                thrItemCount = 0;
                fstItemSpan = 0;
            }
            if (collectItemMapping != null && collectItemMapping.keySet().size() > 0) {
                Iterator it = collectItemMapping.keySet().iterator();
                String cId = null;
                JSONObject emptyFstItem = null;
                while (it.hasNext()) {
                    cId = (String)it.next();
                    emptyFstItem = this.createCellData(((CoreBaseInfo)collectItemMapping.get(cId)).get((String)fstFieldNames.get("name")));
                    this.appendCellData(rowIdx, 0, emptyFstItem);
                    this.appendCellData(rowIdx, 2, this.createCellData(""));
                    this.appendCellData(rowIdx, 1, this.createCellData(""), this.getDiffLineCellStyle(rowIdx));
                    ++rowIdx;
                }
            }
            HSSFCell lastCell = null;
            if (config.getFormType().equals((Object)FormTypeEnum.INSTANCE_SPARETIME) || config.getFormType().equals((Object)FormTypeEnum.NODE_SPARETIME)) {
                lastCell = this.appendCellData(rowIdx, 0, this.createCellData(1, 3, TEXT_TOTAL_AVERAGE), this.styleKit.get("8"));
                ExcelExportUtils.appendBlockData(this.sheet, this.styleKit.get("11"), 0, this.createCellData(new Integer(0)), this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1, rowIdx, rowIdx);
            } else {
                lastCell = this.appendCellData(rowIdx, 0, this.createCellData(1, 3, TEXT_TOTAL_COUNT), this.styleKit.get("8"));
                if (lastCell != null) {
                    this.appendSumFormulaRowData(rowIdx, rowIdxList, this.styleKit.getCommonCalculateStyle());
                }
            }
            if (lastCell != null) {
                this.registRowIdx(LABEL_TOTAL_POST_ID, rowIdx);
            }
            this.setDataRowCount(rowIdx - this.dataRowStartIdx + 1);
        }
    }

    public void buildSingleLatitudeBizData(Context ctx, FormConfigInfo config, IRowSet dataRows, int rowIdx, Map fieldNames) throws EASBizException, BOSException, SQLException, JSONException {
        this.dataRowStartIdx = rowIdx;
        this.dataColStartIdx = 1;
        boolean isEmpty = true;
        if (dataRows != null) {
            String fstId = null;
            JSONObject fstItem = null;
            boolean fstColIdx = false;
            while (dataRows.next()) {
                fstId = dataRows.getString((String)fieldNames.get("id"));
                if (fstId != null) {
                    fstItem = this.createCellData(dataRows.getString((String)fieldNames.get("name")));
                    this.registRowIdx(dataRows.getString((String)fieldNames.get("id")), rowIdx);
                    this.appendCellData(rowIdx, 0, fstItem, this.getDiffLineCellStyle(rowIdx));
                    ++rowIdx;
                    isEmpty = false;
                    continue;
                }
                fstItem = null;
            }
            if (!isEmpty) {
                HSSFCell lastCell = null;
                JSONObject calculItem = null;
                if (config.getFormType().equals((Object)FormTypeEnum.INSTANCE_SPARETIME) || config.getFormType().equals((Object)FormTypeEnum.NODE_SPARETIME)) {
                    calculItem = this.createCellData(TEXT_TOTAL_AVERAGE);
                    lastCell = this.appendCellData(rowIdx, 0, calculItem, this.styleKit.get("8"));
                    ExcelExportUtils.appendBlockData(this.sheet, this.styleKit.get("11"), 0, this.createCellData(new Integer(0)), this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1, rowIdx, rowIdx);
                } else {
                    calculItem = this.createCellData(TEXT_TOTAL_COUNT);
                    lastCell = this.appendCellData(rowIdx, 0, calculItem, this.styleKit.get("8"));
                    this.appendSumFormulaRowData(rowIdx, this.dataRowStartIdx, rowIdx - 1, this.styleKit.getCommonCalculateStyle());
                }
                if (lastCell != null) {
                    this.registRowIdx(LABEL_TOTAL_POST_ID, rowIdx);
                    this.setDataRowCount(lastCell.getRowIndex() - this.dataRowStartIdx + 1);
                }
            }
        }
    }

    public void buildLatitudeDataByAdminProc(Context ctx, FormConfigInfo config, int rowIdx) throws EASBizException, BOSException, UuidException, SQLException, JSONException {
        this.initProcdefNameMap(ctx);
        HashMap<String, String> collectFieldNames = new HashMap<String, String>();
        collectFieldNames.put("id", "id");
        collectFieldNames.put("name", "name");
        HashMap<String, String> procFieldNames = new HashMap<String, String>();
        procFieldNames.put("id", "procDef.procDefID");
        procFieldNames.put("name", "procDef.name");
        HashMap<String, String> adminFieldNames = new HashMap<String, String>();
        adminFieldNames.put("longNumber", "\"PROCINST\".FORGLONGNUMBER");
        IRowSet dataRows = this.query(ctx, this.createChildAdminDataSQL(ctx, config, QUERY_GET_ADMIN_AND_PROCDEF, adminFieldNames, "createTime"));
        this.buildBiLatitudeBizData(ctx, config, rowIdx, dataRows, collectFieldNames, procFieldNames);
    }

    public void buildLatitudeDataByAdminProcStep(Context ctx, FormConfigInfo config, int rowIdx) throws EASBizException, BOSException, SQLException, JSONException {
        this.initProcdefNameMap(ctx);
        HashMap<String, String> collectFieldNames = new HashMap<String, String>();
        collectFieldNames.put("id", "id");
        collectFieldNames.put("name", "name");
        HashMap<String, String> procFieldNames = new HashMap<String, String>();
        procFieldNames.put("id", "procDef.procDefID");
        procFieldNames.put("name", "procDef.name");
        HashMap<String, String> stepFieldNames = new HashMap<String, String>();
        stepFieldNames.put("id", "stepDef.actDefID");
        stepFieldNames.put("name", "stepDef.name");
        HashMap<String, String> adminFieldNames = new HashMap<String, String>();
        adminFieldNames.put("longNumber", "\"ACTINST\".FORGLONGNUMBER");
        IRowSet dataRows = this.query(ctx, this.createChildAdminDataSQL(ctx, config, QUERY_GET_ADMIN_PROCDEF_STEPDEF, adminFieldNames, "stepInst.createTime"));
        this.buildTriLatitudeBizData(ctx, config, dataRows, rowIdx, collectFieldNames, procFieldNames, stepFieldNames);
    }

    public void buildLatitudeDataByTypeProc(Context ctx, FormConfigInfo config, int rowIdx) throws SQLException, JSONException, BOSException {
        this.initProcdefNameMap(ctx);
        HashMap<String, String> collectFieldNames = new HashMap<String, String>();
        collectFieldNames.put("id", "number");
        collectFieldNames.put("name", "name");
        HashMap<String, String> procFieldNames = new HashMap<String, String>();
        procFieldNames.put("id", "procDef.procDefID");
        procFieldNames.put("name", "procDef.name");
        EntityViewInfo view = null;
        if (!this.isNeedConfigEntryJoinQuery()) {
            view = this.createCollectIdView("id", config);
        } else {
            view = this.createEmptyView();
            view.getFilter().getFilterItems().add(new FilterItemInfo("config.id", (Object)config.getId().toString(), CompareType.EQUALS));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("procInst.orgLongNumber", (Object)(config.getAdmin().getLongNumber() + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("CU.longNumber", (Object)(config.getAdmin().getCU().getLongNumber() + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("procInst.createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("procInst.createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS_EQUALS));
        view.getFilter().mergeFilter(filter, "and");
        String sql = DataUtil.getSQL(ctx, QUERY_GET_FLOWTYPE_PROCDEF, view);
        if (!this.isNeedConfigEntryJoinQuery()) {
            sql = this.removeCollectItemSQL(sql, CollectTypeEnum.PROCESSTYPE);
        }
        IRowSet dataRows = this.query(ctx, sql);
        this.buildBiLatitudeBizData(ctx, config, rowIdx, dataRows, collectFieldNames, procFieldNames);
    }

    public void buildLatitudeDataByTypeProcStep(Context ctx, FormConfigInfo config, int rowIdx) throws EASBizException, BOSException, SQLException, JSONException {
        HashMap<String, String> collectFieldNames = new HashMap<String, String>();
        collectFieldNames.put("id", "number");
        collectFieldNames.put("name", "name");
        HashMap<String, String> procFieldNames = new HashMap<String, String>();
        procFieldNames.put("id", "procDef.procDefID");
        procFieldNames.put("name", "procDef.name");
        HashMap<String, String> stepFieldNames = new HashMap<String, String>();
        stepFieldNames.put("id", "stepDef.actDefID");
        stepFieldNames.put("name", "stepDef.name");
        EntityViewInfo view = null;
        if (!this.isNeedConfigEntryJoinQuery()) {
            view = this.createCollectIdView("id", config);
        } else {
            view = this.createEmptyView();
            view.getFilter().getFilterItems().add(new FilterItemInfo("config.id", (Object)config.getId().toString(), CompareType.EQUALS));
        }
        String filterText = "(\"_PROCINST_\".FCuLongNumber LIKE '" + config.getAdmin().getCU().getLongNumber() + "%' AND \"USER\".FID='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' AND \"_PROCINST_\".FOrgLongNumber LIKE '" + config.getAdmin().getLongNumber() + "%' AND \"_PROCINST_\".FCREATETIME >= {TS'" + DateUtils.formatDate(config.getStartDate(), null) + "'} AND \"_PROCINST_\".FCREATETIME < {TS'" + DateUtils.formatDate(DateUtils.addOneDay(config.getEndDate()), null) + "'})";
        String sql = this.insertProcInstSubQueryFilter(DataUtil.getSQL(ctx, QUERY_GET_FLOWTYPE_PROCDEF_STEPDEF, view), this.addMoreProcTypeLatitudeFilterText(filterText));
        if (!this.isNeedConfigEntryJoinQuery()) {
            sql = this.removeCollectItemSQL(sql, CollectTypeEnum.PROCESSTYPE);
        }
        IRowSet dataRows = this.query(ctx, sql);
        this.buildTriLatitudeBizData(ctx, config, dataRows, rowIdx, collectFieldNames, procFieldNames, stepFieldNames);
    }

    public void buildLatitudeDataByTemplateProc(Context ctx, FormConfigInfo config, int rowIdx) throws SQLException, JSONException, BOSException {
        this.initProcdefNameMap(ctx);
        HashMap<String, String> collectFieldNames = new HashMap<String, String>();
        collectFieldNames.put("id", "number");
        collectFieldNames.put("name", "name");
        HashMap<String, String> procFieldNames = new HashMap<String, String>();
        procFieldNames.put("id", "procDef.procDefID");
        procFieldNames.put("name", "procDef.name");
        EntityViewInfo view = null;
        if (!this.isNeedConfigEntryJoinQuery()) {
            view = this.createCollectIdView("id", config);
        } else {
            view = this.createEmptyView();
            view.getFilter().getFilterItems().add(new FilterItemInfo("config.id", (Object)config.getId().toString(), CompareType.EQUALS));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("procInst.orgLongNumber", (Object)(config.getAdmin().getLongNumber() + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("CU.longNumber", (Object)(config.getAdmin().getCU().getLongNumber() + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("procInst.createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("procInst.createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS_EQUALS));
        view.getFilter().mergeFilter(filter, "and");
        String sql = DataUtil.getSQL(ctx, QUERY_GET_FLOWTEMPLATE_PROCDEF, view);
        if (!this.isNeedConfigEntryJoinQuery()) {
            sql = this.removeCollectItemSQL(sql, CollectTypeEnum.PROCESSTEMPLATE);
        }
        IRowSet dataRows = this.query(ctx, sql);
        this.buildBiLatitudeBizData(ctx, config, rowIdx, dataRows, collectFieldNames, procFieldNames);
    }

    public void buildLatitudeDataByTemplateProcStep(Context ctx, FormConfigInfo config, int rowIdx) throws EASBizException, BOSException, SQLException, JSONException {
        HashMap<String, String> collectFieldNames = new HashMap<String, String>();
        collectFieldNames.put("id", "number");
        collectFieldNames.put("name", "name");
        HashMap<String, String> procFieldNames = new HashMap<String, String>();
        procFieldNames.put("id", "procDef.procDefID");
        procFieldNames.put("name", "procDef.name");
        HashMap<String, String> stepFieldNames = new HashMap<String, String>();
        stepFieldNames.put("id", "stepDef.actDefID");
        stepFieldNames.put("name", "stepDef.name");
        EntityViewInfo view = null;
        if (!this.isNeedConfigEntryJoinQuery()) {
            view = this.createCollectIdView("id", config);
        } else {
            view = this.createEmptyView();
            view.getFilter().getFilterItems().add(new FilterItemInfo("config.id", (Object)config.getId().toString(), CompareType.EQUALS));
        }
        String filterText = "(\"_PROCINST_\".FCuLongNumber LIKE '" + config.getAdmin().getCU().getLongNumber() + "%' AND \"USER\".FID='" + this.getUserId() + "' AND \"_PROCINST_\".FOrgLongNumber LIKE '" + config.getAdmin().getLongNumber() + "%'  AND \"_PROCINST_\".FCREATETIME >= {TS'" + DateUtils.formatDate(config.getStartDate(), null) + "'} AND \"_PROCINST_\".FCREATETIME < {TS'" + DateUtils.formatDate(DateUtils.addOneDay(config.getEndDate()), null) + "'})";
        String sql = this.insertProcInstSubQueryFilter(DataUtil.getSQL(ctx, QUERY_GET_FLOWTEMPLATE_PROCDEF_STEPDEF, view), this.addMoreProcTemplateLatitudeFilterText(filterText));
        if (!this.isNeedConfigEntryJoinQuery()) {
            sql = this.removeCollectItemSQL(sql, CollectTypeEnum.PROCESSTEMPLATE);
        }
        IRowSet dataRows = this.query(ctx, sql);
        this.buildTriLatitudeBizData(ctx, config, dataRows, rowIdx, collectFieldNames, procFieldNames, stepFieldNames);
    }

    public void buildLatitudeDataByProc(Context ctx, FormConfigInfo config, int rowIdx) throws BOSException, EASBizException, SQLException, JSONException {
        HashMap<String, String> fieldNames = new HashMap<String, String>();
        fieldNames.put("id", "procDefID");
        fieldNames.put("name", "name");
        EntityViewInfo view = null;
        if (!this.isNeedConfigEntryJoinQuery()) {
            view = this.createCollectIdView("procDefID", config);
        } else {
            view = this.createEmptyView();
            view.getFilter().getFilterItems().add(new FilterItemInfo("config.id", (Object)config.getId().toString(), CompareType.EQUALS));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("procInst.orgLongNumber", (Object)(config.getAdmin().getLongNumber() + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("CU.longNumber", (Object)(config.getAdmin().getCU().getLongNumber() + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("procInst.createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("procInst.createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS_EQUALS));
        view.getFilter().mergeFilter(filter, "and");
        String sql = DataUtil.getSQL(ctx, QUERY_GET_PROCDEF, view);
        if (!this.isNeedConfigEntryJoinQuery()) {
            sql = this.removeCollectItemSQL(sql, CollectTypeEnum.PROCESS);
        }
        IRowSet dataRows = this.query(ctx, sql);
        this.buildSingleLatitudeBizData(ctx, config, dataRows, rowIdx, fieldNames);
    }

    public void buildLatitudeDataByProcStep(Context ctx, FormConfigInfo config, int rowIdx) throws BOSException, SQLException, JSONException {
        HashMap<String, String> procFieldNames = new HashMap<String, String>();
        procFieldNames.put("id", "procDefID");
        procFieldNames.put("name", "name");
        HashMap<String, String> stepFieldNames = new HashMap<String, String>();
        stepFieldNames.put("id", "stepDef.actDefID");
        stepFieldNames.put("name", "stepDef.name");
        EntityViewInfo view = null;
        if (!this.isNeedConfigEntryJoinQuery()) {
            view = this.createCollectIdView("procDefID", config);
        } else {
            view = this.createEmptyView();
            view.getFilter().getFilterItems().add(new FilterItemInfo("config.id", (Object)config.getId().toString(), CompareType.EQUALS));
        }
        String filterText = "(\"_PROCINST_\".FCuLongNumber LIKE '" + config.getAdmin().getCU().getLongNumber() + "%' AND \"USER\".FID='" + this.getUserId() + "' AND \"_PROCINST_\".FOrgLongNumber LIKE '" + config.getAdmin().getLongNumber() + "%'  AND \"_PROCINST_\".FCREATETIME >= {TS'" + DateUtils.formatDate(config.getStartDate(), null) + "'} AND \"_PROCINST_\".FCREATETIME < {TS'" + DateUtils.formatDate(DateUtils.addOneDay(config.getEndDate()), null) + "'})";
        String sql = this.insertProcInstSubQueryFilter(DataUtil.getSQL(ctx, QUERY_GET_PROCDEF_STEPDEF, view), this.addMoreProcDefLatitudeFilterText(filterText));
        if (!this.isNeedConfigEntryJoinQuery()) {
            sql = this.removeCollectItemSQL(sql, CollectTypeEnum.PROCESS);
        }
        IRowSet dataRows = this.query(ctx, sql);
        this.buildBiLatitudeBizData(ctx, config, rowIdx, dataRows, procFieldNames, stepFieldNames);
    }

    public void buildBodyData(Context ctx, FormConfigInfo config) throws Exception {
        switch (config.getCollectType().getValue()) {
            case 0: {
                this.buildLatitudeByOrg(ctx, config);
                this.logInfo("rowMap" + this.rowMap == null ? "null" : this.rowMap.toString());
                this.buildBizGridDataByOrg(ctx, config);
                break;
            }
            case 1: {
                this.buildLatitudeByProcType(ctx, config);
                this.logInfo("rowMap" + this.rowMap == null ? "null" : this.rowMap.toString());
                this.buildBizGridDataByProcType(ctx, config);
                break;
            }
            case 2: {
                this.buildLatitudeByProcTemplate(ctx, config);
                this.logInfo("rowMap" + this.rowMap == null ? "null" : this.rowMap.toString());
                this.buildBizGridDataByProcTemplate(ctx, config);
                break;
            }
            case 3: {
                this.buildLatitudeByProc(ctx, config);
                this.logInfo("rowMap" + this.rowMap == null ? "null" : this.rowMap.toString());
                this.buildBizGridDataByProc(ctx, config);
            }
        }
        this.buildCalculCells();
        this.fillUpEmptyGridCell();
    }

    public void buildCalculCells() throws Exception {
    }

    public void buildLatitudeByProc(Context ctx, FormConfigInfo config) throws Exception {
    }

    public void buildBizGridDataByProc(Context ctx, FormConfigInfo config) throws Exception {
    }

    public void buildLatitudeByProcTemplate(Context ctx, FormConfigInfo config) throws Exception {
    }

    public void buildBizGridDataByProcTemplate(Context ctx, FormConfigInfo config) throws Exception {
    }

    public void buildLatitudeByProcType(Context ctx, FormConfigInfo config) throws Exception {
    }

    public void buildBizGridDataByProcType(Context ctx, FormConfigInfo config) throws Exception {
    }

    public void buildLatitudeByOrg(Context ctx, FormConfigInfo config) throws Exception {
    }

    public void buildBizGridDataByOrg(Context ctx, FormConfigInfo config) throws Exception {
    }

    public void buildData(Context ctx, FormConfigInfo config) throws Exception {
        this.beforeBuildData(ctx, config);
        this.initLoggerHeadInfo(config);
        this.workbook = new HSSFWorkbook();
        if (this.styleKit == null) {
            this.styleKit = new ExcelStyleToolKit(this.workbook);
        } else {
            this.styleKit.init(this.workbook);
        }
        this.commonStyle = this.styleKit.getCommonStyle();
        this.sheet = this.workbook.createSheet(config.getName() != null ? config.getName() : "report");
        this.buildHeadData(ctx, config);
        this.buildBodyData(ctx, config);
    }

    protected void beforeBuildData(Context ctx, FormConfigInfo config) {
    }

    public HSSFWorkbook export(Context ctx, FormConfigInfo config) throws Exception {
        return this.export(ctx, config, null);
    }

    public HSSFWorkbook export(Context ctx, FormConfigInfo config, UserInfo user) throws Exception {
        this.reset();
        this.user = user == null ? ContextUtil.getCurrentUserInfo((Context)ctx) : user;
        this.setUserId(this.user.getId().toString());
        this.buildData(ctx, config);
        return this.workbook;
    }

    public int getRowIdx(String rowId) {
        int rowIdx = -1;
        if (rowId != null) {
            rowIdx = (Integer)this.rowMap.get(rowId);
        }
        return rowIdx;
    }

    public int getColumnIdx(String colId) {
        int colIdx = -1;
        if (colId != null) {
            colIdx = (Integer)this.colMap.get(colId);
        }
        return colIdx;
    }

    public void registRowIdx(String rowId, int rowIdx) {
        this.rowMap.put(rowId, new Integer(rowIdx));
        if (rowId != null && rowId.length() > 0 && (rowId.lastIndexOf(LABEL_SUB_POST_ID) != -1 || LABEL_TOTAL_POST_ID.equals(rowId))) {
            this.calculRowIdxSet.add(new Integer(rowIdx));
        }
    }

    public void registColIdx(String colId, int colIdx) {
        this.colMap.put(colId, new Integer(colIdx));
    }

    public HSSFCellStyle getDiffLineCellStyle(int rowIdx) {
        return rowIdx % 2 == 0 ? this.styleKit.get("2") : this.styleKit.get("3");
    }

    public JSONObject createCellData(int rowspan, int colspan, Object value) throws JSONException {
        JSONObject obj = new JSONObject();
        if (rowspan > 1) {
            obj.put(LABEL_ROWSPAN, (Object)new Integer(rowspan));
        }
        if (colspan > 1) {
            obj.put(LABEL_COLSPAN, (Object)new Integer(colspan));
        }
        obj.put(LABEL_VALUE, value == null ? "" : value);
        return obj;
    }

    public JSONObject createCellData(Object value) throws JSONException {
        return this.createCellData(1, 1, value);
    }

    public HSSFCell appendCellData(int rowIdx, int colIdx, JSONObject cellData) throws JSONException {
        return this.appendCellData(rowIdx, colIdx, cellData, 1);
    }

    public HSSFCell appendCellData(int rowIdx, int colIdx, JSONObject cellData, HSSFCellStyle style) throws JSONException {
        return this.appendCellData(rowIdx, colIdx, cellData, 1, style);
    }

    public HSSFCell appendCellData(int rowIdx, int colIdx, JSONObject cellData, int cellType) throws JSONException {
        return this.appendCellData(rowIdx, colIdx, cellData, cellType, null);
    }

    public HSSFCell appendCellData(int rowIdx, int colIdx, JSONObject cellData, int cellType, HSSFCellStyle style) throws JSONException {
        return ExcelExportUtils.appendCell(this.sheet, rowIdx, colIdx, style == null ? this.commonStyle : style, cellType, cellData);
    }

    public void appendSumFormulaRowData(int formualRowIdx, int startSumRowIdx, int endSumRowIdx, HSSFCellStyle style) throws JSONException {
        this.appendSumRowData(this.sheet, style, formualRowIdx, startSumRowIdx, endSumRowIdx, this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1);
    }

    public void appendSumFormulaRowData(int formualRowIdx, int[] sumTargetRowIdxs, HSSFCellStyle style) throws JSONException {
        this.appendSumRowData(this.sheet, style, formualRowIdx, sumTargetRowIdxs, this.dataColStartIdx, this.dataColStartIdx + this.dataColCount - 1);
    }

    public void appendSumFormulaRowData(int formualRowIdx, List sumTargetRowIdxs, HSSFCellStyle style) throws JSONException {
        int[] idxs = null;
        if (sumTargetRowIdxs != null && sumTargetRowIdxs.size() > 0) {
            idxs = new int[sumTargetRowIdxs.size()];
            int len = idxs.length;
            for (int i = 0; i < len; ++i) {
                idxs[i] = (Integer)sumTargetRowIdxs.get(i);
            }
        }
        this.appendSumFormulaRowData(formualRowIdx, idxs, style);
    }

    public void appendRateColData(int formualColIdx, int subDataColIdx, int totalDataColIdx, HSSFCellStyle style) throws JSONException {
        this.appendRateColData(this.sheet, style, formualColIdx, subDataColIdx, totalDataColIdx, this.dataRowStartIdx, this.dataRowStartIdx + this.dataRowCount - 1);
    }

    public void appendIncreasingRateColData(int formualColIdx, int lastDataColIdx, int currentDataColIdx, HSSFCellStyle style) throws JSONException {
        this.appendIncreasingRateColData(this.sheet, style, formualColIdx, lastDataColIdx, currentDataColIdx, this.dataRowStartIdx, this.dataRowStartIdx + this.dataRowCount - 1);
    }

    public void appendSumFormulaColData(int formualColIdx, List sumTargetColIdxs, HSSFCellStyle style) throws JSONException {
        int[] idxs = new int[sumTargetColIdxs.size()];
        int len = idxs.length;
        for (int i = 0; i < len; ++i) {
            idxs[i] = (Integer)sumTargetColIdxs.get(i);
        }
        this.appendSumFormulaColData(formualColIdx, idxs, style);
    }

    public void appendSumFormulaColData(int formualColIdx, int[] sumTargetColIdxs, HSSFCellStyle style) throws JSONException {
        this.appendSumColData(this.sheet, style, formualColIdx, sumTargetColIdxs, this.dataRowStartIdx, this.dataRowStartIdx + this.dataRowCount - 1);
    }

    public JSONObject appendBizCellData(String rowId, String colId, Object cellValue, HSSFCellStyle style) throws JSONException {
        JSONObject bizData = null;
        if (this.colMap.containsKey(colId) && this.rowMap.containsKey(rowId)) {
            String textValue = "";
            if (cellValue != null && cellValue.toString() != null) {
                textValue = cellValue.toString();
            }
            bizData = this.createCellData(textValue);
            this.appendCellData((Integer)this.rowMap.get(rowId), (Integer)this.colMap.get(colId), bizData, NumericUtils.isDigital(textValue) ? 0 : 1, style == null ? this.getDiffLineCellStyle(this.getRowIdx(rowId)) : style);
        }
        return bizData;
    }

    public void appendBizCellData(IRowSet dataRows, Map params, HSSFCellStyle style) throws SQLException, JSONException {
        if (dataRows != null) {
            while (dataRows.next()) {
                String colId = null;
                String[] colIdFieldNames = (String[])params.get(LABEL_COLIDS);
                if (colIdFieldNames != null && colIdFieldNames.length > 0) {
                    String formatStr = (String)params.get(LABEL_FORMAT_COL_ID);
                    Object[] colIds = new String[colIdFieldNames.length];
                    int len = colIdFieldNames.length;
                    for (int i = 0; i < len; ++i) {
                        colIds[i] = dataRows.getString(colIdFieldNames[i]);
                        if (colIds[i] != null) continue;
                        return;
                    }
                    colId = MessageFormat.format(formatStr, colIds);
                }
                String rowId = null;
                String[] rowIdFieldNames = (String[])params.get(LABEL_ROWIDS);
                if (rowIdFieldNames != null && rowIdFieldNames.length > 0) {
                    String formatStr = (String)params.get(LABEL_FORMAT_ROW_ID);
                    Object[] rowIds = new String[rowIdFieldNames.length];
                    int len = rowIdFieldNames.length;
                    for (int i = 0; i < len; ++i) {
                        rowIds[i] = dataRows.getString(rowIdFieldNames[i]);
                        if (rowIds[i] != null) continue;
                        return;
                    }
                    rowId = MessageFormat.format(formatStr, rowIds);
                }
                Object value = dataRows.getObject((String)params.get(LABEL_VALUE));
                this.appendBizCellData(rowId, colId, value, style);
            }
        }
    }

    public void appendSumRowData(HSSFSheet sheet, HSSFCellStyle style, int formualRowIdx, int startSumRowIdx, int endSumRowIdx, int startColIdx, int endColIdx) throws JSONException {
        HSSFCell cell = null;
        JSONObject itemProp = null;
        String formula = null;
        String colIdxName = null;
        if (style == null) {
            style = this.styleKit.getCommonCalculateStyle();
        }
        if (sheet.getRow(formualRowIdx) != null) {
            for (int colStep = startColIdx; colStep <= endColIdx; ++colStep) {
                cell = sheet.getRow(formualRowIdx).getCell(colStep);
                itemProp = new JSONObject();
                colIdxName = ExcelExportUtils.convertColIdx(colStep);
                formula = "SUM(" + colIdxName + (startSumRowIdx + 1) + ":" + colIdxName + (endSumRowIdx + 1) + ")";
                itemProp.put(LABEL_VALUE, (Object)formula);
                if (cell != null) continue;
                ExcelExportUtils.appendCell(sheet, formualRowIdx, colStep, style, 2, itemProp);
            }
        }
    }

    public void appendSumRowData(HSSFSheet sheet, HSSFCellStyle style, int formualRowIdx, int[] sumTargetRowIdxs, int startColIdx, int endColIdx) throws JSONException {
        HSSFCell cell = null;
        JSONObject itemProp = null;
        String formula = "";
        String subFormulaFormat = "if({0}=\"\",0,{0})";
        String colIdxName = null;
        if (style == null) {
            style = this.styleKit.getCommonCalculateStyle();
        }
        if (sheet.getRow(formualRowIdx) != null) {
            for (int colStep = startColIdx; colStep <= endColIdx; ++colStep) {
                cell = sheet.getRow(formualRowIdx).getCell(colStep);
                itemProp = new JSONObject();
                colIdxName = ExcelExportUtils.convertColIdx(colStep);
                formula = "";
                if (sumTargetRowIdxs != null && sumTargetRowIdxs.length > 0) {
                    int len = sumTargetRowIdxs.length;
                    for (int i = 0; i < len; ++i) {
                        formula = formula + (i == 0 ? "" : "+") + MessageFormat.format("if({0}=\"\",0,{0})", colIdxName + (sumTargetRowIdxs[i] + 1));
                    }
                } else {
                    formula = "0";
                }
                itemProp.put(LABEL_VALUE, (Object)formula);
                if (cell != null) continue;
                ExcelExportUtils.appendCell(sheet, formualRowIdx, colStep, style, 2, itemProp);
            }
        }
    }

    public void appendSumColData(HSSFSheet sheet, HSSFCellStyle style, int formualColIdx, int[] sumTargetColIdxs, int startRowIdx, int endRowIdx) throws JSONException {
        JSONObject itemProp = null;
        String[] colIdxName = new String[sumTargetColIdxs.length];
        int len = sumTargetColIdxs.length;
        for (int i = 0; i < len; ++i) {
            colIdxName[i] = ExcelExportUtils.convertColIdx(sumTargetColIdxs[i]);
        }
        String formula = "";
        String subFormulaFormat = "if({0}=\"\",0,{0})";
        for (int rowStep = startRowIdx; rowStep <= endRowIdx; ++rowStep) {
            if (sheet.getRow(rowStep) == null) continue;
            itemProp = new JSONObject();
            formula = "";
            int len2 = colIdxName.length;
            for (int i = 0; i < len2; ++i) {
                formula = formula + (i == 0 ? "" : "+") + MessageFormat.format("if({0}=\"\",0,{0})", colIdxName[i] + (rowStep + 1));
            }
            itemProp.put(LABEL_VALUE, (Object)formula);
            ExcelExportUtils.appendCell(sheet, rowStep, formualColIdx, style == null ? (this.calculRowIdxSet.contains(new Integer(rowStep)) ? this.styleKit.getCommonCalculateStyle() : this.styleKit.getCommonDifferStyle(rowStep)) : style, 2, itemProp);
        }
    }

    public void appendRateColData(HSSFSheet sheet, HSSFCellStyle style, int formualColIdx, int subDataColIdx, int totalDataColIdx, int startRowIdx, int endRowIdx) throws JSONException {
        JSONObject itemProp = null;
        String formateStr = "if(or({1}=0,{1}=\"\",{0}=0,{0}=\"\"),0,{0}/{1})";
        String subDataColIdxName = ExcelExportUtils.convertColIdx(subDataColIdx);
        String totalDataColIdxName = ExcelExportUtils.convertColIdx(totalDataColIdx);
        String formula = null;
        for (int rowStep = startRowIdx; rowStep <= endRowIdx; ++rowStep) {
            if (sheet.getRow(rowStep) == null) continue;
            itemProp = new JSONObject();
            formula = MessageFormat.format(formateStr, subDataColIdxName + (rowStep + 1), totalDataColIdxName + (rowStep + 1));
            itemProp.put(LABEL_VALUE, (Object)formula);
            ExcelExportUtils.appendCell(sheet, rowStep, formualColIdx, style == null ? (this.calculRowIdxSet.contains(new Integer(rowStep)) ? this.styleKit.get("14") : this.styleKit.getDifferLineRatingStyle(rowStep)) : style, 2, itemProp);
        }
    }

    public void appendIncreasingRateColData(HSSFSheet sheet, HSSFCellStyle style, int formualColIdx, int lastDataColIdx, int currentDataColIdx, int startRowIdx, int endRowIdx) throws JSONException {
        JSONObject itemProp = null;
        String formateStr = "if(or({1}=0,{1}=\"\"),0,if(or({0}=0,{0}=\"\"),1,({1}-{0})/{0}))";
        String lastDataColIdxName = ExcelExportUtils.convertColIdx(lastDataColIdx);
        String currentDataColIdxName = ExcelExportUtils.convertColIdx(currentDataColIdx);
        String formula = null;
        for (int rowStep = startRowIdx; rowStep <= endRowIdx; ++rowStep) {
            if (sheet.getRow(rowStep) == null) continue;
            itemProp = new JSONObject();
            formula = MessageFormat.format(formateStr, lastDataColIdxName + (rowStep + 1), currentDataColIdxName + (rowStep + 1));
            itemProp.put(LABEL_VALUE, (Object)formula);
            ExcelExportUtils.appendCell(sheet, rowStep, formualColIdx, style == null ? (this.calculRowIdxSet.contains(new Integer(rowStep)) ? this.styleKit.get("14") : this.styleKit.getDifferLineRatingStyle(rowStep)) : style, 2, itemProp);
        }
    }

    protected String addMoreProcTypeLatitudeFilterText(String filterText) {
        return filterText;
    }

    protected String addMoreProcTemplateLatitudeFilterText(String filterText) {
        return filterText;
    }

    protected String addMoreProcDefLatitudeFilterText(String filterText) {
        return filterText;
    }
}

