/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfs.CollectTypeEnum;
import com.kingdee.eas.cp.wfs.FormConfigFactory;
import com.kingdee.eas.cp.wfs.FormConfigInfo;
import com.kingdee.eas.cp.wfs.FormTypeEnum;
import com.kingdee.eas.cp.wfs.IFormConfig;
import com.kingdee.eas.cp.wfs.utils.AbstractExcelReportBiz;
import com.kingdee.eas.cp.wfs.utils.ExcelExportGeneralViewReportBiz;
import com.kingdee.eas.cp.wfs.utils.ExcelExportPostponeReportBiz;
import com.kingdee.eas.cp.wfs.utils.ExcelExportProcInstCostTimeReportBiz;
import com.kingdee.eas.cp.wfs.utils.ExcelExportProcInstReportBiz;
import com.kingdee.eas.cp.wfs.utils.ExcelExportStepInstCostTimeReportBiz;
import com.kingdee.eas.cp.wfs.utils.ExcelExportStepInstReportBiz;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelExportHandler {
    public static final String LABEL_LATITUDE = "latitude";
    public static final String LABEL_BIZ_DATA = "bizData";
    private AbstractExcelReportBiz biz;
    private FormConfigInfo config;
    private Context ctx;

    public ExcelExportHandler(Context ctx, AbstractExcelReportBiz biz, FormConfigInfo config) {
        this.biz = biz;
        this.config = config;
        this.ctx = ctx;
    }

    public ExcelExportHandler(Context ctx, String configId) throws EASBizException, BOSException {
        this(ctx, ExcelExportHandler.getConfig(ctx, configId));
    }

    public ExcelExportHandler(Context ctx, FormConfigInfo config) {
        this.ctx = ctx;
        this.config = config;
        switch (config.getFormType().getValue()) {
            case 0: {
                this.biz = new ExcelExportGeneralViewReportBiz();
                break;
            }
            case 1: {
                this.biz = new ExcelExportProcInstReportBiz();
                break;
            }
            case 2: {
                this.biz = new ExcelExportStepInstReportBiz();
                break;
            }
            case 3: {
                this.biz = new ExcelExportPostponeReportBiz();
                break;
            }
            case 4: {
                this.biz = new ExcelExportProcInstCostTimeReportBiz();
                break;
            }
            case 5: {
                this.biz = new ExcelExportStepInstCostTimeReportBiz();
                break;
            }
            default: {
                this.biz = null;
            }
        }
        if (this.biz != null) {
            if (CollectTypeEnum.PROCESS.equals((Object)config.getCollectType()) || FormTypeEnum.NODE.equals((Object)config.getFormType()) || FormTypeEnum.NODE_SPARETIME.equals((Object)config.getFormType()) || FormTypeEnum.DEFER.equals((Object)config.getFormType())) {
                this.biz.setIsNeedConfigEntryJoinQuery(false);
            } else {
                this.biz.setIsNeedConfigEntryJoinQuery(true);
            }
        }
    }

    public static FormConfigInfo getConfig(Context ctx, String id) throws BOSException, EASBizException {
        IFormConfig ifc = FormConfigFactory.getLocalInstance(ctx);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("formType"));
        selectors.add(new SelectorItemInfo("statPeriod"));
        selectors.add(new SelectorItemInfo("startDate"));
        selectors.add(new SelectorItemInfo("endDate"));
        selectors.add(new SelectorItemInfo("collectType"));
        selectors.add(new SelectorItemInfo("collectItems"));
        selectors.add(new SelectorItemInfo("admin.id"));
        selectors.add(new SelectorItemInfo("admin.name"));
        selectors.add(new SelectorItemInfo("admin.number"));
        selectors.add(new SelectorItemInfo("admin.level"));
        selectors.add(new SelectorItemInfo("admin.longNumber"));
        selectors.add(new SelectorItemInfo("admin.cu"));
        selectors.add(new SelectorItemInfo("admin.cu.longNumber"));
        selectors.add(new SelectorItemInfo("person.id"));
        selectors.add(new SelectorItemInfo("person.name"));
        selectors.add(new SelectorItemInfo("person.number"));
        selectors.add(new SelectorItemInfo("entry.id"));
        selectors.add(new SelectorItemInfo("entry.collectItemId"));
        return ifc.getFormConfigInfo((IObjectPK)new ObjectUuidPK(id), selectors);
    }

    public HSSFWorkbook getReportDatas(UserInfo user) throws Exception {
        return this.biz.export(this.ctx, this.config, user);
    }

    public HSSFWorkbook getReportDatas(String userId) throws Exception {
        UserInfo user = null;
        if (userId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            user = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId), sic);
        }
        return this.biz.export(this.ctx, this.config, user);
    }
}

