/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfs.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfs.CollectTypeEnum;
import com.kingdee.eas.cp.wfs.FormConfigInfo;
import com.kingdee.eas.cp.wfs.ResourceUtils;
import com.kingdee.eas.cp.wfs.utils.AbstractExcelReportBiz;
import com.kingdee.eas.cp.wfs.utils.DataUtil;
import com.kingdee.eas.cp.wfs.utils.DateUtils;
import com.kingdee.eas.cp.wfs.utils.NumericUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.json.JSONException;

public class ExcelExportProcInstCostTimeReportBiz
extends AbstractExcelReportBiz {
    private String COMMON_FILTER = "\"PROCINST\".FSTATE = 'finished'";
    public static final String QUREY_REPORT_DATA_AVG_BY_PERIOD = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstCostTimeAVGByPeriodQuery";
    public static final String QUERY_REPORT_DATA_BY_ORG = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstCostTimeByAdminQuery";
    public static final String QUREY_REPORT_DATA_AVG_BY_ORG = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstCostTimeAVGByAdminPeriodQuery";
    public static final String QUERY_REPORT_DATA_BY_FLOWTYPE = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstCostTimeByProcTypeQuery";
    public static final String QUREY_REPORT_DATA_AVG_BY_FLOWTYPE = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstCostTimeAVGByProcTypePeriodQuery";
    public static final String QUERY_REPORT_DATA_BY_FLOWTEMPLATE = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstCostTimeByProcTemplateQuery";
    public static final String QUREY_REPORT_DATA_AVG_BY_FLOWTEMPLATE = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstCostTimeAVGByProcTemplatePeriodQuery";
    public static final String QUERY_REPORT_DATA_BY_PROCDEF = "com.kingdee.eas.cp.wfs.app.GetReportDataProcInstCostTimeByProcDefQuery";
    private static final String[] ITEM_LABEL = new String[]{ResourceUtils.getString("CURRENT_PERIOD"), ResourceUtils.getString("INCREASE_PERCENT"), ResourceUtils.getString("MAX_VALUE"), ResourceUtils.getString("MIN_VALUE"), ResourceUtils.getString("STDEV_VALUE")};
    private static final String[] STATE_VALUE = new String[]{"avg", "ip", "max", "min", "stdev"};
    private String[] LATITUDE_HEADER_ITEM = new String[]{"", ResourceUtils.getString("FLOW_NAME")};
    private Map headCalculMap = new HashMap();
    private boolean isIncludAllVersionProc = true;
    private String stdevFunctionName = null;
    private boolean isNeedDialectPrefix = false;

    private void initNativeStdevFunctionConfig(Context ctx) {
        this.stdevFunctionName = DataUtil.getStdevNativeFunctionName(ctx);
        this.logInfo("\u5f53\u524d\u6570\u636e\u5e93\u4ee3\u53f7\uff1a" + DataUtil.getDbType(ctx));
        if (DataUtil.getDbType(ctx) == 0) {
            this.isNeedDialectPrefix = true;
        }
    }

    protected void beforeBuildData(Context ctx, FormConfigInfo config) {
        super.beforeBuildData(ctx, config);
        this.initNativeStdevFunctionConfig(ctx);
        if (this.COMMON_FILTER == null) {
            this.COMMON_FILTER = "";
        }
        this.COMMON_FILTER = this.COMMON_FILTER + (!"".equals(this.COMMON_FILTER) ? " AND " : "") + "\"USER\".FID" + "='" + this.getUserId() + "' AND (\"CU\".FID = '" + config.getAdmin().getCU().getId().toString() + "' OR " + "\"CU\".FLONGNUMBER like '" + config.getAdmin().getCU().getLongNumber() + "%')";
    }

    private EntityViewInfo createCommonView(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, UuidException, SQLException {
        EntityViewInfo view = this.createEmptyView();
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS));
        view.getFilter().getFilterItems().add(this.getAdminOrgAndUserRangeFilterItem(ctx, "user.id"));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgLongNumber", (Object)(config.getAdmin().getLongNumber() + (CollectTypeEnum.ADMIN.equals((Object)config.getCollectType()) ? "!%" : "%")), CompareType.LIKE));
        if (CollectTypeEnum.PROCESSTYPE.equals((Object)config.getCollectType()) || CollectTypeEnum.PROCESSTEMPLATE.equals((Object)config.getCollectType())) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("config.id", (Object)config.getId().toString(), CompareType.EQUALS));
        } else if (CollectTypeEnum.PROCESS.equals((Object)config.getCollectType())) {
            view.getFilter().mergeFilter(this.createCollectIdView("procDef.procDefId", config).getFilter(), "and");
        }
        return view;
    }

    private void buildBatchDataCellItems(IRowSet dataRows, String yId, String periodId, HSSFCellStyle style) throws JSONException, SQLException {
        int countInst = 0;
        double stdev = 0.0;
        double avgCostTime = 0.0;
        double maxCostTime = 0.0;
        double minCostTime = 0.0;
        countInst = dataRows.getInt("COUNTINST");
        stdev = dataRows.getDouble("STDEV");
        avgCostTime = DateUtils.calculateWorkTime(NumericUtils.divide(dataRows.getDouble("SUMCOSTTIME"), countInst, 4) + "", 4).doubleValue();
        maxCostTime = DateUtils.calculateWorkTime(dataRows.getDouble("MAXCOSTTIME") + "").doubleValue();
        minCostTime = DateUtils.calculateWorkTime(dataRows.getDouble("MINCOSTTIME") + "").doubleValue();
        this.appendBizCellData(yId, periodId + "_stdev", NumericUtils.formatNumberText(stdev), style);
        this.appendBizCellData(yId, periodId + "_avg", NumericUtils.formatNumberText(avgCostTime), style);
        this.appendBizCellData(yId, periodId + "_max", NumericUtils.formatNumberText(maxCostTime), style);
        this.appendBizCellData(yId, periodId + "_min", NumericUtils.formatNumberText(minCostTime), style);
    }

    private void buildCommonDataCell(Context ctx, FormConfigInfo config, String[] latitudeDataIds, String sql) throws SQLException, BOSException, JSONException {
        boolean isBiLatitude = latitudeDataIds.length == 2;
        IRowSet dataRows = this.query(ctx, sql);
        String yId = null;
        String periodId = null;
        String collectId = null;
        String procDefId = null;
        while (dataRows.next()) {
            periodId = dataRows.getString("PERIOD");
            if (isBiLatitude) {
                collectId = dataRows.getString(latitudeDataIds[0]);
                procDefId = dataRows.getString(latitudeDataIds[1]);
            } else {
                procDefId = dataRows.getString(latitudeDataIds[0]);
            }
            if (periodId == null || !(isBiLatitude ? collectId != null && procDefId != null : procDefId != null)) continue;
            yId = (isBiLatitude ? collectId + "_" : "") + procDefId;
            this.buildBatchDataCellItems(dataRows, yId, periodId, this.styleKit.getDifferLineDecimalStyle(this.getRowIdx(yId)));
        }
    }

    private void buildCalculDataCell(Context ctx, FormConfigInfo config, String collectIdFieldName, String postStr, String sql) throws SQLException, BOSException, JSONException {
        IRowSet dataRows = this.query(ctx, sql);
        String yId = null;
        String periodId = null;
        String collectId = null;
        while (dataRows.next()) {
            periodId = dataRows.getString("PERIOD");
            collectId = collectIdFieldName != null ? dataRows.getString(collectIdFieldName) : "";
            if (periodId == null || collectId == null) continue;
            yId = (!"".equals(collectId) ? collectId + "_" : "") + postStr;
            this.buildBatchDataCellItems(dataRows, yId, periodId, this.styleKit.get("11"));
        }
    }

    public void buildHeadData(Context ctx, FormConfigInfo config) throws Exception {
        HSSFCellStyle style = this.styleKit.getCommonHeadStyle();
        switch (config.getCollectType().getValue()) {
            case 0: {
                this.LATITUDE_HEADER_ITEM[0] = ResourceUtils.getString("ADMIN_NAME");
                break;
            }
            case 1: {
                this.LATITUDE_HEADER_ITEM[0] = ResourceUtils.getString("FLOW_TYPE");
                break;
            }
            case 2: {
                this.LATITUDE_HEADER_ITEM[0] = ResourceUtils.getString("FLOW_TEMPLATE");
                break;
            }
            case 3: {
                this.LATITUDE_HEADER_ITEM = new String[]{ResourceUtils.getString("FLOW_NAME")};
            }
        }
        int len = this.LATITUDE_HEADER_ITEM.length;
        for (int i = 0; i < len; ++i) {
            this.appendCellData(0, i, this.createCellData(3, 1, this.LATITUDE_HEADER_ITEM[i]), style);
        }
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        if (periodDatas != null) {
            int idx = 0;
            int size = periodDatas.size();
            for (int i = 0; i < size; ++i) {
                this.appendCellData(0, i * STATE_VALUE.length + this.LATITUDE_HEADER_ITEM.length, this.createCellData(1, STATE_VALUE.length, DateUtils.getPeriodText((Map)periodDatas.get(i), null)), style);
                this.appendCellData(1, i * STATE_VALUE.length + this.LATITUDE_HEADER_ITEM.length, this.createCellData(1, STATE_VALUE.length, ResourceUtils.getString("PROC_AVERAGE_COST_TIME")), style);
                int len2 = STATE_VALUE.length;
                for (int j = 0; j < len2; ++j) {
                    this.appendCellData(2, this.LATITUDE_HEADER_ITEM.length + i * STATE_VALUE.length + j, this.createCellData(ITEM_LABEL[j]), style);
                    idx = i * STATE_VALUE.length + j + this.LATITUDE_HEADER_ITEM.length;
                    this.registColIdx("dateGroup" + i + "_" + STATE_VALUE[j], idx);
                    if (!STATE_VALUE[j].equals("ip")) continue;
                    if (i == 0) {
                        this.headCalculMap.put(new Integer(idx - 1), new Integer(idx - 1));
                        continue;
                    }
                    this.headCalculMap.put(new Integer(idx - 1), new Integer(idx - STATE_VALUE.length - 1));
                }
            }
        }
        this.setDataColCount(periodDatas.size() * STATE_VALUE.length);
    }

    private String createRptSQLByPeriod(Context ctx, FormConfigInfo config) throws BOSException, EASBizException, UuidException, SQLException {
        boolean isFilteringByEntry;
        EntityViewInfo view = this.createCommonView(ctx, config);
        boolean bl = isFilteringByEntry = CollectTypeEnum.PROCESSTYPE.equals((Object)config.getCollectType()) || CollectTypeEnum.PROCESSTEMPLATE.equals((Object)config.getCollectType());
        if (isFilteringByEntry) {
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)config.getStartDate(), CompareType.GREATER_EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("createTime", (Object)DateUtils.addOneDay(config.getEndDate()), CompareType.LESS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("orgLongNumber", (Object)(config.getAdmin().getLongNumber() + (CollectTypeEnum.ADMIN.equals((Object)config.getCollectType()) ? "!%" : "%")), CompareType.LIKE));
        }
        StringBuffer sql = new StringBuffer(DataUtil.getSQL(ctx, QUREY_REPORT_DATA_AVG_BY_PERIOD, view));
        if (this.isIncludAllVersionProc) {
            sql = this.removeNewestVersionProcJoinQuery(sql);
        }
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".FCreateTime"));
        String _sql = this.insertFilter(sql.toString().replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", stateSQL.toString()), this.COMMON_FILTER);
        if (isFilteringByEntry) {
            String insertPlace = "FROM T_WFS_ProcInst AS \"PROCINST\"";
            String insertJoinQuery = null;
            if (CollectTypeEnum.PROCESSTYPE.equals((Object)config.getCollectType())) {
                insertJoinQuery = "\nINNER JOIN T_WFS_ProcDef AS \"PROCDEF\" \nON \"PROCINST\".FProcDefId = \"PROCDEF\".FProcDefId \n\nINNER JOIN T_WFS_FlowType AS \"TYPE\" \nON \"PROCDEF\".FFlowType = \"TYPE\".FID \n\nINNER JOIN T_WFS_FormConfigEntry AS \"ENTRY\" \nON \"TYPE\".FID = \"ENTRY\".FCollectItemId\n\nINNER JOIN T_WFS_FormConfig AS \"CONFIG\" \nON \"ENTRY\".FBillID = \"CONFIG\".FID\n";
            } else if (CollectTypeEnum.PROCESSTEMPLATE.equals((Object)config.getCollectType())) {
                insertJoinQuery = "\nINNER JOIN T_WFS_ProcDef AS \"PROCDEF\" \nON \"PROCINST\".FProcDefId = \"PROCDEF\".FProcDefId \n\nINNER JOIN T_WFS_FlowTemplate AS \"TEMPLATE\" \nON \"PROCDEF\".FFlowTemplate = \"TEMPLATE\".FID \n\nINNER JOIN T_WFS_FormConfigEntry AS \"ENTRY\" \nON \"TEMPLATE\".FID = \"ENTRY\".FCollectItemId\n\nINNER JOIN T_WFS_FormConfig AS \"CONFIG\" \nON \"ENTRY\".FBillID = \"CONFIG\".FID\n";
            }
            _sql = this.insertStr(_sql, insertPlace, "\n\n" + insertJoinQuery, false);
            _sql = this.insertFilter(_sql, "\"CONFIG\".FID='" + config.getId().toString() + "'");
        }
        _sql = this.insertStdevFunction(_sql);
        return _sql;
    }

    private String insertStdevFunction(String sql) {
        String insertPlace = "Max(\"PROCINST\".FCostWorkTime) AS \"MAXCOSTTIME\"";
        String insertText = "," + this.stdevFunctionName + "(\"PROCINST\".FCostWorkTime/" + DateUtils.baseTime.toString() + ") AS \"STDEV\"";
        return (this.isNeedDialectPrefix ? "/*dialect*/" : "") + this.insertStr(sql, insertPlace, insertText, false);
    }

    public void buildLatitudeByOrg(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, SQLException, JSONException {
        this.buildLatitudeDataByAdminProc(ctx, config, 3);
    }

    private String createRptSQLByOrg(Context ctx, FormConfigInfo config, String queryName) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config);
        StringBuffer sql = new StringBuffer(DataUtil.getSQL(ctx, queryName, view));
        if (this.isIncludAllVersionProc) {
            sql = this.removeNewestVersionProcJoinQuery(sql);
        }
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE1 AS \"REPLACESTATEMENT1\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".FCreateTime"));
        StringBuffer adminSQL = new StringBuffer();
        String adminReplace = "(?u)NULLVALUE2 AS \"REPLACESTATEMENT2\"";
        List adminList = this.getChildAdmin(ctx, config);
        if (adminList.size() == 0) {
            adminList.add(config.getAdmin());
        }
        adminSQL.append(" \n(CASE \n");
        AdminOrgUnitInfo admin = null;
        int size = adminList.size();
        for (int i = 0; i < size; ++i) {
            admin = (AdminOrgUnitInfo)adminList.get(i);
            adminSQL.append("WHEN \"PROCINST\".FORGLONGNUMBER LIKE '" + admin.getLongNumber() + "%' THEN '" + admin.getId().toString() + "' \n");
        }
        adminSQL.append("end )");
        String _sql = this.insertFilter(sql.toString().replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE1", stateSQL.toString()).replaceAll(adminReplace, adminSQL.toString() + "as \"ADMINORG.ID\" \n").replaceAll("(?u)NULLVALUE2", adminSQL.toString()), this.COMMON_FILTER);
        return this.insertStdevFunction(_sql);
    }

    public void buildBizGridDataByOrg(Context ctx, FormConfigInfo config) throws Exception {
        this.buildCommonDataCell(ctx, config, new String[]{"ADMINORG.ID", "PROCDEF.PROCDEFID"}, this.createRptSQLByOrg(ctx, config, QUERY_REPORT_DATA_BY_ORG));
        this.buildCalculDataCell(ctx, config, "ADMINORG.ID", "sub", this.createRptSQLByOrg(ctx, config, QUREY_REPORT_DATA_AVG_BY_ORG));
        this.buildCalculDataCell(ctx, config, null, "total", this.createRptSQLByPeriod(ctx, config));
    }

    public void buildLatitudeByProcType(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, SQLException, JSONException {
        this.buildLatitudeDataByTypeProc(ctx, config, 3);
    }

    private String createRptSQLByProcType(Context ctx, FormConfigInfo config, String queryName) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config);
        StringBuffer sql = new StringBuffer(DataUtil.getSQL(ctx, queryName, view));
        if (this.isIncludAllVersionProc) {
            sql = this.removeNewestVersionProcJoinQuery(sql);
        }
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".FCreateTime"));
        String _sql = sql.toString();
        _sql = this.insertFilter(_sql.replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", stateSQL.toString()), this.COMMON_FILTER);
        return this.insertStdevFunction(_sql);
    }

    public void buildBizGridDataByProcType(Context ctx, FormConfigInfo config) throws Exception {
        this.buildCommonDataCell(ctx, config, new String[]{"TYPE.NUMBER", "PROCDEF.PROCDEFID"}, this.createRptSQLByProcType(ctx, config, QUERY_REPORT_DATA_BY_FLOWTYPE));
        this.buildCalculDataCell(ctx, config, "TYPE.NUMBER", "sub", this.createRptSQLByProcType(ctx, config, QUREY_REPORT_DATA_AVG_BY_FLOWTYPE));
        this.buildCalculDataCell(ctx, config, null, "total", this.createRptSQLByPeriod(ctx, config));
    }

    public void buildLatitudeByProcTemplate(Context ctx, FormConfigInfo config) throws EASBizException, BOSException, SQLException, JSONException {
        this.buildLatitudeDataByTemplateProc(ctx, config, 3);
    }

    private String createRptSQLByProcTemplate(Context ctx, FormConfigInfo config, String queryName) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config);
        StringBuffer sql = new StringBuffer(DataUtil.getSQL(ctx, queryName, view));
        if (this.isIncludAllVersionProc) {
            sql = this.removeNewestVersionProcJoinQuery(sql);
        }
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".FCreateTime"));
        String _sql = sql.toString();
        _sql = this.insertFilter(_sql.replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", stateSQL.toString()), this.COMMON_FILTER);
        return this.insertStdevFunction(_sql);
    }

    public void buildBizGridDataByProcTemplate(Context ctx, FormConfigInfo config) throws Exception {
        this.buildCommonDataCell(ctx, config, new String[]{"TEMPLATE.NUMBER", "PROCDEF.PROCDEFID"}, this.createRptSQLByProcTemplate(ctx, config, QUERY_REPORT_DATA_BY_FLOWTEMPLATE));
        this.buildCalculDataCell(ctx, config, "TEMPLATE.NUMBER", "sub", this.createRptSQLByProcTemplate(ctx, config, QUREY_REPORT_DATA_AVG_BY_FLOWTEMPLATE));
        this.buildCalculDataCell(ctx, config, null, "total", this.createRptSQLByPeriod(ctx, config));
    }

    public void buildLatitudeByProc(Context ctx, FormConfigInfo config) throws BOSException, SQLException, JSONException, EASBizException {
        this.buildLatitudeDataByProc(ctx, config, 3);
    }

    private String createRptSQLByProcDef(Context ctx, FormConfigInfo config, String queryName) throws BOSException, EASBizException, UuidException, SQLException {
        EntityViewInfo view = this.createCommonView(ctx, config);
        StringBuffer sql = new StringBuffer(DataUtil.getSQL(ctx, queryName, view));
        if (this.isIncludAllVersionProc) {
            sql = this.removeNewestVersionProcJoinQuery(sql);
        }
        StringBuffer stateSQL = new StringBuffer();
        String stateReplace = "(?u)NULLVALUE AS \"REPLACESTATEMENT\"";
        List periodDatas = DateUtils.getPeriod(config.getStartDate(), config.getEndDate(), config.getStatPeriod());
        stateSQL.append(this.createDateCASESQL(periodDatas, "\"PROCINST\".FCreateTime"));
        String _sql = this.removeCollectItemSQL(sql.toString(), CollectTypeEnum.PROCESS);
        _sql = this.insertFilter(_sql.replaceAll(stateReplace, stateSQL.toString() + " as \"PERIOD\" \n").replaceAll("(?u)NULLVALUE", stateSQL.toString()), this.COMMON_FILTER);
        return this.insertStdevFunction(_sql);
    }

    public void buildBizGridDataByProc(Context ctx, FormConfigInfo config) throws Exception {
        this.buildCommonDataCell(ctx, config, new String[]{"PROCDEF.PROCDEFID"}, this.createRptSQLByProcDef(ctx, config, QUERY_REPORT_DATA_BY_PROCDEF));
        this.buildCalculDataCell(ctx, config, null, "total", this.createRptSQLByPeriod(ctx, config));
    }

    public void buildCalculCells() throws Exception {
        Set keySet = this.headCalculMap.keySet();
        Iterator it = keySet.iterator();
        int currentDataIdx = 0;
        while (it.hasNext()) {
            currentDataIdx = (Integer)it.next();
            this.appendIncreasingRateColData(currentDataIdx + 1, (Integer)this.headCalculMap.get(new Integer(currentDataIdx)), currentDataIdx, null);
        }
    }
}

