/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bi.application.model.formula.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.eas.formula.IEASFormulaCalculate;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.bi.application.model.formula.DateContextHandler;
import com.kingdee.eas.bi.application.model.formula.KPITimeTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.DefaultContextHandler;
import com.kingdee.eas.fi.rpt.IContextHandler;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BiFormulaAppManager
implements IEASFormulaCalculate {
    private static Logger logger = Logger.getLogger(BiFormulaAppManager.class);
    private static final String PERMISSION = "\u6743\u9650";
    private static final String KPI_FORMULA_NO_PERMISSION_ERROR = "KPI\u516c\u5f0f\u65e0\u6743\u9650,\u516c\u5f0f:";
    private static final String kpi_standardvalue_formula_no_permission_error = "\u6807\u51c6\u503c\u516c\u5f0f\u65e0\u6743\u9650!\u516c\u5f0f:";
    private static final String kpi_formula_error = "KPI\u516c\u5f0f\u9519\u8bef";
    private static final String kpi_standardvalue_error = "KPI\u6807\u51c6\u503c\u516c\u5f0f\u9519\u8bef";

    public Variant[] calculateFormulas(List formulas, Date date, Map formulaInfoMap, Context ctx) throws BOSException, EASBizException {
        return this.forcalcFormula(ctx, formulas, date, formulaInfoMap);
    }

    public Variant calculateFormula(String formula, Date date, Map formulaInfoMap, Context ctx) throws BOSException, EASBizException {
        return this._calcFormula(ctx, formula, date, formulaInfoMap);
    }

    protected Variant _calcFormula(Context ctx, String formula, Date date, Map formulaInfoMap) throws BOSException {
        Variant[] resultVariant = new Variant[1];
        ArrayList<String> formulas = new ArrayList<String>();
        formulas.add(formula);
        try {
            resultVariant = this.forcalcFormula(ctx, formulas, date, formulaInfoMap);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return resultVariant[0];
    }

    private Variant[] forcalcFormula(Context ctx, List formulas, Date date, Map formulaInfoMap) throws EASBizException, BOSException {
        Variant[] reVariant = new Variant[formulas.size()];
        if (formulas == null || formulas.size() == 0 || date == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizDate", date);
        if (null != formulaInfoMap) {
            if (null != formulaInfoMap.get("formulaTimeType")) {
                params.put("timeType", formulaInfoMap.get("formulaTimeType"));
            }
            if (null != formulaInfoMap.get("formulaCompany")) {
                params.put("company", (OrgUnitInfo)formulaInfoMap.get("formulaCompany"));
            }
            if (null != formulaInfoMap.get("formulaIsUnpassedVoucherIncluded")) {
                params.put("IncludePosted", Boolean.valueOf(formulaInfoMap.get("formulaIsUnpassedVoucherIncluded").toString()));
            }
            if (null != formulaInfoMap.get("formulaIsDetailItemBalanceInclude")) {
                params.put("IncludeLeaf", Boolean.valueOf(formulaInfoMap.get("formulaIsDetailItemBalanceInclude").toString()));
            }
            if (null != formulaInfoMap.get("formulaIsSubItemBalanceInclude")) {
                params.put("IncludeSub", Boolean.valueOf(formulaInfoMap.get("formulaIsSubItemBalanceInclude").toString()));
            }
            params.put("timeType", (Object)KPITimeTypeEnum.month);
        }
        reVariant = this.docalcFormula(ctx, formulas, params);
        return reVariant;
    }

    private Variant[] docalcFormula(Context ctx, List formulas, Map params) throws BOSException, EASBizException {
        Variant[] tempResultVariant = null;
        if (formulas == null || formulas.size() <= 0) {
            logger.info((Object)"sem_mp error: formulas is null or formulas's length < 0!");
            return null;
        }
        if (params == null) {
            logger.info((Object)"sem_mp error: params is null!");
            return null;
        }
        Map contextMap = this.initCaculateParam(ctx, params);
        ArrayList<String> formulaList = new ArrayList<String>();
        String formula = null;
        for (int i = 0; i < formulas.size(); ++i) {
            formula = (String)formulas.get(i);
            if (formula != null) {
                if (!formula.startsWith("=")) {
                    formula = "=" + formula;
                }
                if (formula.endsWith(";")) {
                    formula = formula.substring(0, formula.length() - 1);
                }
            }
            formulaList.add(formula);
        }
        DateContextHandler contextHandler = new DateContextHandler();
        tempResultVariant = ReportFactory.getLocalInstance((Context)ctx).calcFormulas(contextMap, formulaList, (IContextHandler)contextHandler);
        return tempResultVariant;
    }

    protected Variant[] _calcFormulas(Context ctx, List formulas, IContextHandler handler) throws BOSException {
        int i;
        Book book = Book.Manager.getNewBook(null, (int)1);
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        calcContext.setPermission(new ChecFmlParamPermissionUtil(ctx));
        ReportInfo report = new ReportInfo();
        ReportVariables iv = VariablesHelper.sheetParams2Variables((ReportInfo)report);
        for (i = 0; i < iv.getAllVariables().size(); ++i) {
            ((VariableEntry)iv.getAllVariables().get(i)).setSheetName(book.getSheet(0).getSheetName());
        }
        calcContext.setReportVariables(iv);
        if (handler == null) {
            handler = new DefaultContextHandler();
        }
        handler.handlerContext(ctx, report, iv);
        calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        try {
            FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)calcContext);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        book.getUndoManager().enable(false);
        book.setCalculate(false);
        for (i = 0; i < formulas.size(); ++i) {
            String formula = (String)formulas.get(i);
            book.getSheet(0).getCell(i, 0, true).setFormula(formula);
        }
        book.calc();
        book.getUndoManager().enable(false);
        Variant[] results = new Variant[formulas.size()];
        for (int i2 = 0; i2 < formulas.size(); ++i2) {
            results[i2] = book.getSheet(0).getCell(i2, 0, true).getValue();
        }
        return results;
    }

    private Map initCaculateParam(Context ctx, Map params) throws EASBizException, BOSException {
        Object obj = params.get("timeType");
        if (obj == null || !(obj instanceof KPITimeTypeEnum)) {
            logger.info((Object)"_calcFormula ,the timeType is null ");
            return null;
        }
        KPITimeTypeEnum timeType = (KPITimeTypeEnum)((Object)obj);
        obj = params.get("bizDate");
        if (obj == null || !(obj instanceof Date)) {
            logger.info((Object)"_calcFormula ,the bizDate is null ");
            return null;
        }
        Date bizDate = (Date)obj;
        CompanyOrgUnitInfo companyInfo = null;
        CurrencyInfo currencyInfo = null;
        OrgUnitInfo tempCompany = null;
        obj = params.get("company");
        if (obj != null && obj instanceof OrgUnitInfo) {
            tempCompany = (OrgUnitInfo)obj;
            companyInfo = this.getCompanyInfo(ctx, tempCompany);
            currencyInfo = this.getCurrency(companyInfo);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("timetype", (Object)timeType);
        context.put("DateContextHandler_date", bizDate);
        context.put("IContextHandler_company", companyInfo);
        context.put("IContextHandler_currency", currencyInfo);
        obj = params.get("IncludePosted");
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            context.put("IContextHandler_INCLUDE_POSTED", "Y");
        } else {
            context.put("IContextHandler_INCLUDE_POSTED", "N");
        }
        obj = params.get("IncludeLeaf");
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            context.put("IContextHandler_INCLUDE_LEAF", "Y");
        } else {
            context.put("IContextHandler_INCLUDE_LEAF", "N");
        }
        obj = params.get("IncludeSub");
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            context.put("IContextHandler_INCLUDE_SUB", "Y");
        } else {
            context.put("IContextHandler_INCLUDE_SUB", "N");
        }
        return context;
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, OrgUnitInfo company) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo;
        OrgUnitInfo ou = company;
        String companyid = ou.getId().toString();
        if (!ou.isIsCompanyOrgUnit() && (ou = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).getDelegateUnit(companyid, OrgType.Company)) != null) {
            companyid = ou.getId().toString();
        }
        if (ou == null) {
            companyInfo = RptUtilForServer.getCurrentCompany((Context)ctx);
        } else {
            companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(ou.getId());
            companyInfo.setNumber(ou.getNumber());
        }
        SelectorItemCollection scc = new SelectorItemCollection();
        scc.add(new SelectorItemInfo("id"));
        scc.add(new SelectorItemInfo("number"));
        scc.add(new SelectorItemInfo("name"));
        scc.add(new SelectorItemInfo("reportCurrency.*"));
        scc.add(new SelectorItemInfo("baseCurrency.*"));
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()), scc);
        return companyInfo;
    }

    private CurrencyInfo getCurrency(CompanyOrgUnitInfo companyInfo) {
        CurrencyInfo currencyInfo = new CurrencyInfo();
        if (companyInfo == null) {
            return currencyInfo;
        }
        currencyInfo = companyInfo.isIsOnlyUnion() ? companyInfo.getReportCurrency() : companyInfo.getBaseCurrency();
        return currencyInfo;
    }
}

