/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bizframework.billconfig.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.bizframework.billconfig.BillConfigureCollection;
import com.kingdee.eas.bizframework.billconfig.BillConfigureFactory;
import com.kingdee.eas.bizframework.billconfig.BillConfigureInfo;
import com.kingdee.eas.bizframework.billconfig.UseStatusEnum;
import com.kingdee.eas.bizframework.billconfig.app.AbstractBillConfigureControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BillConfigureControllerBean
extends AbstractBillConfigureControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bizframework.billconfig.app.BillConfigureControllerBean");

    @Override
    protected void _active(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        IObjectPK pk = null;
        String idStr = "";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            pk = pks[i];
            idStr = idStr + "'" + pk.toString() + "',";
        }
        idStr = idStr.substring(0, idStr.length() - 1);
        String cuId = ((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)).getId().toString();
        sb.append("update T_BIZ_BillConfigure set FState = 2 where FID in (").append(idStr).append(")");
        sb.append(" and FState in (1,3) and FControlunitid = '").append(cuId).append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("queryEntry.seq"));
        return super._getValue(ctx, pk, selector, sorter);
    }

    @Override
    protected void _unActive(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        IObjectPK pk = null;
        String idStr = "";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            pk = pks[i];
            idStr = idStr + "'" + pk.toString() + "',";
        }
        idStr = idStr.substring(0, idStr.length() - 1);
        String cuId = ((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)).getId().toString();
        sb.append("update T_BIZ_BillConfigure set FState = 3 where FID in (").append(idStr).append(")");
        sb.append(" and FState=2 and FControlunitid= '").append(cuId).append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNameDup(ctx, model);
        BillConfigureInfo info = (BillConfigureInfo)model;
        info.setState(UseStatusEnum.SAVED);
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected Map _handleBillByOprtState(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, BillConfigureInfo> map = new HashMap<String, BillConfigureInfo>();
        Object id = paramMap.get("id");
        if (id == null) {
            return this.createBill(ctx);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", id, CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        selector.add(new SelectorItemInfo("queryEntry.*"));
        selector.add(new SelectorItemInfo("userConfig.*"));
        selector.add(new SelectorItemInfo("userConfig.user.*"));
        selector.add(new SelectorItemInfo("userConfig.user.group.*"));
        selector.add(new SelectorItemInfo("groupConfig.*"));
        selector.add(new SelectorItemInfo("roleConfig.*"));
        view.setFilter(filter);
        view.setSelector(selector);
        BillConfigureCollection coll = BillConfigureFactory.getLocalInstance(ctx).getBillConfigureCollection(view);
        map.put("bill", coll.get(0));
        return map;
    }

    private Map createBill(Context ctx) throws BOSException, EASBizException {
        HashMap<String, BillConfigureInfo> map = new HashMap<String, BillConfigureInfo>();
        BillConfigureInfo billInfo = new BillConfigureInfo();
        CtrlUnitInfo cu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        PermissionFactory.getRemoteInstance().checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(cu.getId().toString()), "billconfigure_addnew");
        billInfo.setState(UseStatusEnum.NEW);
        billInfo.setCU(cu);
        map.put("bill", billInfo);
        return map;
    }

    @Override
    protected IObjectValue _getBillConfigureData(Context ctx, String bosType) throws BOSException, EASBizException {
        BillConfigureInfo billInfo = null;
        String billId = this.getBillIdByRelation(ctx, bosType);
        EntityViewInfo view = null;
        view = billId == null ? this.getEntityViewInfo(this.getFilter(ctx, bosType), this.getSelector(), this.getSorter()) : this.getEntityViewInfo(this.getFilter(billId), this.getSelector(), this.getSorter());
        BillConfigureCollection billColl = BillConfigureFactory.getLocalInstance(ctx).getBillConfigureCollection(view);
        if (billColl.size() > 0) {
            billInfo = billColl.get(0);
        }
        return billInfo;
    }

    private EntityViewInfo getEntityViewInfo(FilterInfo filter, SelectorItemCollection selector, SorterItemCollection sorter) {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(selector);
        view.setSorter(sorter);
        return view;
    }

    private FilterInfo getFilter(Context ctx, String bosType) {
        CtrlUnitInfo cu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entityBosType", (Object)bosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cu.getId().toString(), CompareType.EQUALS));
        return filter;
    }

    private FilterInfo getFilter(String billId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
        return filter;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        selector.add(new SelectorItemInfo("queryEntry.*"));
        return selector;
    }

    private SorterItemCollection getSorter() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        sorter.add(new SorterItemInfo("queryEntry.seq"));
        return sorter;
    }

    private String getBillIdByRelation(Context ctx, String bosType) throws EASBizException, BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        UserGroupInfo group = user.getGroup();
        RoleInfo role = user.getMainRole();
        String billId = this.getBillIdByTableRelation(ctx, bosType, "T_BIZ_BillConfigureUser", "FUserID", user.getId().toString());
        if (billId == null && group != null) {
            billId = this.getBillIdByTableRelation(ctx, bosType, "T_BIZ_BillConfigureGroup", "FGroupID", group.getId().toString());
        } else if (billId == null && role != null) {
            billId = this.getBillIdByTableRelation(ctx, bosType, "T_BIZ_BillConfigureRole", "FRoleID", role.getId().toString());
        }
        return billId;
    }

    private String getBillIdByTableRelation(Context ctx, String bosType, String tableName, String fieldName, String fieldValue) throws EASBizException, BOSException {
        String billId = null;
        CtrlUnitInfo cu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        StringBuffer sb = new StringBuffer();
        sb.append(" select config.FID as ID from T_BIZ_BillConfigure config ");
        sb.append(" inner join ").append(tableName).append(" relation on config.FID = relation.FBillConfigID");
        sb.append(" where config.fentityBosType = '").append(bosType).append("'");
        sb.append(" and   config.fcontrolunitid = '").append(cu.getId().toString()).append("'");
        sb.append(" and   config.fstate = ").append(2);
        sb.append(" and   relation.").append(fieldName).append("= '").append(fieldValue).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                billId = rs.getString("ID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return billId;
    }
}

