/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.adv.chain.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class BizChainLogger {
    private static final String PARAM_LEVEL_NAME = "BizChainLogLevel";
    private static final String LOGGER_NAME = "com.kingdee.eas.dynbusiness.adv.businesschain";
    private static final int INFO = 1;
    private static final int DEBUG = 2;
    private Context ctx;
    private Logger logger;
    private int level;
    private LowTimer timer;
    private LowTimer innerTimer;
    private StringBuffer logBuffer;

    public static synchronized BizChainLogger getLogger(Context ctx) {
        return new BizChainLogger(ctx);
    }

    private BizChainLogger(Context ctx) {
        this.ctx = ctx;
        this.timer = new LowTimer();
        this.innerTimer = new LowTimer();
        this.logBuffer = new StringBuffer();
        this.initLogger();
        if (ctx != null) {
            this.initParam();
        } else {
            this.level = 0;
        }
    }

    public void beginLog(String action, String bosType) {
        if (this.level == 0) {
            return;
        }
        this.innerTimer.reset();
        this.logBuffer.append(this.getLogHeadInfo());
        this.logBuffer.append(" begin BusinessChainProcess, Action: " + action + ", BOSType: " + bosType).append("\n");
    }

    public void error(String message) {
        this.logBuffer.append("BusinessChainProcess error: ").append(message).append("\n");
        this.logger.info((Object)this.logBuffer.toString());
        this.logBuffer.setLength(0);
    }

    public void info(String message) {
        if (this.level < 1) {
            return;
        }
        this.logBuffer.append(message).append("\n");
    }

    public void debug(String message) {
        if (this.level < 2) {
            return;
        }
        this.logBuffer.append(message).append("\n");
    }

    public void endLog() {
        if (this.level == 0) {
            return;
        }
        this.logBuffer.append("end BusinessChainProcess, spend times: " + this.innerTimer.msValue()).append("\n");
        this.logger.info((Object)this.logBuffer.toString());
        this.logBuffer.setLength(0);
    }

    public void resetTimer() {
        this.timer.reset();
    }

    public long getTimes() {
        return this.timer.msValue();
    }

    protected String getLogHeadInfo() {
        if (this.ctx == null) {
            return "NO Context";
        }
        String clientIP = this.ctx.getClientHostIP();
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u5ba2\u6237\u7aefIP\uff1a").append(clientIP);
        return buffer.toString();
    }

    private void initLogger() {
        if (this.logger == null) {
            String fileName = "EAS_BizChain.log";
            this.addRollFileLogConfig("bizchain", LOGGER_NAME, fileName, Level.INFO, "10MB", "10");
            this.logger = Logger.getLogger((String)LOGGER_NAME);
        }
    }

    private void addRollFileLogConfig(String appenderName, String loggerName, String fileName, Level logLevel, String fileSize, String fileCount) {
        String instHome = System.getProperty("EAS_INSTANCE_HOME");
        String fileFullName = instHome + "/logs/" + fileName;
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withCharset(Charset.forName("UTF-8")).withConfiguration(config).withPattern("[%d{yyyy-MM-dd HH:mm:ss.SSS} %-6p] %m %n").build();
        SizeBasedTriggeringPolicy sizePolicy = SizeBasedTriggeringPolicy.createPolicy((String)fileSize);
        DefaultRolloverStrategy indexPolicy = DefaultRolloverStrategy.newBuilder().withMax(fileCount).build();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName(appenderName)).setImmediateFlush(true)).withFileName(fileFullName).withFilePattern(fileName + ".%i").setLayout((Layout)layout)).withPolicy((TriggeringPolicy)sizePolicy).withStrategy((RolloverStrategy)indexPolicy).build();
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)appenderName, (Level)logLevel, null);
        LoggerConfig logConfig = LoggerConfig.newBuilder().withLoggerName(loggerName).withAdditivity(false).withLevel(logLevel).withRefs(new AppenderRef[]{ref}).withConfig(config).build();
        logConfig.addAppender((Appender)appender, logLevel, null);
        config.addLogger(loggerName, logConfig);
        ctx.updateLoggers(config);
    }

    private Properties getLogProperties() {
        Properties properties = new Properties();
        String appendFullName = "log4j.appender.bizchain";
        String fileName = "${EAS_INSTANCE_HOME}/logs/EAS_BizChain.log";
        properties.put("log4j.logger.com.kingdee.eas.dynbusiness.adv.businesschain", "info, bizchain");
        properties.put("log4j.additivity.com.kingdee.eas.dynbusiness.adv.businesschain", "false");
        properties.put(appendFullName, "org.apache.log4j.RollingFileAppender");
        properties.put(appendFullName + ".MaxBackupIndex", "10");
        properties.put(appendFullName + ".MaxFileSize", "10MB");
        properties.put(appendFullName + ".layout", "org.apache.log4j.PatternLayout");
        properties.put(appendFullName + ".layout.ConversionPattern", "[%d{yyyy-MM-dd HH:mm:ss.SSS} %-6p] %m %n");
        properties.put(appendFullName + ".encoding", "UTF-8");
        properties.put(appendFullName + ".File", fileName);
        return properties;
    }

    private void initParam() {
        String sql = "SELECT FValue From T_DT_DTTempParam WHERE FKey = 'BizChainLogLevel'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            this.level = rs.next() ? rs.getInt("FValue") : 0;
        }
        catch (Exception e) {
            this.level = 0;
            this.error(e.getMessage());
        }
    }
}

