/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.adv.chain.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessChainExecuteException;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainEntryCollection;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainEntryInfo;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainFactory;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainInfo;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessorCollection;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessorInfo;
import com.kingdee.eas.dynbusiness.adv.chain.ServerUnitTypeEnum;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainUtil;
import com.kingdee.eas.dynbusiness.app.AbstractBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.monitor.ProgressExecuteListener;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BusinessChainProcessorBuilder
extends AbstractBusinessProcessorBuilder {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.dynbusiness.chain.app.BusinessChainProcessorBuilder");
    private Map<String, BusinessProcessorInfo> processors;

    public BusinessChainProcessorBuilder(ExecuteContext executeContext) {
        super(executeContext);
    }

    @Override
    public IBusinessProcessor buildProcessor(Context ctx) throws BOSException, EASBizException {
        IBusinessProcessor mainProcessor = null;
        String bosType = this.bosType.toString();
        String action = this.batchAction.getBizAction();
        StringBuffer sb = new StringBuffer();
        sb.append("select *, entry.* where bosType='");
        sb.append(bosType);
        sb.append("' and action='");
        sb.append(action);
        sb.append("'");
        try {
            BusinessProcessChainInfo bpci = BusinessProcessChainFactory.getLocalInstance(ctx).getBusinessProcessChainInfo(sb.toString());
            if (bpci == null) {
                this.outputBCNotFound(ctx);
                return null;
            }
            BusinessProcessChainEntryCollection bpcc = bpci.getEntry();
            if (bpcc == null || bpcc.size() == 0) {
                return null;
            }
            if (BusinessChainUtil.isChainCycleReference(ctx, bpci)) {
                String err = "\u4e1a\u52a1\u94fe[" + bpci.getDescription() + "]\u4e2d\u5b58\u5728\u5faa\u73af\u5f15\u7528\u81ea\u8eab\uff0c\u8bf7\u68c0\u67e5\uff01";
                logger.debug((Object)err);
                throw new ActionCommonException(null, err);
            }
            this.preFetchProcessor(ctx, bpci);
            mainProcessor = this.assembleABusinessChain(ctx, bpci);
        }
        catch (ObjectNotFoundException e) {
            this.outputBCNotFound(ctx);
            return null;
        }
        return mainProcessor;
    }

    private void outputBCNotFound(Context ctx) {
        StringBuffer sb = new StringBuffer();
        EntityObjectInfo mainEO = BusinessProcessUtil.getEntityInfo(ctx, this.bosType);
        sb.append(mainEO.getAlias());
        sb.append("[").append(this.bosType.toString()).append("]");
        sb.append("\u7684\u64cd\u4f5c").append(this.batchAction.getBizAction());
        sb.append("\u627e\u4e0d\u5230\u4e1a\u52a1\u94fe\u914d\u7f6e\uff01");
        logger.debug((Object)sb.toString());
    }

    private Set<String> iterateAChain(Context ctx, BusinessProcessChainInfo bc) throws EASBizException, BOSException {
        BusinessProcessChainEntryCollection bpcc = bc.getEntry();
        HashSet<String> idSet = new HashSet<String>();
        Iterator iter = bpcc.iterator();
        while (iter.hasNext()) {
            BusinessProcessChainEntryInfo item = (BusinessProcessChainEntryInfo)iter.next();
            if (!item.isIsActive()) continue;
            if (item.getType().equals((Object)ServerUnitTypeEnum.BIZUNIT)) {
                idSet.add(item.getProcessor());
                continue;
            }
            ObjectUuidPK pk = new ObjectUuidPK(item.getProcessor());
            BusinessProcessChainInfo sub = BusinessProcessChainFactory.getLocalInstance(ctx).getBusinessProcessChainInfo((IObjectPK)pk);
            if (sub == null) {
                String err = "\u4e1a\u52a1\u94fe[" + bc.getDescription() + "]\u5f15\u7528\u7684\u5b50\u4e1a\u52a1\u94fe[" + item.getProcessor() + "]\u4e0d\u5b58\u5728\uff01";
                logger.debug((Object)err);
                throw new ActionCommonException(null, err);
            }
            idSet.addAll(this.iterateAChain(ctx, sub));
        }
        return idSet;
    }

    private void preFetchProcessor(Context ctx, BusinessProcessChainInfo bc) throws BOSException, EASBizException {
        this.processors = new HashMap<String, BusinessProcessorInfo>();
        Set<String> idSet = this.iterateAChain(ctx, bc);
        int length = idSet.size();
        if (length == 0) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("id");
        coll.add("implementClass");
        coll.add("name");
        view.setSelector(coll);
        view.setFilter(filter);
        BusinessProcessorCollection bpc = BusinessProcessorFactory.getLocalInstance(ctx).getBusinessProcessorCollection(view);
        Iterator iter = bpc.iterator();
        while (iter.hasNext()) {
            BusinessProcessorInfo info = (BusinessProcessorInfo)iter.next();
            this.processors.put(info.getId().toString(), info);
        }
    }

    private IBusinessProcessor assembleABusinessChain(Context ctx, BusinessProcessChainInfo bc) throws BOSException, EASBizException {
        ExecuteContext ec;
        IBusinessProcessor mainProcessor = null;
        IBusinessProcessor lastProcessor = null;
        IBusinessProcessor thisProcessor = null;
        HashMap<String, String> previousMap = new HashMap<String, String>();
        HashMap<String, BusinessProcessChainEntryInfo> processorMap = new HashMap<String, BusinessProcessChainEntryInfo>();
        BatchActionEnum actionEnum = BatchActionEnum.getBatchActionEnum((Context)ctx, (String)bc.getAction());
        if (this.executeContext.getBatchAction().equals((Object)actionEnum)) {
            ec = this.executeContext;
        } else {
            try {
                ec = (ExecuteContext)this.executeContext.clone();
                ec.setBatchAction(actionEnum);
            }
            catch (CloneNotSupportedException e) {
                throw new BOSException((Throwable)e);
            }
        }
        Iterator iter = bc.getEntry().iterator();
        LinkedList<IBusinessProcessor> prefixList = new LinkedList<IBusinessProcessor>();
        BusinessProcessChainEntryInfo aItem = null;
        while (iter.hasNext()) {
            BusinessProcessChainEntryInfo item = (BusinessProcessChainEntryInfo)iter.next();
            if (item.getNextProcessor() != null) {
                previousMap.put(item.getNextProcessor().getId().toString(), item.getId().toString());
            }
            if (item.getExecMode().equals((Object)ProcessorExecutionModeEnum.MAIN)) {
                aItem = item;
            }
            processorMap.put(item.getId().toString(), item);
        }
        if (aItem == null) {
            String err = "\u4e1a\u52a1\u94fe[" + bc.getDescription() + "]\u4e3b\u4e1a\u52a1\u5904\u7406\u5668\u4e0d\u5b58\u5728\uff01";
            logger.debug((Object)err);
            throw new ActionCommonException(null, err);
        }
        mainProcessor = this.buildAProcessor(ctx, aItem, ec);
        String preId = (String)previousMap.get(aItem.getId().toString());
        while (preId != null) {
            BusinessProcessChainEntryInfo item = (BusinessProcessChainEntryInfo)processorMap.get(preId);
            if (!item.isIsActive()) {
                preId = (String)previousMap.get(item.getId().toString());
                continue;
            }
            thisProcessor = this.buildAProcessor(ctx, item, ec);
            prefixList.addFirst(thisProcessor);
            preId = (String)previousMap.get(item.getId().toString());
            if (prefixList.size() < processorMap.size()) continue;
            String err = "\u4e1a\u52a1\u94fe[" + bc.getDescription() + "]\u5b58\u5728\u95ed\u73af\uff0c\u8bf7\u68c0\u67e5\uff01";
            logger.debug((Object)err);
            throw new ActionCommonException(null, err);
        }
        if (mainProcessor.getBusinessChainSupport() != null) {
            mainProcessor.getBusinessChainSupport().setPrefixBusinessProcessors(prefixList);
        }
        lastProcessor = mainProcessor;
        while (aItem.getNextProcessor() != null) {
            String nextId = aItem.getNextProcessor().getId().toString();
            BusinessProcessChainEntryInfo item = (BusinessProcessChainEntryInfo)processorMap.get(nextId);
            if (!item.isIsActive()) {
                aItem = item;
                continue;
            }
            thisProcessor = this.buildAProcessor(ctx, item, ec);
            if (lastProcessor.getBusinessChainSupport() != null) {
                lastProcessor.getBusinessChainSupport().addPostBusinessProcessor(thisProcessor);
            }
            lastProcessor = thisProcessor;
            aItem = item;
        }
        return mainProcessor;
    }

    private IBusinessProcessor buildABusinessChain(Context ctx, BusinessProcessChainEntryInfo item) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(item.getProcessor());
        BusinessProcessChainInfo bc = BusinessProcessChainFactory.getLocalInstance(ctx).getBusinessProcessChainInfo((IObjectPK)pk);
        return this.assembleABusinessChain(ctx, bc);
    }

    protected IBusinessProcessor buildAProcessor(Context ctx, BusinessProcessChainEntryInfo item, ExecuteContext ec) throws BOSException, EASBizException {
        String className = null;
        if (item.getType().equals((Object)ServerUnitTypeEnum.BIZCHAIN)) {
            return this.buildABusinessChain(ctx, item);
        }
        try {
            BusinessProcessorInfo bpi = this.processors.get(item.getProcessor());
            if (bpi == null) {
                throw new BusinessChainExecuteException(BusinessChainExecuteException.PROCESSOR_NOT_FOUND, new Object[]{"ID:" + item.getProcessor()});
            }
            if (this.prgressListener != null) {
                ((ProgressExecuteListener)this.prgressListener).addProcessor(bpi);
            }
            className = bpi.getImplementClass();
            Class<?> clz = Class.forName(className);
            Constructor<?> constructor = clz.getConstructor(ProcessorConstructParam.class);
            ec.getApplicationContext().putData(className, bpi.getName());
            ProcessorConstructParam param = new ProcessorConstructParam(ec, item.getExecMode(), item.getTransactionModeEnum(), null);
            IBusinessProcessor processor = (IBusinessProcessor)constructor.newInstance(param);
            if (item.isIsInvokeBeanExt() && ec.getCaller() instanceof IBatchExecute) {
                processor.setBatchExecutor((IBatchExecute)ec.getCaller());
            }
            processor.addExecuteListener(this.logListener);
            processor.addExecuteListener(this.prgressListener);
            return processor;
        }
        catch (ClassNotFoundException e) {
            throw new BusinessChainExecuteException(BusinessChainExecuteException.PROCESSOR_NOT_FOUND, new Object[]{className});
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            return this.buildAProcessorWithOldConstructor(item, ec);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IBusinessProcessor buildAProcessorWithOldConstructor(BusinessProcessChainEntryInfo item, ExecuteContext ec) throws BOSException, EASBizException {
        String className = null;
        try {
            BusinessProcessorInfo bpi = this.processors.get(item.getProcessor());
            if (bpi == null) {
                throw new BusinessChainExecuteException(BusinessChainExecuteException.PROCESSOR_NOT_FOUND, new Object[]{"ID:" + item.getProcessor()});
            }
            className = bpi.getImplementClass();
            Class<?> clz = Class.forName(className);
            Constructor<?> constructor = clz.getConstructor(ExecuteContext.class, ProcessorExecutionModeEnum.class, Conditions.class, TransactionModeEnum.class);
            ec.getApplicationContext().putData(className, bpi.getName());
            IBusinessProcessor processor = (IBusinessProcessor)constructor.newInstance(new Object[]{ec, item.getExecMode(), null, item.getTransactionModeEnum()});
            if (item.isIsInvokeBeanExt() && ec.getCaller() instanceof IBatchExecute) {
                processor.setBatchExecutor((IBatchExecute)ec.getCaller());
            }
            processor.addExecuteListener(this.logListener);
            processor.addExecuteListener(this.prgressListener);
            return processor;
        }
        catch (ClassNotFoundException e) {
            throw new BusinessChainExecuteException(BusinessChainExecuteException.PROCESSOR_NOT_FOUND, new Object[]{className});
        }
        catch (SecurityException e) {
            throw new BusinessChainExecuteException(BusinessChainExecuteException.PROCESSOR_CONSTRUCTOR_ERR, new Object[]{"(ProcessorConstructParam param)"});
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

