/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.adv.chain.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainEntryCollection;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainEntryInfo;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainFactory;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessChainInfo;
import com.kingdee.eas.dynbusiness.adv.chain.ServerUnitTypeEnum;
import java.util.Iterator;

public final class BusinessChainUtil {
    public static boolean isChainCycleReference(Context ctx, BusinessProcessChainInfo item) throws EASBizException, BOSException {
        return BusinessChainUtil.iterateCycleCheck(ctx, item, item.getId() == null ? null : item.getId().toString());
    }

    private static boolean iterateCycleCheck(Context ctx, BusinessProcessChainInfo item, String bcId) throws EASBizException, BOSException {
        if (item == null || item.getId() == null) {
            return false;
        }
        boolean result = false;
        BusinessProcessChainEntryCollection col = item.getEntry();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            BusinessProcessChainEntryInfo entry = (BusinessProcessChainEntryInfo)iter.next();
            if (!entry.getType().equals((Object)ServerUnitTypeEnum.BIZCHAIN)) continue;
            result = entry.getProcessor().equals(bcId);
            if (!result) {
                ObjectUuidPK pk = new ObjectUuidPK(entry.getProcessor());
                BusinessProcessChainInfo bc = BusinessProcessChainFactory.getLocalInstance(ctx).getBusinessProcessChainInfo((IObjectPK)pk);
                result = BusinessChainUtil.iterateCycleCheck(ctx, bc, bcId);
            }
            if (!result) continue;
            return true;
        }
        return result;
    }
}

