/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.adv.chain.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BizChainLogger;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainProcessorBuilder;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public class DefaultBusinessChainExecutor
implements IBusinessChainExecutor {
    @Override
    public BatchActionResults batchExecute(ExecuteContext executeContext) throws BOSException, EASBizException {
        try {
            BizChainLogger logger = executeContext.getLogger();
            logger.beginLog(executeContext.getBatchAction().getBizAction(), executeContext.getBosType().toString());
            BusinessChainProcessorBuilder builder = new BusinessChainProcessorBuilder(executeContext);
            IBusinessProcessor mainProcessor = builder.buildProcessor(executeContext.getContext());
            if (mainProcessor == null) {
                logger.error("mainProcessor is null");
                return null;
            }
            BatchActionResults batchResults = executeContext.populateActionResults();
            batchResults.setAddedSelector(executeContext.getAddedSelector());
            BatchActionResults result = mainProcessor.execute(batchResults);
            logger.endLog();
            return result;
        }
        catch (BOSException | EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage() + e.getCause() + e.getStackTrace()[0]);
        }
    }
}

