/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.dynbusiness.ColumnDataType;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.condition.ColumnItem;
import com.kingdee.eas.dynbusiness.condition.CompositeItem;
import com.kingdee.eas.dynbusiness.condition.Condition;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.condition.EntityItem;
import com.kingdee.eas.dynbusiness.condition.IFItem;
import com.kingdee.eas.dynbusiness.condition.IPropertySupport;
import com.kingdee.eas.dynbusiness.condition.InterfaceItem;
import com.kingdee.eas.dynbusiness.condition.ListItem;
import com.kingdee.eas.dynbusiness.condition.ParameterItem;
import com.kingdee.eas.dynbusiness.condition.PropertyItem;
import com.kingdee.eas.dynbusiness.condition.StateItem;
import com.kingdee.eas.dynbusiness.condition.TextItem;
import com.kingdee.eas.dynbusiness.config.ActionItem;
import com.kingdee.eas.dynbusiness.config.ActionItemList;
import com.kingdee.eas.dynbusiness.config.BOTProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.BOTProcessConfigItems;
import com.kingdee.eas.dynbusiness.config.BOTProcessSubItem;
import com.kingdee.eas.dynbusiness.config.BOTSourceItem;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItems;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessResource;
import com.kingdee.eas.dynbusiness.config.ColumnPair;
import com.kingdee.eas.dynbusiness.config.OneToManyWriteBackSubItem;
import com.kingdee.eas.dynbusiness.config.OneToOneWriteBackSubItem;
import com.kingdee.eas.dynbusiness.config.Property;
import com.kingdee.eas.dynbusiness.config.PropertyCheckConfigItems;
import com.kingdee.eas.dynbusiness.config.TableCheckConfigItems;
import com.kingdee.eas.dynbusiness.config.UpdateStatusItem;
import com.kingdee.eas.dynbusiness.config.UpdatedColumn;
import com.kingdee.eas.dynbusiness.config.ValueMappingItem;
import com.kingdee.eas.dynbusiness.config.WriteBackConfigItem;
import com.kingdee.eas.dynbusiness.config.WriteBackPolicy;
import com.kingdee.eas.dynbusiness.config.WriteBackSubItem;
import com.kingdee.eas.dynbusiness.util.ResourceUtils;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.commons.collections.FastHashMap;
import org.jdom2.Element;

public final class BusinessProcessSqlBuilder {
    private static BusinessProcessSqlBuilder businessProcessSqlBuilder;
    private static final String XmlPath = "bizprocessconfig.xml";
    private static final String BILLTYPEID = "billtypeid";
    private static final String SPPATH = "com/kingdee/eas/scm/common/app/cfgfile/plugin/";
    private static final String INDUSTRYPATH = "com/kingdee/eas/config/app/cfgfile/industry/";
    private static final String FILE_URL_PREFIX = "file:";
    private static final String JAR_URL_SEPARATOR = "!/";
    private FastHashMap processMap = new FastHashMap();
    private FastHashMap mergedMap = new FastHashMap();
    private HashMap billMap = new HashMap();
    private HashMap interfaceMap = new HashMap();
    private HashMap spMap = new HashMap();
    private HashMap industryMap = new HashMap();
    private String langProfix;

    private BusinessProcessSqlBuilder() {
        this.processMap.setFast(true);
        this.mergedMap.setFast(true);
    }

    private static synchronized void initiate(Context ctx) throws BOSException {
        if (businessProcessSqlBuilder == null) {
            businessProcessSqlBuilder = new BusinessProcessSqlBuilder();
            BusinessProcessSqlBuilder.businessProcessSqlBuilder.langProfix = ResourceUtils.getLanguage(ctx);
            BusinessConfigurationCache.getCache();
            BusinessConfigurationCache.initiate(ctx);
            businessProcessSqlBuilder.parseRootXml(XmlPath);
            businessProcessSqlBuilder.parseIndustryXmls();
            businessProcessSqlBuilder.parseSpXmls();
        }
    }

    public static BusinessProcessSqlBuilder getInstance(Context ctx) throws BOSException {
        if (businessProcessSqlBuilder == null) {
            BusinessProcessSqlBuilder.initiate(ctx);
        }
        return businessProcessSqlBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessProcessConfigItem getBusinessProcessConfigItem(Context ctx, String billTypeId, String action) throws BOSException {
        String key = this.getKey(billTypeId, action);
        if (!this.mergedMap.containsKey((Object)key)) {
            FastHashMap fastHashMap = this.mergedMap;
            synchronized (fastHashMap) {
                this.parseProcessXml(billTypeId);
                this.mergeConfigItem(ctx, billTypeId, key);
            }
        }
        BusinessProcessConfigItem bpConfigItem = (BusinessProcessConfigItem)this.mergedMap.get((Object)key);
        return bpConfigItem;
    }

    void pushXmlFile(String billTypeId, String xmlFileName) {
        if (xmlFileName == null || billTypeId == null) {
            return;
        }
        this.pushXmlFileInCache(billTypeId, xmlFileName);
    }

    void pushXmlFile(BOSObjectType bosType, String xmlFileName) {
        if (xmlFileName == null || bosType == null) {
            return;
        }
        this.pushXmlFileInCache(bosType.toString(), xmlFileName);
    }

    private void pushXmlFileInCache(String key, String xmlFileName) {
        if (xmlFileName.endsWith(".xml")) {
            this.billMap.put(key, xmlFileName.substring(0, xmlFileName.lastIndexOf(".xml")));
        } else {
            this.billMap.put(key, xmlFileName);
        }
    }

    public String getXmlFileInCache(String key) {
        return (String)this.billMap.get(key);
    }

    private synchronized void mergeConfigItem(Context ctx, String billTypeId, String key) throws BOSException {
        BusinessProcessConfigItem bpConfigItem = (BusinessProcessConfigItem)this.processMap.get((Object)key);
        this.mergePlugin(ctx, billTypeId, key, bpConfigItem, this.industryMap);
        this.mergePlugin(ctx, billTypeId, key, bpConfigItem, this.spMap);
        if (this.processMap.containsKey((Object)key)) {
            this.processMap.remove((Object)key);
        }
    }

    private void mergePlugin(Context ctx, String billTypeId, String key, BusinessProcessConfigItem bpConfigItem, Map toMergeMap) throws BOSException {
        if (toMergeMap.containsKey(key)) {
            BusinessProcessConfigItem pluginItem = (BusinessProcessConfigItem)toMergeMap.get(key);
            if (BusinessProcessorHelper.isDebug()) {
                BusinessProcessorHelper.outpurtDebug("\u627e\u5230\u5355\u636e[" + BusinessProcessorHelper.getBillName(ctx, billTypeId) + "]\u7684\u914d\u7f6e\u63d2\u4ef6\uff1aKEY[" + key + "]");
            }
            if (bpConfigItem != null) {
                bpConfigItem.merge(pluginItem);
                if (BusinessProcessorHelper.isDebug()) {
                    BusinessProcessorHelper.outpurtDebug("\u5904\u7406\u5355\u636e[" + BusinessProcessorHelper.getBillName(ctx, billTypeId) + "]\u7684\u914d\u7f6e\u63d2\u4ef6\u5408\u5e76\uff1aKEY[" + key + "]");
                }
                this.mergedMap.put((Object)key, (Object)bpConfigItem);
            } else {
                this.mergedMap.put((Object)key, (Object)pluginItem);
            }
            toMergeMap.remove(key);
        } else if (bpConfigItem == null) {
            bpConfigItem = BusinessProcessConfigItem.NULL_CONFIG_ITEM;
            this.processMap.put((Object)key, (Object)bpConfigItem);
        } else {
            this.mergedMap.put((Object)key, (Object)bpConfigItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessProcessConfigItem getBusinessProcessConfigItem(Context ctx, BOSObjectType bosType, String action) throws BOSException {
        String key = this.getKey(bosType, action);
        if (!this.mergedMap.containsKey((Object)key)) {
            FastHashMap fastHashMap = this.mergedMap;
            synchronized (fastHashMap) {
                this.parseProcessXml(bosType);
                this.mergeConfigItem(ctx, null, key);
            }
        }
        BusinessProcessConfigItem bpConfigItem = (BusinessProcessConfigItem)this.mergedMap.get((Object)key);
        return bpConfigItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConfigItem(String billTypeId, String action) {
        String key = this.getKey(billTypeId, action);
        FastHashMap fastHashMap = this.processMap;
        synchronized (fastHashMap) {
            this.processMap.remove((Object)key);
        }
    }

    private String getKey(String billTypeId, String action) {
        return billTypeId + action;
    }

    private String getKey(BOSObjectType bosType, String action) {
        return bosType.toString() + action;
    }

    private WriteBackConfigItem parseWriteBackItem(Element element, String dstBillTypeId, String bosType, BusinessProcessConfigItem parent) throws BOSException {
        WriteBackConfigItem configItem = null;
        if (element != null) {
            configItem = new WriteBackConfigItem(parent, ProcessorExecutionMode.getProcessorExecutionMode(element.getAttributeValue("execution")));
            List wbItems = element.getChildren();
            ArrayList<WriteBackSubItem> writebackItems = new ArrayList<WriteBackSubItem>();
            int size = wbItems.size();
            for (int idxOfwbItem = 0; idxOfwbItem < size; ++idxOfwbItem) {
                writebackItems.add(this.parseWriteBackSubItem((Element)wbItems.get(idxOfwbItem), dstBillTypeId, bosType, configItem));
            }
            configItem.setWritebackItems(writebackItems);
        }
        return configItem;
    }

    private void parsePlugInXmls(Map cacheMap, String path) throws BOSException {
        ZipFile jarFile = null;
        try {
            Enumeration<Object> enumeration = this.getClass().getClassLoader().getResources(path);
            String jarName = null;
            while (enumeration.hasMoreElements()) {
                int separatorIndex;
                URL url = enumeration.nextElement();
                String urlFile = url.getFile();
                if (urlFile == null || !urlFile.startsWith(FILE_URL_PREFIX) || (separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR)) <= 0) continue;
                jarName = urlFile.substring(FILE_URL_PREFIX.length(), separatorIndex);
                break;
            }
            if (jarName == null) {
                return;
            }
            jarFile = new JarFile(jarName);
            enumeration = ((JarFile)jarFile).entries();
            while (enumeration.hasMoreElements()) {
                JarEntry entry = (JarEntry)enumeration.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path) || !name.endsWith(".xml")) continue;
                if (BusinessProcessorHelper.isDebug()) {
                    BusinessProcessorHelper.outpurtDebug("\u627e\u5230\u914d\u7f6e\u63d2\u4ef6\u6587\u4ef6\uff1a" + name);
                }
                Element root = XMLParser.parseXML((InputStream)this.getClass().getClassLoader().getResourceAsStream(name)).getRootElement();
                BusinessProcessConfigItem[] bpcis = this.parseProcessXml(root, null);
                for (int i = 0; i < bpcis.length; ++i) {
                    BusinessProcessConfigItem bpci = bpcis[i];
                    cacheMap.put(this.getKey(bpci.getBosType(), bpci.getAction()), bpci);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void parseSpXmls() throws BOSException {
        this.parsePlugInXmls(this.spMap, SPPATH);
    }

    private void parseIndustryXmls() throws BOSException {
        this.parsePlugInXmls(this.industryMap, INDUSTRYPATH);
    }

    private void parseSrcBills(Element wbItemElement, WriteBackSubItem writebackItem) {
        String srcbill = wbItemElement.getAttributeValue("srcbill");
        if (srcbill != null) {
            String[] srcbills = srcbill.split("\\s*[,;\\s]{1}\\s*");
            String[] srcBosTypes = new String[srcbills.length];
            ArrayList<String> srcBillTypes = new ArrayList<String>(srcbills.length);
            for (int i = 0; i < srcbills.length; ++i) {
                EntityItem eitem = this.getEntityFromDefinition(srcbills[i]);
                if (eitem == null) {
                    throw new IllegalArgumentException("\u627e\u4e0d\u5230\u5b9e\u4f53" + srcbills[i] + "\u7684\u5b9a\u4e49");
                }
                srcBosTypes[i] = eitem.getBosType();
                srcBillTypes.add(eitem.getBillTypeId());
            }
            writebackItem.setSrcBillIds(srcBillTypes);
            writebackItem.setSrcBosTypes(srcBosTypes);
        } else {
            String srcbillid = wbItemElement.getAttributeValue("srcbillid");
            String srcbostype = wbItemElement.getAttributeValue("srcbostype");
            if (srcbostype != null) {
                writebackItem.setSrcBosTypes(srcbostype.split("\\s+"));
            }
            writebackItem.setSrcBillIds(this.parseSrcBillIds(srcbillid));
        }
    }

    private WriteBackSubItem parseWriteBackSubItem(Element wbItemElement, String dstBillTypeId, String bosType, WriteBackConfigItem configItem) throws BOSException {
        String relation;
        int idx;
        List subItems = wbItemElement.getChildren();
        Element subItem = (Element)subItems.get(idx = 0);
        WriteBackSubItem writebackItem = subItem.getName().equalsIgnoreCase("policy") && subItem.getAttributeValue("type").equalsIgnoreCase("one-many") ? new OneToManyWriteBackSubItem(configItem, dstBillTypeId) : new OneToOneWriteBackSubItem(configItem, dstBillTypeId);
        writebackItem.setDstBosType(bosType);
        int level = Integer.valueOf(wbItemElement.getAttributeValue("level"));
        if (wbItemElement.getAttribute("type") != null) {
            writebackItem.setWriteTo(wbItemElement.getAttributeValue("type"), level);
        }
        if (wbItemElement.getAttribute("status") != null) {
            writebackItem.setStatus(wbItemElement.getAttributeValue("status"));
            String oldIdField = wbItemElement.getAttributeValue("oldIdField");
            if (oldIdField != null) {
                writebackItem.setOldIdField(oldIdField);
            }
        }
        if ((relation = wbItemElement.getAttributeValue("relation")) != null) {
            String[] stringArray = relation.split("\\s+");
        }
        if (subItem.getName().equalsIgnoreCase("policy")) {
            this.parseWriteBackPolicy(subItem);
        }
        this.parseSrcBills(wbItemElement, writebackItem);
        int n = ++idx;
        Conditions conditionsList = this.parseConditions((Element)subItems.get(n));
        writebackItem.setLevel(level);
        writebackItem.setConditions(conditionsList);
        int n2 = ++idx;
        ++idx;
        Element nextElement = (Element)subItems.get(n2);
        HashMap<String, Conditions> condsMap = null;
        if (nextElement.getName().equalsIgnoreCase("signconditions")) {
            List condsList = nextElement.getChildren();
            int size = condsList.size();
            condsMap = new HashMap<String, Conditions>(size);
            for (int i = 0; i < size; ++i) {
                Conditions conds = this.parseConditions((Element)condsList.get(i));
                condsMap.put(conds.getId(), conds);
            }
            nextElement = (Element)subItems.get(idx++);
        }
        writebackItem.setColumnPairs(this.parseColumnPairList(nextElement, condsMap));
        nextElement = (Element)subItems.get(idx++);
        String srcBillId0 = (String)writebackItem.getSrcBillIds().get(writebackItem.getSrcBillIds().size() - 1);
        writebackItem.setUpdStatusItem(this.parseUpdateStatus(nextElement, srcBillId0, writebackItem));
        if (subItems.size() > idx) {
            writebackItem.setCheckItems(this.parseCheckItems((Element)subItems.get(idx), writebackItem));
        }
        return writebackItem;
    }

    private WriteBackPolicy parseWriteBackPolicy(Element policyItem) {
        WriteBackPolicy policy = new WriteBackPolicy(policyItem.getAttributeValue("type"));
        List subList = policyItem.getChildren();
        if (subList != null) {
            int i;
            int size = subList.size();
            if (size == 0) {
                return policy;
            }
            Element sortElement = (Element)subList.get(0);
            List sortsList = sortElement.getChildren();
            if (sortsList != null) {
                int subsize = sortsList.size();
                ArrayList<ColumnItem> sortCols = new ArrayList<ColumnItem>(subsize);
                for (int i2 = 0; i2 < subsize; ++i2) {
                    sortCols.add(this.parseColumnItem((Element)sortsList.get(i2)));
                }
                String sortType = sortElement.getAttributeValue("type");
                String[] sortTypes = sortType.split("\\.");
                if (sortTypes.length < subsize) {
                    String[] realTypes = new String[subsize];
                    for (i = 0; i < subsize; ++i) {
                        realTypes[i] = i < sortTypes.length ? sortTypes[i] : sortTypes[sortTypes.length - 1];
                    }
                    policy.setSortTypes(realTypes);
                } else {
                    policy.setSortTypes(sortTypes);
                }
            }
            if (size == 1) {
                return policy;
            }
            Element transElement = (Element)subList.get(1);
            List transList = transElement.getChildren();
            if (transList != null) {
                int subsize = transList.size();
                if (subsize == 0) {
                    return policy;
                }
                Element nextElement = (Element)transList.get(0);
                List subtransList = nextElement.getChildren();
                int thissize = subtransList.size();
                for (i = 0; i < thissize; ++i) {
                    this.parseTransformInPolicy(policy, (Element)subtransList.get(i));
                }
            }
        }
        return policy;
    }

    private ColumnItem parseColumnItem(Element colElement) {
        ColumnItem item = new ColumnItem(colElement.getText());
        item.setTable(TableTypeEnum.getTableType(colElement.getAttributeValue("table")));
        return item;
    }

    private void parseTransformInPolicy(WriteBackPolicy policy, Element transElement) {
        ColumnItem item = this.parseColumnItem(transElement);
        if (transElement.getName().equalsIgnoreCase("rate")) {
            policy.setExchangeRate(item);
        } else if (transElement.getName().equalsIgnoreCase("mode")) {
            policy.setConvertMode(item);
        } else if (transElement.getName().equalsIgnoreCase("currency")) {
            policy.setCurrency(item);
        }
    }

    private List parseColumnPairList(Element pairsElement, Map condsMap) throws BOSException {
        ArrayList<ColumnPair> columnPairList = new ArrayList<ColumnPair>();
        List pairsList = pairsElement.getChildren();
        if (pairsList == null || pairsList.size() == 0) {
            return columnPairList;
        }
        int subsize = pairsList.size();
        for (int j = 0; j < subsize; ++j) {
            List pairList;
            Element pairElement = (Element)pairsList.get(j);
            if (pairElement == null || (pairList = pairElement.getChildren()) == null) continue;
            int pairsize = pairList.size();
            if (pairsize < 5) {
                throw new IllegalArgumentException("The columnpair must be contains 5 elements in xml.");
            }
            ColumnPair pair = new ColumnPair();
            pair.setSrcColumn(((Element)pairList.get(0)).getText());
            Element aElement = (Element)pairList.get(1);
            ColumnDataType dataType = ColumnDataType.getType(((Element)pairList.get(3)).getText());
            ConditionItem dstColumn = this.parseConditionItem(aElement, aElement.getAttributeValue("type") == null ? "column" : aElement.getAttributeValue("type"));
            pair.setDstColumn(dstColumn);
            Element nextElement = (Element)pairList.get(2);
            List calList = nextElement.getChildren();
            if (calList.size() > 0) {
                aElement = (Element)calList.get(0);
                pair.setIfConditions((Conditions)condsMap.get(aElement.getAttributeValue("condition")));
                pair.setCalculation(aElement.getText());
                aElement = (Element)calList.get(1);
                pair.setElseCalculation(aElement.getText());
            } else {
                pair.setCalculation(nextElement.getText());
            }
            aElement = (Element)pairList.get(4);
            String transFrom = aElement.getText();
            if (transFrom != null && transFrom.length() > 0) {
                ConditionItem item = this.parseConditionItem(aElement, "column");
                pair.setTransFromColumn((ColumnItem)item);
            }
            pair.setType(dataType);
            if (pairsize > 5) {
                nextElement = (Element)pairList.get(5);
                if (nextElement.getName().equalsIgnoreCase("conditions")) {
                    pair.setConditions(this.parseConditions(nextElement));
                    this.parseVerification(pairList, 6, pair);
                } else {
                    this.parseVerification(pairList, 5, pair);
                }
            }
            columnPairList.add(pair);
        }
        return columnPairList;
    }

    private void parseVerification(List pairList, int idx, ColumnPair pair) {
        int size = pairList.size();
        if (size <= idx) {
            return;
        }
        Element nextElement = (Element)pairList.get(idx);
        if (!nextElement.getName().equals("verification")) {
            return;
        }
        if (size - idx < 2) {
            throw new IllegalArgumentException("The verification in columnpair must be followed message or exception element in xml.");
        }
        pair.setVerificationColumn(nextElement.getText());
        nextElement = (Element)pairList.get(idx + 1);
        pair.setResource(this.parseResource(nextElement));
    }

    private UpdateStatusItem[] parseUpdateStatus(Element updStatusElement, String billTypeId, Object parent) throws BOSException {
        List updStatusList = updStatusElement.getChildren();
        UpdateStatusItem[] usItems = new UpdateStatusItem[updStatusList.size()];
        int subsize = updStatusList.size();
        for (int idxOfUpdStatus = 0; idxOfUpdStatus < subsize; ++idxOfUpdStatus) {
            Element subUpdStatusElement = (Element)updStatusList.get(idxOfUpdStatus);
            List subUpdStatusList = subUpdStatusElement.getChildren();
            if (subUpdStatusList == null || subUpdStatusList.size() == 0) continue;
            UpdateStatusItem updateStatusItem = new UpdateStatusItem(billTypeId, parent);
            updateStatusItem.setThisTable(subUpdStatusElement.getAttributeValue("table"));
            updateStatusItem.setThisAction(subUpdStatusElement.getAttributeValue("action"));
            updateStatusItem.setThisReversedAction(subUpdStatusElement.getAttributeValue("reversedaction"));
            int subSize = subUpdStatusList.size();
            Element firstElement = (Element)subUpdStatusList.get(0);
            int idx = 0;
            if (firstElement.getName().equalsIgnoreCase("conditions")) {
                updateStatusItem.setThisConditions(this.parseConditions(firstElement));
            }
            int n = ++idx;
            Element updColumnsElement = (Element)subUpdStatusList.get(n);
            updateStatusItem.setUpdColumns(this.parseUpdColumns(updColumnsElement.getChildren()));
            if (subSize > ++idx) {
                Element infectionElement = (Element)subUpdStatusList.get(idx++);
                updateStatusItem.setInfectionTable(infectionElement.getAttributeValue("table"));
                updateStatusItem.setInfectionAction(infectionElement.getAttributeValue("action"));
                updateStatusItem.setInfectionReversedAction(infectionElement.getAttributeValue("reversedaction"));
                if (infectionElement.getChildren() != null && infectionElement.getChildren().size() > 0) {
                    for (int i = 0; i < infectionElement.getChildren().size(); ++i) {
                        Element updColsInfection = (Element)infectionElement.getChildren().get(i);
                        if (updColsInfection.getName().equalsIgnoreCase("conditions")) {
                            updateStatusItem.setInfectConditons(this.parseConditions(updColsInfection));
                            continue;
                        }
                        updateStatusItem.setInfectionUpdColumns(this.parseUpdColumns(updColsInfection.getChildren()));
                    }
                }
            }
            usItems[idxOfUpdStatus] = updateStatusItem;
        }
        return usItems;
    }

    private List parseUpdColumns(List updColumnsList) {
        if (updColumnsList != null && updColumnsList.size() > 0) {
            ArrayList<UpdatedColumn> updColumns = new ArrayList<UpdatedColumn>();
            int colsize = updColumnsList.size();
            for (int idxOfCol = 0; idxOfCol < colsize; ++idxOfCol) {
                Element colElement = (Element)updColumnsList.get(idxOfCol);
                UpdatedColumn updColumn = new UpdatedColumn();
                updColumn.setColumnName(colElement.getAttributeValue("name"));
                updColumn.setType(colElement.getAttributeValue("type"));
                updColumn.setValue(colElement.getAttributeValue("value"));
                updColumns.add(updColumn);
            }
            return updColumns;
        }
        return null;
    }

    private boolean parseProcessXml(BOSObjectType bosType) throws BOSException {
        String xmlFileName = (String)this.billMap.get(bosType.toString());
        if (xmlFileName == null || xmlFileName.endsWith("!OK")) {
            return false;
        }
        this.parseProcessXml(xmlFileName, bosType);
        this.billMap.put(bosType.toString(), xmlFileName + "!OK");
        return true;
    }

    private void parseProcessXml(String billTypeId) throws BOSException {
        String xmlFileName = (String)this.billMap.get(billTypeId);
        this.parseProcessXml(xmlFileName, null);
    }

    private BusinessProcessConfigItem[] parseProcessXml(Element root) throws BOSException {
        List childrens = root.getChildren();
        ArrayList<BusinessProcessConfigItem> bpciList = new ArrayList<BusinessProcessConfigItem>();
        int size = childrens.size();
        for (int i = 0; i < size; ++i) {
            EntityItem eitem;
            Element elementItems = (Element)childrens.get(i);
            if (elementItems.getName().equals("definition")) {
                this.parseDefinition(elementItems);
                continue;
            }
            String billTypeId = elementItems.getAttributeValue(BILLTYPEID);
            String bill = elementItems.getAttributeValue("bill");
            String bosType = elementItems.getAttributeValue("bostype");
            if (bill != null && (eitem = this.getEntityFromDefinition(bill)) != null) {
                if (billTypeId == null) {
                    billTypeId = eitem.getBillTypeId();
                }
                if (bosType == null) {
                    bosType = eitem.getBosType();
                }
            }
            if (bosType == null) {
                throw new IllegalArgumentException("Item processitems must be contain attribute 'bostype' in XML file.");
            }
            if (BusinessProcessorHelper.isDebug() && billTypeId != null) {
                String billName = BusinessProcessorHelper.getBillName(null, billTypeId);
                if (billName == null) {
                    billName = bill;
                }
                BusinessProcessorHelper.outpurtDebug("\u89e3\u6790\u5355\u636e" + billName + "\u7684\u914d\u7f6e\u6587\u4ef6\uff1a\u5355\u636e\u7c7b\u578b[" + billTypeId + "] BOSType[" + bosType + "]");
            }
            List listItems = elementItems.getChildren();
            int itemsSize = listItems.size();
            for (int idxOfItems = 0; idxOfItems < itemsSize; ++idxOfItems) {
                String refKey;
                boolean isRef = false;
                Element elementItem = (Element)listItems.get(idxOfItems);
                String action = elementItem.getAttributeValue("action").toUpperCase();
                String ref = elementItem.getAttributeValue("ref");
                BusinessProcessConfigItem bpitem = null;
                BusinessProcessConfigItem refConfigItem = null;
                if (ref != null && ref.length() > 0 && (refConfigItem = (BusinessProcessConfigItem)this.processMap.get((Object)(refKey = this.getKey(ref, action)))) != null) {
                    try {
                        bpitem = (BusinessProcessConfigItem)refConfigItem.clone();
                        isRef = true;
                    }
                    catch (CloneNotSupportedException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if (bpitem == null) {
                    bpitem = new BusinessProcessConfigItem();
                }
                bpitem.setBillTypeId(billTypeId);
                bpitem.setAction(action);
                bpitem.setBosType(bosType);
                bpitem.setActionLevel(BatchActionEnum.getDefaultLevel((String)action));
                List listItem = elementItem.getChildren();
                int sizeItem = listItem.size();
                int idx = 0;
                Element nextElement = null;
                if (sizeItem > idx && (nextElement = (Element)listItem.get(idx)).getName().equalsIgnoreCase("preconditions")) {
                    List conditions = nextElement.getChildren();
                    if (conditions != null && conditions.size() > 0) {
                        int condSize = conditions.size();
                        ArrayList<Conditions> preConditions = new ArrayList<Conditions>(condSize);
                        for (int idxOfConds = 0; idxOfConds < condSize; ++idxOfConds) {
                            preConditions.add(this.parseConditions((Element)conditions.get(idxOfConds)));
                        }
                        bpitem.setPreConditions(preConditions);
                    }
                    ++idx;
                }
                if (sizeItem > idx && (nextElement = (Element)listItem.get(idx)).getName().equals("selector")) {
                    String selector = nextElement.getText();
                    if (selector != null) {
                        String[] sels = selector.split("\\s*;\\s*");
                        bpitem.setAddedSelector(sels);
                    }
                    ++idx;
                }
                if (sizeItem > idx && (nextElement = (Element)listItem.get(idx)).getName().equals("checkitems")) {
                    BusinessCheckConfigItems checkitems = this.parseCheckItems(nextElement, bpitem);
                    bpitem.setCheckItems(checkitems);
                    ++idx;
                }
                if (sizeItem > idx && (nextElement = (Element)listItem.get(idx)).getName().equals("updsrcstatuses")) {
                    UpdateStatusItem[] usItems = this.parseUpdateStatus(nextElement, billTypeId, bpitem);
                    if (usItems.length > 0) {
                        bpitem.setUpdStatusItem(usItems[0]);
                    }
                    ++idx;
                }
                if (sizeItem > idx && (nextElement = (Element)listItem.get(idx)).getName().equals("wbitems")) {
                    WriteBackConfigItem wbConfigItem = this.parseWriteBackItem(nextElement, billTypeId, bosType, bpitem);
                    if (wbConfigItem != null) {
                        wbConfigItem.setAction(action);
                    }
                    bpitem.setWritebackItem(wbConfigItem);
                    ++idx;
                }
                if (sizeItem > idx && (nextElement = (Element)listItem.get(idx)).getName().equals("botitems")) {
                    BOTProcessConfigItems botItems = this.parseBOTConfigItems((Element)listItem.get(idx++), bpitem);
                    bpitem.setBotConfigItems(botItems);
                    ++idx;
                }
                if (sizeItem > idx && (nextElement = (Element)listItem.get(idx)).getName().equals("actionlist")) {
                    bpitem.setActionList(this.parseActionItemList(bpitem, nextElement));
                }
                if (isRef) {
                    try {
                        bpitem = (BusinessProcessConfigItem)bpitem.deepedCloned(refConfigItem);
                    }
                    catch (CloneNotSupportedException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                bpciList.add(bpitem);
            }
        }
        return bpciList.toArray(new BusinessProcessConfigItem[0]);
    }

    private ActionItemList parseActionItemList(Object item, Element elementActions) throws BOSException {
        if (elementActions == null) {
            return null;
        }
        ActionItemList actionList = new ActionItemList(item, ProcessorExecutionMode.getProcessorExecutionMode(elementActions.getAttributeValue("execution")), elementActions.getAttributeValue("state"));
        List listActions = elementActions.getChildren();
        ArrayList<ActionItem> actions = new ArrayList<ActionItem>();
        int subsize = listActions.size();
        for (int i = 0; i < subsize; ++i) {
            actions.add(this.parseActionItem((Element)listActions.get(i), i, actionList));
        }
        actionList.setActionList(actions);
        return actionList;
    }

    private void parseProcessXml(String xmlFileName, BOSObjectType bosType) throws BOSException {
        HashMap thisMap = new HashMap();
        BusinessProcessConfigItem[] bpCfgItems = this.parseProcessXmlByBOSType(xmlFileName, bosType);
        if (bpCfgItems == null || bpCfgItems.length == 0) {
            return;
        }
        this.mergeCfgItem(bpCfgItems, thisMap);
        this.processMap.putAll(thisMap);
    }

    public BusinessProcessConfigItem[] parseProcessXmlByBOSType(String xmlFileName, BOSObjectType bosType) throws BOSException {
        if (xmlFileName == null) {
            return null;
        }
        BusinessProcessConfigItem[] bpCfgItems = null;
        String[] xmlFileNames = xmlFileName.split("\\s*;\\s*");
        for (int i = 0; i < xmlFileNames.length; ++i) {
            String xmlFile = xmlFileNames[i].replaceAll("\\.", "/") + ".xml";
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(xmlFile);
            if (is == null) continue;
            try {
                Element root = XMLParser.parseXML((InputStream)is).getRootElement();
                bpCfgItems = this.parseProcessXml(root, bosType);
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return bpCfgItems;
    }

    private void mergeCfgItem(BusinessProcessConfigItem[] bpConfigItems, Map toMergeMap) throws BOSException {
        for (int i = 0; i < bpConfigItems.length; ++i) {
            BusinessProcessConfigItem cfgItem = bpConfigItems[i];
            String key = this.getKey(cfgItem.getBosType(), cfgItem.getAction());
            if (toMergeMap.containsKey(key)) {
                cfgItem.merge(toMergeMap.get(key));
                if (BusinessProcessorHelper.isDebug()) {
                    BusinessProcessorHelper.outpurtDebug("\u5904\u7406\u5355\u636e\u914d\u7f6e\u6587\u4ef6\u5408\u5e76");
                }
            }
            toMergeMap.put(key, cfgItem);
        }
    }

    private BusinessProcessConfigItem[] parseProcessXml(Element root, BOSObjectType bosType) throws BOSException {
        BusinessProcessConfigItem[] bpcis = this.parseProcessXml(root);
        try {
            for (int i = 0; i < bpcis.length; ++i) {
                BusinessProcessConfigItem bpci = bpcis[i];
                if (!this.isInherited(bpci.getBosType())) continue;
                if (bosType != null) {
                    bpci = (BusinessProcessConfigItem)bpci.deepedCloned(bpci);
                    bpci.setBosType(bosType.toString());
                    continue;
                }
                this.processMap.put((Object)this.getKey(bpci.getBosType(), bpci.getAction()), (Object)bpci);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return bpcis;
    }

    private boolean isInherited(String bosType) {
        if (bosType == null) {
            return false;
        }
        return bosType.startsWith("@");
    }

    private synchronized void parseDefinition(Element elementDefinition) throws BOSException {
        List listItems = elementDefinition.getChildren();
        int size = listItems.size();
        for (int i = 0; i < size; ++i) {
            ConditionItem item;
            Element elementItem;
            int j;
            int subsize;
            Element elementItems = (Element)listItems.get(i);
            List listItem = elementItems.getChildren();
            if (elementItems.getName().equals("entities")) {
                subsize = listItem.size();
                for (j = 0; j < subsize; ++j) {
                    elementItem = (Element)listItem.get(j);
                    item = this.parseConditionItem(elementItem, "entity");
                    BusinessConfigurationCache.getCache().putDefinitionInCache(elementItem.getAttributeValue("id"), item);
                }
                continue;
            }
            if (!elementItems.getName().equals("interfaces")) continue;
            subsize = listItem.size();
            for (j = 0; j < subsize; ++j) {
                elementItem = (Element)listItem.get(j);
                item = this.parseConditionItem(elementItem, "interface");
                this.interfaceMap.put(elementItem.getAttributeValue("id"), item);
            }
        }
    }

    private BOTProcessConfigItems parseBOTConfigItems(Element elementBOTItems, BusinessProcessConfigItem bpitem) throws BOSException {
        if (elementBOTItems == null) {
            return null;
        }
        List botItems = elementBOTItems.getChildren();
        if (botItems == null || botItems.size() == 0) {
            return null;
        }
        BOTProcessConfigItems items = new BOTProcessConfigItems(ProcessorExecutionMode.getProcessorExecutionMode(elementBOTItems.getAttributeValue("execution")));
        int size = botItems.size();
        for (int i = 0; i < size; ++i) {
            Element elementItem = (Element)botItems.get(i);
            BOTProcessConfigItem item = new BOTProcessConfigItem(elementItem.getAttributeValue("id"), bpitem, elementItem.getAttributeValue("name"));
            List subItems = elementItem.getChildren();
            int idx = 0;
            int subSize = subItems.size();
            if (subSize == 0) continue;
            item.setPreCondition(this.parseConditions((Element)subItems.get(idx++)));
            ArrayList<BOTProcessSubItem> subBOTItems = new ArrayList<BOTProcessSubItem>();
            while (idx < subSize) {
                subBOTItems.add(this.parseBOTSubItem((Element)subItems.get(idx++), item));
            }
            item.setSubBOTItems(subBOTItems);
            items.add(item);
        }
        return items;
    }

    private int parseColumnIdx(Element element, String name) {
        int result = 0;
        String value = element.getAttributeValue(name);
        if (value != null) {
            result = Integer.parseInt(value);
        }
        return result;
    }

    private BOTSourceItem parseBOTSourceItem(Element sourceElement, BOTProcessSubItem parent) throws BOSException {
        BOTSourceItem sourceItem = new BOTSourceItem(parent, sourceElement.getAttributeValue("type"));
        sourceItem.setKey(sourceElement.getAttributeValue("key"));
        String reload = sourceElement.getAttributeValue("reload");
        if (reload != null) {
            sourceItem.setReload(Boolean.valueOf(reload));
        }
        List listSource = sourceElement.getChildren();
        int idx = 0;
        if (listSource == null || listSource.size() == 0) {
            return sourceItem;
        }
        Element nextElement = (Element)listSource.get(idx++);
        sourceItem.setSourceSql(nextElement.getText());
        sourceItem.setIdxGroupby(this.parseColumnIdx(nextElement, "groupby"));
        sourceItem.setIdxBillId(this.parseColumnIdx(nextElement, "id"));
        sourceItem.setIdxEntryId(this.parseColumnIdx(nextElement, "entryid"));
        nextElement = (Element)listSource.get(idx++);
        sourceItem.setMappingItem(this.parseValueMappingItem(nextElement, sourceItem));
        return sourceItem;
    }

    private BOTProcessSubItem parseBOTSubItem(Element elementSubItem, BOTProcessConfigItem item) throws BOSException {
        String transform;
        String dstBosType = elementSubItem.getAttributeValue("dstbostype");
        BOTProcessSubItem subItem = new BOTProcessSubItem(item, elementSubItem.getAttributeValue("id"), elementSubItem.getAttributeValue("mapid"), dstBosType != null ? BOSObjectType.create((String)dstBosType) : null);
        String checkFirst = elementSubItem.getAttributeValue("checkfirst");
        if (checkFirst != null) {
            subItem.setCheckFirst(Boolean.valueOf(checkFirst));
        }
        if ((transform = elementSubItem.getAttributeValue("transform")) != null) {
            subItem.setTransform(Boolean.valueOf(transform));
        }
        subItem.setBotResultCondition(elementSubItem.getAttributeValue("botresult"));
        List subItems = elementSubItem.getChildren();
        int size = subItems.size();
        int idx = 0;
        if (size == idx) {
            return subItem;
        }
        Element nextElement = (Element)subItems.get(idx++);
        subItem.setSourceItem(this.parseBOTSourceItem(nextElement, subItem));
        nextElement = (Element)subItems.get(idx++);
        subItem.setPreCondition(this.parseConditions(nextElement));
        if (size == idx) {
            return subItem;
        }
        Element elementMapping = (Element)subItems.get(idx++);
        subItem.setMappingItem(this.parseValueMappingItem(elementMapping, subItem));
        if (size == idx) {
            return subItem;
        }
        Element elementActions = (Element)subItems.get(idx++);
        subItem.setActionItems(this.parseActionItemList(subItem, elementActions));
        return subItem;
    }

    private ActionItem parseActionItem(Element elementAction, int seq, ActionItemList subItem) throws BOSException {
        String type = elementAction.getAttributeValue("type");
        ActionItem actionItem = null;
        if (type != null && type.equals("sql")) {
            Element elementSql = (Element)elementAction.getChildren().get(0);
            actionItem = new ActionItem(subItem, elementSql.getText(), type, elementSql.getAttributeValue("updateto"));
        } else {
            if (type != null && type.equals("interface")) {
                actionItem = new ActionItem(subItem, elementAction.getText().toUpperCase(), type, seq);
                actionItem.setInterfaceItem((IPropertySupport)((Object)this.parseConditionItem(elementAction, type)));
            } else {
                String paramsType;
                String strEnum = elementAction.getAttributeValue("enum");
                actionItem = new ActionItem(subItem, elementAction.getText().toUpperCase(), strEnum == null ? -100 : Integer.parseInt(strEnum), seq);
                String method = elementAction.getAttributeValue("method");
                if (method != null) {
                    actionItem.setMethod(method);
                }
                if ((paramsType = elementAction.getAttributeValue("paramstype")) != null) {
                    actionItem.setParamsType(paramsType.split("\\s*;\\s*"));
                }
            }
            String reload = elementAction.getAttributeValue("reload");
            if (reload != null) {
                actionItem.setReload(Boolean.valueOf(reload));
            }
            actionItem.setPreCondition(elementAction.getAttributeValue("precondition"));
        }
        actionItem.setLogServiceParam(elementAction.getAttributeValue("logservice"));
        return actionItem;
    }

    private ValueMappingItem parseValueMappingItem(Element elementMapping, Object parent) throws BOSException {
        if (elementMapping == null) {
            return null;
        }
        List listMapping = elementMapping.getChildren();
        if (listMapping == null || listMapping.size() == 0) {
            return null;
        }
        List properties = this.parseProperties((Element)listMapping.get(0));
        Element elementValues = (Element)listMapping.get(1);
        List listValues = elementValues.getChildren();
        ArrayList<ConditionItem> values = new ArrayList<ConditionItem>();
        int size = listValues.size();
        for (int i = 0; i < size; ++i) {
            Element elementValue = (Element)listValues.get(i);
            values.add(this.parseConditionItem(elementValue, elementValue.getAttributeValue("type")));
        }
        return new ValueMappingItem(parent, properties, values);
    }

    private BusinessCheckConfigItems parseCheckItems(Element elementCheckItems, Object parent) throws BOSException {
        List listCheckItems = elementCheckItems.getChildren();
        BusinessCheckConfigItems checkItems = elementCheckItems.getAttribute("type") != null && elementCheckItems.getAttributeValue("type").equalsIgnoreCase("table") ? new TableCheckConfigItems(parent) : new PropertyCheckConfigItems(parent);
        int sizeCheckItems = listCheckItems.size();
        for (int idxOfCheck = 0; idxOfCheck < sizeCheckItems; ++idxOfCheck) {
            List listCheckItem;
            int sizeCheckItem;
            String srcbillid;
            Element elementCheckItem = (Element)listCheckItems.get(idxOfCheck);
            if (elementCheckItem.getName().equalsIgnoreCase("preconditions")) {
                throw new IllegalArgumentException("preconditions should be the first item in processitem.");
            }
            BusinessCheckConfigItem checkItem = new BusinessCheckConfigItem();
            checkItem.setId(elementCheckItem.getAttributeValue("id"));
            checkItem.setValidation(elementCheckItem.getAttributeValue("validation"));
            String ignore = elementCheckItem.getAttributeValue("ignore");
            if (ignore != null) {
                checkItem.setCanIgnore(Boolean.valueOf(ignore));
            }
            if ((srcbillid = elementCheckItem.getAttributeValue("srcbillid")) != null) {
                checkItem.setSrcBillIds(this.parseSrcBillIds(srcbillid));
            }
            if ((sizeCheckItem = (listCheckItem = elementCheckItem.getChildren()).size()) < 2) {
                throw new IllegalArgumentException("The checkitem must be contains 2 elements in xml.");
            }
            Element firstElement = (Element)listCheckItem.get(0);
            if (firstElement.getName().equalsIgnoreCase("conditions")) {
                checkItem.setConditions(this.parseConditions(firstElement));
            } else {
                checkItem.setProperties(this.parseProperties(firstElement));
            }
            Element elementMessage = (Element)listCheckItem.get(1);
            checkItem.setResource(this.parseResource(elementMessage));
            checkItems.add(checkItem);
        }
        return checkItems;
    }

    private BusinessResource parseResource(Element elementMessage) {
        if (elementMessage == null) {
            return null;
        }
        BusinessResource resource = new BusinessResource(elementMessage.getAttributeValue("resource"), elementMessage.getAttributeValue("name"));
        resource.setException(elementMessage.getName().equalsIgnoreCase("exception"));
        resource.setMessage(elementMessage.getText());
        return resource;
    }

    private List parseProperties(Element elementProps) {
        if (elementProps == null || elementProps.getChildren() == null || elementProps.getChildren().size() == 0) {
            return null;
        }
        int size = elementProps.getChildren().size();
        ArrayList<Property> properties = new ArrayList<Property>(size);
        for (int i = 0; i < size; ++i) {
            Element elementProp = (Element)elementProps.getChildren().get(i);
            Property property = new Property(elementProp.getText().trim());
            property.setPrecondition(elementProp.getAttributeValue("precondition"));
            property.setComparison(elementProp.getAttributeValue("comparison"));
            properties.add(property);
        }
        return properties;
    }

    private void parseRootXml(String xmlFile) throws BOSException {
        Element root;
        InputStream is = null;
        try {
            if (!xmlFile.endsWith(".xml")) {
                xmlFile = xmlFile.replaceAll("\\.", "/") + ".xml";
            }
            if ((is = xmlFile.indexOf("/") < 0 ? this.getClass().getResourceAsStream(xmlFile) : this.getClass().getClassLoader().getResourceAsStream(xmlFile)) == null) {
                return;
            }
            root = XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        List childrens = root.getChildren();
        int size = childrens.size();
        for (int i = 0; i < size; ++i) {
            EntityItem eitem;
            Element element = (Element)childrens.get(i);
            String rootXml = element.getAttributeValue("root");
            if (rootXml != null) {
                this.parseRootXml(rootXml);
                continue;
            }
            String bill = element.getAttributeValue("bill");
            String bosType = element.getAttributeValue("bostype");
            String ref = element.getAttributeValue("ref");
            if (bill != null && (eitem = this.getEntityFromDefinition(bill)) != null && bosType == null) {
                bosType = eitem.getBosType();
            }
            if (this.isInherited(bosType)) {
                this.parseProcessXml(ref, null);
                continue;
            }
            this.billMap.put(bosType, ref);
        }
    }

    private List parseSrcBillIds(String srcBillIds) {
        ArrayList<String> srcBillIdList = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(srcBillIds);
        while (stk.hasMoreTokens()) {
            srcBillIdList.add(stk.nextToken());
        }
        return srcBillIdList;
    }

    private Conditions parseConditions(Element conditionsElement) throws BOSException {
        if (conditionsElement == null || conditionsElement.getChildren().size() == 0) {
            return null;
        }
        ArrayList<Condition> conditionsList = new ArrayList<Condition>();
        List condElementList = conditionsElement.getChildren();
        int conssize = condElementList.size();
        for (int idxOfCons = 0; idxOfCons < conssize; ++idxOfCons) {
            Element conditionElement = (Element)condElementList.get(idxOfCons);
            List conditionList = conditionElement.getChildren();
            if (conditionList == null || conditionList.size() == 0 || conditionList == null || conditionList.size() <= 0) continue;
            if (conditionList.size() < 3) {
                throw new IllegalArgumentException("The Condition must be contains 3 elements in xml.");
            }
            Condition condition = new Condition();
            Element conditionItem = (Element)conditionList.get(0);
            ConditionItem item = this.parseConditionItem(conditionItem, conditionItem.getName());
            condition.setItem(item);
            conditionItem = (Element)conditionList.get(1);
            condition.setComparison(conditionItem.getText().trim());
            conditionItem = (Element)conditionList.get(2);
            condition.setValue(this.parseConditionItem(conditionItem, conditionItem.getAttributeValue("type")));
            conditionsList.add(condition);
        }
        Conditions conditions = new Conditions();
        conditions.setId(conditionsElement.getAttributeValue("id"));
        conditions.setConditions(conditionsList);
        conditions.setLinkMask(conditionsElement.getAttributeValue("linkmask"));
        return conditions;
    }

    private EntityItem getEntityFromDefinition(String key) {
        return BusinessConfigurationCache.getCache().getEntityFromDefinition(key);
    }

    private ConditionItem parseConditionItem(Element elementItem, String itemType) throws BOSException {
        if (elementItem == null) {
            return null;
        }
        ConditionItem item = null;
        if (itemType == null) {
            item = new TextItem(elementItem.getText());
        } else if (itemType.equals("status")) {
            item = new StateItem(elementItem.getText());
        } else if (itemType.equals("column")) {
            ColumnItem cvalue = new ColumnItem(elementItem.getText());
            cvalue.setTable(TableTypeEnum.getTableType(elementItem.getAttributeValue("table")));
            String levelFrom = elementItem.getAttributeValue("levelfrom");
            if (levelFrom != null) {
                cvalue.setLevelFrom(Integer.valueOf(levelFrom));
            }
            String dataType = elementItem.getAttributeValue("datatype");
            cvalue.setDataType(ColumnDataType.getType(dataType));
            String relation = elementItem.getAttributeValue("relation");
            if (relation != null) {
                String[] relations = relation.split("=");
                cvalue.setRelationField(relations[0]);
                cvalue.setRelationTable(relations[1]);
            }
            String convertto = elementItem.getAttributeValue("covertto");
            cvalue.setConvertTo(convertto);
            item = cvalue;
        } else if (itemType.equals("property")) {
            PropertyItem pitem = new PropertyItem(elementItem.getText());
            pitem.setDataType(elementItem.getAttributeValue("datatype"));
            String bosType = elementItem.getAttributeValue("bostype");
            if (bosType != null) {
                pitem.setBosType(BOSObjectType.create((String)bosType));
            }
            item = pitem;
        } else if (itemType.equals("parameter")) {
            ParameterItem pitem = new ParameterItem(elementItem.getText());
            pitem.setBizOrgProperty(elementItem.getAttributeValue("orgproperty"));
            pitem.setBizOrgColumn(elementItem.getAttributeValue("orgcolumn"));
            pitem.setTable(TableTypeEnum.getTableType(elementItem.getAttributeValue("table")));
            pitem.setLangProfix(this.langProfix);
            item = pitem;
        } else if (itemType.equals("entity")) {
            EntityItem entity;
            String key = elementItem.getAttributeValue("entity");
            EntityItem eitem = null;
            if (key != null && (entity = this.getEntityFromDefinition(key)) != null) {
                try {
                    eitem = (EntityItem)entity.clone();
                    eitem.setName(elementItem.getText());
                }
                catch (CloneNotSupportedException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (eitem == null) {
                eitem = new EntityItem(elementItem.getText(), elementItem.getAttributeValue("bostype"));
                eitem.setBillTypeId(elementItem.getAttributeValue(BILLTYPEID));
            }
            String link = elementItem.getAttributeValue("link");
            eitem.setLink(link);
            eitem.setFilter(elementItem.getAttributeValue("filter"));
            item = eitem;
        } else if (itemType.equals("list")) {
            ListItem litem = new ListItem(null);
            List subElementList = elementItem.getChildren();
            int size = subElementList.size();
            for (int i = 0; i < size; ++i) {
                Element subElement = (Element)subElementList.get(i);
                litem.addSubValue(this.parseConditionItem(subElement, subElement.getAttributeValue("type")));
            }
            item = litem;
        } else if (itemType.equals("interface")) {
            InterfaceItem inf;
            String key = elementItem.getAttributeValue("interface");
            String paramsValue = elementItem.getAttributeValue("paramsvalue");
            InterfaceItem iitem = null;
            if (key != null && (inf = (InterfaceItem)this.interfaceMap.get(key)) != null) {
                try {
                    iitem = (InterfaceItem)inf.clone();
                    iitem.setName(elementItem.getText());
                    iitem.setParamsValue(paramsValue.split("\\s*;\\s*"));
                }
                catch (CloneNotSupportedException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (iitem == null) {
                String paramsType = elementItem.getAttributeValue("paramstype");
                iitem = new InterfaceItem(elementItem.getText(), elementItem.getAttributeValue("bostype"), elementItem.getAttributeValue("method"), elementItem.getAttributeValue("objtype"), paramsType.split(";"), paramsValue != null ? paramsValue.split("\\s*;\\s*") : null, elementItem.getAttributeValue("returntype"));
            }
            item = iitem;
        } else if (itemType.equals("composite")) {
            item = new CompositeItem(elementItem.getText());
            List subElementList = elementItem.getChildren();
            int size = subElementList.size();
            for (int i = 0; i < size; ++i) {
                Element subElement = (Element)subElementList.get(i);
                ((CompositeItem)item).addSubValue(this.parseConditionItem(subElement, subElement.getAttributeValue("type")));
            }
        } else if (itemType.equals("if")) {
            item = new IFItem(elementItem.getText());
            IFItem ifValue = (IFItem)item;
            List ifElementList = elementItem.getChildren();
            int size = ifElementList.size();
            if (size < 2) {
                throw new IllegalArgumentException("The if in subValue must be contains 2 elements in xml");
            }
            Element ifElement = (Element)ifElementList.get(0);
            List inIfElementList = ifElement.getChildren();
            size = inIfElementList.size();
            if (size < 2) {
                throw new IllegalArgumentException("The if in subValue must be contains 2 elements in xml");
            }
            ifValue.setIfConditions(this.parseConditions((Element)inIfElementList.get(0)));
            Element subValue = (Element)inIfElementList.get(1);
            ifValue.setIfValue(this.parseConditionItem(subValue, subValue.getAttributeValue("type")));
            Element elseElement = (Element)ifElementList.get(1);
            List elseElementList = elseElement.getChildren();
            size = elseElementList.size();
            if (size < 1) {
                throw new IllegalArgumentException("The else in subValue must be contains 1 element in xml");
            }
            subValue = (Element)elseElementList.get(0);
            ifValue.setElseValue(this.parseConditionItem(subValue, subValue.getAttributeValue("type")));
        }
        if (item != null) {
            item.setCalculate(elementItem.getAttributeValue("calculate"));
        }
        return item;
    }
}

