/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.app.BusinessProcessSqlBuilder;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.PropertyCheckConfigItems;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class BusinessProcessorHelper {
    private static Logger logger = Logger.getLogger(BusinessProcessorHelper.class);
    private static boolean isDebug = logger.getLevel() != null && logger.getLevel().equals((Object)Level.DEBUG);

    public static String getHeadTableName(Context ctx, String billTypeID) throws BOSException {
        return BusinessConfigurationCache.getTableName(ctx, billTypeID, TableTypeEnum.HEAD);
    }

    public static String getHeadTableNameByBosType(Context ctx, String bosType) throws BOSException {
        return BusinessConfigurationCache.getTableNameByBosType(ctx, bosType, TableTypeEnum.HEAD);
    }

    public static String getEntryTableName(Context ctx, String bosType) throws BOSException {
        return BusinessConfigurationCache.getTableName(ctx, bosType, TableTypeEnum.ENTRY);
    }

    public static String getEntryTableNameByBosType(Context ctx, String billTypeID) throws BOSException {
        return BusinessConfigurationCache.getTableNameByBosType(ctx, billTypeID, TableTypeEnum.ENTRY);
    }

    public static String getBillName(Context ctx, String billTypeID) throws BOSException {
        return BusinessConfigurationCache.getBillName(ctx, billTypeID);
    }

    public static BusinessProcessConfigItem getBusinessProcessConfigItem(Context ctx, String billTypeId, String action) throws BOSException {
        return BusinessProcessSqlBuilder.getInstance(ctx).getBusinessProcessConfigItem(ctx, billTypeId, action);
    }

    public static BusinessProcessConfigItem getBusinessProcessConfigItem(Context ctx, BOSObjectType bosType, String action) throws BOSException {
        return BusinessProcessSqlBuilder.getInstance(ctx).getBusinessProcessConfigItem(ctx, bosType, action);
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static void debugWriteBack(Context ctx, IRowSet rsOld, IRowSet rsNew, String srcBillTypeId, String dstBillTypeId) throws SQLException, BOSException {
        if (rsOld != null && rsNew != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(BusinessProcessorHelper.getBillName(ctx, dstBillTypeId)).append("\u53cd\u5199").append(BusinessProcessorHelper.getBillName(ctx, srcBillTypeId)).append("------------------").append("\r\n");
            int colsize = rsOld.getRowSetMetaData().getColumnCount();
            String TAB = "\t";
            sb.append("\u7f16\u53f7[\u76ee\u6807\u5355]").append(TAB).append("\u5e8f\u53f7[\u76ee\u6807\u5355]").append(TAB).append("\u7f16\u53f7[\u6e90\u5355]").append(TAB).append("\u5e8f\u53f7[\u6e90\u5355]").append(TAB);
            for (int j = 8; j <= colsize; ++j) {
                sb.append(rsOld.getRowSetMetaData().getColumnName(j)).append("\t");
            }
            sb.append("\r\n");
            boolean isDecimal = false;
            DecimalFormat df = new DecimalFormat();
            while (rsOld.next() && rsNew.next()) {
                for (int j = 1; j <= colsize; ++j) {
                    boolean bl = isDecimal = rsOld.getRowSetMetaData().getColumnType(j) == 3;
                    sb.append(isDecimal ? (rsOld.getBigDecimal(j) != null ? df.format(rsOld.getBigDecimal(j)) : "null") : rsOld.getObject(j));
                    if (j >= 5) {
                        sb.append("->").append(isDecimal ? (rsNew.getBigDecimal(j) != null ? df.format(rsNew.getBigDecimal(j)) : "null") : rsNew.getObject(j));
                    }
                    sb.append("\t");
                }
                sb.append("\r\n");
            }
            logger.debug((Object)sb.toString());
        }
    }

    public static void debugSql(String name, String sql, Object[] params) {
        if (BusinessProcessorHelper.isDebug()) {
            StringBuffer sb = new StringBuffer();
            sb.append(name).append(": SQL").append("\r\n").append(sql).append("\r\n").append("\u53c2\u6570").append("\r\n");
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    sb.append(params[i] != null ? params[i].toString() : "[NULL]").append("\r\n");
                }
            }
            logger.debug((Object)sb.toString());
        }
    }

    public static void batchLoadBizObjects(Context ctx, BOSObjectType bosType, String action, String billTypeID, BatchActionResults batchResults) throws EASBizException, BOSException {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            Set idSet = batchResults.getToDoIdsSet();
            BusinessProcessConfigItem bpConfigItem = BusinessProcessSqlBuilder.getInstance(ctx).getBusinessProcessConfigItem(ctx, bosType, action);
            if (bpConfigItem == null) {
                return;
            }
            PropertyCheckConfigItems checkItems = (PropertyCheckConfigItems)bpConfigItem.getCheckItems();
            List selectorList = checkItems.getSelectorList(ctx);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            BusinessProcessorHelper.addSelector(view, checkItems.getSelectorList(ctx));
            Iterator iter = selectorList.iterator();
            while (iter.hasNext()) {
                view.getSelector().add((SelectorItemInfo)iter.next());
            }
            BusinessProcessorHelper.addSelector(view, batchResults.getAddedSelector());
            IObjectCollection collection = BusinessProcessorHelper.loadObjectCollection(ctx, bosType, view);
            batchResults.setObjCollection(collection);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void batchLoadBizObjectsManual(Context ctx, BOSObjectType bosType, String action, String billTypeID, BatchActionResults batchResults) throws EASBizException, BOSException {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            Set idSet = batchResults.getToDoIdsSet();
            ArrayList selectorList = new ArrayList();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            Iterator iter = selectorList.iterator();
            while (iter.hasNext()) {
                view.getSelector().add((SelectorItemInfo)iter.next());
            }
            BusinessProcessorHelper.addSelector(view, batchResults.getAddedSelector());
            IObjectCollection collection = BusinessProcessorHelper.loadObjectCollection(ctx, bosType, view);
            batchResults.setObjCollection(collection);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void addSelector(EntityViewInfo view, List selectorList) {
        if (selectorList == null) {
            return;
        }
        Iterator iter = selectorList.iterator();
        while (iter.hasNext()) {
            view.getSelector().add((SelectorItemInfo)iter.next());
        }
    }

    public static IObjectCollection loadObjectCollection(Context ctx, BOSObjectType bosType, EntityViewInfo view) throws BOSException, EASBizException {
        IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface(ctx, bosType);
        Method mGetCollection = BusinessProcessUtil.getCollectionMethod(ctx, bosType);
        return (IObjectCollection)BusinessProcessUtil.invokeBizMethod(iBiz, mGetCollection, new Object[]{view});
    }

    public static void outpurtDebug(String message) {
        logger.debug((Object)message);
    }
}

