/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessResource;
import com.kingdee.eas.dynbusiness.config.TableCheckConfigItems;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class TableCheckHandler
implements IBusinessBatchHandle {
    private final TableCheckConfigItems items;
    private String tempTableName;

    public TableCheckHandler(TableCheckConfigItems items, String tempTableName) {
        this.items = items;
        this.tempTableName = tempTableName;
    }

    @Override
    public void handle(Context ctx, BatchActionResults batchResults) throws BOSException {
        if (!this.items.isInitialized()) {
            this.items.build(ctx);
        }
        if (this.items.getCheckSql() == null) {
            return;
        }
        String[] idsArray = batchResults.getToDoIdsArray();
        if (idsArray == null || idsArray.length == 0) {
            return;
        }
        String sql = this.items.getCheckSql();
        int size = this.items.getCheckItems().size();
        if (size > 0) {
            String bindMarks = DBUtil.getBindMarks(idsArray.length);
            if (this.tempTableName != null) {
                sql = sql.replaceAll("@TABLE", this.tempTableName);
            }
            sql = sql.replaceAll("\\?\\?\\?", bindMarks);
            Object[] thisParams = new Object[idsArray.length * size];
            for (int i = 0; i < size; ++i) {
                System.arraycopy(idsArray, 0, thisParams, i * idsArray.length, idsArray.length);
            }
            BusinessProcessorHelper.debugSql("\u4e1a\u52a1\u6821\u9a8c", sql, thisParams);
            this.handleCheck(ctx, sql, thisParams, batchResults);
        }
    }

    private void handleCheck(Context ctx, String sql, Object[] params, BatchActionResults batchResults) throws BOSException {
        boolean isHead = true;
        if (this.items.getParent() instanceof BusinessProcessConfigItem && ((BusinessProcessConfigItem)this.items.getParent()).getActionLevel().equals((Object)ActionLevelEnum.ENTRY)) {
            isHead = false;
        }
        IRowSet rs = DBUtil.executeQuery(ctx, sql, params);
        try {
            while (rs.next()) {
                BusinessCheckConfigItem checkItem = (BusinessCheckConfigItem)this.items.getCheckItems().get(rs.getString(2));
                BusinessResource resource = checkItem.getResource();
                batchResults.addError(isHead ? rs.getString(1) : rs.getString(3), resource.getMessage(ctx, ""));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage() + "\r\nThe SQL is:" + sql);
        }
    }

    public TableCheckHandler(TableCheckConfigItems items) {
        this.items = items;
    }
}

