/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.monitor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.common.perf.IJobInstStatusFacade;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.dynbusiness.adv.chain.BusinessProcessorInfo;
import com.kingdee.eas.dynbusiness.app.monitor.CountProgressModel;
import com.kingdee.eas.dynbusiness.app.monitor.ExecuteAdapter;
import com.kingdee.eas.dynbusiness.app.monitor.ExecuteEvent;
import com.kingdee.eas.dynbusiness.app.monitor.IProgressModel;
import com.kingdee.eas.dynbusiness.util.ResourceUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProgressExecuteListener
extends ExecuteAdapter {
    private static Logger logger = Logger.getLogger(ProgressExecuteListener.class);
    private static final String RES_BIZCHAIN = "com.kingdee.eas.dynbusiness.adv.chain.BusinessChainResource";
    private static BigDecimal PROCESSOR_TOTAL_WEIGHT = new BigDecimal("0.98");
    private Context ctx;
    private String jobId;
    private int totalCount;
    private int currProgress;
    private Map<String, BusinessProcessorInfo> allProcessorMap;
    private Map<String, BusinessProcessorInfo> doneCheckMap;
    private Map<String, BusinessProcessorInfo> doneProcessMap;
    private IProgressModel progressModel;
    private IJobInstStatusFacade iJobInstStatusFacade;

    public ProgressExecuteListener(Context ctx, String jobId) {
        this.ctx = ctx;
        this.jobId = jobId;
        this.allProcessorMap = new HashMap<String, BusinessProcessorInfo>();
        this.doneCheckMap = new HashMap<String, BusinessProcessorInfo>();
        this.doneProcessMap = new HashMap<String, BusinessProcessorInfo>();
        try {
            this.iJobInstStatusFacade = JobInstStatusFacadeFactory.getLocalInstance((Context)this.ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("init JobInstStatusFacade error: " + e.getMessage()));
        }
    }

    public boolean addProcessor(BusinessProcessorInfo info) {
        if (info == null) {
            return false;
        }
        this.allProcessorMap.put(info.getImplementClass(), info);
        ++this.totalCount;
        return true;
    }

    @Override
    public void beginCheck(ExecuteEvent e) {
        BusinessProcessorInfo info = this.allProcessorMap.get(e.getSource().getClass().getName());
        if (info == null) {
            return;
        }
        this.currProgress = this.calcProgress();
        String detailMessage = ResourceUtils.getMessage(RES_BIZCHAIN, "EXECUTE_CHECK", new String[]{info.getName()});
        this.updateProgress(this.currProgress, detailMessage);
    }

    @Override
    public void beginDoProcess(ExecuteEvent e) {
        BusinessProcessorInfo info = this.allProcessorMap.get(e.getSource().getClass().getName());
        if (info == null) {
            return;
        }
        this.currProgress = this.calcProgress();
        String detailMessage = ResourceUtils.getMessage(RES_BIZCHAIN, "EXECUTE_PROCESS", new String[]{info.getName()});
        this.updateProgress(this.currProgress, detailMessage);
    }

    @Override
    public void endCheck(ExecuteEvent e) {
        BusinessProcessorInfo info = this.allProcessorMap.get(e.getSource().getClass().getName());
        if (info == null) {
            return;
        }
        this.doneCheckMap.put(info.getImplementClass(), info);
    }

    @Override
    public void endDoProcess(ExecuteEvent e) {
        BusinessProcessorInfo info = this.allProcessorMap.get(e.getSource().getClass().getName());
        if (info == null) {
            return;
        }
        this.doneProcessMap.put(info.getImplementClass(), info);
    }

    private int calcProgress() {
        BigDecimal result = new BigDecimal("0");
        if (this.progressModel == null) {
            this.progressModel = this.getProgressModel();
        }
        Iterator<BusinessProcessorInfo> it = this.doneCheckMap.values().iterator();
        while (it.hasNext()) {
            result = result.add(this.progressModel.getDoCheckWeight(it.next()));
        }
        it = this.doneProcessMap.values().iterator();
        while (it.hasNext()) {
            result = result.add(this.progressModel.getDoProcessWeight(it.next()));
        }
        result = result.multiply(PROCESSOR_TOTAL_WEIGHT);
        return result.intValue();
    }

    private IProgressModel getProgressModel() {
        return new CountProgressModel(this.totalCount);
    }

    private void updateProgress(int progress, String detailMessage) {
        if (this.jobId == null || this.jobId.length() == 0) {
            return;
        }
        try {
            if (this.iJobInstStatusFacade != null) {
                this.iJobInstStatusFacade.updateProgress(this.jobId, progress, "", detailMessage, "");
            }
        }
        catch (BOSException e) {
            logger.error((Object)("update business chain execute status error:" + e.getMessage()));
        }
    }
}

