/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlPluginConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlRootConfigParser;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import org.apache.log4j.Logger;

public final class BusinessConfigFactory {
    private static BusinessConfigFactory businessConfigFactory;
    private static final Logger logger;

    private BusinessConfigFactory() {
    }

    private static synchronized void initiate(Context ctx) throws BOSException {
        if (businessConfigFactory == null) {
            businessConfigFactory = new BusinessConfigFactory();
            logger.debug((Object)"\u52a8\u6001\u4e1a\u52a1\u914d\u7f6e\u7f13\u5b58\u521d\u59cb\u5316\u5f00\u59cb......");
            BusinessConfigurationCache.getCache();
            BusinessConfigurationCache.initiate(ctx);
            logger.debug((Object)"\u52a8\u6001\u4e1a\u52a1\u914d\u7f6e\u7f13\u5b58\u521d\u59cb\u5316\u7ed3\u675f\uff01");
            XmlParserContext parserContext = new XmlParserContext(ctx, null);
            AbstractXmlConfigParser parser = new XmlRootConfigParser();
            parser.parse(parserContext);
            parser = new XmlPluginConfigParser();
            parser.parse(parserContext);
        }
    }

    public static BusinessConfigFactory getInstance(Context ctx) throws BOSException {
        if (businessConfigFactory == null) {
            BusinessConfigFactory.initiate(ctx);
        }
        return businessConfigFactory;
    }

    public IBusinessConfigItem getBusinessProcessConfig(ExecuteContext executeContext) throws BOSException {
        return BusinessConfigurationCache.getCache().getBusinessProcessConfigItem(executeContext);
    }

    static {
        logger = Logger.getLogger(BusinessConfigFactory.class);
    }
}

