/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.parsing.BOTProcessSubItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessProcessConfigItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.IXmlConfigItemVisitor;
import com.kingdee.eas.dynbusiness.app.parsing.WriteBackSubItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionItemConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.condition.IPropertySupport;
import com.kingdee.eas.dynbusiness.config.ActionItem;
import com.kingdee.eas.dynbusiness.config.ActionItemList;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class XmlActionListConfigParser
implements IXmlConfigItemVisitor {
    private XmlParserContext parserContext;

    private ActionItemList parseActionItemList(Object item, Element elementActions) throws XmlConfigParseException {
        if (elementActions == null) {
            return null;
        }
        ActionItemList actionList = new ActionItemList(item, ProcessorExecutionMode.getProcessorExecutionMode(elementActions.getAttributeValue("execution")), elementActions.getAttributeValue("state"));
        List listActions = elementActions.getChildren();
        ArrayList<ActionItem> actions = new ArrayList<ActionItem>();
        int subsize = listActions.size();
        for (int i = 0; i < subsize; ++i) {
            actions.add(this.parseActionItem((Element)listActions.get(i), i, actionList));
        }
        actionList.setActionList(actions);
        return actionList;
    }

    private ActionItem parseActionItem(Element elementAction, int seq, ActionItemList subItem) throws XmlConfigParseException {
        String type = elementAction.getAttributeValue("type");
        ActionItem actionItem = null;
        if (type != null && type.equals("sql")) {
            Element elementSql = (Element)elementAction.getChildren().get(0);
            actionItem = new ActionItem(subItem, elementSql.getText(), type, elementSql.getAttributeValue("updateto"));
        } else {
            if (type != null && type.equals("interface")) {
                actionItem = new ActionItem(subItem, elementAction.getText().toUpperCase(), type, seq);
                XmlConditionItemConfigParser parser = new XmlConditionItemConfigParser();
                this.parserContext.setRoot(elementAction);
                this.parserContext.setItemType(type);
                actionItem.setInterfaceItem((IPropertySupport)((Object)parser.parse(this.parserContext)));
            } else {
                String paramsType;
                String strEnum = elementAction.getAttributeValue("enum");
                actionItem = new ActionItem(subItem, elementAction.getText().toUpperCase(), strEnum == null ? -100 : Integer.parseInt(strEnum), seq);
                String method = elementAction.getAttributeValue("method");
                if (method != null) {
                    actionItem.setMethod(method);
                }
                if ((paramsType = elementAction.getAttributeValue("paramstype")) != null) {
                    actionItem.setParamsType(paramsType.split("\\s*;\\s*"));
                }
            }
            String reload = elementAction.getAttributeValue("reload");
            if (reload != null) {
                actionItem.setReload(Boolean.valueOf(reload));
            }
            actionItem.setPreCondition(elementAction.getAttributeValue("precondition"));
        }
        actionItem.setLogServiceParam(elementAction.getAttributeValue("logservice"));
        return actionItem;
    }

    @Override
    public void visitBOTConfigItems(BOTProcessSubItemVisitable visitable) throws XmlConfigParseException {
        this.parserContext = visitable.getParserContext();
        Element nextElement = this.parserContext.getRoot();
        ActionItemList actionList = this.parseActionItemList(visitable.getItem(), nextElement);
        if (actionList == null) {
            return;
        }
        visitable.getItem().setActionItems(actionList);
    }

    @Override
    public void visitBusinessProcessConfigItem(BusinessProcessConfigItemVisitable visitable) throws XmlConfigParseException {
        this.parserContext = visitable.getParserContext();
        Element nextElement = this.parserContext.getRoot();
        ActionItemList actionList = this.parseActionItemList(visitable.getItem(), nextElement);
        if (actionList == null) {
            return;
        }
        visitable.getItem().setActionList(actionList);
    }

    @Override
    public void visitWriteBackSubItem(WriteBackSubItemVisitable visitable) throws XmlConfigParseException {
    }
}

