/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.condition.EntityItem;
import com.kingdee.eas.dynbusiness.config.BusinessObjectStructure;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import java.util.List;
import org.jdom2.Element;

public class XmlBOStructureParser
extends AbstractXmlConfigParser {
    private XmlParserContext pc;

    @Override
    public IBusinessConfigItem parse(ParserContext parserContext) throws XmlConfigParseException {
        this.pc = (XmlParserContext)parserContext;
        return this.parseStructure(this.pc.getRoot());
    }

    private IBusinessConfigItem parseStructure(Element element) throws XmlConfigParseException {
        if (!"structure".equalsIgnoreCase(element.getName())) {
            return null;
        }
        BusinessObjectStructure.LevelStructure[] structures = new BusinessObjectStructure.LevelStructure[3];
        List eleList = element.getChildren();
        for (int i = 0; i < eleList.size(); ++i) {
            BusinessObjectStructure.LevelStructure ls;
            Element child = (Element)eleList.get(i);
            structures[ls.getLevel()] = ls = this.parseLevelStructure(child);
        }
        BusinessObjectStructure boStructure = new BusinessObjectStructure(structures);
        return boStructure;
    }

    private BusinessObjectStructure.LevelStructure parseLevelStructure(Element element) throws XmlConfigParseException {
        BusinessObjectStructure.LevelStructure levelStructure = new BusinessObjectStructure.LevelStructure();
        String value = element.getAttributeValue("value");
        if (value != null) {
            levelStructure.setLevel(Integer.parseInt(value));
        }
        Element first = (Element)element.getChildren().get(0);
        levelStructure.setEntity(this.parseEntityStructure(first));
        return levelStructure;
    }

    private BusinessObjectStructure.EntityStructure parseEntityStructure(Element element) throws XmlConfigParseException {
        List children;
        BusinessObjectStructure.EntityStructure entity = new BusinessObjectStructure.EntityStructure();
        String name = element.getAttributeValue("name");
        String bosType = element.getAttributeValue("bostype");
        if (name != null && bosType == null) {
            EntityItem entityItem = BusinessConfigurationCache.cache.getEntityFromDefinition(name);
            bosType = entityItem.getBosType();
        }
        try {
            EntityObjectInfo eo = BusinessProcessUtil.getEntityEntriesEntity(this.pc.getContext(), BOSObjectType.create((String)bosType));
            name = eo.getName();
            entity.setName(name);
            entity.setBosType(bosType);
            entity.setTableName(eo.getTable().getName());
            entity.setAlias(eo.getAlias());
        }
        catch (BOSException e) {
            throw new XmlConfigParseException(e);
        }
        entity.setLinkToParent(element.getAttributeValue("linkToParent"));
        String relation = element.getAttributeValue("relation");
        if (relation != null) {
            String[] rels = relation.split("\\.");
            if (rels.length == 1) {
                entity.setRalationTable(TableTypeEnum.HEAD);
                entity.setRelation(rels[0]);
            } else {
                entity.setRalationTable(TableTypeEnum.getTableType(rels[0].toLowerCase()));
                entity.setRelation(rels[1]);
            }
        }
        if ((children = element.getChildren()) != null && children.size() > 0) {
            int size = children.size();
            BusinessObjectStructure.EntityStructure[] entries = new BusinessObjectStructure.EntityStructure[size];
            for (int i = 0; i < size; ++i) {
                Element child = (Element)children.get(i);
                entries[i] = this.parseEntityStructure(child);
            }
            entity.setEntries(entries);
        }
        return entity;
    }
}

