/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.BOTProcessSubItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessProcessConfigItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.IXmlConfigItemVisitor;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.WriteBackSubItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionsConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItems;
import com.kingdee.eas.dynbusiness.config.PropertyCheckConfigItems;
import com.kingdee.eas.dynbusiness.config.TableCheckConfigItems;
import java.util.List;
import org.jdom2.Element;

public class XmlCheckItemsConfigParser
extends AbstractXmlConfigParser
implements IXmlConfigItemVisitor {
    private XmlParserContext pc;

    @Override
    public IBusinessConfigItem parse(ParserContext parserContext) throws XmlConfigParseException {
        return null;
    }

    private BusinessCheckConfigItems parseCheckItems(Element elementCheckItems, Object parent) throws XmlConfigParseException {
        if (!elementCheckItems.getName().equals("checkitems")) {
            return null;
        }
        List listCheckItems = elementCheckItems.getChildren();
        BusinessCheckConfigItems checkItems = elementCheckItems.getAttribute("type") != null && elementCheckItems.getAttributeValue("type").equalsIgnoreCase("table") ? new TableCheckConfigItems(parent) : new PropertyCheckConfigItems(parent);
        int sizeCheckItems = listCheckItems.size();
        for (int idxOfCheck = 0; idxOfCheck < sizeCheckItems; ++idxOfCheck) {
            List listCheckItem;
            int sizeCheckItem;
            String srcbillid;
            Element elementCheckItem = (Element)listCheckItems.get(idxOfCheck);
            if (elementCheckItem.getName().equalsIgnoreCase("preconditions")) {
                throw new IllegalArgumentException("preconditions should be the first item in processitem.");
            }
            BusinessCheckConfigItem checkItem = new BusinessCheckConfigItem();
            checkItem.setId(elementCheckItem.getAttributeValue("id"));
            checkItem.setValidation(elementCheckItem.getAttributeValue("validation"));
            String ignore = elementCheckItem.getAttributeValue("ignore");
            if (ignore != null) {
                checkItem.setCanIgnore(Boolean.valueOf(ignore));
            }
            if ((srcbillid = elementCheckItem.getAttributeValue("srcbillid")) != null) {
                checkItem.setSrcBillIds(this.parseSrcBillIds(srcbillid));
            }
            if ((sizeCheckItem = (listCheckItem = elementCheckItem.getChildren()).size()) < 2) {
                throw new IllegalArgumentException("The checkitem must be contains 2 elements in xml.");
            }
            Element firstElement = (Element)listCheckItem.get(0);
            if (firstElement.getName().equalsIgnoreCase("conditions")) {
                this.pc.setRoot(firstElement);
                checkItem.setConditions((Conditions)new XmlConditionsConfigParser().parse(this.pc));
            } else {
                checkItem.setProperties(this.parseProperties(firstElement));
            }
            Element elementMessage = (Element)listCheckItem.get(1);
            checkItem.setResource(this.parseResource(elementMessage));
            checkItems.add(checkItem);
        }
        return checkItems;
    }

    @Override
    public void visitBusinessProcessConfigItem(BusinessProcessConfigItemVisitable visitable) throws XmlConfigParseException {
        this.pc = visitable.getParserContext();
        Element nextElement = this.pc.getRoot();
        BusinessCheckConfigItems checkItems = this.parseCheckItems(nextElement, visitable.getItem());
        if (checkItems == null) {
            return;
        }
        visitable.getItem().setCheckItems(checkItems);
    }

    @Override
    public void visitWriteBackSubItem(WriteBackSubItemVisitable visitable) throws XmlConfigParseException {
        this.pc = visitable.getParserContext();
        Element nextElement = this.pc.getRoot();
        BusinessCheckConfigItems checkItems = this.parseCheckItems(nextElement, visitable.getItem());
        if (checkItems == null) {
            return;
        }
        visitable.getItem().setCheckItems(checkItems);
    }

    @Override
    public void visitBOTConfigItems(BOTProcessSubItemVisitable visitable) throws XmlConfigParseException {
    }
}

