/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionItemConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.condition.Condition;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class XmlConditionsConfigParser
extends AbstractXmlConfigParser {
    private XmlParserContext parserContext;

    @Override
    public IBusinessConfigItem parse(ParserContext parserContext) throws XmlConfigParseException {
        Element root = ((XmlParserContext)parserContext).getRoot();
        if (root.getName().equalsIgnoreCase("conditions")) {
            this.parserContext = (XmlParserContext)parserContext;
            return this.parseConditions(((XmlParserContext)parserContext).getRoot());
        }
        return null;
    }

    private Conditions parseConditions(Element conditionsElement) throws XmlConfigParseException {
        XmlConditionItemConfigParser parser = new XmlConditionItemConfigParser();
        if (conditionsElement == null || conditionsElement.getChildren().size() == 0) {
            return null;
        }
        ArrayList<Condition> conditionsList = new ArrayList<Condition>();
        List condElementList = conditionsElement.getChildren();
        int conssize = condElementList.size();
        for (int idxOfCons = 0; idxOfCons < conssize; ++idxOfCons) {
            Element conditionElement = (Element)condElementList.get(idxOfCons);
            List conditionList = conditionElement.getChildren();
            if (conditionList == null || conditionList.size() == 0 || conditionList == null || conditionList.size() <= 0) continue;
            if (conditionList.size() < 3) {
                throw new IllegalArgumentException("The Condition must be contains 3 elements in xml.");
            }
            Condition condition = new Condition();
            Element conditionItem = (Element)conditionList.get(0);
            this.parserContext.setRoot(conditionItem);
            this.parserContext.setItemType(conditionItem.getName());
            ConditionItem item = (ConditionItem)parser.parse(this.parserContext);
            condition.setItem(item);
            conditionItem = (Element)conditionList.get(1);
            condition.setComparison(conditionItem.getText().trim());
            conditionItem = (Element)conditionList.get(2);
            this.parserContext.setRoot(conditionItem);
            this.parserContext.setItemType(conditionItem.getAttributeValue("type"));
            condition.setValue((ConditionItem)parser.parse(this.parserContext));
            conditionsList.add(condition);
        }
        Conditions conditions = new Conditions();
        conditions.setId(conditionsElement.getAttributeValue("id"));
        conditions.setConditions(conditionsList);
        conditions.setLinkMask(conditionsElement.getAttributeValue("linkmask"));
        return conditions;
    }
}

