/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlFileReader;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlWholeConfigParser;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItems;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom2.Element;

public final class XmlConfigProxy {
    public static final XmlConfigProxy xmlConfigProxy = new XmlConfigProxy();
    private HashMap billMap = new HashMap();

    private XmlConfigProxy() {
    }

    public void putBizFilePath(String bosType, String filePath) {
        if (bosType == null) {
            return;
        }
        this.billMap.put(bosType, filePath);
    }

    public String getBizFilePath(String bosType) {
        return (String)this.billMap.get(bosType);
    }

    public boolean parseProcessXml(ExecuteContext executeContext) throws BOSException {
        String bosType = executeContext.getBosType().toString();
        if (!this.billMap.containsKey(bosType) && executeContext.getXmlFileName() != null) {
            this.billMap.put(bosType, executeContext.getXmlFileName());
        }
        String xmlFileName = (String)this.billMap.get(bosType);
        if (executeContext.isForceToParseEveryTime()) {
            if (executeContext.getXmlFileName() != null) {
                xmlFileName = executeContext.getXmlFileName();
            } else if (xmlFileName.endsWith("!OK")) {
                xmlFileName = xmlFileName.substring(0, xmlFileName.length() - 3);
            }
        }
        if (xmlFileName == null || xmlFileName.endsWith("!OK")) {
            return false;
        }
        BusinessProcessConfigItems bpCfgItems = this.parseProcessXml(executeContext.getContext(), xmlFileName);
        Map thisMap = this.mergeCfgItem(bpCfgItems);
        BusinessConfigurationCache.getCache().putConfigItemInCache(thisMap);
        this.billMap.put(bosType, xmlFileName + "!OK");
        return true;
    }

    public BusinessProcessConfigItems parseProcessXml(Context ctx, String xmlFileName) throws XmlConfigParseException {
        if (xmlFileName == null) {
            return null;
        }
        BusinessProcessConfigItems bpCfgItems = null;
        String[] xmlFileNames = xmlFileName.split("\\s*;\\s*");
        XmlParserContext parserContext = new XmlParserContext(ctx, null);
        XmlFileReader xmlFilerReader = new XmlFileReader();
        for (int i = 0; i < xmlFileNames.length; ++i) {
            parserContext.setXmlFileName(xmlFileNames[i]);
            Element root = xmlFilerReader.read(parserContext);
            XmlWholeConfigParser parser = new XmlWholeConfigParser();
            parserContext.setRoot(root);
            bpCfgItems = (BusinessProcessConfigItems)parser.parse(parserContext);
        }
        return bpCfgItems;
    }

    private Map mergeCfgItem(BusinessProcessConfigItems bpcis) {
        HashMap<String, BusinessProcessConfigItem> toMergeMap = new HashMap<String, BusinessProcessConfigItem>();
        Iterator iter = bpcis.iterator();
        while (iter.hasNext()) {
            BusinessProcessConfigItem cfgItem = (BusinessProcessConfigItem)iter.next();
            String key = this.getKey(cfgItem.getBosType(), cfgItem.getAction());
            if (toMergeMap.containsKey(key)) {
                cfgItem.merge(toMergeMap.get(key));
                if (BusinessProcessorHelper.isDebug()) {
                    BusinessProcessorHelper.outpurtDebug("\u5904\u7406\u5355\u636e\u914d\u7f6e\u6587\u4ef6\u5408\u5e76");
                }
            }
            toMergeMap.put(key, cfgItem);
        }
        return toMergeMap;
    }

    private String getKey(String bosType, String action) {
        return bosType + action;
    }
}

