/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Element;

public class XmlFileReader {
    public Element read(ParserContext parserContext) throws XmlConfigParseException {
        XmlParserContext pc = (XmlParserContext)parserContext;
        String xmlFile = pc.getXmlFileName();
        if (xmlFile == null) {
            return null;
        }
        return this.parseRootXml(xmlFile);
    }

    private Element parseRootXml(String xmlFile) throws XmlConfigParseException {
        Element root;
        InputStream is = null;
        try {
            if (xmlFile.endsWith(".xml")) {
                xmlFile = xmlFile.substring(0, xmlFile.length() - 4);
            }
            if ((is = (xmlFile = xmlFile.replaceAll("\\.", "/") + ".xml").indexOf("/") < 0 ? this.getClass().getResourceAsStream(xmlFile) : this.getClass().getClassLoader().getResourceAsStream(xmlFile)) == null) {
                Element element = null;
                return element;
            }
            root = XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (Exception e) {
            throw new XmlConfigParseException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new XmlConfigParseException(e);
            }
        }
        return root;
    }
}

