/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigProxy;
import com.kingdee.eas.dynbusiness.app.parsing.XmlFileReader;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlWholeConfigParser;
import com.kingdee.eas.dynbusiness.condition.EntityItem;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class XmlRootConfigParser
extends AbstractXmlConfigParser {
    private static final String xmlFile = "com.kingdee.eas.dynbusiness.app.bizprocessconfig";
    private static final Logger logger = Logger.getLogger(XmlRootConfigParser.class);

    @Override
    public IBusinessConfigItem parse(ParserContext parserContext) throws XmlConfigParseException {
        logger.debug((Object)"\u52a8\u6001\u4e1a\u52a1\u914d\u7f6e\u603b\u5165\u53e3\u6587\u4ef6\u89e3\u6790\u5f00\u59cb......");
        XmlParserContext pc = (XmlParserContext)parserContext;
        pc.setXmlFileName(xmlFile);
        this.parseRootXml(parserContext);
        logger.debug((Object)"\u52a8\u6001\u4e1a\u52a1\u914d\u7f6e\u603b\u5165\u53e3\u6587\u4ef6\u89e3\u6790\u7ed3\u675f\uff01");
        return null;
    }

    private void parseRootXml(ParserContext parserContext) throws XmlConfigParseException {
        XmlFileReader xmlFileReader = new XmlFileReader();
        XmlParserContext pc = (XmlParserContext)parserContext;
        Element root = xmlFileReader.read(pc);
        List childrens = root.getChildren();
        int size = childrens.size();
        for (int i = 0; i < size; ++i) {
            EntityItem eitem;
            Element element = (Element)childrens.get(i);
            String rootXml = element.getAttributeValue("root");
            if (rootXml != null) {
                logger.debug((Object)("\u627e\u5230\u5b50\u5165\u53e3\u6587\u4ef6" + rootXml + "......"));
                pc.setXmlFileName(rootXml);
                this.parseRootXml(pc);
                continue;
            }
            String bill = element.getAttributeValue("bill");
            String bosType = element.getAttributeValue("bostype");
            String ref = element.getAttributeValue("ref");
            if (bill != null && (eitem = this.getEntityFromDefinition(bill)) != null && bosType == null) {
                bosType = eitem.getBosType();
            }
            if (this.isInherited(bosType)) {
                pc.setXmlFileName(ref);
                Element refRoot = xmlFileReader.read(pc);
                XmlWholeConfigParser parser = new XmlWholeConfigParser();
                pc.setRoot(refRoot);
                parser.parse(pc);
                continue;
            }
            XmlConfigProxy.xmlConfigProxy.putBizFilePath(bosType, ref);
        }
    }
}

