/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.eas.dynbusiness.app.parsing.BOTProcessSubItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessProcessConfigItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.IXmlConfigItemVisitor;
import com.kingdee.eas.dynbusiness.app.parsing.WriteBackSubItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionsConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.config.UpdateStatusItem;
import com.kingdee.eas.dynbusiness.config.UpdatedColumn;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class XmlUpdateStatusConfigParser
implements IXmlConfigItemVisitor {
    private XmlParserContext parserContext;

    private UpdateStatusItem[] parseUpdateStatus(Element updStatusElement, String billTypeId, Object parent) throws XmlConfigParseException {
        if (!updStatusElement.getName().equals("updsrcstatuses")) {
            return null;
        }
        List updStatusList = updStatusElement.getChildren();
        UpdateStatusItem[] usItems = new UpdateStatusItem[updStatusList.size()];
        int subsize = updStatusList.size();
        for (int idxOfUpdStatus = 0; idxOfUpdStatus < subsize; ++idxOfUpdStatus) {
            Element subUpdStatusElement = (Element)updStatusList.get(idxOfUpdStatus);
            UpdateStatusItem updateStatusItem = this.parseAUpdateStatusItem(updStatusElement, billTypeId, parent, subUpdStatusElement);
            if (updateStatusItem == null) continue;
            usItems[idxOfUpdStatus] = updateStatusItem;
        }
        return usItems;
    }

    private UpdateStatusItem parseAUpdateStatusItem(Element updStatusElement, String billTypeId, Object parent, Element subUpdStatusElement) throws XmlConfigParseException {
        List subUpdStatusList = subUpdStatusElement.getChildren();
        if (subUpdStatusList == null || subUpdStatusList.size() == 0) {
            return null;
        }
        UpdateStatusItem updateStatusItem = new UpdateStatusItem(billTypeId, parent);
        updateStatusItem.setThisTable(subUpdStatusElement.getAttributeValue("table"));
        updateStatusItem.setThisAction(subUpdStatusElement.getAttributeValue("action"));
        updateStatusItem.setThisReversedAction(subUpdStatusElement.getAttributeValue("reversedaction"));
        int subSize = subUpdStatusList.size();
        Element firstElement = (Element)subUpdStatusList.get(0);
        int idx = 0;
        XmlConditionsConfigParser parser = new XmlConditionsConfigParser();
        if ("conditions".equalsIgnoreCase(firstElement.getName())) {
            this.parserContext.setRoot(firstElement);
            Conditions conditions = (Conditions)parser.parse(this.parserContext);
            if (conditions != null) {
                updateStatusItem.setThisConditions(conditions);
            }
        }
        int n = ++idx;
        Element updColumnsElement = (Element)subUpdStatusList.get(n);
        updateStatusItem.setUpdColumns(this.parseUpdColumns(updColumnsElement.getChildren()));
        if (subSize > ++idx) {
            Element infectionElement = (Element)subUpdStatusList.get(idx++);
            updateStatusItem.setInfectionTable(infectionElement.getAttributeValue("table"));
            updateStatusItem.setInfectionAction(infectionElement.getAttributeValue("action"));
            updateStatusItem.setInfectionReversedAction(infectionElement.getAttributeValue("reversedaction"));
            if (infectionElement.getChildren() != null && infectionElement.getChildren().size() > 0) {
                for (int i = 0; i < infectionElement.getChildren().size(); ++i) {
                    Element updColsInfection = (Element)infectionElement.getChildren().get(i);
                    if (updColsInfection.getName().equalsIgnoreCase("conditions")) {
                        this.parserContext.setRoot(updColsInfection);
                        updateStatusItem.setInfectConditons((Conditions)parser.parse(this.parserContext));
                        continue;
                    }
                    updateStatusItem.setInfectionUpdColumns(this.parseUpdColumns(updColsInfection.getChildren()));
                }
            }
        }
        return updateStatusItem;
    }

    private List parseUpdColumns(List updColumnsList) {
        if (updColumnsList != null && updColumnsList.size() > 0) {
            ArrayList<UpdatedColumn> updColumns = new ArrayList<UpdatedColumn>();
            int colsize = updColumnsList.size();
            for (int idxOfCol = 0; idxOfCol < colsize; ++idxOfCol) {
                Element colElement = (Element)updColumnsList.get(idxOfCol);
                UpdatedColumn updColumn = new UpdatedColumn();
                updColumn.setColumnName(colElement.getAttributeValue("name"));
                updColumn.setType(colElement.getAttributeValue("type"));
                updColumn.setValue(colElement.getAttributeValue("value"));
                updColumns.add(updColumn);
            }
            return updColumns;
        }
        return null;
    }

    @Override
    public void visitBusinessProcessConfigItem(BusinessProcessConfigItemVisitable visitable) throws XmlConfigParseException {
        String billTypeId;
        this.parserContext = visitable.getParserContext();
        Element nextElement = this.parserContext.getRoot();
        UpdateStatusItem[] usItems = this.parseUpdateStatus(nextElement, billTypeId = visitable.getItem().getBillTypeId(), visitable.getItem());
        if (usItems == null || usItems.length == 0) {
            return;
        }
        visitable.getItem().setUpdStatusItem(usItems[0]);
    }

    @Override
    public void visitWriteBackSubItem(WriteBackSubItemVisitable visitable) throws XmlConfigParseException {
        String billTypeId;
        this.parserContext = visitable.getParserContext();
        Element nextElement = this.parserContext.getRoot();
        UpdateStatusItem[] usItems = this.parseUpdateStatus(nextElement, billTypeId = (String)visitable.getItem().getSrcBillIds().get(visitable.getItem().getSrcBillIds().size() - 1), visitable.getItem());
        if (usItems == null) {
            return;
        }
        visitable.getItem().setUpdStatusItem(usItems);
    }

    @Override
    public void visitBOTConfigItems(BOTProcessSubItemVisitable visitable) throws XmlConfigParseException {
    }
}

