/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.parsing;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.dynbusiness.ColumnDataType;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.app.parsing.AbstractXmlConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.BOTProcessSubItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessConfigurationCache;
import com.kingdee.eas.dynbusiness.app.parsing.BusinessProcessConfigItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.IXmlConfigItemVisitor;
import com.kingdee.eas.dynbusiness.app.parsing.ParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.WriteBackSubItemVisitable;
import com.kingdee.eas.dynbusiness.app.parsing.XmlBOStructureParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlCheckItemsConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionItemConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConditionsConfigParser;
import com.kingdee.eas.dynbusiness.app.parsing.XmlConfigParseException;
import com.kingdee.eas.dynbusiness.app.parsing.XmlParserContext;
import com.kingdee.eas.dynbusiness.app.parsing.XmlUpdateStatusConfigParser;
import com.kingdee.eas.dynbusiness.condition.ColumnItem;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.condition.EntityItem;
import com.kingdee.eas.dynbusiness.config.BusinessObjectStructure;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.ColumnPair;
import com.kingdee.eas.dynbusiness.config.OneToManyWriteBackSubItem;
import com.kingdee.eas.dynbusiness.config.OneToOneWriteBackSubItem;
import com.kingdee.eas.dynbusiness.config.WriteBackConfigItem;
import com.kingdee.eas.dynbusiness.config.WriteBackPolicy;
import com.kingdee.eas.dynbusiness.config.WriteBackSubItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class XmlWriteBackConfigParser
extends AbstractXmlConfigParser
implements IXmlConfigItemVisitor {
    private XmlParserContext parserContext;

    @Override
    public IBusinessConfigItem parse(ParserContext parserContext) throws XmlConfigParseException {
        return null;
    }

    private WriteBackConfigItem parseWriteBackItem(Element element, String dstBillTypeId, String bosType, BusinessProcessConfigItem parent) throws XmlConfigParseException {
        if (!element.getName().equals("wbitems")) {
            return null;
        }
        WriteBackConfigItem configItem = null;
        if (element != null) {
            configItem = new WriteBackConfigItem(parent, ProcessorExecutionMode.getProcessorExecutionMode(element.getAttributeValue("execution")));
            List wbItems = element.getChildren();
            ArrayList<WriteBackSubItem> writebackItems = new ArrayList<WriteBackSubItem>();
            int size = wbItems.size();
            for (int idxOfwbItem = 0; idxOfwbItem < size; ++idxOfwbItem) {
                writebackItems.add(this.parseWriteBackSubItem((Element)wbItems.get(idxOfwbItem), dstBillTypeId, bosType, configItem));
            }
            configItem.setWritebackItems(writebackItems);
        }
        return configItem;
    }

    private BusinessObjectStructure parseBusinessObjectStructure(Element root) throws XmlConfigParseException {
        XmlBOStructureParser parser = new XmlBOStructureParser();
        this.parserContext.setRoot(root);
        return (BusinessObjectStructure)parser.parse(this.parserContext);
    }

    private WriteBackSubItem parseWriteBackSubItem(Element wbItemElement, String dstBillTypeId, String bosType, WriteBackConfigItem configItem) throws XmlConfigParseException {
        int idx;
        if (!wbItemElement.getName().equals("wbitem")) {
            return null;
        }
        List subItems = wbItemElement.getChildren();
        Element subItem = (Element)subItems.get(idx = 0);
        WriteBackSubItem writebackItem = subItem.getName().equalsIgnoreCase("policy") && subItem.getAttributeValue("type").equalsIgnoreCase("one-many") ? new OneToManyWriteBackSubItem(configItem, dstBillTypeId) : new OneToOneWriteBackSubItem(configItem, dstBillTypeId);
        writebackItem.setDstBosType(bosType);
        int level = Integer.valueOf(wbItemElement.getAttributeValue("level"));
        if (wbItemElement.getAttribute("type") != null) {
            writebackItem.setWriteTo(wbItemElement.getAttributeValue("type"), level);
        }
        writebackItem.setLevel(level);
        BusinessObjectStructure boStructure = null;
        if (wbItemElement.getAttribute("status") != null) {
            writebackItem.setStatus(wbItemElement.getAttributeValue("status"));
            String oldIdField = wbItemElement.getAttributeValue("oldIdField");
            if (oldIdField != null) {
                writebackItem.setOldIdField(oldIdField);
            }
        }
        if (subItem.getName().equalsIgnoreCase("policy")) {
            this.parseWriteBackPolicy(subItem);
            ++idx;
        } else if (subItem.getName().equalsIgnoreCase("structure")) {
            boStructure = this.parseBusinessObjectStructure(subItem);
            ++idx;
        }
        if (boStructure == null) {
            boStructure = this.parseSrcBills(wbItemElement, writebackItem, level);
        }
        writebackItem.setBoStructure(boStructure);
        Element nextElement = (Element)subItems.get(idx++);
        this.parserContext.setRoot(nextElement);
        AbstractXmlConfigParser parser = new XmlConditionsConfigParser();
        Conditions conditionsList = (Conditions)parser.parse(this.parserContext);
        writebackItem.setConditions(conditionsList);
        nextElement = (Element)subItems.get(idx++);
        HashMap<String, Conditions> condsMap = null;
        if (nextElement.getName().equalsIgnoreCase("signconditions")) {
            List condsList = nextElement.getChildren();
            int size = condsList.size();
            condsMap = new HashMap<String, Conditions>(size);
            for (int i = 0; i < size; ++i) {
                this.parserContext.setRoot((Element)condsList.get(i));
                Conditions conds = (Conditions)parser.parse(this.parserContext);
                condsMap.put(conds.getId(), conds);
            }
            nextElement = (Element)subItems.get(idx++);
        }
        writebackItem.setColumnPairs(this.parseColumnPairList(nextElement, condsMap));
        nextElement = (Element)subItems.get(idx++);
        this.parserContext.setRoot(nextElement);
        WriteBackSubItemVisitable visitable = new WriteBackSubItemVisitable(this.parserContext, writebackItem);
        XmlUpdateStatusConfigParser visitor = new XmlUpdateStatusConfigParser();
        visitable.accept(visitor);
        if (subItems.size() > idx) {
            parser = new XmlCheckItemsConfigParser();
            nextElement = (Element)subItems.get(idx++);
            this.parserContext.setRoot(nextElement);
            visitable.accept((IXmlConfigItemVisitor)((Object)parser));
        }
        return writebackItem;
    }

    private BusinessObjectStructure parseSrcBills(Element wbItemElement, WriteBackSubItem writebackItem, int level) throws XmlConfigParseException {
        List<String> srcBillTypes;
        String srcbill = wbItemElement.getAttributeValue("srcbill");
        if (srcbill != null) {
            String[] srcbills = srcbill.split("\\s*[,;\\s]{1}\\s*");
            String[] srcBosTypes = new String[srcbills.length];
            srcBillTypes = new ArrayList(srcbills.length);
            for (int i = 0; i < srcbills.length; ++i) {
                EntityItem eitem = this.getEntityFromDefinition(srcbills[i]);
                if (eitem == null) {
                    String msg = "\u89e3\u6790xml\u6587\u4ef6" + this.parserContext.getXmlFileName() + "\u65f6\uff0c\u672a\u627e\u5230\u5b9e\u4f53" + srcbills[i] + "\u7684\u5b9a\u4e49";
                    throw new XmlConfigParseException(msg);
                }
                srcBosTypes[i] = eitem.getBosType();
                srcBillTypes.add(eitem.getBillTypeId());
            }
            writebackItem.setSrcBillIds(srcBillTypes);
            writebackItem.setSrcBosTypes(srcBosTypes);
        } else {
            String srcbillid = wbItemElement.getAttributeValue("srcbillid");
            String srcbostype = wbItemElement.getAttributeValue("srcbostype");
            if (srcbostype != null) {
                writebackItem.setSrcBosTypes(srcbostype.split("\\s+"));
            }
            srcBillTypes = this.parseSrcBillIds(srcbillid);
            writebackItem.setSrcBillIds(srcBillTypes);
        }
        String[] rels = null;
        String relation = wbItemElement.getAttributeValue("relation");
        if (relation != null) {
            rels = relation.split("\\s+");
        }
        BusinessObjectStructure.LevelStructure[] structures = this.createDefaultBOStructure(srcBillTypes, rels, writebackItem);
        BusinessObjectStructure boStructure = new BusinessObjectStructure(structures);
        boStructure.setLevel(level);
        return boStructure;
    }

    private BusinessObjectStructure.LevelStructure[] createDefaultBOStructure(List srcBillTypes, String[] rels, WriteBackSubItem writebackItem) throws XmlConfigParseException {
        BusinessObjectStructure.LevelStructure[] structures = new BusinessObjectStructure.LevelStructure[3];
        try {
            for (int i = 0; i < srcBillTypes.size(); ++i) {
                int level = i + 1;
                String srcBillType = (String)srcBillTypes.get(i);
                BusinessObjectStructure.LevelStructure ls = new BusinessObjectStructure.LevelStructure();
                ls.setLevel(level);
                BusinessObjectStructure.EntityStructure es = BusinessConfigurationCache.cache.createEntityStructureByBillType(this.parserContext.getContext(), srcBillType);
                es.setRalationTable(TableTypeEnum.ENTRY);
                if (rels != null && rels.length > 0) {
                    es.setRelation(rels[0]);
                } else {
                    es.setRelation(writebackItem.getWriteTo()[i].equalsIgnoreCase("SOURCE") ? "FSourceBillId" : "FCoreBillId");
                }
                es.getEntries()[0].setRalationTable(TableTypeEnum.ENTRY);
                if (rels != null && rels.length > 1) {
                    es.getEntries()[0].setRelation(rels[1]);
                } else {
                    es.getEntries()[0].setRelation(writebackItem.getWriteTo()[i].equalsIgnoreCase("SOURCE") ? "FSourceBillEntryId" : "FCoreBillEntryId");
                }
                es.getEntries()[0].setLinkToParent("FParentID");
                ls.setEntity(es);
                ls.setBillTypeId(srcBillType);
                structures[level] = ls;
            }
        }
        catch (BOSException e) {
            throw new XmlConfigParseException(e);
        }
        return structures;
    }

    private WriteBackPolicy parseWriteBackPolicy(Element policyItem) throws XmlConfigParseException {
        WriteBackPolicy policy = new WriteBackPolicy(policyItem.getAttributeValue("type"));
        List subList = policyItem.getChildren();
        if (subList != null) {
            int size = subList.size();
            if (size == 0) {
                return policy;
            }
            Element sortElement = (Element)subList.get(0);
            List sortsList = sortElement.getChildren();
            if (sortsList != null) {
                XmlConditionItemConfigParser parser = new XmlConditionItemConfigParser();
                int subsize = sortsList.size();
                ArrayList<IBusinessConfigItem> sortCols = new ArrayList<IBusinessConfigItem>(subsize);
                for (int i = 0; i < subsize; ++i) {
                    this.parserContext.setRoot((Element)sortsList.get(i));
                    this.parserContext.setItemType("column");
                    sortCols.add(parser.parse(this.parserContext));
                }
                String sortType = sortElement.getAttributeValue("type");
                String[] sortTypes = sortType.split("\\.");
                if (sortTypes.length < subsize) {
                    String[] realTypes = new String[subsize];
                    for (int i = 0; i < subsize; ++i) {
                        realTypes[i] = i < sortTypes.length ? sortTypes[i] : sortTypes[sortTypes.length - 1];
                    }
                    policy.setSortTypes(realTypes);
                } else {
                    policy.setSortTypes(sortTypes);
                }
            }
            if (size == 1) {
                return policy;
            }
            Element transElement = (Element)subList.get(1);
            List transList = transElement.getChildren();
            if (transList != null) {
                int subsize = transList.size();
                if (subsize == 0) {
                    return policy;
                }
                Element nextElement = (Element)transList.get(0);
                List subtransList = nextElement.getChildren();
                int thissize = subtransList.size();
                for (int i = 0; i < thissize; ++i) {
                    this.parseTransformInPolicy(policy, (Element)subtransList.get(i));
                }
            }
        }
        return policy;
    }

    private List parseColumnPairList(Element pairsElement, Map condsMap) throws XmlConfigParseException {
        ArrayList<ColumnPair> columnPairList = new ArrayList<ColumnPair>();
        List pairsList = pairsElement.getChildren();
        if (pairsList == null || pairsList.size() == 0) {
            return columnPairList;
        }
        XmlConditionItemConfigParser parser = new XmlConditionItemConfigParser();
        int subsize = pairsList.size();
        for (int j = 0; j < subsize; ++j) {
            List pairList;
            Element pairElement = (Element)pairsList.get(j);
            if (pairElement == null || (pairList = pairElement.getChildren()) == null) continue;
            int pairsize = pairList.size();
            if (pairsize < 5) {
                throw new IllegalArgumentException("The columnpair must be contains 5 elements in xml.");
            }
            ColumnPair pair = new ColumnPair();
            pair.setSrcColumn(((Element)pairList.get(0)).getText());
            Element aElement = (Element)pairList.get(1);
            ColumnDataType dataType = ColumnDataType.getType(((Element)pairList.get(3)).getText());
            this.parserContext.setRoot(aElement);
            this.parserContext.setItemType(aElement.getAttributeValue("type") == null ? "column" : aElement.getAttributeValue("type"));
            ConditionItem dstColumn = (ConditionItem)parser.parse(this.parserContext);
            if (dstColumn instanceof ColumnItem && ((ColumnItem)dstColumn).getTable() == null) {
                ((ColumnItem)dstColumn).setTable(TableTypeEnum.ENTRY);
            }
            pair.setDstColumn(dstColumn);
            Element nextElement = (Element)pairList.get(2);
            List calList = nextElement.getChildren();
            if (calList.size() > 0) {
                aElement = (Element)calList.get(0);
                pair.setIfConditions((Conditions)condsMap.get(aElement.getAttributeValue("condition")));
                pair.setCalculation(aElement.getText());
                aElement = (Element)calList.get(1);
                pair.setElseCalculation(aElement.getText());
            } else {
                pair.setCalculation(nextElement.getText());
            }
            aElement = (Element)pairList.get(4);
            String transFrom = aElement.getText();
            if (transFrom != null && transFrom.length() > 0) {
                this.parserContext.setRoot(aElement);
                this.parserContext.setItemType("column");
                ConditionItem item = (ConditionItem)parser.parse(this.parserContext);
                pair.setTransFromColumn((ColumnItem)item);
            }
            pair.setType(dataType);
            if (pairsize > 5) {
                nextElement = (Element)pairList.get(5);
                if (nextElement.getName().equalsIgnoreCase("conditions")) {
                    XmlConditionsConfigParser parser2 = new XmlConditionsConfigParser();
                    this.parserContext.setRoot(nextElement);
                    pair.setConditions((Conditions)parser2.parse(this.parserContext));
                    this.parseVerification(pairList, 6, pair);
                } else {
                    this.parseVerification(pairList, 5, pair);
                }
            }
            columnPairList.add(pair);
        }
        return columnPairList;
    }

    private void parseVerification(List pairList, int idx, ColumnPair pair) {
        int size = pairList.size();
        if (size <= idx) {
            return;
        }
        Element nextElement = (Element)pairList.get(idx);
        if (!nextElement.getName().equals("verification")) {
            return;
        }
        if (size - idx < 2) {
            throw new IllegalArgumentException("The verification in columnpair must be followed message or exception element in xml.");
        }
        pair.setVerificationColumn(nextElement.getText());
        nextElement = (Element)pairList.get(idx + 1);
        pair.setResource(this.parseResource(nextElement));
    }

    private void parseTransformInPolicy(WriteBackPolicy policy, Element transElement) throws XmlConfigParseException {
        XmlConditionItemConfigParser parser = new XmlConditionItemConfigParser();
        this.parserContext.setRoot(transElement);
        this.parserContext.setItemType("column");
        ColumnItem item = (ColumnItem)parser.parse(this.parserContext);
        if (transElement.getName().equalsIgnoreCase("rate")) {
            policy.setExchangeRate(item);
        } else if (transElement.getName().equalsIgnoreCase("mode")) {
            policy.setConvertMode(item);
        } else if (transElement.getName().equalsIgnoreCase("currency")) {
            policy.setCurrency(item);
        }
    }

    @Override
    public void visitBOTConfigItems(BOTProcessSubItemVisitable visitable) throws XmlConfigParseException {
    }

    @Override
    public void visitBusinessProcessConfigItem(BusinessProcessConfigItemVisitable visitable) throws XmlConfigParseException {
        XmlParserContext pc = visitable.getParserContext();
        Element nextElement = pc.getRoot();
        BusinessProcessConfigItem bpitem = visitable.getItem();
        this.parserContext = pc;
        WriteBackConfigItem wbConfigItem = this.parseWriteBackItem(nextElement, bpitem.getBillTypeId(), bpitem.getBosType(), bpitem);
        if (wbConfigItem != null) {
            wbConfigItem.setAction(bpitem.getAction());
            bpitem.setWritebackItem(wbConfigItem);
        }
    }

    @Override
    public void visitWriteBackSubItem(WriteBackSubItemVisitable visitable) throws XmlConfigParseException {
    }
}

