/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.AsynchronousProcessJob;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessorChainSupport;
import com.kingdee.eas.dynbusiness.app.processor.TransactionInvokeUtil;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DefaultBusinessProcessorChainSupport
implements IBusinessProcessorChainSupport {
    private static final long serialVersionUID = 1L;
    private AbstractBusinessProcessor ownProcessor;
    private List<IBusinessProcessor> prefixProcessors = null;
    private AbstractBusinessProcessor postProcessor = null;
    private transient IObjectCollection objCollection;
    private transient IObjectCollection preCollection;
    private boolean isInRoot = false;

    @Override
    public void addPostBusinessProcessor(IBusinessProcessor processor) {
        this.postProcessor = (AbstractBusinessProcessor)processor;
    }

    @Override
    public void setNestedBusinessProcessor(IBusinessProcessor processor) {
    }

    @Override
    public void setPrefixBusinessProcessors(List processors) {
        this.prefixProcessors = processors;
    }

    private void executePrefixProcessors(BatchActionResults batchResults) throws EASBizException, BOSException {
        if (this.prefixProcessors == null) {
            return;
        }
        int size = this.prefixProcessors.size();
        for (int i = 0; i < size; ++i) {
            IBusinessProcessor processor = this.prefixProcessors.get(i);
            BatchActionResults todoResults = batchResults.getToDoResults();
            processor.execute(todoResults);
            batchResults.mergeResults(todoResults);
        }
    }

    @Override
    public boolean doChecking(BatchActionResults batchResults) throws EASBizException, BOSException {
        boolean checkResult = true;
        boolean preCondition = this.preCondition(batchResults);
        boolean isMain = this.ownProcessor.executeMode.equals((Object)ProcessorExecutionModeEnum.MAIN);
        if (isMain && !preCondition) {
            return false;
        }
        if (!(this.ownProcessor.executeMode.equals((Object)ProcessorExecutionModeEnum.ASYNCHRONOUS) || this.ownProcessor.transactionMode != null && this.ownProcessor.transactionMode.equals((Object)TransactionModeEnum.LOOPNEWTRAN))) {
            BatchActionResults todoResults = null;
            if (preCondition) {
                checkResult = this.execCheck(batchResults);
                if (this.ownProcessor.batchExecutor != null) {
                    todoResults = batchResults.getToDoResults();
                    this.ownProcessor.batchExecutor.batchCheck(this.ownProcessor.ctx, this.ownProcessor.batchAction, todoResults);
                    batchResults.mergeResults(todoResults);
                }
            }
        }
        this.doPostChecking(batchResults);
        return checkResult;
    }

    private boolean execCheck(BatchActionResults batchResults) throws EASBizException, BOSException {
        return this.ownProcessor.innerCheck(batchResults);
    }

    private void execProcessing(BatchActionResults todoResults) throws EASBizException, BOSException {
        this.ownProcessor.innerDoProcessing(todoResults);
    }

    private void doPostChecking(BatchActionResults batchResults) throws EASBizException, BOSException {
        if (this.postProcessor != null) {
            this.mergeObjCollection(batchResults);
            BatchActionResults todoResults = batchResults.getToDoResults();
            this.postProcessor.businessChainSupport.doChecking(todoResults);
            batchResults.mergeResults(todoResults);
        }
    }

    private void mergeObjCollection(BatchActionResults batchResults) {
        if (this.objCollection == null || this.preCollection == null || this.objCollection.size() == this.preCollection.size()) {
            return;
        }
        Iterator iter = this.objCollection.iterator();
        int idx = 0;
        int oidx = 0;
        while (iter.hasNext()) {
            IObjectValue objValue = (IObjectValue)iter.next();
            Object oid = objValue.get(objValue.getPKField());
            String id = null;
            if (oid != null) {
                id = oid.toString();
            }
            if (idx >= this.preCollection.size()) break;
            IObjectValue preObjValue = this.preCollection.getObject(idx);
            Object oPreId = preObjValue.get(preObjValue.getPKField());
            String preId = null;
            if (oPreId != null) {
                preId = oid.toString();
            }
            if (StringUtil.isEmpty(id) && StringUtil.isEmpty(preId)) {
                ++idx;
                ++oidx;
                continue;
            }
            if (!StringUtil.isEmpty(id) && id.equals(preId)) {
                ++idx;
                ++oidx;
                continue;
            }
            this.objCollection.setObject(oidx, preObjValue);
            ++idx;
            ++oidx;
        }
    }

    private boolean preCondition(BatchActionResults batchResults) throws EASBizException, BOSException {
        if (this.ownProcessor.conditions == null) {
            return true;
        }
        if (batchResults.getObjCollection() == null) {
            return true;
        }
        if (this.preCollection == null) {
            this.preCollection = BusinessProcessUtil.getCollectionInstance(this.ownProcessor.ctx, this.ownProcessor.bosType);
            HashMap<String, Context> paramMap = new HashMap<String, Context>();
            paramMap.put("_CTX", this.ownProcessor.ctx);
            boolean isMain = this.ownProcessor.executeMode.equals((Object)ProcessorExecutionModeEnum.MAIN);
            for (IObjectValue objValue : batchResults.getObjCollection()) {
                if (this.ownProcessor.conditions.calculateResult(objValue, 0, paramMap, null)) {
                    this.preCollection.addObject(objValue);
                    continue;
                }
                String id = objValue.get(objValue.getPKField()).toString();
                if (!isMain) continue;
                batchResults.addError(id, "\u4e0d\u7b26\u5408\u4e3b\u4e1a\u52a1\u5904\u7406\u5668\u7684\u6267\u884c\u6761\u4ef6");
            }
        }
        if (this.objCollection.size() != this.preCollection.size()) {
            this.objCollection = batchResults.getObjCollection();
            batchResults.setObjCollection(this.preCollection);
        }
        return batchResults.getObjCollection().size() > 0;
    }

    private void executeAsynchronousProcessor(BatchActionResults batchResults) throws BOSException {
        JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)new AsynchronousProcessJob(this.ownProcessor, batchResults, batchResults.getObjCollection()), true, true, 500, null, null, JobIsolationLevel.Instance);
        StringBuffer sb = new StringBuffer();
        sb.append("~\u5f02\u6b65\u6267\u884c\u4e1a\u52a1\u5904\u7406\u5668[\u540d\u79f0\uff1a");
        sb.append(this.ownProcessor.processorDescription);
        sb.append(" \u7c7b\u540d\uff1a");
        sb.append(this.ownProcessor.getClass().getName());
        sb.append("]");
        Job job = new Job(this.ownProcessor.ctx, sb.toString(), cfg, null);
        job.setScheduledTime(new Date(System.currentTimeMillis()));
        JobServiceFactory.getLocalInstance((Context)this.ownProcessor.ctx).createJobInstance(job);
    }

    @Override
    public void doProcessing(BatchActionResults batchResults) throws EASBizException, BOSException {
        BatchActionResults todoResults = batchResults.getToDoResults();
        AbstractBusinessProcessor nextProcessor = null;
        if (this.ownProcessor.executeMode.equals((Object)ProcessorExecutionModeEnum.ASYNCHRONOUS)) {
            boolean preCondition = this.preCondition(todoResults);
            if (preCondition) {
                this.executeAsynchronousProcessor(todoResults);
            }
            nextProcessor = this.postProcessor;
        } else if (this.ownProcessor.transactionMode != null && this.ownProcessor.transactionMode.equals((Object)TransactionModeEnum.LOOPNEWTRAN)) {
            nextProcessor = this.executeNewLoopTrans(todoResults);
            batchResults.mergeResults(todoResults);
            todoResults = batchResults.getToDoResults();
        } else {
            boolean preCondition = this.preCondition(todoResults);
            if (preCondition) {
                this.execProcessing(todoResults);
                if (this.ownProcessor.batchExecutor != null) {
                    this.ownProcessor.batchExecutor.batchExecute(this.ownProcessor.ctx, this.ownProcessor.batchAction, todoResults);
                }
                batchResults.mergeResults(todoResults);
            }
            nextProcessor = this.postProcessor;
        }
        if (nextProcessor != null) {
            todoResults = batchResults.getToDoResults();
            nextProcessor.businessChainSupport.doProcessing(todoResults);
            batchResults.mergeResults(todoResults);
        }
    }

    private AbstractBusinessProcessor executeNewLoopTrans(BatchActionResults batchResults) throws BOSException {
        BatchActionResults todoResults = batchResults.getToDoResults();
        BatchActionResults[] results = todoResults.splitActionResults(this.ownProcessor.ctx, batchResults);
        AbstractBusinessProcessor nextProcessor = null;
        for (int i = 0; i < results.length; ++i) {
            BatchActionResults aResult = results[i];
            try {
                nextProcessor = (AbstractBusinessProcessor)TransactionInvokeUtil.invokeRequiresNew(this, "executeNewLoopTransProcessor", new Object[]{aResult}, new Class[]{BatchActionResults.class});
                continue;
            }
            catch (EASBizException e) {
                String[] ids = aResult.getAllIDs();
                if (ids.length <= 0) continue;
                batchResults.addError(ids[0], (Exception)((Object)e));
            }
        }
        return nextProcessor;
    }

    public AbstractBusinessProcessor executeNewLoopTransProcessor(BatchActionResults batchResults) throws EASBizException, BOSException {
        if (this.ownProcessor.transactionMode.equals((Object)TransactionModeEnum.LOOPNEWTRAN) && !this.ownProcessor.executeMode.equals((Object)ProcessorExecutionModeEnum.ASYNCHRONOUS)) {
            boolean preCondition = this.preCondition(batchResults);
            if (preCondition) {
                this.ownProcessor.execute(batchResults);
            }
            if (this.postProcessor != null) {
                return ((DefaultBusinessProcessorChainSupport)this.postProcessor.businessChainSupport).executeNewLoopTransProcessor(batchResults);
            }
            return null;
        }
        return this.ownProcessor;
    }

    BatchActionResults executeMainProcessor(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.isInRoot = true;
        this.executePrefixProcessors(batchResults);
        boolean checkResult = this.doChecking(batchResults);
        if (!checkResult || !batchResults.hasToDos()) {
            return batchResults;
        }
        BatchActionResults todoResults = batchResults.getToDoResults();
        this.doProcessing(todoResults);
        batchResults.mergeResults(todoResults);
        return batchResults;
    }

    BatchActionResults executeCurrent(BatchActionResults batchResults) throws EASBizException, BOSException {
        if (this.execCheck(batchResults)) {
            BatchActionResults todoResults = batchResults.getToDoResults();
            if (this.ownProcessor.batchExecutor != null) {
                this.ownProcessor.batchExecutor.batchCheck(this.ownProcessor.ctx, this.ownProcessor.batchAction, todoResults);
            }
            batchResults.mergeResults(todoResults);
            todoResults = batchResults.getToDoResults();
            this.execProcessing(todoResults);
            batchResults.mergeResults(todoResults);
            todoResults = batchResults.getToDoResults();
            if (this.ownProcessor.batchExecutor != null) {
                this.ownProcessor.batchExecutor.batchExecute(this.ownProcessor.ctx, this.ownProcessor.batchAction, batchResults);
            }
            batchResults.mergeResults(todoResults);
        }
        return batchResults;
    }

    @Override
    public BatchActionResults execute(BatchActionResults batchResults) throws BOSException, EASBizException {
        boolean isMain = this.ownProcessor.executeMode.equals((Object)ProcessorExecutionModeEnum.MAIN);
        if (isMain && !this.isInRoot) {
            return this.executeRoot(batchResults);
        }
        return this.executeCurrent(batchResults);
    }

    private BatchActionResults executeRoot(BatchActionResults batchResults) throws BOSException, EASBizException {
        ArrayList<AbstractBusinessProcessor> bizChainList = new ArrayList<AbstractBusinessProcessor>();
        bizChainList.add(this.ownProcessor);
        AbstractBusinessProcessor thisProcessor2 = this.ownProcessor;
        AbstractBusinessProcessor postProcessor = ((DefaultBusinessProcessorChainSupport)thisProcessor2.businessChainSupport).postProcessor;
        while (postProcessor != null) {
            boolean isMain = ProcessorExecutionModeEnum.MAIN.equals((Object)postProcessor.executeMode);
            if (isMain) {
                bizChainList.add(postProcessor);
                thisProcessor2.businessChainSupport.addPostBusinessProcessor(null);
            }
            thisProcessor2 = postProcessor;
            postProcessor = ((DefaultBusinessProcessorChainSupport)thisProcessor2.businessChainSupport).postProcessor;
        }
        if (bizChainList.size() == 1) {
            return this.executeMainProcessor(batchResults);
        }
        for (AbstractBusinessProcessor thisProcessor2 : bizChainList) {
            BatchActionResults todoResults = batchResults.getToDoResults();
            BatchActionResults thisResults = ((DefaultBusinessProcessorChainSupport)thisProcessor2.businessChainSupport).executeMainProcessor(todoResults);
            batchResults.mergeResults(thisResults);
        }
        return batchResults;
    }

    @Override
    public void setOwnProcessor(AbstractBusinessProcessor ownProcessor) {
        this.ownProcessor = ownProcessor;
    }
}

