/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public class GeneralBusinessProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1L;

    public GeneralBusinessProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public GeneralBusinessProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public GeneralBusinessProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    @Override
    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        BusinessProcessConfigItem configItem;
        BatchExecuteParamsEntry[] entries = batchResults.getParamEntries();
        if (entries != null && entries.length > 0) {
            if (entries[0].get(0) instanceof IObjectValue) {
                IObjectCollection collection = BusinessProcessUtil.getCollectionInstance(this.ctx, this.bosType);
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    IObjectValue objValue = (IObjectValue)entries[i].get(0);
                    collection.addObject(objValue);
                }
                batchResults.setObjCollection(collection);
            }
            batchResults.setParamEntries(entries);
        }
        if ((configItem = this.getBusinessProcessConfigItem()) != null && configItem.getCheckItems() != null) {
            configItem.getCheckItems().getBusinessCheckHandler(this.ctx).handle(this.ctx, batchResults);
        }
        return batchResults.hasToDos();
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        BusinessProcessConfigItem configItem = this.getBusinessProcessConfigItem();
        if (configItem != null && configItem.getUpdStatusItem() != null) {
            String[] headIds = null;
            String[] entryIds = null;
            if (this.batchAction.getActionLevel().equals((Object)ActionLevelEnum.HEAD)) {
                headIds = batchResults.getToDoIdsArray();
            } else {
                entryIds = batchResults.getToDoIdsArray();
            }
            configItem.getUpdStatusItem().getUpdateStatusHander(this.ctx, headIds, entryIds).handle(this.ctx, batchResults);
        }
    }

    @Override
    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.MAIN;
    }
}

