/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessorChainSupport;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.util.LowTimer;
import java.util.ArrayList;
import java.util.List;

public class NoBusinessProcessorChainSupport
implements IBusinessProcessorChainSupport {
    private static final long serialVersionUID = -2804779493170586241L;
    private IBusinessProcessor nestedProcessor = null;
    private AbstractBusinessProcessor ownProcessor;
    private List<IBusinessProcessor> postProcessors = null;

    @Override
    public void addPostBusinessProcessor(IBusinessProcessor processor) {
        if (this.postProcessors == null) {
            this.postProcessors = new ArrayList<IBusinessProcessor>();
        }
        this.postProcessors.add(processor);
    }

    @Override
    public boolean doChecking(BatchActionResults batchResults) throws EASBizException, BOSException {
        return this.ownProcessor.innerCheck(batchResults);
    }

    @Override
    public void doProcessing(BatchActionResults batchResults) throws EASBizException, BOSException {
        this.ownProcessor.innerDoProcessing(batchResults);
    }

    @Override
    public BatchActionResults execute(BatchActionResults batchResults) throws BOSException, EASBizException {
        LowTimer timer = new LowTimer();
        if (this.doChecking(batchResults)) {
            BatchActionResults todoResults = batchResults.getToDoResults();
            if (this.ownProcessor.batchExecutor != null) {
                this.ownProcessor.batchExecutor.batchCheck(this.ownProcessor.ctx, this.ownProcessor.batchAction, todoResults);
            }
            batchResults.mergeResults(todoResults);
            todoResults = batchResults.getToDoResults();
            if (this.nestedProcessor != null) {
                this.nestedProcessor.execute(todoResults);
                batchResults.mergeResults(todoResults);
                todoResults = batchResults.getToDoResults();
            }
            timer.reset();
            this.doProcessing(todoResults);
            batchResults.mergeResults(todoResults);
            if (this.postProcessors != null) {
                for (int idxOf = 0; idxOf < this.postProcessors.size(); ++idxOf) {
                    IBusinessProcessor postProcessor = this.postProcessors.get(idxOf);
                    if (postProcessor == null) continue;
                    BatchActionResults nextToDoResults = batchResults.getToDoResults();
                    postProcessor.execute(nextToDoResults);
                    batchResults.mergeResults(nextToDoResults);
                }
            }
            if (this.ownProcessor.batchExecutor != null) {
                this.ownProcessor.batchExecutor.batchExecute(this.ownProcessor.ctx, this.ownProcessor.batchAction, batchResults);
            }
        }
        return batchResults;
    }

    @Override
    public void setNestedBusinessProcessor(IBusinessProcessor processor) {
        this.nestedProcessor = processor;
    }

    @Override
    public void setPrefixBusinessProcessors(List processors) {
    }

    @Override
    public void setOwnProcessor(AbstractBusinessProcessor ownProcessor) {
        this.ownProcessor = ownProcessor;
    }
}

