/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bo.TransactionAttribute;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class TransactionInvokeUtil {
    private static Bridge b = new Bridge();
    private static Method m = null;

    public static TransactionAttribute getTransactionAttribute(String transactionDifinition) {
        if (StringUtils.isEmpty((String)transactionDifinition)) {
            return TransactionAttribute.NOTSUPPORTED;
        }
        return TransactionAttribute.getEnum((String)transactionDifinition);
    }

    public static Object invokeTransactonMethod(Object invoker, String methodName, Object[] params, Class[] classType, TransactionAttribute transactionAttribute) throws EASBizException, BOSException {
        if (transactionAttribute == null || transactionAttribute.equals((Object)TransactionAttribute.NOTSUPPORTED)) {
            return TransactionInvokeUtil.invokeWtihoutTransaction(invoker, methodName, params, classType);
        }
        int transaction = 4;
        if (transactionAttribute.equals((Object)TransactionAttribute.REQUIRED)) {
            transaction = 0;
        } else if (transactionAttribute.equals((Object)TransactionAttribute.SUPPORTS)) {
            transaction = 1;
        } else if (transactionAttribute.equals((Object)TransactionAttribute.REQUIRESNEW)) {
            transaction = 3;
        } else if (transactionAttribute.equals((Object)TransactionAttribute.MANDATORY)) {
            transaction = 2;
        } else if (transactionAttribute.equals((Object)TransactionAttribute.NEVER)) {
            transaction = 5;
        }
        return TransactionInvokeUtil.invokeWtihTransaction(invoker, methodName, params, classType, transaction);
    }

    public static Object invokeRequired(Object invoker, String methodName, Object[] params, Class[] classType) throws EASBizException, BOSException {
        return TransactionInvokeUtil.invokeWtihTransaction(invoker, methodName, params, classType, 0);
    }

    public static Object invokeRequiresNew(Object invoker, String methodName, Object[] params, Class[] classType) throws EASBizException, BOSException {
        return TransactionInvokeUtil.invokeWtihTransaction(invoker, methodName, params, classType, 3);
    }

    private static Object invokeWtihTransaction(Object invoker, String methodName, Object[] params, Class[] classType, int transactionDefinition) throws BOSException, EASBizException {
        if (invoker == null || StringUtils.isEmpty((String)methodName)) {
            return null;
        }
        if (params != null && classType == null) {
            classType = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                classType[i] = params[i].getClass();
            }
        }
        try {
            Method method = invoker.getClass().getMethod(methodName, classType);
            EJBTransactionProxy proxy = EJBFactory.getEJBTransactionProxy((Object)b);
            return proxy.invoke(m, new Object[]{invoker, method, params}, transactionDefinition);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    private static Object invokeWtihoutTransaction(Object invoker, String methodName, Object[] params, Class[] classType) throws BOSException, EASBizException {
        if (invoker == null || StringUtils.isEmpty((String)methodName)) {
            return null;
        }
        if (params != null && classType == null) {
            classType = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                classType[i] = params[i].getClass();
            }
        }
        try {
            Method method = invoker.getClass().getMethod(methodName, classType);
            return method.invoke(invoker, params);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
    }

    static {
        try {
            m = Bridge.class.getMethod("invoke", Object.class, Method.class, Object[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Bridge {
        public Object invoke(Object o, Method method, Object[] params) throws Throwable {
            try {
                Object r = method.invoke(o, params);
                return r;
            }
            catch (Throwable t) {
                EJBTransactionProxy.tryRollback();
                throw t;
            }
        }
    }
}

