/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.condition;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.condition.IPropertySupport;
import com.kingdee.eas.dynbusiness.condition.ObjectValueSearcher;
import com.kingdee.eas.dynbusiness.function.FunctionLoader;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.DataConverter;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.util.enums.IntEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InterfaceItem
extends ConditionItem
implements IPropertySupport,
Cloneable {
    public static final String FACADE = "facade";
    public static final String ENTITY = "entity";
    public static final String METHOD = "method";
    private String bosType;
    private String method;
    private String[] paramsType;
    private String[] paramsValue;
    private PropertyInfo[] propertyInfos;
    private String returnType;
    private String objectType;
    private Class[] parameterTypes;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setParamsValue(String[] paramsValue) {
        this.paramsValue = paramsValue;
    }

    public InterfaceItem(String name) {
        super(name);
    }

    public InterfaceItem(String name, String method, String objectType, Class[] parameterTypes, String returnType) {
        super(name);
        this.objectType = objectType;
        this.method = method;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
    }

    public InterfaceItem(String name, String type, String method, String type2, String[] type3, String[] value, String type4) {
        super(name);
        this.bosType = type;
        this.method = method;
        this.objectType = type2;
        this.paramsType = type3;
        this.paramsValue = value;
        this.returnType = type4;
    }

    public InterfaceItem(String name, String bosType, String method, String objectType, Class[] parameterTypes, String returnType) {
        super(name);
        this.bosType = bosType;
        this.method = method;
        this.objectType = objectType;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
    }

    @Override
    public String getExpression() {
        return null;
    }

    public Object doMethodInvoke(Object object, Object[] paramValues) throws BOSException {
        if (!this.objectType.equalsIgnoreCase(METHOD)) {
            throw new IllegalArgumentException("The invoking only supporte METHOD type.");
        }
        try {
            Class<?> clz = Class.forName(this.name);
            Method m = clz.getMethod(this.method, this.parameterTypes);
            return m.invoke(object, paramValues);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public Object doInvoke(Context ctx, Object[] paramValues) throws EASBizException, BOSException {
        IBizCtrl iBiz = null;
        if (this.objectType.equalsIgnoreCase(FACADE)) {
            iBiz = BusinessProcessUtil.getFacadeBizInteface(ctx, BOSObjectType.create((String)this.bosType));
        } else if (this.objectType.equalsIgnoreCase(ENTITY)) {
            iBiz = BusinessProcessUtil.getBizInteface(ctx, BOSObjectType.create((String)this.bosType));
        } else {
            throw new IllegalArgumentException("The objtype property of interface item is not supported.");
        }
        Class[] clzTypes = this.parameterTypes == null ? BusinessProcessUtil.getParamClassTypes(this.paramsType) : this.parameterTypes;
        Method methodAction = BusinessProcessUtil.getLocBizMethod(iBiz, this.method, clzTypes);
        Object result = BusinessProcessUtil.invokeBizMethod(iBiz, methodAction, paramValues);
        if (this.getName() == null || this.getName().length() == 0) {
            return result;
        }
        return result;
    }

    @Override
    public Object getValue(IObjectValue objValue, int level, Map paramMap, String objName) throws EASBizException, BOSException {
        Object[] values = this.calculateParamValues(objValue, level, paramMap, objName);
        Context ctx = (Context)paramMap.get("_CTX");
        Class[] clzTypes = BusinessProcessUtil.getParamClassTypes(this.paramsType);
        String target = (this.bosType != null ? this.bosType : this.name) + "." + this.method;
        String key = this.getCacheKey(target, values, clzTypes);
        if (paramMap.containsKey(key)) {
            return paramMap.get(key);
        }
        Object result = this.doInvoke(ctx, values);
        paramMap.put(key, result);
        return result;
    }

    private Object[] calculateParamValues(IObjectValue objValue, int level, Map paramMap, String objName) throws BOSException, EASBizException {
        Object[] values = new Object[this.paramsValue.length];
        for (int i = 0; i < this.paramsValue.length; ++i) {
            Object value = this.calculateParamValue(objValue, level, paramMap, objName, this.paramsValue[i], this.paramsType[i]);
            if (value == null) continue;
            values[i] = this.paramsType[i].equalsIgnoreCase("String") && !(value instanceof String) ? value.toString() : (this.paramsType[i].equalsIgnoreCase("int") && value instanceof IntEnum ? new Integer(((IntEnum)value).getValue()) : value);
        }
        return values;
    }

    private Object calculateParamValue(IObjectValue objValue, int level, Map paramMap, String objName, String paramValue, String paramType) throws BOSException, EASBizException {
        Object value = null;
        if (Conditions.isStringConstants(paramValue)) {
            try {
                String strValue = paramValue.substring(1, paramValue.length() - 1);
                value = DataConverter.stringConvert(strValue, paramType != null ? this.getParamDataType(paramType) : DataType.STRING, null);
            }
            catch (DataConverter.DataConvertException e) {
                throw new BOSException((Throwable)e);
            }
        } else if (paramValue.equals("@this")) {
            value = objValue;
        } else {
            ExpressionParser exprParser = ExpressionParser.getInstance();
            String[] funcs = exprParser.parseFunction(paramValue);
            if (funcs.length > 0) {
                Object funcParamValue = null;
                if (funcs.length > 1) {
                    String[] paramNames = new String[funcs.length - 1];
                    Object[] paramValus = new Object[paramNames.length];
                    System.arraycopy(funcs, 1, paramNames, 0, paramNames.length);
                    for (int i = 0; i < paramNames.length; ++i) {
                        paramValus[i] = this.calculateParamValue(objValue, level, paramMap, objName, paramNames[i], null);
                    }
                    funcParamValue = paramNames.length == 1 ? paramValus[0] : paramValus;
                }
                value = FunctionLoader.calculateFunction(funcParamValue, funcs[0], paramMap);
            } else {
                String[] stringArray;
                if (Conditions.isTemporaryVariable(paramValue)) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = paramValue;
                } else {
                    stringArray = paramValue.split("\\.");
                }
                value = ObjectValueSearcher.searchValue((Object)objValue, stringArray, level, objName, paramMap);
            }
            if (value instanceof IObjectValue) {
                value = value.get(value.getPKField()).toString();
            }
        }
        return value;
    }

    private DataType getParamDataType(String paramType) {
        if (paramType.equalsIgnoreCase("String")) {
            return DataType.STRING;
        }
        if (paramType.equalsIgnoreCase("Boolean")) {
            return DataType.BOOLEAN;
        }
        if (paramType.equalsIgnoreCase("Integer")) {
            return DataType.INTEGER;
        }
        if (paramType.equalsIgnoreCase("int")) {
            return DataType.INTEGER;
        }
        return null;
    }

    @Override
    public DataType getDataType(Context ctx) throws BOSException {
        if (this.returnType == null) {
            return null;
        }
        if (this.returnType.equalsIgnoreCase("IObjectPK")) {
            return DataType.OBJECTPK;
        }
        if (this.returnType.equalsIgnoreCase("IObjectValue")) {
            return DataType.OBJECTVALUE;
        }
        if (this.returnType.equalsIgnoreCase("IObjectCollection")) {
            return DataType.OBJECTCOLLECTION;
        }
        return DataType.getEnum((String)this.returnType);
    }

    @Override
    public String getClassName(Context ctx) throws BOSException {
        return null;
    }

    @Override
    public List getSelectorList() {
        ArrayList<SelectorItemInfo> selectorList = new ArrayList<SelectorItemInfo>();
        for (int i = 0; i < this.paramsValue.length; ++i) {
            if (Conditions.isTemporaryVariable(this.paramsValue[i]) || Conditions.isStringConstants(this.paramsValue[i])) continue;
            selectorList.add(new SelectorItemInfo(this.paramsValue[i]));
        }
        return selectorList;
    }

    @Override
    public PropertyInfo[] getPropertyInfo(EntityObjectInfo mainEo, Map subEntities) {
        if (this.propertyInfos != null) {
            return this.propertyInfos;
        }
        ArrayList<PropertyInfo> propList = new ArrayList<PropertyInfo>();
        ExpressionParser exprParser = ExpressionParser.getInstance();
        block0: for (int idxParamsValue = 0; idxParamsValue < this.paramsValue.length; ++idxParamsValue) {
            String[] props = exprParser.splitPropertise(this.paramsValue[idxParamsValue]);
            for (int idxOfProp = 0; idxOfProp < props.length; ++idxOfProp) {
                PropertyInfo propInfo;
                int j;
                if (exprParser.isExpression(props[idxOfProp])) {
                    String[] thisProps = exprParser.splitVariables(props[idxOfProp]);
                    for (j = 0; j < thisProps.length; ++j) {
                        propInfo = this.getPropertyInfo(mainEo, subEntities, thisProps[j]);
                        if (propInfo == null) continue;
                        propList.add(propInfo);
                    }
                    continue;
                }
                String[] funcs = exprParser.parseFunction(this.paramsValue[idxParamsValue]);
                if (funcs.length > 0) {
                    for (j = 1; j < funcs.length; ++j) {
                        propInfo = this.getPropertyInfo(mainEo, subEntities, funcs[j]);
                        if (propInfo == null) continue;
                        propList.add(propInfo);
                    }
                    continue;
                }
                PropertyInfo propInfo2 = this.getPropertyInfo(mainEo, subEntities, this.paramsValue[idxParamsValue]);
                if (propInfo2 == null) continue block0;
                propList.add(propInfo2);
                continue block0;
            }
        }
        this.propertyInfos = propList.toArray(new PropertyInfo[0]);
        return this.propertyInfos;
    }

    private PropertyInfo getPropertyInfo(EntityObjectInfo mainEo, Map subEntities, String property) {
        if (Conditions.isTemporaryVariable(property) || Conditions.isStringConstants(property) || property.startsWith("@")) {
            return null;
        }
        return BusinessProcessUtil.getPropertyInfo(mainEo, property, property.split("\\."), subEntities);
    }

    @Override
    public String getEntryName() {
        return null;
    }

    private String getCacheKey(String target, Object[] arguments, Class[] argumentClasses) {
        StringBuffer result = new StringBuffer();
        result.append(target);
        if (arguments != null) {
            result.append("@");
            for (int i = 0; i < arguments.length; ++i) {
                if (i > 0) {
                    result.append("-");
                }
                result.append(argumentClasses[i].getName());
                result.append("#");
                result.append(this.getKey(arguments[i]));
            }
        }
        return result.toString();
    }

    private String getKey(Object object) {
        if (object == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        if (object instanceof Object[]) {
            result.append("[");
            Object[] array = (Object[])object;
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                if (i > 0) {
                    result.append(";");
                }
                result.append(this.getKey(element));
            }
            result.append("]");
        } else if (object instanceof Collection) {
            result.append("[");
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (i > 0) {
                    result.append(";");
                }
                result.append(this.getKey(element));
                ++i;
            }
            result.append("]");
        } else {
            result.append(object.toString());
        }
        return result.toString();
    }
}

