/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.condition;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import java.util.Map;

public final class ObjectValueSearcher {
    public static Object searchValue(Object aValue, String[] splits, int length, String objName, Map paramMap) {
        return ObjectValueSearcher.searchValue(aValue, splits, length, objName, paramMap, -1);
    }

    public static Object searchValue(Object aValue, String[] splits, int length, String objName, Map paramMap, int seq) {
        if (aValue == null || splits.length == 0) {
            return null;
        }
        Object result = null;
        boolean forward = splits.length > length;
        int idx = length;
        if (idx < 0) {
            return null;
        }
        if (length > 0 && objName != null) {
            forward = objName.equals(splits[0]);
        }
        String key = forward ? splits[idx] : "parent";
        ExpressionParser exprParse = ExpressionParser.getInstance();
        if (exprParse.isExpression(key)) {
            key = Conditions.buildKey((IObjectValue)paramMap.get("_HEAD"), key, paramMap);
        } else if (Conditions.isTemporaryVariable(key)) {
            key = key.substring(1, key.length() - 1);
        }
        if (!(aValue instanceof IObjectValue)) {
            if (aValue instanceof Map) {
                return ((Map)aValue).get(key);
            }
            return null;
        }
        IObjectValue objValue = (IObjectValue)aValue;
        Object value = null;
        if (forward) {
            if (length == splits.length) {
                result = objValue.get(splits[length - 1]);
                return result;
            }
            value = idx == splits.length - 1 ? objValue.get(key) : ObjectValueSearcher.deepSearchValue(objValue, splits, length, objName, paramMap, seq, key);
        } else {
            IObjectValue parent = (IObjectValue)paramMap.get("_HEAD");
            if (parent == null) {
                parent = objValue.getObjectValue("parent");
            }
            if (parent != null && parent instanceof IObjectValue) {
                value = ObjectValueSearcher.searchValue((Object)parent, splits, 0, null, paramMap, seq);
            }
        }
        return value;
    }

    private static Object deepSearchValue(IObjectValue objValue, String[] splits, int length, String objName, Map paramMap, int seq, String key) {
        Object value;
        Object result = objValue.get(key);
        if (result instanceof IObjectCollection) {
            IObjectCollection collection = (IObjectCollection)result;
            if (collection == null || collection.size() == 0) {
                return null;
            }
            int size = collection.size();
            if (seq >= 0 && seq < size) {
                IObjectValue aObjValue = collection.getObject(seq);
                value = ObjectValueSearcher.searchValue((Object)aObjValue, splits, length + 1, splits[0], paramMap, seq);
            } else {
                Object[] values = new Object[size];
                for (int i = 0; i < size; ++i) {
                    IObjectValue aObjValue = collection.getObject(i);
                    values[i] = ObjectValueSearcher.searchValue((Object)aObjValue, splits, length + 1, splits[0], paramMap, seq);
                }
                value = values;
            }
        } else {
            value = ObjectValueSearcher.searchValue(objValue.get(key), splits, length + 1, objName, paramMap, seq);
        }
        return value;
    }

    public static Object searchValue(Object aValue, String propertyName, int length, String objName, Map paramMap) {
        if (propertyName == null) {
            return null;
        }
        String[] splits = propertyName.split("\\.");
        return ObjectValueSearcher.searchValue(aValue, splits, length, objName, paramMap);
    }

    public static Object searchValue(Object aValue, String propertyName, int length, String objName, Map paramMap, int seq) {
        if (propertyName == null) {
            return null;
        }
        String[] splits = propertyName.split("\\.");
        return ObjectValueSearcher.searchValue(aValue, splits, length, objName, paramMap, seq);
    }
}

