/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.condition;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ColumnDataType;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.condition.IPropertySupport;
import com.kingdee.eas.dynbusiness.condition.ITableSQLBuild;
import com.kingdee.eas.dynbusiness.condition.ObjectValueSearcher;
import com.kingdee.eas.dynbusiness.condition.TableColumnHelper;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParameterItem
extends ConditionItem
implements IPropertySupport,
ITableSQLBuild {
    String bizOrgProperty;
    String bizOrgColumn;
    private String langProfix;
    private PropertyInfo[] propertyInfos;
    private TableColumnHelper helper = new TableColumnHelper();

    public void setTable(TableTypeEnum table) {
        this.helper.setTable(table);
    }

    public boolean getValueAsBoolean(Context ctx, IObjectPK orgUnitID) throws EASBizException, BOSException {
        String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)orgUnitID, (String)this.name);
        if (StringUtil.isEmpty(paramValue)) {
            return false;
        }
        return Boolean.valueOf(paramValue);
    }

    @Override
    public Object getValue(IObjectValue objValue, int level, Map paramMap, String objName) throws EASBizException, BOSException {
        String orgId = null;
        Object orgValue = ObjectValueSearcher.searchValue((Object)objValue, this.getSplits(), level, objName, paramMap);
        if (orgValue == null) {
            return null;
        }
        if (orgValue instanceof IObjectValue) {
            IObjectValue vo = (IObjectValue)orgValue;
            BOSUuid orgPK = (BOSUuid)vo.get(vo.getPKField());
            orgId = orgPK.toString();
        } else if (orgValue instanceof String) {
            orgId = (String)orgValue;
        } else {
            throw new IllegalArgumentException("The parameterItem orgProperty(" + this.bizOrgProperty + ") value should be IObjectValue or String type.");
        }
        String name = this.getName();
        String orgkey = name + orgId;
        if (paramMap.containsKey(orgkey)) {
            return paramMap.get(orgkey);
        }
        Context ctx = (Context)paramMap.get("_CTX");
        String paramValue = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(orgId), name);
        paramMap.put(orgkey, paramValue);
        return paramValue;
    }

    public ParameterItem(String name) {
        super(name);
    }

    @Override
    public String getExpression() {
        return null;
    }

    public String getBizOrgProperty() {
        return this.bizOrgProperty;
    }

    public void setBizOrgProperty(String bizOrgProperty) {
        this.bizOrgProperty = bizOrgProperty;
    }

    @Override
    public String[] getSplits() {
        if (this.splits == null) {
            this.splits = Conditions.isTemporaryVariable(this.bizOrgProperty) ? new String[]{this.bizOrgProperty} : this.bizOrgProperty.split("\\.");
        }
        return super.getSplits();
    }

    @Override
    public DataType getDataType(Context ctx) throws BOSException {
        return DataType.STRING;
    }

    @Override
    public String getClassName(Context ctx) throws BOSException {
        return null;
    }

    @Override
    public List getSelectorList() {
        ArrayList<SelectorItemInfo> selectorList = new ArrayList<SelectorItemInfo>();
        if (!Conditions.isTemporaryVariable(this.bizOrgProperty)) {
            selectorList.add(new SelectorItemInfo(this.bizOrgProperty));
        }
        return selectorList;
    }

    @Override
    public boolean hasLevelGreaterZero(String alias) {
        return this.bizOrgProperty.startsWith(alias);
    }

    @Override
    public PropertyInfo[] getPropertyInfo(EntityObjectInfo mainEo, Map subEntities) {
        if (this.propertyInfos != null) {
            return this.propertyInfos;
        }
        ExpressionParser exprParser = ExpressionParser.getInstance();
        String[] props = exprParser.splitPropertise(this.bizOrgProperty);
        ArrayList<PropertyInfo> propList = new ArrayList<PropertyInfo>(props.length);
        for (int i = 0; i < props.length; ++i) {
            if (Conditions.isTemporaryVariable(props[i])) continue;
            if (exprParser.isExpression(props[i])) {
                String[] thisProps = exprParser.splitVariables(props[i]);
                for (int j = 0; j < thisProps.length; ++j) {
                    propList.add(BusinessProcessUtil.getPropertyInfo(mainEo, thisProps[j], thisProps[j].split("\\."), subEntities));
                }
                continue;
            }
            propList.add(BusinessProcessUtil.getPropertyInfo(mainEo, this.bizOrgProperty, props, subEntities));
            break;
        }
        this.propertyInfos = propList.toArray(new PropertyInfo[0]);
        return this.propertyInfos;
    }

    @Override
    public String getEntryName() {
        return null;
    }

    @Override
    public String buildConditon(boolean isToSum, String[] columns) {
        return "pmi.FValue_" + this.langProfix;
    }

    @Override
    public String buildJoin() {
        StringBuffer sb = new StringBuffer();
        sb.append("LEFT OUTER JOIN T_BAS_Param pm ON pm.FNumber='");
        sb.append(this.name);
        sb.append("'");
        sb.append("\r\n");
        sb.append("LEFT OUTER JOIN T_BAS_ParamItem pmi ON pm.FID=pmi.FKeyID AND ");
        sb.append(this.helper.getAliasByLevel());
        sb.append(".");
        sb.append(this.bizOrgColumn);
        sb.append("=pmi.FOrgUnitID");
        return sb.toString();
    }

    @Override
    public String[] getColumnNames(int levelFrom, boolean withAlias) {
        if (this.helper.getLevelFrom() != levelFrom) {
            return new String[0];
        }
        if (withAlias) {
            return new String[]{this.getColumnWithAlias()};
        }
        return new String[]{this.bizOrgColumn + " VARCHAR(44)"};
    }

    private String getColumnWithAlias() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.helper.getAliasByLevel());
        sb.append(".");
        sb.append(this.bizOrgColumn);
        return sb.toString();
    }

    @Override
    public String[] getGroupByFields(int levelFrom) {
        return new String[]{levelFrom == 0 ? this.getColumnWithAlias() : "pmi.FValue_" + this.langProfix};
    }

    @Override
    public boolean hasMulOrDivOperation(int levelFrom) {
        return false;
    }

    @Override
    public void setDataType(ColumnDataType dataType) {
    }

    public void setBizOrgColumn(String bizOrgColumn) {
        this.bizOrgColumn = bizOrgColumn;
    }

    public void setLangProfix(String langProfix) {
        this.langProfix = langProfix;
    }
}

