/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IActionItemHandle;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.condition.IPropertySupport;
import com.kingdee.eas.dynbusiness.config.ActionItemList;
import com.kingdee.eas.dynbusiness.config.BOTProcessSubItem;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.util.ArrayUtils;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ActionItem
implements IBusinessBatchHandle {
    private String action;
    private String method;
    private String[] paramsType;
    private int value;
    private ActionItemList parent;
    private int seq;
    private String sql;
    private String type = "action";
    private String updateTo;
    private boolean reload = false;
    private String preCondition;
    private IPropertySupport interfaceItem;
    private String logServiceParam;

    public void setLogServiceParam(String logServiceParam) {
        this.logServiceParam = logServiceParam;
    }

    public void setPreCondition(String preCondition) {
        this.preCondition = preCondition;
    }

    public ActionItem(ActionItemList item, String action, String type, int seq) {
        this.parent = item;
        this.action = action;
        this.type = type;
        this.seq = seq;
    }

    public void setInterfaceItem(IPropertySupport interfaceItem) {
        this.interfaceItem = interfaceItem;
    }

    public ActionItem(ActionItemList item, String sql, String type, String updateTo) {
        this.parent = item;
        this.sql = sql;
        this.type = type;
        this.updateTo = updateTo;
    }

    public ActionItem(ActionItemList item, String action, int value, int seq) {
        this.parent = item;
        this.action = action;
        this.value = value;
        this.seq = seq;
        if (!this.type.equals("action")) {
            return;
        }
        if (action.equalsIgnoreCase("SUBMIT")) {
            this.method = "submitRelations";
            this.paramsType = new String[]{"CoreBillBaseInfo", "BOTRelationCollection"};
        } else if (action.equalsIgnoreCase("SAVE")) {
            this.method = "saveRelations";
            this.paramsType = new String[]{"CoreBillBaseInfo", "BOTRelationCollection"};
        }
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String[] getParamsType() {
        return this.paramsType;
    }

    public void setParamsType(String[] paramsType) {
        this.paramsType = paramsType;
    }

    private void handleInBPConfigItem(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] ids = batchResults.getToDoIdsArray();
        if (ids.length == 0) {
            return;
        }
        BusinessProcessConfigItem bpCfgItem = (BusinessProcessConfigItem)this.parent.getParent();
        IObjectCollection objCollection = batchResults.getObjCollection();
        if (objCollection == null || objCollection.size() == 0) {
            return;
        }
        if (objCollection.size() != ids.length) {
            Iterator iter = objCollection.iterator();
            while (iter.hasNext()) {
                IObjectValue objValue = (IObjectValue)iter.next();
                if (batchResults.isToDo(objValue.get(objValue.getPKField()).toString())) continue;
                iter.remove();
            }
        }
        if (objCollection.size() == 0) {
            return;
        }
        IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface(ctx, BOSObjectType.create((String)bpCfgItem.getBosType()));
        if (this.reload) {
            objCollection = this.reLoadObjCollection(ctx, iBiz, objCollection);
        }
        this.executeAction(ctx, iBiz, objCollection, null, batchResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction(Context ctx, IBizCtrl iBiz, IObjectCollection objCollection, BOTRelationCollection relationCollection, BatchActionResults batchResults) throws EASBizException, BOSException {
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            for (int i = 0; i < objCollection.size(); ++i) {
                IObjectValue objValue = objCollection.getObject(i);
                if (this.preCondition != null && this.parent.getParent() instanceof BusinessProcessConfigItem) {
                    Conditions thisConds = null;
                    BusinessProcessConfigItem bpCfgItem = (BusinessProcessConfigItem)this.parent.getParent();
                    List preConds = bpCfgItem.getPreConditions();
                    for (Conditions conds : preConds) {
                        if (!this.preCondition.equals(conds.getId())) continue;
                        thisConds = conds;
                        break;
                    }
                    if (thisConds != null) {
                        HashMap<String, Object> paramMap = new HashMap<String, Object>();
                        paramMap.put("_CTX", ctx);
                        String entriesName = BusinessProcessUtil.getEntityEntriesName(ctx, BOSObjectType.create((String)bpCfgItem.getBosType()));
                        paramMap.put("_ENTRISENAME", entriesName);
                        if (!thisConds.calculateResult(objValue, 0, paramMap, null)) continue;
                    }
                }
                if (this.interfaceItem != null) {
                    String id;
                    Object result = this.invokeInterfaceItem(ctx, objValue);
                    if (result == null) continue;
                    if (result instanceof IObjectValue) {
                        objCollection.setObject(i, (IObjectValue)result);
                        continue;
                    }
                    if (!this.action.equalsIgnoreCase("SUBMIT") && !this.action.equalsIgnoreCase("SAVE") || !(id = batchResults.getToDoIdsArray()[0]).equals("NEWID") || !(result instanceof IObjectPK)) continue;
                    batchResults.replaceNewId(((IObjectPK)result).toString());
                    continue;
                }
                if (this.isActionState(objValue)) continue;
                Method methodAction = null;
                Class[] clzTypes = BusinessProcessUtil.getParamClassTypes(this.paramsType);
                methodAction = BusinessProcessUtil.getLocBizMethod(iBiz, this.method, clzTypes);
                IObjectPK logPk = this.beforeLogSevice(ctx, objValue);
                Object retValue = BusinessProcessUtil.invokeBizMethod(iBiz, methodAction, this.getParamValues(ctx, objValue, relationCollection));
                this.afterLogSevice(ctx, logPk);
                if (batchResults.getCaller() == null || !(batchResults.getCaller() instanceof IActionItemHandle)) continue;
                ((IActionItemHandle)batchResults.getCaller()).afterActionHandle(ctx, this, batchResults, objValue, retValue);
            }
        }
        finally {
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.FALSE);
        }
    }

    private IObjectPK beforeLogSevice(Context ctx, IObjectValue objValue) {
        if (this.logServiceParam == null) {
            return null;
        }
        String[] logParams = this.logServiceParam.split("\\s*;\\s*");
        if (logParams.length < 2) {
            return null;
        }
        LogControllManager.getInstance().enableLog();
        ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
        return LogUtil.beginLog((Context)ctx, (String)logParams[0], (BOSObjectType)objValue.getBOSType(), (IObjectPK)new ObjectUuidPK((BOSUuid)objValue.get(objValue.getPKField())), (String)((String)objValue.get("number")), (String)logParams[1]);
    }

    private void afterLogSevice(Context ctx, IObjectPK logPk) {
        if (logPk == null) {
            return;
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    @Override
    public void handle(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (this.parent.getParent() instanceof BusinessProcessConfigItem) {
            this.handleInBPConfigItem(ctx, batchResults);
            return;
        }
        BOTProcessSubItem botSubItem = (BOTProcessSubItem)this.parent.getParent();
        if (this.type.equals("sql")) {
            this.executeSql(ctx, batchResults);
            return;
        }
        BTPTransformResult transformResult = batchResults.getTransformResult(botSubItem.getId());
        if (transformResult == null) {
            return;
        }
        IObjectCollection objCollection = transformResult.getBills();
        if (objCollection == null || objCollection.size() == 0) {
            return;
        }
        IBizCtrl iBiz = BusinessProcessUtil.getLocBizInteface(ctx, botSubItem.getDstBosType());
        if (this.reload) {
            IObjectCollection newCollection = this.reLoadObjCollection(ctx, iBiz, objCollection);
            botSubItem.getMappingItem().resetTempValue(objCollection, newCollection);
            transformResult.setBills(newCollection);
            objCollection = newCollection;
        }
        this.executeAction(ctx, iBiz, objCollection, transformResult.getBOTRelationCollection(), batchResults);
    }

    private Object invokeInterfaceItem(Context ctx, IObjectValue objValue) throws EASBizException, BOSException {
        IObjectValue r;
        Object id;
        HashMap<String, Context> paramMap = new HashMap<String, Context>();
        paramMap.put("_CTX", ctx);
        Object result = this.interfaceItem.getValue(objValue, 0, paramMap, null);
        if (result != null && result.getClass().getName().equals(objValue.getClass().getName()) && (id = (r = (IObjectValue)result).get(r.getPKField())) != null && id.equals(objValue.get(objValue.getPKField()))) {
            return r;
        }
        return result;
    }

    private void executeSql(Context ctx, BatchActionResults batchResults) throws BOSException {
        if (this.sql == null || this.sql.length() == 0) {
            return;
        }
        BOTProcessSubItem botSubItem = (BOTProcessSubItem)this.parent.getParent();
        Object[] idsArray = null;
        if (this.updateTo.equals("source")) {
            if (botSubItem.getSourceKey() == null) {
                idsArray = ArrayUtils.getIdArrayFromCollection(batchResults.getObjCollection());
            } else {
                BTPTransformResult transformResult = batchResults.getTransformResult(botSubItem.getSourceKey());
                idsArray = ArrayUtils.getIdArrayFromCollection(transformResult.getBills());
            }
        }
        if (idsArray == null || idsArray.length == 0) {
            return;
        }
        String bindMarks = DBUtil.getBindMarks(idsArray.length);
        this.sql = this.sql.replaceAll("\\?\\?\\?", bindMarks);
        DBUtil.executeUpdate(ctx, this.sql, idsArray);
    }

    private IObjectCollection reLoadObjCollection(Context ctx, IBizCtrl iBiz, IObjectCollection objCollection) throws BOSException, EASBizException {
        HashSet<Object> idSet = new HashSet<Object>();
        for (int i = 0; i < objCollection.size(); ++i) {
            IObjectValue objValue = objCollection.getObject(i);
            idSet.add(objValue.get(objValue.getPKField()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        return BusinessProcessorHelper.loadObjectCollection(ctx, this.parent.getParent() instanceof BOTProcessSubItem ? ((BOTProcessSubItem)this.parent.getParent()).getDstBosType() : BOSObjectType.create((String)((BusinessProcessConfigItem)this.parent.getParent()).getBosType()), view);
    }

    private SelectorItemCollection getSelector() {
        for (int i = 0; i < this.paramsType.length; ++i) {
            if (!this.paramsType[i].equalsIgnoreCase("IObjectValue") && !this.paramsType[i].equalsIgnoreCase("CoreBillBaseInfo")) continue;
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo(this.parent.getStateProperty()));
        return selector;
    }

    private boolean isActionState(IObjectValue objValue) {
        Object valueState = objValue.get(this.parent.getStateProperty());
        int state = -100;
        if (valueState instanceof Integer) {
            state = (Integer)valueState;
        } else if (valueState instanceof String) {
            state = Integer.valueOf((String)valueState);
        }
        return state == this.value;
    }

    private Object[] getParamValues(Context ctx, IObjectValue objValue, BOTRelationCollection relationCollection) {
        Object[] results = new Object[this.paramsType.length];
        for (int i = 0; i < this.paramsType.length; ++i) {
            results[i] = this.paramsType[i].equalsIgnoreCase("Context") ? ctx : (this.paramsType[i].equalsIgnoreCase("IObjectPK") ? new ObjectUuidPK((BOSUuid)objValue.get(objValue.getPKField())) : (this.paramsType[i].equalsIgnoreCase("IObjectValue") || this.paramsType[i].equalsIgnoreCase("CoreBillBaseInfo") || this.paramsType[i].equals(objValue.getClass().getName()) ? objValue : (this.paramsType[i].equalsIgnoreCase("BOTRelationCollection") ? relationCollection : null)));
        }
        return results;
    }
}

