/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.config.BOTProcessSubItem;
import com.kingdee.eas.dynbusiness.config.ValueMappingItem;
import com.kingdee.eas.dynbusiness.util.ArrayUtils;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BOTSourceItem {
    private String sourceSql;
    private int idxGroupby;
    private int idxBillId;
    private int idxEntryId;
    BOTProcessSubItem parent;
    private ValueMappingItem mappingItem;
    private String sourceType;
    private String key;
    private boolean reload = true;

    public boolean isReload() {
        return this.reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public BOTProcessSubItem getParent() {
        return this.parent;
    }

    public BOTSourceItem(BOTProcessSubItem parent, String sourceType) {
        this.parent = parent;
        this.sourceType = sourceType;
    }

    public void setMappingItem(ValueMappingItem mappingItem) {
        this.mappingItem = mappingItem;
    }

    public void setIdxEntryId(int idxEntryId) {
        this.idxEntryId = idxEntryId;
    }

    public void setIdxGroupby(int groupby) {
        this.idxGroupby = groupby;
    }

    public void setSourceSql(String sourceSql) {
        this.sourceSql = sourceSql;
    }

    public void setIdxBillId(int idxBillId) {
        this.idxBillId = idxBillId;
    }

    void prepareData(Context ctx, BatchActionResults batchResults) throws EASBizException, BOSException {
        if (this.mappingItem != null) {
            this.mappingItem.handle(ctx, batchResults);
        }
    }

    List loadSourceData(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (!this.reload && batchResults.getObjCollection() != null) {
            ArrayList<IObjectCollection> list = new ArrayList<IObjectCollection>(1);
            list.add(batchResults.getObjCollection());
            return list;
        }
        if (this.sourceType.equalsIgnoreCase("sql")) {
            return this.loadSourceBySql(ctx, batchResults);
        }
        if (this.key != null) {
            ArrayList result = new ArrayList(1);
            BTPTransformResult transformResult = batchResults.getTransformResult(this.key);
            if (transformResult != null) {
                return this.loadSourceById(ctx, this.getArrayIdFromTransform(batchResults), transformResult.getBills());
            }
            return result;
        }
        return this.loadSourceById(ctx, batchResults.getToDoIdsArray(), batchResults.getObjCollection());
    }

    public IObjectCollection getDataSource(BatchActionResults batchResults) {
        if (this.key != null) {
            return batchResults.getTransformResult(this.key).getBills();
        }
        return batchResults.getObjCollection();
    }

    private List loadSourceById(Context ctx, String[] idsArray, IObjectCollection oldCollection) throws BOSException, EASBizException {
        if (idsArray == null || idsArray.length == 0) {
            return null;
        }
        SelectorItemCollection botpSelectors = this.loadSelector(ctx, this.parent);
        if (botpSelectors == null) {
            return null;
        }
        ArrayList<IObjectCollection> list = new ArrayList<IObjectCollection>();
        BOSObjectType bosType = this.key != null ? this.parent.getParent().getDstBosType(this.key) : BOSObjectType.create((String)this.parent.getParent().getParent().getBosType());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)StringUtil.getKeyIdListWithOutQuotationMask(idsArray), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(botpSelectors);
        IObjectCollection collection = BusinessProcessorHelper.loadObjectCollection(ctx, bosType, view);
        List lstItems = this.getParent().getParent().getSubBOTItems();
        for (int i = 0; i < lstItems.size(); ++i) {
            BOTProcessSubItem subItem = (BOTProcessSubItem)lstItems.get(i);
            if (!subItem.getId().equals(this.key)) continue;
            subItem.getMappingItem().resetTempValue(oldCollection, collection);
        }
        list.add(collection);
        return list;
    }

    private String[] getArrayIdFromTransform(BatchActionResults batchResults) {
        BTPTransformResult transformResult = batchResults.getTransformResult(this.key);
        return ArrayUtils.getIdArrayFromCollection(transformResult.getBills());
    }

    private List loadSourceBySql(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (this.sourceSql == null || this.sourceSql.length() == 0) {
            return null;
        }
        String sql = this.sourceSql;
        Object[] idsArray = null;
        idsArray = this.key == null ? batchResults.getToDoIdsArray() : this.getArrayIdFromTransform(batchResults);
        if (idsArray == null || idsArray.length == 0) {
            return null;
        }
        String bindMarks = DBUtil.getBindMarks(idsArray.length);
        sql = sql.replaceAll("\\?\\?\\?", bindMarks);
        IRowSet rs = DBUtil.executeQuery(ctx, sql, idsArray);
        HashSet set = new HashSet();
        try {
            set.addAll(rs.toCollection(this.idxGroupby));
            if (set.size() == 0) {
                return null;
            }
            SelectorItemCollection botpSelectors = this.loadSelector(ctx, this.parent);
            if (botpSelectors == null) {
                return null;
            }
            BOSObjectType bosType = null;
            bosType = this.key != null ? this.parent.getParent().getDstBosType(this.key) : BOSObjectType.create((String)this.parent.getParent().getParent().getBosType());
            String entryName = BusinessProcessUtil.getEntityEntriesName(ctx, bosType);
            ArrayList<IObjectCollection> results = new ArrayList<IObjectCollection>(set.size());
            boolean hasRow = rs.first();
            String group = null;
            String id = null;
            StringBuffer sb = new StringBuffer();
            ArrayList<String> entryIdList = new ArrayList<String>();
            HashSet<String> idSet = new HashSet<String>();
            List[] valList = null;
            IRowSetMetaData rsMetadata = rs.getRowSetMetaData();
            int cntColumn = rsMetadata.getColumnCount();
            if (cntColumn < 3) {
                cntColumn = 3;
            } else {
                valList = new ArrayList[cntColumn - 3];
                for (int i = 0; i < cntColumn - 3; ++i) {
                    valList[i] = new ArrayList();
                }
            }
            while (hasRow) {
                String valGroup;
                String valId = rs.getString(this.idxBillId);
                if (!valId.equals(id)) {
                    id = valId;
                    idSet.add(id);
                    for (int i = 0; i < cntColumn - 3; ++i) {
                        valList[i].add(rs.getObject(i + 4));
                    }
                }
                if ((valGroup = rs.getString(this.idxGroupby)) == null) {
                    hasRow = rs.next();
                    continue;
                }
                if (!valGroup.equals(group)) {
                    if (group != null) {
                        results.add(this.loadSourceByGroup(ctx, bosType, idSet, group, botpSelectors, entryIdList, entryName, valList));
                        idSet.clear();
                        idSet.add(id);
                        for (int i = 0; i < cntColumn - 3; ++i) {
                            valList[i].clear();
                            valList[i].add(rs.getObject(i + 4));
                        }
                        entryIdList.clear();
                    }
                    group = valGroup;
                    sb.setLength(0);
                }
                entryIdList.add(rs.getString(this.idxEntryId));
                hasRow = rs.next();
            }
            if (group != null) {
                results.add(this.loadSourceByGroup(ctx, bosType, idSet, group, botpSelectors, entryIdList, entryName, valList));
            }
            return results;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IObjectCollection loadSourceByGroup(Context ctx, BOSObjectType bosType, Set idSet, String group, SelectorItemCollection botpSelectors, List entryIdList, String entryName, List[] valList) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(botpSelectors);
        IObjectCollection collection = BusinessProcessorHelper.loadObjectCollection(ctx, bosType, view);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objValue = collection.getObject(i);
            objValue.put("source." + this.idxGroupby, (Object)group);
            if (valList != null && valList.length > 0 && i < valList[0].size()) {
                for (int j = 0; j < valList.length; ++j) {
                    objValue.put("source." + (j + 4), valList[j].get(i));
                }
            }
            IObjectCollection objCollection = (IObjectCollection)objValue.get(entryName);
            Iterator iter = objCollection.iterator();
            while (iter.hasNext()) {
                IObjectValue entryObj = (IObjectValue)iter.next();
                String entryId = entryObj.get(entryObj.getPKField()).toString();
                if (entryIdList.indexOf(entryId) > -1) continue;
                iter.remove();
            }
        }
        return collection;
    }

    private SelectorItemCollection loadSelector(Context ctx, BOTProcessSubItem firstItem) throws BOSException, ActionCommonException {
        SelectorItemCollection botpSelectors = null;
        try {
            IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo bmap = botMapping.getMappingInfoByPK((IObjectPK)new ObjectUuidPK(firstItem.getBotMappingId()));
            if (bmap == null) {
                return null;
            }
            try {
                botpSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)bmap);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.mergeSelector(botpSelectors, firstItem.getSelectorList());
            if (firstItem.getMappingItem() != null) {
                this.mergeSelector(botpSelectors, firstItem.getMappingItem().getSelectorList(ctx));
            }
            if (this.mappingItem != null) {
                this.mergeSelector(botpSelectors, this.mappingItem.getSelectorList(ctx));
            }
            if (firstItem.getSeq() == 0) {
                this.mergeSelector(botpSelectors, firstItem.getParent().getSelectorList());
            }
        }
        catch (ObjectNotFoundException e) {
            throw new ActionCommonException(null, "\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u7f6e\u7684BOTP\u89c4\u5219\u627e\u4e0d\u5230\uff0cID\u4e3a" + firstItem.getBotMappingId());
        }
        return botpSelectors;
    }

    private void mergeSelector(SelectorItemCollection botpSelectors, List selectorList) {
        if (selectorList != null) {
            Iterator iter = selectorList.iterator();
            while (iter.hasNext()) {
                botpSelectors.add((SelectorItemInfo)iter.next());
            }
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }
}

