/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.dynbusiness.ColumnDataType;
import com.kingdee.eas.dynbusiness.TableTypeEnum;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.condition.ColumnItem;
import com.kingdee.eas.dynbusiness.condition.Condition;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.config.BusinessCheckConfigItem;
import com.kingdee.eas.dynbusiness.config.ColumnPair;
import com.kingdee.eas.dynbusiness.config.WriteBackConfigItem;
import com.kingdee.eas.dynbusiness.config.WriteBackSubItem;
import com.kingdee.eas.dynbusiness.util.ArrayUtils;
import com.kingdee.eas.dynbusiness.util.SqlBuilderHelper;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OneToOneWriteBackSubItem
extends WriteBackSubItem {
    boolean isTransformByUnit = false;
    private String createTempTableSql;
    private String insertWriteBackDataSql;
    private String writeBackWithTempTableSql;
    private String createDstDataTempTableSql;
    private String insertDstDataTempTableSql;
    private String createObtain2SrcIdSql;
    private String idTempTableSql2;
    public static final String idTempTableSql = "CREATE TABLE ID_TEMP_TABLE (FID VARCHAR(44),FEntryID VARCHAR(44), FDstID VARCHAR(44))";
    public static final String idTempTableSql_2L = "CREATE TABLE ID_TEMP_TABLE (FID VARCHAR(44),FEntryID VARCHAR(44), FDstID VARCHAR(44), FSrc0EntryID VARCHAR(44))";
    public static final String fetchSrcIdsSql = "SELECT DISTINCT FID FROM @IDTABLE";

    public String getIdTempTableSql2() {
        return this.idTempTableSql2;
    }

    public String getCreateObtain2SrcIdSql() {
        return this.createObtain2SrcIdSql;
    }

    public OneToOneWriteBackSubItem(WriteBackConfigItem parent, String id) {
        super(parent, id);
    }

    @Override
    protected void buildWriteBackSqls(Context ctx) throws BOSException {
        super.buildWriteBackSqls(ctx);
        List columnPairList = this.getColumnPairs();
        Map colMap = this.getCheckNeedColList(columnPairList);
        this.createDstDataTempTableSql = this.buildCreateDstDataTempTableSql(columnPairList);
        this.insertDstDataTempTableSql = this.buildInsertDstDataSql(ctx, colMap);
        this.createTempTableSql = this.buildCreateTempTableSql(columnPairList, colMap);
        this.insertWriteBackDataSql = this.buildInsertWriteBackDataSql(ctx, colMap);
        this.writeBackWithTempTableSql = this.buildWriteBackSqlWithTempTable(ctx);
        this.createObtain2SrcIdSql = this.buildObtainSrcIdSql2(ctx);
        this.idTempTableSql2 = this.buildCreateTempTableSql2();
    }

    @Override
    protected String buildObtainSrcIdSql(Context ctx) throws BOSException {
        String entryAlias = null;
        boolean hasFSourceBillTypeIdColumn = false;
        if (this.getLevel() == 1) {
            entryAlias = "entry";
            hasFSourceBillTypeIdColumn = this.getParent().fldSrcTypeId != null;
        } else {
            entryAlias = "src0e";
        }
        boolean isHead = this.getParent().getParent().getActionLevel().equals((Object)ActionLevelEnum.HEAD);
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append("@IDTABLE").append("\r\n");
        sb.append(this.boStructure.buildObtainSrcIdSelectSql(hasFSourceBillTypeIdColumn));
        if (this.getLevel() > 1) {
            return sb.toString();
        }
        if (this.getConditions() != null) {
            sb.append(this.getConditions().buildJoin());
        }
        sb.append(SqlBuilderHelper.buildWhereClause(this.getConditions(), isHead));
        if (this.getLevel() > 1 || hasFSourceBillTypeIdColumn) {
            sb.append("AND ").append(entryAlias).append(".").append(this.isWriteToSrc() ? this.getParent().fldSrcTypeId : this.getParent().fldCoreTypeId).append("=?");
        }
        return sb.toString();
    }

    private String buildCreateTempTableSql2() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE ID_TEMP_TABLE (").append(this.getRelationEntryField(1)).append(" VARCHAR(44), FID VARCHAR(44), FSrc0EntryID VARCHAR(44))");
        return sb.toString();
    }

    private String buildObtainSrcIdSql2(Context ctx) throws BOSException {
        String entryAlias = "entry";
        boolean isHead = this.getParent().getParent().getActionLevel().equals((Object)ActionLevelEnum.HEAD);
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append("@IDTABLE").append("\r\n");
        sb.append("SELECT ").append(entryAlias).append(".").append(this.getRelationEntryField(1)).append("\r\n").append(", ").append("head").append(".FID, ").append(entryAlias).append(".FID").append("\r\n");
        sb.append(this.boStructure.buildJoinClause(0));
        if (this.getConditions() != null) {
            sb.append(this.getConditions().buildJoin());
        }
        sb.append(SqlBuilderHelper.buildWhereClause(this.getConditions(), isHead));
        return sb.toString();
    }

    @Override
    protected String buildDebugWriteBackDataSql(Context ctx) throws BOSException {
        List columnPairList = this.getColumnPairs();
        Conditions conditions = this.getConditions();
        boolean isHead = this.getParent().getParent().getActionLevel().equals((Object)ActionLevelEnum.HEAD);
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("head").append(".FNumber, ").append("entry").append(".FSeq, ").append("src").append(".FNumber AS FSrcNumber, ").append("srce").append(".FSeq AS FSrcSeq, ");
        sb.append(this.buildSelColList(columnPairList, this.isAlerting(), true)).append("\r\n");
        sb.append(this.boStructure.buildJoinClause(this.getLevel()));
        if (this.getStatus() != null && this.getStatus().equalsIgnoreCase("ALTERING")) {
            sb.append(this.boStructure.buildJoinClauseForAlerting(this.oldIdField));
        }
        if (conditions != null) {
            sb.append(conditions.buildJoin());
        }
        sb.append(SqlBuilderHelper.buildWhereClause(conditions, isHead));
        return sb.toString();
    }

    private Map getCheckNeedColList(List columnPairList) {
        if (this.checkItems == null) {
            return null;
        }
        Map checkMap = this.checkItems.getCheckItems();
        Iterator iter = checkMap.values().iterator();
        HashMap colMap = null;
        int sizePair = columnPairList.size();
        ArrayList<String> srcColumns = new ArrayList<String>(sizePair);
        for (int k = 0; k < sizePair; ++k) {
            ColumnPair pair = (ColumnPair)this.columnPairs.get(k);
            srcColumns.add(pair.getSrcColumn());
        }
        colMap = new HashMap();
        while (iter.hasNext()) {
            BusinessCheckConfigItem checkItem = (BusinessCheckConfigItem)iter.next();
            List conditions = checkItem.getConditions().getConditions();
            if (conditions == null) continue;
            int subsize = conditions.size();
            for (int j = 0; j < subsize; ++j) {
                Condition condition = (Condition)conditions.get(j);
                if (condition.getItem() instanceof ColumnItem) {
                    this.retriveCreateColumn(colMap, srcColumns, (ColumnItem)condition.getItem());
                }
                if (!(condition.getValue() instanceof ColumnItem)) continue;
                this.retriveCreateColumn(colMap, srcColumns, (ColumnItem)condition.getValue());
            }
        }
        return colMap;
    }

    private void retriveCreateColumn(Map colMap, List srcColumns, ColumnItem item) {
        String[] itemNames = item.getSplits();
        for (int i = 0; i < itemNames.length; ++i) {
            if (srcColumns.contains(itemNames[i])) continue;
            colMap.put(itemNames[i], item.getDataType());
        }
    }

    private String buildCreateTempTableSql(List columnPairList, Map colMap) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE ").append("@TABLE").append("(").append(this.getRelationEntryField()).append(" VARCHAR(44),");
        int size = columnPairList.size();
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)columnPairList.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(pair.getSrcColumn());
            sb.append(pair.getType().getColumnDefinition());
        }
        if (colMap != null) {
            for (Map.Entry entry : colMap.entrySet()) {
                sb.append(", ");
                sb.append(entry.getKey());
                sb.append(((ColumnDataType)entry.getValue()).getColumnDefinition());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private String buildCreateDstDataTempTableSql(List columnPairList) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE ").append("@TABLE").append("(").append(this.getRelationEntryField()).append(" VARCHAR(44)");
        HashSet<String> columnSet = new HashSet<String>();
        int size = columnPairList.size();
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)columnPairList.get(i);
            String[] cols = pair.getDstColumnNames(0, false, this.isAlerting());
            for (int j = 0; j < cols.length; ++j) {
                String colName = cols[j];
                if (columnSet.contains(colName)) continue;
                columnSet.add(colName);
                sb.append(", ");
                sb.append(colName);
            }
            if (this.isTransformByUnit) continue;
            this.isTransformByUnit = pair.isTransformByUnit();
        }
        if (this.isTransformByUnit) {
            sb.append(", ");
            sb.append(this.getParent().getFldUnitId());
            sb.append(" VARCHAR(44)");
        }
        sb.append(")");
        return sb.toString();
    }

    private String buildSelColForDstData(List columnPairList, boolean isAlerting) {
        StringBuffer sb = new StringBuffer();
        HashSet<String> columnSet = new HashSet<String>();
        int size = columnPairList.size();
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)columnPairList.get(i);
            String[] cols = pair.getDstColumnNames(0, true, isAlerting);
            String[] cols2 = pair.getDstColumnNames(0, false, isAlerting);
            for (int j = 0; j < cols.length; ++j) {
                String colName = cols[j];
                if (columnSet.contains(cols2[j])) continue;
                columnSet.add(cols2[j]);
                sb.append(", ");
                sb.append(colName);
            }
        }
        if (this.isTransformByUnit) {
            String entryAlias = this.getLevel() == 1 ? "entry" : "src0e";
            sb.append(", ");
            sb.append(entryAlias);
            sb.append(".");
            sb.append(this.getParent().getFldUnitId());
        }
        return sb.toString();
    }

    public boolean isAlerting() {
        return this.status != null && this.status.equalsIgnoreCase("ALTERING");
    }

    private String buildInsertWriteBackDataSql(Context ctx, Map colMap) throws BOSException {
        List columnPairList = this.getColumnPairs();
        String entryAlias = "entry";
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO  ").append("@TABLE").append("\r\n").append(" SELECT ");
        sb.append(entryAlias).append(".").append(this.getRelationEntryField()).append(", ");
        sb.append(this.buildSelColList(columnPairList, false, false)).append("\r\n");
        sb.append(this.getCheckedColList(colMap));
        sb.append("FROM ");
        sb.append("@TABLE");
        sb.append(" ");
        sb.append(entryAlias);
        sb.append("\r\n");
        sb.append("INNER JOIN ").append(this.boStructure.getTableName(this.getLevel(), TableTypeEnum.ENTRY)).append(" ").append("srce").append(" ON ");
        sb.append(entryAlias);
        sb.append(".").append(this.getRelationEntryField()).append("=").append("srce").append(".FID ").append("\r\n");
        if (this.isTransformByUnit) {
            sb.append("LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON ").append("srce").append(".FMaterialID = mmu.FMaterialID ").append("AND ").append("srce").append(".FUnitID=mmu.FMeasureUnitID ").append("\r\n");
        }
        sb.append(this.buildColPairsJoin(columnPairList));
        sb.append(this.buildGroupByClause(entryAlias, colMap, this.getLevel()));
        return sb.toString().replaceAll("head\\.", entryAlias + '.');
    }

    private String buildInsertDstDataSql(Context ctx, Map colMap) throws BOSException {
        List columnPairList = this.getColumnPairs();
        Conditions conditions = this.getConditions();
        int level = 1;
        String entryAlias = level == 1 ? "entry" : "src0e";
        boolean isHead = this.getParent().getParent().getActionLevel().equals((Object)ActionLevelEnum.HEAD);
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO  ").append("@TABLE").append("\r\n");
        this.buildInsertDstDataSqlSelect(columnPairList, entryAlias, sb, this.isAlerting());
        this.buildInsertDstDataSqlJoin(ctx, columnPairList, conditions, level, entryAlias, sb, this.isAlerting());
        if (this.getLevel() == 1) {
            sb.append(SqlBuilderHelper.buildWhereClause(conditions, isHead));
        }
        this.buildInsertDstDataSqlGroupBy(colMap, entryAlias, sb);
        if (this.isAlerting()) {
            sb.append("\r\n");
            sb.append("UNION ALL");
            sb.append("\r\n");
            this.buildInsertDstDataSqlSelect(columnPairList, entryAlias, sb, false);
            this.buildInsertDstDataSqlJoin(ctx, columnPairList, conditions, level, entryAlias, sb, false);
            if (this.getLevel() == 1) {
                sb.append(SqlBuilderHelper.buildWhereClause(conditions, isHead));
            } else {
                sb.append("\r\n");
            }
            sb.append("AND NOT EXISTS(SELECT 1 FROM ").append(this.boStructure.getTableName(0, TableTypeEnum.ENTRY)).append(" ").append("oentry").append(" WHERE ").append("oentry").append(".").append(this.oldIdField).append("=").append("entry").append(".FID)").append("\r\n");
            this.buildInsertDstDataSqlGroupBy(colMap, entryAlias, sb);
        }
        return sb.toString();
    }

    private void buildInsertDstDataSqlJoin(Context ctx, List columnPairList, Conditions conditions, int level, String entryAlias, StringBuffer sb, boolean isAlerting) throws BOSException {
        sb.append(this.boStructure.buildJoinClause(0));
        if (this.getLevel() > 1) {
            sb.append("INNER JOIN ").append("@IDTABLE").append(" idtemp ON idtemp.FSrc0EntryID=").append(entryAlias).append(".FID");
            sb.append("\r\n");
        }
        if (isAlerting) {
            sb.append(this.boStructure.buildJoinClauseForAlerting(this.oldIdField));
        }
        if (conditions != null) {
            sb.append(conditions.buildJoin());
        }
    }

    private void buildInsertDstDataSqlSelect(List columnPairList, String entryAlias, StringBuffer sb, boolean isAlerting) {
        sb.append("SELECT ");
        sb.append(this.boStructure.getRelationFieldWithAlias());
        String selColForDstData = this.buildSelColForDstData(columnPairList, isAlerting);
        if (this.getLevel() > 1) {
            selColForDstData = selColForDstData.replaceAll("src0e\\.", "entry.");
        }
        sb.append(selColForDstData).append("\r\n");
    }

    private void buildInsertDstDataSqlGroupBy(Map colMap, String entryAlias, StringBuffer sb) {
        String groupBy = this.buildGroupByClause(entryAlias, colMap, 0);
        if (groupBy.length() > 0 && this.getLevel() > 1) {
            groupBy = groupBy.replaceFirst(entryAlias + "\\." + this.getRelationEntryField(), "idtemp.FEntryId");
        }
        sb.append(groupBy);
        if (this.isTransformByUnit) {
            sb.append(", ");
            sb.append(entryAlias);
            sb.append(".");
            sb.append(this.getParent().getFldUnitId());
        }
    }

    private String buildColPairsJoin(List columnPairList) {
        StringBuffer sb = new StringBuffer();
        HashSet<String> set = new HashSet<String>();
        int size = columnPairList.size();
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)columnPairList.get(i);
            if (pair.getIfConditions() != null && !set.contains(pair.getIfConditions().getId())) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(pair.getIfConditions().buildJoin());
                set.add(pair.getIfConditions().getId());
            }
            sb.append(pair.buildJoin());
        }
        return sb.toString();
    }

    private String buildGroupByClause(String entryAlias, Map colMap, int levelFrom) {
        int i;
        int i2;
        String colList;
        StringBuffer sb = new StringBuffer();
        sb.append(entryAlias);
        sb.append(".").append(this.getRelationEntryField());
        if (levelFrom > 0 && (colList = this.getUpdColList(this.getColumnPairs(), true, true)).length() > 0) {
            sb.append(", ");
            sb.append(colList);
        }
        String[] fields = new String[]{};
        int size = this.getColumnPairs().size();
        for (i2 = 0; i2 < size; ++i2) {
            ColumnPair pair = (ColumnPair)this.getColumnPairs().get(i2);
            fields = ArrayUtils.mergeArray(fields, pair.getGroupByFields(levelFrom));
        }
        for (i2 = 0; i2 < fields.length; ++i2) {
            sb.append(",");
            sb.append(fields[i2]);
        }
        if (levelFrom > 0) {
            sb.append(this.getCheckedColList(colMap));
        }
        String[] groups = sb.toString().split("\\s*,\\s*");
        HashSet<String> groupSet = new HashSet<String>();
        int size2 = groups.length;
        for (i = 0; i < size2; ++i) {
            groupSet.add(groups[i]);
        }
        if (levelFrom > 0) {
            groups = this.getGroupConditionList(this.getColumnPairs(), levelFrom);
            size2 = groups.length;
            for (i = 0; i < size2; ++i) {
                groupSet.add(groups[i]);
            }
        }
        if (groupSet.size() == 0) {
            return "";
        }
        sb.setLength(0);
        sb.append("GROUP BY ");
        sb.append(StringUtil.getKeyIdListWithOutQuotationMask(groupSet.toArray()));
        return sb.toString();
    }

    private String[] getGroupConditionList(List columnPairList, int levelFrom) {
        String[] groups = new String[]{};
        int size = columnPairList.size();
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)columnPairList.get(i);
            if (pair.getConditions() != null) {
                groups = ArrayUtils.mergeArray(groups, pair.getConditions().getGroupByFields(levelFrom));
            }
            if (pair.getIfConditions() == null) continue;
            groups = ArrayUtils.mergeArray(groups, pair.getIfConditions().getGroupByFields(levelFrom));
        }
        return groups;
    }

    private String getUpdColList(List columnPairList, boolean withAlias, boolean forGroupBy) {
        StringBuffer sb = new StringBuffer();
        int size = columnPairList.size();
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)columnPairList.get(i);
            if (forGroupBy && "=".equals(pair.getCalculation())) continue;
            if (i > 0) {
                sb.append(", ");
            }
            if (withAlias) {
                sb.append("srce").append(".");
            }
            sb.append(pair.getSrcColumn());
        }
        return sb.toString();
    }

    private String getCheckedColList(Map colMap) {
        StringBuffer sb = new StringBuffer();
        if (colMap != null) {
            for (Map.Entry entry : colMap.entrySet()) {
                sb.append(", ");
                sb.append("srce");
                sb.append(".");
                sb.append(entry.getKey());
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    private String buildWriteBackSqlWithTempTable(Context ctx) throws BOSException {
        List columnPairList = this.getColumnPairs();
        String entryTableName = this.boStructure.getTableName(this.getLevel(), TableTypeEnum.ENTRY);
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ").append(entryTableName).append("\r\n").append("SET (");
        sb.append(this.getUpdColList(columnPairList, false, false));
        sb.append(") = ").append("\r\n").append("(SELECT ");
        sb.append(this.getsSelColListWithTempTable(columnPairList)).append("\r\n");
        sb.append(" FROM ").append("@TABLE").append(" temp ").append("\r\n");
        sb.append("WHERE EXISTS(SELECT 1 FROM ");
        sb.append("@IDTABLE");
        sb.append(" idtemp WHERE idtemp.FEntryID=temp.").append(this.getRelationEntryField());
        sb.append("\r\n");
        sb.append(" AND idtemp.FDstID IN (").append("???").append("))");
        sb.append("\r\n");
        sb.append("AND ");
        sb.append(entryTableName);
        sb.append(".FID=temp.");
        sb.append(this.getRelationEntryField());
        sb.append(")");
        return sb.toString();
    }

    private String getsSelColListWithTempTable(List columnPairList) {
        StringBuffer sb = new StringBuffer();
        int size = columnPairList.size();
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)columnPairList.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("temp.");
            sb.append(pair.getSrcColumn());
        }
        return sb.toString();
    }

    @Override
    public String buildWriteBackCheckSql(Context ctx) throws BOSException {
        if (this.getCheckItems() == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Map checkMap = this.checkItems.getCheckItems();
        Iterator iter = checkMap.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            BusinessCheckConfigItem checkItem = (BusinessCheckConfigItem)iter.next();
            if (i > 0) {
                sb.append("\r\n");
                sb.append("UNION ALL");
                sb.append("\r\n");
            }
            ++i;
            this.buildACheckItemSql(ctx, sb, checkItem);
        }
        return sb.toString();
    }

    private void buildACheckItemSql(Context ctx, StringBuffer sb, BusinessCheckConfigItem checkItem) throws BOSException {
        String condition = null;
        if (checkItem.getConditions() != null) {
            condition = checkItem.getConditions().buildConditon(false, null);
        }
        sb.append("SELECT ");
        sb.append("head");
        sb.append(".FID, '");
        sb.append(checkItem.getId());
        sb.append("' AS FErrID");
        sb.append("\r\n");
        sb.append("FROM ");
        sb.append(this.boStructure.getTableName(0, TableTypeEnum.HEAD));
        sb.append(" ");
        sb.append("head");
        sb.append("\r\n");
        sb.append("WHERE ");
        sb.append("head");
        sb.append(".FID IN (");
        sb.append("???");
        sb.append(") AND EXISTS(SELECT ");
        sb.append("entry");
        sb.append(".");
        sb.append(this.getRelationEntryField()).append(", ");
        sb.append("entry");
        sb.append(".");
        sb.append("FParentID FROM ");
        sb.append("\r\n");
        sb.append(this.boStructure.getTableName(0, TableTypeEnum.ENTRY));
        sb.append(" ");
        sb.append("entry");
        sb.append("\r\n");
        sb.append("INNER JOIN ");
        sb.append("@TABLE");
        sb.append(" temp ON temp.");
        sb.append(this.getRelationEntryField());
        sb.append("=");
        sb.append("entry");
        sb.append(".");
        sb.append(this.getRelationEntryField());
        sb.append("\r\n");
        this.buildTransformJoinForCheck(ctx, sb, checkItem);
        sb.append("WHERE ");
        sb.append("entry");
        sb.append(".FParentID=");
        sb.append("head");
        sb.append(".FID");
        sb.append("\r\n");
        if (condition != null) {
            condition = condition.replaceAll("srce\\.", "temp.");
            condition = condition.replaceAll("src\\.", "temp.");
            condition = condition.replaceAll("src0\\.", "temp.");
            condition = condition.replaceAll("src0e\\.", "temp.");
            sb.append("AND ");
            sb.append(condition);
        }
        sb.append(")");
    }

    private void buildTransformJoinForCheck(Context ctx, StringBuffer sb, BusinessCheckConfigItem checkItem) throws BOSException {
        if (checkItem.getConditions() != null) {
            boolean isTransForAmt;
            String entryAlias = this.getLevel() == 1 ? "srce" : "src0e";
            String srcBillType = null;
            srcBillType = this.getLevel() == 1 ? (String)this.getSrcBillIds().get(0) : (String)this.getSrcBillIds().get(this.getSrcBillIds().size() - 1);
            boolean isTransForQty = checkItem.getConditions().hasMulOrDivOperation(this.getLevel());
            if (isTransForQty) {
                this.buildCheckJoinWithSrcEntryTable(ctx, sb, entryAlias, srcBillType);
                sb.append("LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON ").append(entryAlias).append(".FMaterialID = mmu.FMaterialID ").append("AND ").append(entryAlias).append(".FUnitID=mmu.FMeasureUnitID ").append("\r\n");
            }
            if (isTransForAmt = checkItem.getConditions().hasMulOrDivOperation(this.getLevel() + 10)) {
                String headAlias;
                String string = headAlias = this.getLevel() == 1 ? "src" : "src0";
                if (!isTransForQty) {
                    this.buildCheckJoinWithSrcEntryTable(ctx, sb, entryAlias, srcBillType);
                }
                sb.append("INNER JOIN ").append(BusinessProcessorHelper.getHeadTableName(ctx, srcBillType)).append(" ").append(headAlias).append(" ON ").append(headAlias).append(".FID=").append(entryAlias).append(".FParentID").append("\r\n");
                sb.append("LEFT OUTER JOIN T_BD_Currency cur ON ").append(headAlias).append(".FCurrencyID=cur.FID").append("\r\n");
            }
        }
    }

    private void buildCheckJoinWithSrcEntryTable(Context ctx, StringBuffer sb, String entryAlias, String srcBillType) throws BOSException {
        sb.append("INNER JOIN ").append(BusinessProcessorHelper.getEntryTableName(ctx, srcBillType)).append(" ").append(entryAlias).append(" ON ").append(entryAlias).append(".FID=temp.").append(this.getRelationEntryField()).append("\r\n");
    }

    private String buildSelColList(List columnPairList, boolean isAlerting, boolean isDebug) {
        StringBuffer sb = new StringBuffer();
        int size = columnPairList.size();
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)columnPairList.get(i);
            if (i > 0) {
                sb.append(", ");
                sb.append("\r\n");
            }
            if (!isDebug && pair.getIfConditions() != null) {
                sb.append("CASE WHEN ");
                sb.append(pair.getIfConditions().buildConditon(false, null));
                sb.append(" THEN ");
            }
            sb.append(pair.buildPailColList(this.getParent().getFldUnitId(), isAlerting, isDebug, false));
            if (isDebug || pair.getIfConditions() == null) continue;
            sb.append("\r\n");
            sb.append(" ELSE ");
            sb.append(pair.buildPailColList(this.getParent().getFldUnitId(), isAlerting, isDebug, true));
            sb.append(" END");
        }
        return sb.toString();
    }

    public String getCreateTempTableSql() {
        return this.createTempTableSql;
    }

    public String getInsertWriteBackDataSql() {
        return this.insertWriteBackDataSql;
    }

    public String getWriteBackWithTempTableSql() {
        return this.writeBackWithTempTableSql;
    }

    @Override
    protected String buildLockSourceTableSql(Context ctx) throws BOSException {
        String srcBillId = null;
        srcBillId = this.getLevel() == 1 ? (String)this.getSrcBillIds().get(0) : (String)this.getSrcBillIds().get(this.getSrcBillIds().size() - 1);
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(BusinessProcessorHelper.getEntryTableName(ctx, srcBillId));
        sb.append(" SET FID=FID");
        sb.append("\r\n");
        sb.append("WHERE EXISTS(SELECT 1 FROM ");
        sb.append("@IDTABLE");
        sb.append(" temp");
        sb.append("\r\n");
        sb.append("WHERE temp.FEntryID=");
        sb.append(BusinessProcessorHelper.getEntryTableName(ctx, srcBillId));
        sb.append(".FID)");
        return sb.toString();
    }

    public String getCreateDstDataTempTableSql() {
        return this.createDstDataTempTableSql;
    }

    public String getInsertDstDataTempTableSql() {
        return this.insertDstDataTempTableSql;
    }
}

