/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.dynbusiness.IBusinessBatchBuild;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.app.handler.UpdateStatusHandler;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.IConfigItemDeepedCloneable;
import com.kingdee.eas.dynbusiness.config.UpdatedColumn;
import com.kingdee.eas.dynbusiness.config.WriteBackSubItem;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import java.util.ArrayList;
import java.util.List;

public class UpdateStatusItem
implements IBusinessBatchBuild,
IConfigItemDeepedCloneable,
IBusinessConfigItem {
    protected Conditions thisConditions;
    protected List updColumns;
    protected String thisTable;
    protected String thisAction;
    protected String infectionTable;
    protected String infectionAction;
    private Conditions infectConditons;
    protected String thisReversedAction;
    protected String infectionReversedAction;
    private transient String insertIdTableForWritebackSql;
    public String idTempTableSql = "CREATE TABLE ID_TEMP_TABLE (FID VARCHAR(44))";
    List infectionUpdColumns;
    Object parent;
    protected transient String updateFirstStatusSql;
    protected transient String updateSecondStatusSql;
    protected transient String[] firstParamMarks;
    protected transient String[] secondParamMarks;
    private transient boolean isInitialized = false;
    private String billTypeId;
    private String headTableName;
    private String entryTableName;

    public String getInsertIdTableForWritebackSql() {
        return this.insertIdTableForWritebackSql;
    }

    public Object getParent() {
        return this.parent;
    }

    public String getUpdateFirstStatusSql() {
        return this.updateFirstStatusSql;
    }

    public String getUpdateSecondStatusSql() {
        return this.updateSecondStatusSql;
    }

    public String[] getFirstParamMarks() {
        return this.firstParamMarks;
    }

    public String[] getSecondParamMarks() {
        return this.secondParamMarks;
    }

    public UpdateStatusItem(String billTypeId) {
        this.billTypeId = billTypeId;
    }

    public UpdateStatusItem(String id, Object parent) {
        this.billTypeId = id;
        this.parent = parent;
    }

    @Override
    public synchronized void build(Context ctx) throws BOSException {
        if (this.isInitialized) {
            return;
        }
        if (this.billTypeId != null) {
            this.headTableName = BusinessProcessorHelper.getHeadTableName(ctx, this.billTypeId);
            this.entryTableName = BusinessProcessorHelper.getEntryTableName(ctx, this.billTypeId);
        } else if (this.parent instanceof BusinessProcessConfigItem) {
            BusinessProcessConfigItem configItem = (BusinessProcessConfigItem)this.parent;
            this.headTableName = BusinessProcessorHelper.getHeadTableNameByBosType(ctx, configItem.getBosType());
            this.entryTableName = BusinessProcessorHelper.getEntryTableNameByBosType(ctx, configItem.getBosType());
        }
        this.updateFirstStatusSql = this.buildUpdateFirstStatusSql(ctx, this.billTypeId);
        this.updateSecondStatusSql = this.buildUpdateSecondStatusSql(ctx, this.billTypeId);
        this.isInitialized = true;
    }

    public IBusinessBatchHandle getUpdateStatusHander(Context ctx, String[] headIds, String[] entryIds) throws BOSException {
        if (!this.isInitialized) {
            this.build(ctx);
        }
        return new UpdateStatusHandler(this, headIds, entryIds);
    }

    public IBusinessBatchHandle getUpdateStatusHander(Context ctx, String[] headIds, String[] entryIds, String idTableName) throws BOSException {
        if (!this.isInitialized) {
            this.build(ctx);
        }
        return new UpdateStatusHandler(this, headIds, entryIds, idTableName);
    }

    private String buildUpdateFirstStatusSql(Context ctx, String billTypeId) throws BOSException {
        boolean needToUpdStatus;
        StringBuffer sb = new StringBuffer();
        boolean bl = needToUpdStatus = BusinessProcessUtil.actionNameToStatus(this.thisAction) != null;
        if ("head".equalsIgnoreCase(this.getThisTable())) {
            sb.append("UPDATE ");
            sb.append(this.headTableName);
            sb.append(" SET ");
            if (needToUpdStatus) {
                sb.append("FBaseStatus = ?  ");
            }
            String updString = this.getUpdColListInSrcStatus(this.getUpdColumns());
            sb.append(needToUpdStatus ? updString : updString.substring(2));
            sb.append("\r\n");
            sb.append("WHERE FID IN (");
            sb.append("???");
            sb.append(")");
            List paramMarkList = this.getUpdColParamMarks(this.getUpdColumns());
            int idx = 0;
            this.firstParamMarks = new String[(paramMarkList != null ? paramMarkList.size() : 0) + (needToUpdStatus ? 2 : 1)];
            if (needToUpdStatus) {
                this.firstParamMarks[idx++] = "@STATUS";
            }
            if (paramMarkList != null) {
                int size = paramMarkList.size();
                for (int i = 0; i < size; ++i) {
                    this.firstParamMarks[i + idx] = (String)paramMarkList.get(i);
                }
            }
            this.firstParamMarks[this.firstParamMarks.length - 1] = "???";
        } else {
            boolean isWriteback = this.parent instanceof WriteBackSubItem;
            List paramMarkList = this.getUpdColParamMarks(this.getUpdColumns());
            this.firstParamMarks = new String[(paramMarkList != null ? paramMarkList.size() : 0) + 3];
            this.firstParamMarks[0] = "@STATUS";
            if (paramMarkList != null) {
                int size = paramMarkList.size();
                for (int i = 0; i < size; ++i) {
                    this.firstParamMarks[i + 1] = (String)paramMarkList.get(i);
                }
            }
            this.firstParamMarks[this.firstParamMarks.length - 2] = "???";
            this.firstParamMarks[this.firstParamMarks.length - 1] = this.getThisReversedAction() == null ? "@STATUS" : "@STATUS_REVERSE";
            sb.append(isWriteback ? this.buildUpdateFirstEntrySql2Writeback(ctx) : this.buildUpdateFirstEntrySql(ctx));
            if (isWriteback) {
                return sb.toString();
            }
        }
        return sb.toString().replaceAll("entry\\.", "");
    }

    private String buildUpdateFirstEntrySql2Writeback(Context ctx) throws BOSException {
        String condition;
        StringBuffer sb = new StringBuffer();
        String tabDst = this.entryTableName;
        sb.append("INSERT INTO ").append("@IDTABLE");
        sb.append("\r\n");
        sb.append("SELECT ").append("entry").append(".FID");
        sb.append("\r\n");
        sb.append("FROM ").append(tabDst).append(" ").append("entry");
        sb.append("\r\n");
        sb.append("INNER JOIN ").append("@IDTABLE").append(" idtemp ON ").append("entry").append(".FID=idtemp.FEntryID");
        sb.append("\r\n");
        if (this.getThisConditions() != null && this.getThisConditions().hasMulOrDivOperation(0)) {
            sb.append("INNER JOIN T_BD_MultiMeasureUnit mmu ON ").append("entry").append(".FMaterialID = mmu.FMaterialID AND ").append("entry").append(".FUnitID=mmu.FMeasureUnitID ");
            sb.append("\r\n");
        }
        sb.append("WHERE idtemp.FDstID IN (").append("???").append(")");
        if (this.getThisConditions() != null && (condition = this.getThisConditions().buildConditon(false, null)) != null) {
            sb.append("\r\n");
            sb.append(" AND ");
            sb.append(condition);
        }
        this.insertIdTableForWritebackSql = sb.toString();
        sb.setLength(0);
        sb.append("UPDATE ").append(tabDst).append(" SET FBaseStatus = ?  ").append(this.getUpdColListInSrcStatus(this.getUpdColumns())).append("\r\n");
        sb.append("WHERE FBaseStatus ");
        if (this.getThisReversedAction() == null) {
            sb.append("<>");
        } else {
            sb.append("=");
        }
        sb.append("?");
        sb.append("\r\n");
        sb.append("AND EXISTS(SELECT 1 FROM ");
        sb.append("@IDTABLE");
        sb.append(" idtemp");
        sb.append("\r\n");
        sb.append("WHERE ");
        sb.append(tabDst);
        sb.append(".FID=idtemp.FID)");
        return sb.toString();
    }

    private String buildUpdateFirstEntrySql(Context ctx) throws BOSException {
        String condition;
        StringBuffer sb = new StringBuffer();
        String tabDst = this.entryTableName;
        sb.append("UPDATE ").append(tabDst).append(" SET FBaseStatus = ?  ").append(this.getUpdColListInSrcStatus(this.getUpdColumns())).append("\r\n");
        sb.append("WHERE FID ");
        sb.append("IN (").append("???").append(")");
        sb.append("\r\n");
        sb.append("AND ");
        sb.append("FBaseStatus ");
        if (this.getThisReversedAction() == null) {
            sb.append("<>");
        } else {
            sb.append("=");
        }
        sb.append("?");
        if (this.getThisConditions() != null && (condition = this.getThisConditions().buildConditon(false, null)) != null) {
            sb.append("\r\n");
            sb.append(" AND ");
            if (this.getThisConditions().hasMulOrDivOperation(0)) {
                sb.append("EXISTS(SELECT 1 FROM T_BD_MultiMeasureUnit mmu");
                sb.append("\r\n");
                sb.append("WHERE ");
                sb.append(tabDst).append(".FMaterialID = mmu.FMaterialID AND ").append(tabDst).append(".FUnitID=mmu.FMeasureUnitID ");
                sb.append("\r\n");
                sb.append("AND ");
                sb.append(condition.replaceAll("entry\\.", tabDst + "."));
                sb.append(")");
            } else {
                sb.append(condition);
            }
        }
        return sb.toString();
    }

    private String buildUpdateSecondStatusSql(Context ctx, String billTypeId) throws BOSException {
        String condition;
        if (this.getInfectionTable() == null || this.getInfectionAction() == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if ("head".equalsIgnoreCase(this.getInfectionTable())) {
            return this.buildUpdateSecondHeadSql(ctx);
        }
        sb.append("UPDATE ").append(this.entryTableName).append(" SET FBaseStatus = ? ");
        sb.append(this.getUpdColListInSrcStatus(this.getInfectionUpdColumns()));
        sb.append("\r\n").append(" WHERE FID IN (SELECT entry.FID ").append("\r\n").append("FROM ").append(this.entryTableName).append(" entry ").append("\r\n").append("INNER JOIN ").append(this.headTableName).append(" head ON head.FID=entry.FParentID ").append("\r\n");
        if (this.infectConditons != null) {
            sb.append(this.infectConditons.buildJoin());
        }
        sb.append("WHERE head.FID IN (");
        sb.append("???");
        sb.append(")");
        if (this.infectConditons != null && (condition = this.infectConditons.buildConditon(false, null)) != null) {
            sb.append("\r\n");
            sb.append("AND ");
            sb.append(condition);
        }
        sb.append(")");
        this.secondParamMarks = new String[2];
        this.secondParamMarks[0] = "@STATUS";
        this.secondParamMarks[1] = "???";
        return sb.toString();
    }

    private String buildUpdateSecondHeadSql(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String thisTable = this.headTableName;
        if (this.parent instanceof BusinessProcessConfigItem && ((BusinessProcessConfigItem)this.parent).getActionLevel().equals((Object)ActionLevelEnum.ENTRY)) {
            sb.append("UPDATE ").append(thisTable).append(" SET FBaseStatus = ? ");
            sb.append("\r\n");
            sb.append("WHERE EXISTS (SELECT 1 FROM ");
            sb.append(this.entryTableName);
            sb.append(" ").append("srce");
            sb.append("\r\n");
            sb.append("WHERE ");
            sb.append("srce");
            sb.append(".FParentID=");
            sb.append(thisTable);
            sb.append(".FID");
            sb.append("\r\n");
            sb.append("AND ");
            sb.append("srce");
            sb.append(".FID IN (");
            sb.append("???");
            sb.append(")) AND");
            sb.append("\r\n");
            if (this.getInfectionReversedAction() == null) {
                sb.append("NOT ");
            }
            sb.append("EXISTS (SELECT 1 FROM ");
            sb.append(this.entryTableName);
            sb.append(" ").append("srce");
            sb.append("\r\n");
            sb.append("WHERE ");
            sb.append("srce");
            sb.append(".FParentID=");
            sb.append(thisTable);
            sb.append(".FID");
            sb.append("\r\n");
            sb.append("AND ");
            sb.append("srce");
            sb.append(".FBaseStatus <> ?)");
            this.secondParamMarks = new String[3];
            this.secondParamMarks[0] = "@STATUS";
            this.secondParamMarks[1] = "???";
            this.secondParamMarks[this.secondParamMarks.length - 1] = this.getInfectionReversedAction() != null ? "@STATUS_REVERSE" : "@STATUS";
        } else {
            sb.append("UPDATE ").append(thisTable).append(" SET FBaseStatus = ? ");
            sb.append(this.getUpdColListInSrcStatus(this.getInfectionUpdColumns()));
            sb.append("\r\n");
            sb.append("WHERE EXISTS(SELECT 1 FROM ");
            sb.append("@IDTABLE");
            sb.append(" idtemp");
            sb.append("\r\n");
            sb.append("WHERE idtemp.FDstID IN (");
            sb.append("???");
            sb.append(") AND idtemp.FID=");
            sb.append(thisTable);
            sb.append(".FID) AND");
            sb.append("\r\n");
            if (this.getInfectionReversedAction() != null) {
                sb.append("FBaseStatus = ? AND ").append("\r\n");
            }
            if (this.getInfectionReversedAction() == null) {
                sb.append("NOT ");
            }
            sb.append("EXISTS (SELECT 1 FROM ").append(this.entryTableName).append(" ").append("srce");
            sb.append("\r\n");
            sb.append("WHERE ").append(thisTable).append(".FID=").append("srce").append(".FParentID ");
            sb.append("\r\n");
            sb.append("AND ").append("srce").append(".FBaseStatus ");
            if (this.getInfectionReversedAction() == null) {
                sb.append("<>");
            } else {
                sb.append("=");
            }
            sb.append(" ?)");
            this.secondParamMarks = new String[this.getInfectionReversedAction() != null ? 4 : 3];
            this.secondParamMarks[0] = "@STATUS";
            this.secondParamMarks[1] = "???";
            if (this.getInfectionReversedAction() != null) {
                this.secondParamMarks[2] = "@STATUS_REVERSE";
            }
            this.secondParamMarks[this.secondParamMarks.length - 1] = "@STATUS";
        }
        return sb.toString();
    }

    private String getUpdColListInSrcStatus(List updColList) {
        if (updColList == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int size = updColList.size();
        for (int i = 0; i < size; ++i) {
            sb.append(", ");
            sb.append(((UpdatedColumn)updColList.get(i)).buildUpdClause());
        }
        return sb.toString();
    }

    private List getUpdColParamMarks(List updColList) {
        if (updColList == null) {
            return null;
        }
        ArrayList<String> paramMarkList = new ArrayList<String>();
        int size = updColList.size();
        for (int i = 0; i < size; ++i) {
            UpdatedColumn updColumn = (UpdatedColumn)updColList.get(i);
            if ("USER".equalsIgnoreCase(updColumn.getType())) {
                paramMarkList.add("@USER");
                continue;
            }
            if (!"PARAM".equalsIgnoreCase(updColumn.getType())) continue;
            paramMarkList.add(updColumn.getValue());
        }
        return paramMarkList;
    }

    public List getInfectionUpdColumns() {
        return this.infectionUpdColumns;
    }

    public void setInfectionUpdColumns(List infectionUpdColumns) {
        this.infectionUpdColumns = infectionUpdColumns;
    }

    public String getInfectionReversedAction() {
        return this.infectionReversedAction;
    }

    public void setInfectionReversedAction(String infectionReversedAction) {
        this.infectionReversedAction = infectionReversedAction;
    }

    public String getThisReversedAction() {
        return this.thisReversedAction;
    }

    public void setThisReversedAction(String thisReversedAction) {
        this.thisReversedAction = thisReversedAction;
    }

    public String getInfectionAction() {
        return this.infectionAction;
    }

    public void setInfectionAction(String infectionAction) {
        this.infectionAction = infectionAction;
    }

    public String getInfectionTable() {
        return this.infectionTable;
    }

    public void setInfectionTable(String infectionTable) {
        this.infectionTable = infectionTable;
    }

    public String getThisAction() {
        return this.thisAction;
    }

    public void setThisAction(String thisAction) {
        this.thisAction = thisAction;
    }

    public String getThisTable() {
        return this.thisTable;
    }

    public void setThisTable(String thisTable) {
        this.thisTable = thisTable;
    }

    public List getUpdColumns() {
        return this.updColumns;
    }

    public void setUpdColumns(List updColumns) {
        this.updColumns = updColumns;
    }

    public Conditions getThisConditions() {
        return this.thisConditions;
    }

    public void setThisConditions(Conditions thisConditions) {
        this.thisConditions = thisConditions;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Object deepedCloned(BusinessProcessConfigItem bpcItem) throws CloneNotSupportedException {
        UpdateStatusItem usi = (UpdateStatusItem)this.clone();
        usi.isInitialized = false;
        usi.parent = bpcItem;
        usi.billTypeId = bpcItem.getBillTypeId();
        return usi;
    }

    public void setInfectConditons(Conditions infectConditons) {
        this.infectConditons = infectConditons;
    }
}

